/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.b.d;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u001d\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a0\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0007\u001a\u0019\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u001a \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007\u001a+\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0082\b\u001a2\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0002\u001a(\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a'\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010#\u001a'\u0010$\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010#\u001a?\u0010%\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010(\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00012\u0006\u0010*\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0080\b\u001a\u0011\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0082\b\u001a \u0010-\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a \u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0000\u001a \u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0002\u001a0\u00106\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a0\u00109\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u001bH\u0002\u001a\u0018\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u0002\u001a \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010A\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a0\u0010B\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a(\u0010D\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a \u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u001bH\u0002\u001a\u0018\u0010H\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001bH\u0002\u001a0\u0010J\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001aH\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010S\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\"\u0018\u0010V\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010U\"\u0019\u0010X\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010U\"\u0018\u0010Z\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010U\u00a8\u0006\\"}, d2={"Tau", "", "Epsilon", "FloatEpsilon", "", "evaluateX", "segment", "Landroidx/compose/ui/graphics/PathSegment;", "t", "evaluateY", "evaluateLine", "p0y", "p1y", "evaluateQuadratic", "p0", "p1", "p2", "evaluateCubic", "p3", "findFirstRoot", "fraction", "findFirstLineRoot", "findFirstQuadraticRoot", "findFirstCubicRoot", "findLineRoot", "", "roots", "", "index", "findQuadraticRoots", "findDerivativeRoots", "horizontal", "", "computeHorizontalBounds", "Landroidx/collection/FloatFloatPair;", "(Landroidx/compose/ui/graphics/PathSegment;[FI)J", "computeVerticalBounds", "computeCubicVerticalBounds", "p2y", "p3y", "(FFFF[FI)J", "closeTo", "b", "clampValidRootInUnitRange", "r", "writeValidRootInUnitRange", "lineWinding", "points", "x", "y", "isQuadraticMonotonic", "y0", "y1", "y2", "quadraticWinding", "tmpQuadratics", "tmpRoots", "monotonicQuadraticWinding", "offset", "quadraticToMonotonicQuadratics", "quadratic", "dst", "splitQuadraticAt", "", "src", "unitDivide", "cubicWinding", "tmpCubics", "monotonicCubicWinding", "cubicToMonotonicCubics", "cubic", "tmpRoot", "findCubicExtremaY", "dstRoots", "splitCubicAt", "srcOffset", "dstOffset", "cubicArea", "x0", "x1", "x2", "x3", "y3", "startX", "getStartX", "(Landroidx/compose/ui/graphics/PathSegment;)F", "endX", "getEndX", "startY", "getStartY", "endY", "getEndY", "ui-graphics"})
public final class BezierKt {
    private static final double Tau = Math.PI * 2;
    private static final double Epsilon = 1.0E-7;
    private static final float FloatEpsilon = 1.05E-6f;

    private static final float evaluateX(PathSegment pathSegment, float f) {
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                return fArray[0];
            }
            case 2: {
                return BezierKt.evaluateLine(fArray[0], fArray[2], f);
            }
            case 3: {
                return BezierKt.evaluateQuadratic(fArray[0], fArray[2], fArray[4], f);
            }
            case 4: {
                return BezierKt.evaluateCubic(fArray[0], fArray[2], fArray[4], fArray[6], f);
            }
        }
        return Float.NaN;
    }

    public static final float evaluateY(PathSegment pathSegment, float f) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                return fArray[1];
            }
            case 2: {
                return BezierKt.evaluateLine(fArray[1], fArray[3], f);
            }
            case 3: {
                return BezierKt.evaluateQuadratic(fArray[1], fArray[3], fArray[5], f);
            }
            case 4: {
                return BezierKt.evaluateCubic(fArray[1], fArray[3], fArray[5], fArray[7], f);
            }
        }
        return Float.NaN;
    }

    private static final float evaluateLine(float f, float f2, float f3) {
        return (f2 - f) * f3 + f;
    }

    private static final float evaluateQuadratic(float f, float f2, float f3, float f4) {
        float f5 = 2.0f * (f2 - f);
        f2 = f3 - f2 * 2.0f + f;
        return (f2 * f4 + f5) * f4 + f;
    }

    private static final float evaluateCubic(float f, float f2, float f3, float f4, float f5) {
        f4 = f4 + 3.0f * (f2 - f3) - f;
        f3 = 3.0f * (f3 - f2 * 2.0f + f);
        f2 = 3.0f * (f2 - f);
        return ((f4 * f5 + f3) * f5 + f2) * f5 + f;
    }

    public static final float evaluateCubic(float f, float f2, float f3) {
        float f4 = 0.33333334f + (f - f2);
        return 3.0f * ((f4 * f3 + (f2 -= f * 2.0f)) * f3 + f) * f3;
    }

    public static final float findFirstRoot(PathSegment pathSegment, float f) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                return Float.NaN;
            }
            case 2: {
                float f2;
                float f3 = fArray[0] - f;
                f = fArray[2] - f;
                f = f3 = -f3 / (f - f3);
                f = f2 < 0.0f ? 0.0f : f;
                if (Math.abs((f = f > 1.0f ? 1.0f : f) - f3) > 1.05E-6f) break;
                return f;
            }
            case 3: {
                return BezierKt.findFirstQuadraticRoot(fArray[0] - f, fArray[2] - f, fArray[4] - f);
            }
            case 5: {
                return Float.NaN;
            }
            case 4: {
                return BezierKt.findFirstCubicRoot(fArray[0] - f, fArray[2] - f, fArray[4] - f, fArray[6] - f);
            }
            case 6: {
                return Float.NaN;
            }
            case 7: {
                return Float.NaN;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Float.NaN;
    }

    private static final float findFirstLineRoot(float f, float f2) {
        float f3;
        f2 = f = -f / (f2 - f);
        f2 = f3 < 0.0f ? 0.0f : f2;
        float f4 = f2 = f2 > 1.0f ? 1.0f : f2;
        if (Math.abs(f4 - f) > 1.05E-6f) {
            return Float.NaN;
        }
        return f2;
    }

    private static final float findFirstQuadraticRoot(float f, float f2, float f3) {
        double d = f;
        double d2 = f2;
        double d3 = f3;
        double d4 = d - d2 * 2.0 + d3;
        if (!(d4 == 0.0)) {
            float f4;
            float f5;
            double d5 = d2;
            double d6 = -Math.sqrt(d5 * d5 - d * d3);
            double d7 = -d + d2;
            f2 = f = (float)(-(d6 + d7) / d4);
            f2 = f5 < 0.0f ? 0.0f : f2;
            f = Math.abs((f2 = f2 > 1.0f ? 1.0f : f2) - f) > 1.05E-6f ? Float.NaN : f2;
            if (!Float.isNaN(f)) {
                return f;
            }
            f2 = f = (float)((d6 - d7) / d4);
            f2 = f4 < 0.0f ? 0.0f : f2;
            float f6 = f2 = f2 > 1.0f ? 1.0f : f2;
            if (Math.abs(f6 - f) > 1.05E-6f) {
                return Float.NaN;
            }
            return f2;
        }
        if (!(d2 == d3)) {
            float f7;
            float f8;
            float f9 = f8 = (float)((d2 * 2.0 - d3) / (d2 * 2.0 - d3 * 2.0));
            f = f7 < 0.0f ? 0.0f : f9;
            float f10 = f = f > 1.0f ? 1.0f : f;
            if (Math.abs(f10 - f8) > 1.05E-6f) {
                return Float.NaN;
            }
            return f;
        }
        return Float.NaN;
    }

    public static final float findFirstCubicRoot(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        double d;
        double d2 = 3.0 * ((double)f - 2.0 * (double)f2 + (double)f3);
        double d3 = 3.0 * (double)(f2 - f);
        double d4 = f;
        double d5 = (double)(-f) + 3.0 * (double)(f2 - f3) + (double)f4;
        if (Math.abs(d) < 1.0E-7) {
            float f7;
            float f8;
            float f9;
            if (Math.abs(d2) < 1.0E-7) {
                float f10;
                float f11;
                float f12;
                if (Math.abs(d3) < 1.0E-7) {
                    return Float.NaN;
                }
                float f13 = f12 = (float)(-d4 / d3);
                float f14 = f11 < 0.0f ? 0.0f : f13;
                float f15 = f10 = f14 > 1.0f ? 1.0f : f14;
                if (Math.abs(f15 - f12) > 1.05E-6f) {
                    return Float.NaN;
                }
                return f10;
            }
            double d6 = d3;
            double d7 = Math.sqrt(d6 * d6 - d2 * 4.0 * d4);
            double d8 = d2 * 2.0;
            float f16 = f9 = (float)((d7 - d3) / d8);
            float f17 = f8 < 0.0f ? 0.0f : f16;
            float f18 = f17 > 1.0f ? 1.0f : f17;
            float f19 = Math.abs(f18 - f9) > 1.05E-6f ? Float.NaN : f18;
            if (!Float.isNaN(f19)) {
                return f19;
            }
            f16 = f9 = (float)((-d3 - d7) / d8);
            f17 = f7 < 0.0f ? 0.0f : f16;
            float f20 = f18 = f17 > 1.0f ? 1.0f : f17;
            if (Math.abs(f20 - f9) > 1.05E-6f) {
                return Float.NaN;
            }
            return f18;
        }
        double d9 = d2 /= d5;
        double d10 = ((d3 /= d5) * 3.0 - d9 * d9) / 9.0;
        double d11 = (d2 * 2.0 * d2 * d2 - d2 * 9.0 * d3 + (d4 /= d5) * 27.0) / 54.0;
        double d12 = d10;
        double d13 = d11 * d11 + d12 * d12 * d10;
        double d14 = d2 / 3.0;
        if (d13 < 0.0) {
            float f21;
            float f22;
            float f23;
            double d15;
            double d16;
            double d17 = d10;
            double d18 = -(d17 * d17 * d10);
            double d19 = Math.sqrt(d18);
            double d20 = d16 = -d11 / d19;
            double d21 = d15 < -1.0 ? -1.0 : d20;
            double d22 = d21 > 1.0 ? 1.0 : d21;
            d20 = Math.acos(d22);
            f = 2.0f * MathHelpersKt.fastCbrt((float)((float)d19));
            f3 = f2 = (float)((double)f * Math.cos(d20 / 3.0) - d14);
            f3 = f2;
            f3 = f23 < 0.0f ? 0.0f : f3;
            f2 = Math.abs((f3 = f3 > 1.0f ? 1.0f : f3) - f2) > 1.05E-6f ? Float.NaN : f3;
            if (!Float.isNaN(f2)) {
                return f2;
            }
            f3 = f2 = (float)((double)f * Math.cos((d20 + Math.PI * 2) / 3.0) - d14);
            f3 = f2;
            f3 = f22 < 0.0f ? 0.0f : f3;
            f2 = Math.abs((f3 = f3 > 1.0f ? 1.0f : f3) - f2) > 1.05E-6f ? Float.NaN : f3;
            if (!Float.isNaN(f2)) {
                return f2;
            }
            f3 = f2 = (float)((double)f * Math.cos((d20 + Math.PI * 4) / 3.0) - d14);
            f3 = f2;
            f3 = f21 < 0.0f ? 0.0f : f3;
            float f24 = f3 = f3 > 1.0f ? 1.0f : f3;
            if (Math.abs(f24 - f2) > 1.05E-6f) {
                return Float.NaN;
            }
            return f3;
        }
        if (d13 == 0.0) {
            float f25;
            float f26;
            float f27;
            float f28 = -MathHelpersKt.fastCbrt((float)((float)d11));
            float f29 = f27 = f28 * 2.0f - (float)d14;
            float f30 = f26 < 0.0f ? 0.0f : f29;
            f = f30 > 1.0f ? 1.0f : f30;
            float f31 = Math.abs(f - f27) > 1.05E-6f ? Float.NaN : f;
            if (!Float.isNaN(f31)) {
                return f31;
            }
            f29 = f27 = -f28 - (float)d14;
            f30 = f25 < 0.0f ? 0.0f : f29;
            float f32 = f = f30 > 1.0f ? 1.0f : f30;
            if (Math.abs(f32 - f27) > 1.05E-6f) {
                return Float.NaN;
            }
            return f;
        }
        double d23 = Math.sqrt(d13);
        float f33 = MathHelpersKt.fastCbrt((float)((float)(-d11 + d23)));
        float f34 = MathHelpersKt.fastCbrt((float)((float)(d11 + d23)));
        float f35 = f6 = (float)((double)(f33 - f34) - d14);
        f = f5 < 0.0f ? 0.0f : f35;
        float f36 = f2 = f > 1.0f ? 1.0f : f;
        if (Math.abs(f36 - f6) > 1.05E-6f) {
            return Float.NaN;
        }
        return f2;
    }

    private static final int findLineRoot(float f, float f2, float[] fArray, int n) {
        return BezierKt.writeValidRootInUnitRange(-f / (f2 - f), fArray, n);
    }

    static /* synthetic */ int findLineRoot$default(float f, float f2, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return BezierKt.writeValidRootInUnitRange(-f / (f2 - f), fArray, n);
    }

    private static final int findQuadraticRoots(float f, float f2, float f3, float[] fArray, int n) {
        double d = f;
        double d2 = f2;
        double d3 = f3;
        double d4 = d - d2 * 2.0 + d3;
        int n2 = 0;
        if (!(d4 == 0.0)) {
            double d5 = d2;
            double d6 = -Math.sqrt(d5 * d5 - d * d3);
            double d7 = -d + d2;
            n2 = 0 + BezierKt.writeValidRootInUnitRange((float)(-(d6 + d7) / d4), fArray, n);
            if ((n2 += BezierKt.writeValidRootInUnitRange((float)((d6 - d7) / d4), fArray, n + n2)) > 1) {
                f2 = fArray[n];
                f3 = fArray[n + 1];
                if (f2 > f3) {
                    fArray[n] = f3;
                    fArray[n + 1] = f2;
                } else if (f2 == f3) {
                    --n2;
                }
            }
        } else if (!(d2 == d3)) {
            n2 = 0 + BezierKt.writeValidRootInUnitRange((float)((d2 * 2.0 - d3) / (d2 * 2.0 - d3 * 2.0)), fArray, n);
        }
        return n2;
    }

    static /* synthetic */ int findQuadraticRoots$default(float f, float f2, float f3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return BezierKt.findQuadraticRoots(f, f2, f3, fArray, n);
    }

    private static final int findDerivativeRoots(PathSegment pathSegment, boolean bl, float[] fArray, int n) {
        bl = !bl;
        float[] fArray2 = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 3: {
                float f = 2.0f * (fArray2[bl + 2] - fArray2[bl]);
                float f2 = 2.0f * (fArray2[bl + 4] - fArray2[bl + 2]);
                return BezierKt.writeValidRootInUnitRange(-f / (f2 - f), fArray, n);
            }
            case 4: {
                float f = 3.0f * (fArray2[bl + 2] - fArray2[bl]);
                float f3 = 3.0f * (fArray2[bl + 4] - fArray2[bl + 2]);
                float f4 = 3.0f * (fArray2[bl + 6] - fArray2[bl + 4]);
                int n2 = BezierKt.findQuadraticRoots(f, f3, f4, fArray, n);
                f = 2.0f * (f3 - f);
                f4 = 2.0f * (f4 - f3);
                return n2 + BezierKt.writeValidRootInUnitRange(-f / (f4 - f), fArray, n += n2);
            }
        }
        return 0;
    }

    public static final long computeHorizontalBounds(PathSegment pathSegment, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        n = BezierKt.findDerivativeRoots(pathSegment, true, fArray, n);
        PathSegment pathSegment2 = pathSegment;
        float f = pathSegment2.getPoints()[0];
        float f2 = BezierKt.getEndX(pathSegment);
        float f3 = Math.min(f, f2);
        PathSegment pathSegment3 = pathSegment;
        float f4 = pathSegment3.getPoints()[0];
        float f5 = BezierKt.getEndX(pathSegment);
        f = Math.max(f4, f5);
        for (int i = 0; i < n; ++i) {
            f5 = fArray[i];
            f5 = BezierKt.evaluateX(pathSegment, f5);
            f3 = Math.min(f3, f5);
            f = Math.max(f, f5);
        }
        return d.a((float)f3, (float)f);
    }

    public static /* synthetic */ long computeHorizontalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeHorizontalBounds(pathSegment, fArray, n);
    }

    public static final long computeVerticalBounds(PathSegment pathSegment, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        n = BezierKt.findDerivativeRoots(pathSegment, false, fArray, n);
        PathSegment pathSegment2 = pathSegment;
        float f = pathSegment2.getPoints()[1];
        float f2 = BezierKt.getEndY(pathSegment);
        float f3 = Math.min(f, f2);
        PathSegment pathSegment3 = pathSegment;
        float f4 = pathSegment3.getPoints()[1];
        float f5 = BezierKt.getEndY(pathSegment);
        f = Math.max(f4, f5);
        for (int i = 0; i < n; ++i) {
            f5 = fArray[i];
            f5 = BezierKt.evaluateY(pathSegment, f5);
            f3 = Math.min(f3, f5);
            f = Math.max(f, f5);
        }
        return d.a((float)f3, (float)f);
    }

    public static /* synthetic */ long computeVerticalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeVerticalBounds(pathSegment, fArray, n);
    }

    public static final long computeCubicVerticalBounds(float f, float f2, float f3, float f4, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        float f5 = 3.0f * (f2 - f);
        float f6 = 3.0f * (f3 - f2);
        float f7 = 3.0f * (f4 - f3);
        int n2 = BezierKt.findQuadraticRoots(f5, f6, f7, fArray, n);
        f5 = 2.0f * (f6 - f5);
        f6 = 2.0f * (f7 - f6);
        n += n2;
        n2 += BezierKt.writeValidRootInUnitRange(-f5 / (f6 - f5), fArray, n);
        float f8 = Math.min(f, f4);
        f5 = Math.max(f, f4);
        for (int i = 0; i < n2; ++i) {
            f7 = fArray[i];
            f7 = BezierKt.evaluateCubic(f, f2, f3, f4, f7);
            f8 = Math.min(f8, f7);
            f5 = Math.max(f5, f7);
        }
        return d.a((float)f8, (float)f5);
    }

    public static /* synthetic */ long computeCubicVerticalBounds$default(float f, float f2, float f3, float f4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return BezierKt.computeCubicVerticalBounds(f, f2, f3, f4, fArray, n);
    }

    public static final boolean closeTo(double d2, double d3) {
        return Math.abs(d2 - d3) < 1.0E-7;
    }

    public static final boolean closeTo(float f, float f2) {
        return Math.abs(f - f2) < 1.05E-6f;
    }

    private static final float clampValidRootInUnitRange(float f) {
        float f2;
        float f3 = f;
        f3 = f2 < 0.0f ? 0.0f : f3;
        float f4 = f3 = f3 > 1.0f ? 1.0f : f3;
        if (Math.abs(f4 - f) > 1.05E-6f) {
            return Float.NaN;
        }
        return f3;
    }

    private static final int writeValidRootInUnitRange(float f, float[] fArray, int n) {
        float f2;
        float f3 = f;
        f3 = f2 < 0.0f ? 0.0f : f3;
        f3 = f3 > 1.0f ? 1.0f : f3;
        fArray[n] = f = Math.abs(f3 - f) > 1.05E-6f ? Float.NaN : f3;
        if (Float.isNaN(f)) {
            return 0;
        }
        return 1;
    }

    public static final int lineWinding(float[] fArray, float f, float f2) {
        float f3;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 4) {
            return 0;
        }
        float f4 = fArray[0];
        float f5 = f3 = fArray[1];
        float f6 = fArray[2];
        float f7 = fArray[3];
        float f8 = f7 - f3;
        int n = 1;
        if (f3 > f7) {
            f3 = f7;
            f7 = f5;
            n = -1;
        }
        if (f2 < f3 || f2 >= f7) {
            return 0;
        }
        f7 = (f6 - f4) * (f2 - f5) - f8 * (f - f4);
        if (f7 == 0.0f) {
            n = 0;
        } else if ((int)Math.signum(f7) == n) {
            n = 0;
        }
        return n;
    }

    private static final boolean isQuadraticMonotonic(float f, float f2, float f3) {
        return !(Math.signum(f - f2) + Math.signum(f2 - f3) == 0.0f);
    }

    public static final int quadraticWinding(float[] fArray, float f, float f2, float[] fArray2, float[] fArray3) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray3, (String)"");
        float f3 = fArray[1];
        float f4 = fArray[3];
        float f5 = fArray[5];
        if (BezierKt.isQuadraticMonotonic(f3, f4, f5)) {
            return BezierKt.monotonicQuadraticWinding(fArray, 0, f, f2, fArray3);
        }
        int n = BezierKt.quadraticToMonotonicQuadratics(fArray, fArray2);
        int n2 = BezierKt.monotonicQuadraticWinding(fArray2, 0, f, f2, fArray3);
        if (n > 0) {
            n2 += BezierKt.monotonicQuadraticWinding(fArray2, 4, f, f2, fArray3);
        }
        return n2;
    }

    private static final int monotonicQuadraticWinding(float[] fArray, int n, float f, float f2, float[] fArray2) {
        float f3;
        float f4 = fArray[n + 1];
        float f5 = fArray[n + 5];
        int n2 = 1;
        if (f4 > f5) {
            f3 = f5;
            f5 = f4;
            f4 = f3;
            n2 = -1;
        }
        if (f2 < f4 || f2 >= f5) {
            return 0;
        }
        f4 = fArray[n + 1];
        f3 = fArray[n + 3];
        f5 = fArray[n + 5];
        float f6 = (n = BezierKt.findQuadraticRoots$default(f4 - f3 * 2.0f + f5, 2.0f * (f3 - f4), f4 - f2, fArray2, 0, 16, null)) == 0 ? fArray[1 - n2 << 1] : BezierKt.evaluateQuadratic(fArray[0], fArray[2], fArray[4], fArray2[0]);
        float f7 = f6;
        if (!(!(Math.abs(f6 - f) < 1.05E-6f) || f == fArray[4] && f2 == f5)) {
            return 0;
        }
        if (f6 < f) {
            return n2;
        }
        return 0;
    }

    private static final int quadraticToMonotonicQuadratics(float[] fArray, float[] fArray2) {
        if (fArray.length < 6) {
            return 0;
        }
        if (fArray2.length < 6) {
            return 0;
        }
        float f = fArray[1];
        float f2 = fArray[3];
        float f3 = fArray[5];
        if (!BezierKt.isQuadraticMonotonic(f, f2, f3)) {
            float f4 = BezierKt.unitDivide(f - f2, f - f2 - f2 + f3);
            if (!Float.isNaN(f4)) {
                BezierKt.splitQuadraticAt(fArray, fArray2, f4);
                return 1;
            }
            f2 = Math.abs(f - f2) < Math.abs(f2 - f3) ? f : f3;
        }
        ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)6);
        fArray2[3] = f2;
        return 0;
    }

    private static final void splitQuadraticAt(float[] fArray, float[] fArray2, float f) {
        if (fArray.length < 6) {
            return;
        }
        if (fArray2.length < 10) {
            return;
        }
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = fArray[4];
        float f7 = fArray[5];
        float f8 = MathHelpersKt.lerp((float)f2, (float)f4, (float)f);
        float f9 = MathHelpersKt.lerp((float)f3, (float)f5, (float)f);
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray2[2] = f8;
        fArray2[3] = f9;
        f2 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        f3 = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        f4 = MathHelpersKt.lerp((float)f8, (float)f2, (float)f);
        f = MathHelpersKt.lerp((float)f9, (float)f3, (float)f);
        fArray2[4] = f4;
        fArray2[5] = f;
        fArray2[6] = f2;
        fArray2[7] = f3;
        fArray2[8] = f6;
        fArray2[9] = f7;
    }

    private static final float unitDivide(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        if (f < 0.0f) {
            f3 = -f;
            f4 = -f2;
        }
        if (f4 == 0.0f || f3 == 0.0f || f3 >= f4) {
            return Float.NaN;
        }
        f = f3 / f4;
        if (f == 0.0f) {
            return Float.NaN;
        }
        return f;
    }

    public static final int cubicWinding(float[] fArray, float f, float f2, float[] fArray2, float[] fArray3) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray3, (String)"");
        int n = BezierKt.cubicToMonotonicCubics(fArray, fArray2, fArray3);
        int n2 = 0;
        int n3 = 0;
        if (n >= 0) {
            while (true) {
                n2 += BezierKt.monotonicCubicWinding(fArray2, n3 * 3 << 1, f, f2);
                if (n3 == n) break;
                ++n3;
            }
        }
        return n2;
    }

    private static final int monotonicCubicWinding(float[] fArray, int n, float f, float f2) {
        float f3;
        float f4;
        float f5 = fArray[n + 1];
        float f6 = fArray[n + 7];
        int n2 = 1;
        if (f5 > f6) {
            f4 = f6;
            f6 = f5;
            f5 = f4;
            n2 = -1;
        }
        if (f2 < f5 || f2 >= f6) {
            return 0;
        }
        f4 = fArray[n];
        float f7 = fArray[n + 2];
        float f8 = fArray[n + 4];
        float f9 = fArray[n + 6];
        f5 = Math.min(f4, Math.min(f7, Math.min(f8, f9)));
        if (f < f5) {
            return 0;
        }
        f5 = Math.max(f4, Math.max(f7, Math.max(f8, f9)));
        if (f > f5) {
            return n2;
        }
        f5 = fArray[n + 1];
        float f10 = fArray[n + 3];
        float f11 = fArray[n + 5];
        f6 = fArray[n + 7];
        float f12 = BezierKt.findFirstCubicRoot(f5 - f2, f10 - f2, f11 - f2, f6 - f2);
        if (Float.isNaN(f12)) {
            return 0;
        }
        float f13 = f12 = BezierKt.evaluateCubic(f4, f7, f8, f9, f12);
        if (!(!(Math.abs(f3 - f) < 1.05E-6f) || f == f9 && f2 == f6)) {
            return 0;
        }
        if (f12 < f) {
            return n2;
        }
        return 0;
    }

    private static final int cubicToMonotonicCubics(float[] fArray, float[] fArray2, float[] fArray3) {
        int n = BezierKt.findCubicExtremaY(fArray, fArray3);
        if (n == 0) {
            if (fArray2.length < 8) {
                return 0;
            }
            ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)8);
        } else {
            float f = 0.0f;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                float f2;
                float f3 = fArray3[i];
                f = (f3 - f) / (1.0f - f);
                f = f2 < 0.0f ? 0.0f : f;
                f3 = f > 1.0f ? 1.0f : f;
                f = f3;
                BezierKt.splitCubicAt(fArray, n2, fArray2, n2, f3);
                fArray = fArray2;
                n2 += 6;
            }
        }
        return n;
    }

    private static final int findCubicExtremaY(float[] fArray, float[] fArray2) {
        float f = fArray[1];
        float f2 = fArray[3];
        float f3 = fArray[5];
        float f4 = fArray[7];
        f4 = f4 - f + 3.0f * (f2 - f3);
        f3 = 2.0f * (f - f2 - f2 - f3);
        f = f2 - f;
        return BezierKt.findQuadraticRoots(f4, f3, f, fArray2, 0);
    }

    private static final void splitCubicAt(float[] fArray, int n, float[] fArray2, int n2, float f) {
        if (fArray.length < n + 8) {
            return;
        }
        if (fArray2.length < n2 + 14) {
            return;
        }
        if (f >= 1.0f) {
            ArraysKt.copyInto((float[])fArray, (float[])fArray2, (int)n2, (int)n, (int)8);
            float f2 = fArray[n + 6];
            float f3 = fArray[n + 7];
            fArray2[n2 + 8] = f2;
            fArray2[n2 + 9] = f3;
            fArray2[n2 + 10] = f2;
            fArray2[n2 + 11] = f3;
            fArray2[n2 + 12] = f2;
            fArray2[n2 + 13] = f3;
            return;
        }
        float f4 = fArray[n];
        float f5 = fArray[n + 1];
        fArray2[n2] = f4;
        fArray2[n2 + 1] = f5;
        float f6 = fArray[n + 2];
        float f7 = fArray[n + 3];
        f4 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        f5 = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        fArray2[n2 + 2] = f4;
        fArray2[n2 + 3] = f5;
        float f8 = fArray[n + 4];
        float f9 = fArray[n + 5];
        f6 = MathHelpersKt.lerp((float)f6, (float)f8, (float)f);
        f7 = MathHelpersKt.lerp((float)f7, (float)f9, (float)f);
        f4 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        f5 = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        fArray2[n2 + 4] = f4;
        fArray2[n2 + 5] = f5;
        float f10 = fArray[n + 6];
        float f11 = fArray[n + 7];
        float f12 = MathHelpersKt.lerp((float)f8, (float)f10, (float)f);
        f8 = MathHelpersKt.lerp((float)f9, (float)f11, (float)f);
        f6 = MathHelpersKt.lerp((float)f6, (float)f12, (float)f);
        f7 = MathHelpersKt.lerp((float)f7, (float)f8, (float)f);
        f4 = MathHelpersKt.lerp((float)f4, (float)f6, (float)f);
        f = MathHelpersKt.lerp((float)f5, (float)f7, (float)f);
        fArray2[n2 + 6] = f4;
        fArray2[n2 + 7] = f;
        fArray2[n2 + 8] = f6;
        fArray2[n2 + 9] = f7;
        fArray2[n2 + 10] = f12;
        fArray2[n2 + 11] = f8;
        fArray2[n2 + 12] = f10;
        fArray2[n2 + 13] = f11;
    }

    public static final float cubicArea(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return ((f8 - f2) * (f3 + f5) - (f7 - f) * (f4 + f6) + f4 * (f - f5) - f3 * (f2 - f6) + f8 * (f5 + f / 3.0f) - f7 * (f6 + f2 / 3.0f)) * 3.0f / 20.0f;
    }

    private static final float getStartX(PathSegment pathSegment) {
        return pathSegment.getPoints()[0];
    }

    private static final float getEndX(PathSegment pathSegment) {
        int n;
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    private static final float getStartY(PathSegment pathSegment) {
        return pathSegment.getPoints()[1];
    }

    private static final float getEndY(PathSegment pathSegment) {
        int n;
        float[] fArray = pathSegment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

