/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor.stream.slf4j;

import dorkbox.executor.stream.CallerLoggerUtil;
import dorkbox.executor.stream.slf4j.Level;
import dorkbox.executor.stream.slf4j.Slf4jDebugOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jErrorOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jInfoOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jTraceOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jWarnOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Ldorkbox/executor/stream/slf4j/Slf4jStream;", "", "()V", "as", "Ldorkbox/executor/stream/slf4j/Slf4jOutputStream;", "level", "Ldorkbox/executor/stream/slf4j/Level;", "log", "Lorg/slf4j/Logger;", "asDebug", "asError", "asInfo", "asTrace", "asWarn", "Executor"})
public final class Slf4jStream {
    public static final Slf4jStream INSTANCE = new Slf4jStream();

    private Slf4jStream() {
    }

    public final Slf4jOutputStream as(Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                return this.asTrace();
            }
            case 2: {
                return this.asDebug();
            }
            case 3: {
                return this.asInfo();
            }
            case 4: {
                return this.asWarn();
            }
            case 5: {
                return this.asError();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final Slf4jOutputStream as(Logger logger, Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                return this.asTrace(logger);
            }
            case 2: {
                return this.asDebug(logger);
            }
            case 3: {
                return this.asInfo(logger);
            }
            case 4: {
                return this.asWarn(logger);
            }
            case 5: {
                return this.asError(logger);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final Slf4jOutputStream asTrace() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return new Slf4jTraceOutputStream(logger);
    }

    public final Slf4jOutputStream asDebug() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return new Slf4jDebugOutputStream(logger);
    }

    public final Slf4jOutputStream asInfo() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return new Slf4jInfoOutputStream(logger);
    }

    public final Slf4jOutputStream asWarn() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return new Slf4jWarnOutputStream(logger);
    }

    public final Slf4jOutputStream asError() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return new Slf4jErrorOutputStream(logger);
    }

    public final Slf4jOutputStream asTrace(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return new Slf4jTraceOutputStream(logger);
    }

    public final Slf4jOutputStream asDebug(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return new Slf4jDebugOutputStream(logger);
    }

    public final Slf4jOutputStream asInfo(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return new Slf4jInfoOutputStream(logger);
    }

    public final Slf4jOutputStream asWarn(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return new Slf4jWarnOutputStream(logger);
    }

    public final Slf4jOutputStream asError(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return new Slf4jErrorOutputStream(logger);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

