/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class MenuItem
extends Entry {
    static boolean alreadyEmittedTooltipWarning = false;
    private volatile String text;
    private volatile Object unknownImage = null;
    private volatile File imageFile;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey = '\u0000';
    private volatile String tooltip;

    public MenuItem() {
    }

    public MenuItem(String string) {
        this.text = string;
    }

    public MenuItem(String string, ActionListener actionListener) {
        this.text = string;
        this.callback = actionListener;
    }

    public MenuItem(String string, String string2) {
        this(string, string2, null);
    }

    public MenuItem(String string, File file) {
        this(string, file, null);
    }

    public MenuItem(String string, URL uRL) {
        this(string, uRL, null);
    }

    public MenuItem(String string, InputStream inputStream) {
        this(string, inputStream, null);
    }

    public MenuItem(String string, Image image) {
        this(string, image, null);
    }

    public MenuItem(String string, String string2, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = string2;
        this.callback = actionListener;
    }

    public MenuItem(String string, File file, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = file;
        this.callback = actionListener;
    }

    public MenuItem(String string, URL uRL, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = uRL;
        this.callback = actionListener;
    }

    public MenuItem(String string, InputStream inputStream, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = inputStream;
        this.callback = actionListener;
    }

    public MenuItem(String string, Image image, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = image;
        this.callback = actionListener;
    }

    public MenuItem(String string, ImageInputStream imageInputStream, ActionListener actionListener) {
        this.text = string;
        this.unknownImage = imageInputStream;
        this.callback = actionListener;
    }

    public MenuItem(JMenuItem jMenuItem) {
        Object object = jMenuItem.getActionListeners();
        if (object != null) {
            if (((ActionListener[])object).length == 1) {
                this.setCallback(object[0]);
            } else {
                object = arg_0 -> MenuItem.lambda$new$0((ActionListener[])object, arg_0);
                this.setCallback((ActionListener)object);
            }
        }
        this.setEnabled(jMenuItem.isEnabled());
        object = jMenuItem.getIcon();
        if (object != null) {
            object = new BufferedImage(object.getIconWidth(), object.getIconHeight(), 2);
            this.setImage((Image)object);
        }
        this.setShortcut(jMenuItem.getMnemonic());
        this.setText(jMenuItem.getText());
    }

    private void realizeImageFile() {
        if (this.unknownImage instanceof String) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (String)this.unknownImage);
        } else if (this.unknownImage instanceof File) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (File)this.unknownImage);
        } else if (this.unknownImage instanceof URL) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (URL)this.unknownImage);
        } else if (this.unknownImage instanceof InputStream) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (InputStream)this.unknownImage);
        } else if (this.unknownImage instanceof Image) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (Image)this.unknownImage);
        } else if (this.unknownImage instanceof ImageInputStream) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (ImageInputStream)this.unknownImage);
        }
        this.unknownImage = null;
    }

    public void bind(MenuItemPeer menuItemPeer, Menu menu, ImageResizeUtil imageResizeUtil) {
        super.bind(menuItemPeer, menu, imageResizeUtil);
        this.realizeImageFile();
        menuItemPeer.setImage(this);
        menuItemPeer.setEnabled(this);
        menuItemPeer.setText(this);
        menuItemPeer.setCallback(this);
        menuItemPeer.setShortcut(this);
        menuItemPeer.setTooltip(this);
    }

    protected void setImageFromTray(File file) {
        this.imageFile = file;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public File getImage() {
        return this.imageFile;
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setText(this);
        }
    }

    public void setImage(File file) {
        this.unknownImage = file;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(String string) {
        this.unknownImage = string;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(URL uRL) {
        this.unknownImage = uRL;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(InputStream inputStream) {
        this.unknownImage = inputStream;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(Image image) {
        this.unknownImage = image;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(ImageInputStream imageInputStream) {
        this.unknownImage = imageInputStream;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public boolean hasImage() {
        return this.imageFile != null;
    }

    public void setCallback(ActionListener actionListener) {
        this.callback = actionListener;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setCallback(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char c) {
        this.mnemonicKey = c;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int n) {
        this.mnemonicKey = SwingUtil.INSTANCE.getFromVirtualKey(n);
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setTooltip(String string) {
        if (string != null) {
            if (string.length() > 64) {
                throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
            }
            if (!alreadyEmittedTooltipWarning) {
                alreadyEmittedTooltipWarning = true;
                SystemTray.logger.warn("Please disable tooltips, as they are not consistent across all platforms and tray types.");
            }
        }
        this.tooltip = string;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setTooltip(this);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    protected JMenuItem asSwingComponent() {
        JMenuItem jMenuItem = new JMenuItem();
        if (this.getImage() != null) {
            jMenuItem.setIcon(new ImageIcon(this.getImage().getAbsolutePath()));
        }
        jMenuItem.setText(this.getText());
        jMenuItem.setToolTipText(this.getTooltip());
        jMenuItem.setEnabled(this.getEnabled());
        jMenuItem.setMnemonic(SwingUtil.INSTANCE.getVirtualKey(this.getShortcut()));
        jMenuItem.addActionListener(this.getCallback());
        return jMenuItem;
    }

    private static /* synthetic */ void lambda$new$0(ActionListener[] actionListenerArray, ActionEvent actionEvent) {
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

