/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelOperationsKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000b\u001a;\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u000b\u001aF\u0010\u0019\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a<\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0087@\u00a2\u0006\u0004\b\u0019\u0010\u001b\u001a(\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0004\b\u0019\u0010\u001e\u001a\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lio/ktor/http/HttpMethod;", "method", "", "upgrade", "Lio/ktor/http/cio/ConnectionOptions;", "connectionOptions", "", "expectHttpUpgrade", "(Lio/ktor/http/HttpMethod;Ljava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;)Z", "Lio/ktor/http/cio/Request;", "request", "(Lio/ktor/http/cio/Request;)Z", "", "contentLength", "transferEncoding", "contentType", "expectHttpBody", "(Lio/ktor/http/HttpMethod;JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Ljava/lang/CharSequence;)Z", "Lio/ktor/http/HttpProtocolVersion;", "version", "Lio/ktor/utils/io/ByteReadChannel;", "input", "Lio/ktor/utils/io/ByteWriteChannel;", "out", "", "parseHttpBody", "(Lio/ktor/http/HttpProtocolVersion;JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/http/cio/HttpHeadersMap;", "headers", "(Lio/ktor/http/cio/HttpHeadersMap;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isTransferEncodingChunked", "(Ljava/lang/CharSequence;)Z", "ktor-http-cio"})
public final class HttpBodyKt {
    public static final boolean expectHttpUpgrade(HttpMethod httpMethod, CharSequence charSequence, ConnectionOptions connectionOptions) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"");
        if (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getGet()) && charSequence != null) {
            ConnectionOptions connectionOptions2 = connectionOptions;
            boolean bl = connectionOptions2 != null ? connectionOptions2.getUpgrade() : false;
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public static final boolean expectHttpUpgrade(Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"");
        return HttpBodyKt.expectHttpUpgrade(request.getMethod(), request.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")));
    }

    public static final boolean expectHttpBody(HttpMethod httpMethod, long l, CharSequence charSequence, ConnectionOptions connectionOptions, CharSequence charSequence2) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"");
        if (charSequence != null) {
            HttpBodyKt.isTransferEncodingChunked(charSequence);
            return true;
        }
        if (l != -1L) {
            return l > 0L;
        }
        if (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getGet()) || Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getHead()) || Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getOptions())) {
            return false;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        return connectionOptions2 != null ? connectionOptions2.getClose() : false;
    }

    public static final boolean expectHttpBody(Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"");
        CharSequence charSequence = request.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request.getMethod(), charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, request.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")), request.getHeaders().get("Content-Type"));
    }

    public static final Object parseHttpBody(HttpProtocolVersion object, long l, CharSequence charSequence, ConnectionOptions connectionOptions, ByteReadChannel byteReadChannel, ByteWriteChannel byteWriteChannel, Continuation<? super Unit> continuation) {
        if (charSequence != null && HttpBodyKt.isTransferEncodingChunked(charSequence)) {
            Object object2 = ChunkedTransferEncodingKt.decodeChunked(byteReadChannel, byteWriteChannel, continuation);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            return Unit.INSTANCE;
        }
        if (l != -1L) {
            Object object3 = ByteReadChannelOperationsKt.copyTo((ByteReadChannel)byteReadChannel, (ByteWriteChannel)byteWriteChannel, (long)l, continuation);
            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object3;
            }
            return Unit.INSTANCE;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        boolean bl = connectionOptions2 != null ? connectionOptions2.getClose() : false;
        if (bl || connectionOptions == null && Intrinsics.areEqual((Object)object, (Object)HttpProtocolVersion.Companion.getHTTP_1_0())) {
            Object object4 = ByteReadChannelOperationsKt.copyTo((ByteReadChannel)byteReadChannel, (ByteWriteChannel)byteWriteChannel, (long)Long.MAX_VALUE, continuation);
            if (object4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object4;
            }
            return Unit.INSTANCE;
        }
        object = new IllegalStateException("Failed to parse request body: request body length should be specified,\nchunked transfer encoding should be used or\nkeep-alive should be disabled (connection: close)");
        ByteWriteChannelOperationsKt.close((ByteWriteChannel)byteWriteChannel, (Throwable)((Throwable)object));
        return Unit.INSTANCE;
    }

    @Deprecated(message="Please use method with version parameter", level=DeprecationLevel.ERROR)
    public static final Object parseHttpBody(long l, CharSequence charSequence, ConnectionOptions connectionOptions, ByteReadChannel byteReadChannel, ByteWriteChannel byteWriteChannel, Continuation<? super Unit> continuation) {
        Object object = HttpBodyKt.parseHttpBody(null, l, charSequence, connectionOptions, byteReadChannel, byteWriteChannel, continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final Object parseHttpBody(HttpHeadersMap httpHeadersMap, ByteReadChannel byteReadChannel, ByteWriteChannel byteWriteChannel, Continuation<? super Unit> continuation) {
        CharSequence charSequence = httpHeadersMap.get("Content-Length");
        Object object = HttpBodyKt.parseHttpBody(null, charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, httpHeadersMap.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(httpHeadersMap.get("Connection")), byteReadChannel, byteWriteChannel, continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean isTransferEncodingChunked(CharSequence charSequence) {
        if (CharsKt.equalsLowerCase$default(charSequence, 0, 0, "chunked", 3, null)) {
            return true;
        }
        if (CharsKt.equalsLowerCase$default(charSequence, 0, 0, "identity", 3, null)) {
            return false;
        }
        boolean bl = false;
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = ",";
        object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            String string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            object2 = string;
            if (Intrinsics.areEqual((Object)string, (Object)"chunked")) {
                if (bl) {
                    throw new IllegalArgumentException("Double-chunked TE is not supported: " + charSequence);
                }
                bl = true;
                continue;
            }
            if (Intrinsics.areEqual(object2, (Object)"identity")) continue;
            throw new IllegalArgumentException("Unsupported transfer encoding " + object2);
        }
        return bl;
    }
}

