/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.buffer.ByteBuf;

final class IPPacket {
    private static final byte MAX_TTL = -1;
    private static final short V4_HEADER_SIZE = 20;
    private static final byte TCP = 6;
    private static final byte UDP = 17;
    private static final int IPV6_VERSION_TRAFFIC_FLOW = 60000000;

    private IPPacket() {
    }

    static void writeUDPv4(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2) {
        IPPacket.writePacketv4(byteBuf, byteBuf2, 17, n, n2);
    }

    static void writeUDPv6(ByteBuf byteBuf, ByteBuf byteBuf2, byte[] byArray, byte[] byArray2) {
        IPPacket.writePacketv6(byteBuf, byteBuf2, 17, byArray, byArray2);
    }

    static void writeTCPv4(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2) {
        IPPacket.writePacketv4(byteBuf, byteBuf2, 6, n, n2);
    }

    static void writeTCPv6(ByteBuf byteBuf, ByteBuf byteBuf2, byte[] byArray, byte[] byArray2) {
        IPPacket.writePacketv6(byteBuf, byteBuf2, 6, byArray, byArray2);
    }

    private static void writePacketv4(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        byteBuf.writeByte(69);
        byteBuf.writeByte(0);
        byteBuf.writeShort(20 + byteBuf2.readableBytes());
        byteBuf.writeShort(0);
        byteBuf.writeShort(0);
        byteBuf.writeByte(-1);
        byteBuf.writeByte(n);
        byteBuf.writeShort(0);
        byteBuf.writeInt(n2);
        byteBuf.writeInt(n3);
        byteBuf.writeBytes(byteBuf2);
    }

    private static void writePacketv6(ByteBuf byteBuf, ByteBuf byteBuf2, int n, byte[] byArray, byte[] byArray2) {
        byteBuf.writeInt(60000000);
        byteBuf.writeShort(byteBuf2.readableBytes());
        byteBuf.writeByte(n & 0xFF);
        byteBuf.writeByte(-1);
        byteBuf.writeBytes(byArray);
        byteBuf.writeBytes(byArray2);
        byteBuf.writeBytes(byteBuf2);
    }
}

