/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.pcap.EthernetPacket;
import io.netty.handler.pcap.IPPacket;
import io.netty.handler.pcap.PcapHeaders;
import io.netty.handler.pcap.PcapWriter;
import io.netty.handler.pcap.State;
import io.netty.handler.pcap.TCPPacket;
import io.netty.handler.pcap.UDPPacket;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;

public final class PcapWriteHandler
extends ChannelDuplexHandler
implements Closeable {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriteHandler.class);
    private PcapWriter pCapWriter;
    private final OutputStream outputStream;
    private final boolean captureZeroByte;
    private final boolean writePcapGlobalHeader;
    private final boolean sharedOutputStream;
    private long sendSegmentNumber = 1L;
    private long receiveSegmentNumber = 1L;
    private ChannelType channelType;
    private InetSocketAddress initiatorAddr;
    private InetSocketAddress handlerAddr;
    private boolean isServerPipeline;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    @Deprecated
    public PcapWriteHandler(OutputStream outputStream) {
        this(outputStream, false, true);
    }

    @Deprecated
    public PcapWriteHandler(OutputStream outputStream, boolean bl, boolean bl2) {
        this.outputStream = (OutputStream)ObjectUtil.checkNotNull((Object)outputStream, (String)"OutputStream");
        this.captureZeroByte = bl;
        this.writePcapGlobalHeader = bl2;
        this.sharedOutputStream = false;
    }

    private PcapWriteHandler(Builder builder, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.captureZeroByte = builder.captureZeroByte;
        this.sharedOutputStream = builder.sharedOutputStream;
        this.writePcapGlobalHeader = builder.writePcapGlobalHeader;
        this.channelType = builder.channelType;
        this.handlerAddr = builder.handlerAddr;
        this.initiatorAddr = builder.initiatorAddr;
        this.isServerPipeline = builder.isServerPipeline;
    }

    public static void writeGlobalHeader(OutputStream outputStream) {
        PcapHeaders.writeGlobalHeader(outputStream);
    }

    private void initializeIfNecessary(ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf;
        if (this.state.get() != State.INIT) {
            return;
        }
        this.pCapWriter = new PcapWriter(this);
        if (this.channelType == null) {
            if (channelHandlerContext.channel() instanceof SocketChannel) {
                this.channelType = ChannelType.TCP;
                if (channelHandlerContext.channel().parent() instanceof ServerSocketChannel) {
                    this.isServerPipeline = true;
                    this.initiatorAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.handlerAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.initiatorAddr);
                } else {
                    this.isServerPipeline = false;
                    this.handlerAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.initiatorAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.handlerAddr);
                }
            } else if (channelHandlerContext.channel() instanceof DatagramChannel) {
                this.channelType = ChannelType.UDP;
                byteBuf = (DatagramChannel)channelHandlerContext.channel();
                if (byteBuf.isConnected()) {
                    this.handlerAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.initiatorAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.handlerAddr);
                }
            }
        }
        if (this.channelType == ChannelType.TCP) {
            this.logger.debug("Initiating Fake TCP 3-Way Handshake");
            byteBuf = channelHandlerContext.alloc().buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, 0L, 0L, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.SYN);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, 0L, 1L, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), TCPPacket.TCPFlag.SYN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler2 = this;
                pcapWriteHandler2.completeTCPWrite(pcapWriteHandler2.handlerAddr, this.initiatorAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, 1L, 1L, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler3 = this;
                pcapWriteHandler3.completeTCPWrite(pcapWriteHandler3.initiatorAddr, this.handlerAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Finished Fake TCP 3-Way Handshake");
        }
        this.state.set(State.WRITING);
    }

    public final void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.initializeIfNecessary(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(channelHandlerContext);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(channelHandlerContext, object, false);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(channelHandlerContext, object, false);
            } else {
                this.logDiscard();
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(channelHandlerContext);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(channelHandlerContext, object, true);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(channelHandlerContext, object, true);
            } else {
                this.logDiscard();
            }
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    private void handleTCP(ChannelHandlerContext channelHandlerContext, Object object, boolean bl) {
        if (object instanceof ByteBuf) {
            int n = ((ByteBuf)object).readableBytes();
            if (n == 0 && !this.captureZeroByte) {
                this.logger.debug("Discarding Zero Byte TCP Packet. isWriteOperation {}", (Object)bl);
                return;
            }
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            if (n == 0) {
                this.handleTcpPacket(channelHandlerContext, (ByteBuf)object, bl, byteBufAllocator);
                return;
            }
            for (int i = 0; i < n; i += 65495) {
                ByteBuf byteBuf = ((ByteBuf)object).slice(i, Math.min(65495, n - i));
                this.handleTcpPacket(channelHandlerContext, byteBuf, bl, byteBufAllocator);
            }
            return;
        }
        this.logger.debug("Discarding Pcap Write for TCP Object: {}", object);
    }

    private void handleTcpPacket(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl, ByteBufAllocator byteBufAllocator) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        int n = byteBuf.readableBytes();
        try {
            if (bl) {
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress2;
                if (this.isServerPipeline) {
                    inetSocketAddress2 = this.handlerAddr;
                    inetSocketAddress = this.initiatorAddr;
                } else {
                    inetSocketAddress2 = this.initiatorAddr;
                    inetSocketAddress = this.handlerAddr;
                }
                TCPPacket.writePacket(byteBuf2, byteBuf, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress2.getPort(), inetSocketAddress.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress2, inetSocketAddress, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress2, inetSocketAddress, false);
                this.sendSegmentNumber = PcapWriteHandler.incrementUintSegmentNumber(this.sendSegmentNumber, n);
                TCPPacket.writePacket(byteBuf2, null, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress.getPort(), inetSocketAddress2.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress, inetSocketAddress2, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress, inetSocketAddress2, true);
            } else {
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress3;
                if (this.isServerPipeline) {
                    inetSocketAddress3 = this.initiatorAddr;
                    inetSocketAddress = this.handlerAddr;
                } else {
                    inetSocketAddress3 = this.handlerAddr;
                    inetSocketAddress = this.initiatorAddr;
                }
                TCPPacket.writePacket(byteBuf2, byteBuf, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress3.getPort(), inetSocketAddress.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress3, inetSocketAddress, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress3, inetSocketAddress, false);
                this.receiveSegmentNumber = PcapWriteHandler.incrementUintSegmentNumber(this.receiveSegmentNumber, n);
                TCPPacket.writePacket(byteBuf2, null, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress.getPort(), inetSocketAddress3.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress, inetSocketAddress3, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress, inetSocketAddress3, true);
            }
            return;
        }
        finally {
            byteBuf2.release();
        }
    }

    private void completeTCPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        byteBufAllocator = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeTCPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress.getAddress())), NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress2.getAddress())));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeTCPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket((ByteBuf)byteBufAllocator, byteBuf3);
            return;
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", (Throwable)iOException);
            channelHandlerContext.fireExceptionCaught((Throwable)iOException);
            return;
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBufAllocator.release();
        }
    }

    private static long incrementUintSegmentNumber(long l, int n) {
        return (l + (long)n) % 0x100000000L;
    }

    private void handleUDP(ChannelHandlerContext channelHandlerContext, Object object, boolean bl) {
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
        try {
            if (object instanceof DatagramPacket) {
                if (((ByteBuf)((DatagramPacket)object).content()).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                if (((ByteBuf)((DatagramPacket)object).content()).readableBytes() > 65507) {
                    this.logger.warn("Unable to write UDP packet to PCAP. Payload of size {} exceeds max size of 65507");
                    return;
                }
                object = ((DatagramPacket)object).duplicate();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)object.sender();
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)object.recipient();
                if (inetSocketAddress == null) {
                    inetSocketAddress = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), inetSocketAddress2);
                }
                this.logger.debug("Writing UDP Data of {} Bytes, isWriteOperation {}, Src Addr {}, Dst Addr {}", new Object[]{((ByteBuf)object.content()).readableBytes(), bl, inetSocketAddress, inetSocketAddress2});
                UDPPacket.writePacket(byteBuf, (ByteBuf)object.content(), inetSocketAddress.getPort(), inetSocketAddress2.getPort());
                this.completeUDPWrite(inetSocketAddress, inetSocketAddress2, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else if (object instanceof ByteBuf && (!(channelHandlerContext.channel() instanceof DatagramChannel) || ((DatagramChannel)channelHandlerContext.channel()).isConnected())) {
                if (((ByteBuf)object).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                if (((ByteBuf)object).readableBytes() > 65507) {
                    this.logger.warn("Unable to write UDP packet to PCAP. Payload of size {} exceeds max size of 65507");
                    return;
                }
                object = ((ByteBuf)object).duplicate();
                InetSocketAddress inetSocketAddress = bl ? this.initiatorAddr : this.handlerAddr;
                InetSocketAddress inetSocketAddress3 = bl ? this.handlerAddr : this.initiatorAddr;
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", new Object[]{object.readableBytes(), inetSocketAddress, inetSocketAddress3});
                UDPPacket.writePacket(byteBuf, (ByteBuf)object, inetSocketAddress.getPort(), inetSocketAddress3.getPort());
                this.completeUDPWrite(inetSocketAddress, inetSocketAddress3, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else {
                this.logger.debug("Discarding Pcap Write for UDP Object: {}", object);
            }
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    private void completeUDPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        byteBufAllocator = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeUDPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress.getAddress())), NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress2.getAddress())));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeUDPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket((ByteBuf)byteBufAllocator, byteBuf3);
            return;
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", (Throwable)iOException);
            channelHandlerContext.fireExceptionCaught((Throwable)iOException);
            return;
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBufAllocator.release();
        }
    }

    private static InetSocketAddress getLocalAddress(Channel object, InetSocketAddress inetSocketAddress) {
        object = (InetSocketAddress)object.localAddress();
        if (inetSocketAddress != null && ((InetSocketAddress)object).getAddress().isAnyLocalAddress()) {
            if (((InetSocketAddress)object).getAddress() instanceof Inet4Address && inetSocketAddress.getAddress() instanceof Inet6Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard6, ((InetSocketAddress)object).getPort());
            }
            if (((InetSocketAddress)object).getAddress() instanceof Inet6Address && inetSocketAddress.getAddress() instanceof Inet4Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard4, ((InetSocketAddress)object).getPort());
            }
        }
        return object;
    }

    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (this.channelType == ChannelType.TCP && this.state.get() == State.WRITING) {
            this.logger.debug("Starting Fake TCP FIN+ACK Flow to close connection");
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            ByteBuf byteBuf = byteBufAllocator.buffer();
            try {
                long l = this.isServerPipeline ? this.receiveSegmentNumber : this.sendSegmentNumber;
                long l2 = this.isServerPipeline ? this.sendSegmentNumber : this.receiveSegmentNumber;
                TCPPacket.writePacket(byteBuf, null, l, l2, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, l2, l, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler2 = this;
                pcapWriteHandler2.completeTCPWrite(pcapWriteHandler2.handlerAddr, this.initiatorAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                this.sendSegmentNumber = PcapWriteHandler.incrementUintSegmentNumber(this.sendSegmentNumber, 1);
                this.receiveSegmentNumber = PcapWriteHandler.incrementUintSegmentNumber(this.receiveSegmentNumber, 1);
                l = this.isServerPipeline ? this.receiveSegmentNumber : this.sendSegmentNumber;
                l2 = this.isServerPipeline ? this.sendSegmentNumber : this.receiveSegmentNumber;
                TCPPacket.writePacket(byteBuf, null, l, l2, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler3 = this;
                pcapWriteHandler3.completeTCPWrite(pcapWriteHandler3.initiatorAddr, this.handlerAddr, byteBuf, byteBufAllocator, channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Finished Fake TCP FIN+ACK Flow to close connection");
        }
        this.close();
        super.handlerRemoved(channelHandlerContext);
    }

    public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.channelType == ChannelType.TCP && this.state.get() == State.WRITING) {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.RST, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Sent Fake TCP RST to close connection");
        }
        this.close();
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    private void logTCP(boolean bl, int n, long l, long l2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            if (bl2) {
                this.logger.debug("Writing TCP ACK, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", new Object[]{bl, l, l2, inetSocketAddress2, inetSocketAddress});
                return;
            }
            this.logger.debug("Writing TCP Data of {} Bytes, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", new Object[]{n, bl, l, l2, inetSocketAddress, inetSocketAddress2});
        }
    }

    final OutputStream outputStream() {
        return this.outputStream;
    }

    final boolean sharedOutputStream() {
        return this.sharedOutputStream;
    }

    final boolean writePcapGlobalHeader() {
        return this.writePcapGlobalHeader;
    }

    public final boolean isWriting() {
        return this.state.get() == State.WRITING;
    }

    final State state() {
        return this.state.get();
    }

    public final void pause() {
        if (!this.state.compareAndSet(State.WRITING, State.PAUSED)) {
            throw new IllegalStateException("State must be 'STARTED' to pause but current state is: " + this.state);
        }
    }

    public final void resume() {
        if (!this.state.compareAndSet(State.PAUSED, State.WRITING)) {
            throw new IllegalStateException("State must be 'PAUSED' to resume but current state is: " + this.state);
        }
    }

    final void markClosed() {
        if (this.state.get() != State.CLOSED) {
            this.state.set(State.CLOSED);
        }
    }

    final PcapWriter pCapWriter() {
        return this.pCapWriter;
    }

    private void logDiscard() {
        this.logger.warn("Discarding pcap write because channel type is unknown. The channel this handler is registered on is not a SocketChannel or DatagramChannel, so the inference does not work. Please call forceTcpChannel or forceUdpChannel before registering the handler.");
    }

    public final String toString() {
        return "PcapWriteHandler{captureZeroByte=" + this.captureZeroByte + ", writePcapGlobalHeader=" + this.writePcapGlobalHeader + ", sharedOutputStream=" + this.sharedOutputStream + ", sendSegmentNumber=" + this.sendSegmentNumber + ", receiveSegmentNumber=" + this.receiveSegmentNumber + ", channelType=" + (Object)((Object)this.channelType) + ", initiatorAddr=" + this.initiatorAddr + ", handlerAddr=" + this.handlerAddr + ", isServerPipeline=" + this.isServerPipeline + ", state=" + this.state + '}';
    }

    @Override
    public final void close() {
        if (this.state.get() == State.CLOSED) {
            this.logger.debug("PcapWriterHandler is already closed");
            return;
        }
        if (this.pCapWriter == null) {
            this.pCapWriter = new PcapWriter(this);
        }
        this.pCapWriter.close();
        this.markClosed();
        this.logger.debug("PcapWriterHandler is now closed");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class WildcardAddressHolder {
        static final InetAddress wildcard4;
        static final InetAddress wildcard6;

        private WildcardAddressHolder() {
        }

        static {
            try {
                wildcard4 = InetAddress.getByAddress(new byte[4]);
                wildcard6 = InetAddress.getByAddress(new byte[16]);
                return;
            }
            catch (UnknownHostException unknownHostException) {
                throw new AssertionError((Object)unknownHostException);
            }
        }
    }

    public static final class Builder {
        private boolean captureZeroByte;
        private boolean sharedOutputStream;
        private boolean writePcapGlobalHeader = true;
        private ChannelType channelType;
        private InetSocketAddress initiatorAddr;
        private InetSocketAddress handlerAddr;
        private boolean isServerPipeline;

        private Builder() {
        }

        public final Builder captureZeroByte(boolean bl) {
            this.captureZeroByte = bl;
            return this;
        }

        public final Builder sharedOutputStream(boolean bl) {
            this.sharedOutputStream = bl;
            return this;
        }

        public final Builder writePcapGlobalHeader(boolean bl) {
            this.writePcapGlobalHeader = bl;
            return this;
        }

        public final Builder forceTcpChannel(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl) {
            this.channelType = ChannelType.TCP;
            this.handlerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)inetSocketAddress, (String)"serverAddress");
            this.initiatorAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)inetSocketAddress2, (String)"clientAddress");
            this.isServerPipeline = bl;
            return this;
        }

        public final Builder forceUdpChannel(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this.channelType = ChannelType.UDP;
            this.handlerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)inetSocketAddress2, (String)"remoteAddress");
            this.initiatorAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)inetSocketAddress, (String)"localAddress");
            return this;
        }

        public final PcapWriteHandler build(OutputStream outputStream) {
            ObjectUtil.checkNotNull((Object)outputStream, (String)"outputStream");
            return new PcapWriteHandler(this, outputStream);
        }
    }

    private static enum ChannelType {
        TCP,
        UDP;

    }
}

