/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.oio.AbstractOioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    protected AbstractOioByteChannel(Channel channel) {
        super(channel);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    private void closeOnRead(ChannelPipeline channelPipeline) {
        if (this.isOpen()) {
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, RecvByteBufAllocator.Handle handle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        handle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl || throwable instanceof OutOfMemoryError || throwable instanceof IOException) {
            this.closeOnRead(channelPipeline);
        }
    }

    @Override
    protected void doRead() {
        block16: {
            boolean bl;
            ChannelConfig channelConfig;
            block15: {
                channelConfig = this.config();
                if (this.isInputShutdown() || !this.readPending) {
                    return;
                }
                this.readPending = false;
                ChannelPipeline channelPipeline = this.pipeline();
                ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
                RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
                handle.reset(channelConfig);
                ByteBuf byteBuf = null;
                boolean bl2 = false;
                bl = false;
                try {
                    byteBuf = handle.allocate(byteBufAllocator);
                    do {
                        int n;
                        handle.lastBytesRead(this.doReadBytes(byteBuf));
                        if (handle.lastBytesRead() <= 0) {
                            if (byteBuf.isReadable()) break;
                            byteBuf.release();
                            byteBuf = null;
                            bl2 = handle.lastBytesRead() < 0;
                            if (!bl2) break;
                            this.readPending = false;
                            break;
                        }
                        bl = true;
                        int n2 = this.available();
                        if (n2 <= 0) break;
                        if (byteBuf.isWritable()) continue;
                        int n3 = byteBuf.capacity();
                        if (n3 == (n = byteBuf.maxCapacity())) {
                            handle.incMessagesRead(1);
                            this.readPending = false;
                            channelPipeline.fireChannelRead(byteBuf);
                            byteBuf = handle.allocate(byteBufAllocator);
                            continue;
                        }
                        n3 = byteBuf.writerIndex();
                        if (n3 + n2 > n) {
                            byteBuf.capacity(n);
                            continue;
                        }
                        byteBuf.ensureWritable(n2);
                    } while (handle.continueReading());
                    if (byteBuf != null) {
                        if (byteBuf.isReadable()) {
                            this.readPending = false;
                            channelPipeline.fireChannelRead(byteBuf);
                        } else {
                            byteBuf.release();
                        }
                        byteBuf = null;
                    }
                    if (bl) {
                        handle.readComplete();
                        channelPipeline.fireChannelReadComplete();
                    }
                    if (!bl2) break block15;
                    this.closeOnRead(channelPipeline);
                }
                catch (Throwable throwable) {
                    try {
                        this.handleReadException(channelPipeline, byteBuf, throwable, bl2, handle);
                        return;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (!this.readPending && !channelConfig.isAutoRead() && (bl || !this.isActive())) break block16;
                        this.read();
                    }
                }
            }
            if (this.readPending || channelConfig.isAutoRead() || !bl && this.isActive()) {
                this.read();
                return;
            }
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            if (object instanceof ByteBuf) {
                object = (ByteBuf)object;
                int n = object.readableBytes();
                while (n > 0) {
                    this.doWriteBytes((ByteBuf)object);
                    int n2 = object.readableBytes();
                    channelOutboundBuffer.progress(n - n2);
                    n = n2;
                }
                channelOutboundBuffer.remove();
                continue;
            }
            if (object instanceof FileRegion) {
                object = (FileRegion)object;
                long l = object.transferred();
                this.doWriteFileRegion((FileRegion)object);
                channelOutboundBuffer.progress(object.transferred() - l);
                channelOutboundBuffer.remove();
                continue;
            }
            channelOutboundBuffer.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object)));
        }
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf || object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract void doWriteBytes(ByteBuf var1);

    protected abstract void doWriteFileRegion(FileRegion var1);
}

