/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.json.Json;
import com.formdev.flatlaf.json.ParseException;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class IntelliJTheme {
    public final String name;
    public final boolean dark;
    public final String author;
    private final boolean isMaterialUILite;
    private Map<String, String> colors;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private Map<String, ColorUIResource> namedColors = Collections.emptyMap();
    private static final Set<String> uiKeyExcludes;
    private static final Set<String> uiKeyDoNotOverride;
    private static final Map<String, String> uiKeyMapping;
    private static final Map<String, String> uiKeyCopying;
    private static final Map<String, String> uiKeyInverseMapping;
    private static final Map<String, String> checkboxKeyMapping;
    private static final Map<String, String> checkboxDuplicateColors;

    public static boolean setup(InputStream inputStream) {
        try {
            return FlatLaf.setup(IntelliJTheme.createLaf(inputStream));
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load IntelliJ theme", exception);
            return false;
        }
    }

    @Deprecated
    public static boolean install(InputStream inputStream) {
        return IntelliJTheme.setup(inputStream);
    }

    public static FlatLaf createLaf(InputStream inputStream) {
        return IntelliJTheme.createLaf(new IntelliJTheme(inputStream));
    }

    public static FlatLaf createLaf(IntelliJTheme intelliJTheme) {
        return new ThemeLaf(intelliJTheme);
    }

    public IntelliJTheme(InputStream inputStream) {
        Map map;
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            map = (Map)Json.parse(inputStreamReader);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage(), parseException);
        }
        this.name = (String)map.get("name");
        this.dark = Boolean.parseBoolean((String)map.get("dark"));
        this.author = (String)map.get("author");
        this.isMaterialUILite = this.author.equals("Mallowigi");
        this.colors = (Map)map.get("colors");
        this.ui = (Map)map.get("ui");
        this.icons = (Map)map.get("icons");
    }

    /*
     * WARNING - void declaration
     */
    private void applyProperties(UIDefaults uIDefaults) {
        int n;
        void var6_11;
        Object object;
        if (this.ui == null) {
            return;
        }
        uIDefaults.put("Component.isIntelliJTheme", (Object)true);
        uIDefaults.put("Button.paintShadow", (Object)true);
        uIDefaults.put("Button.shadowWidth", (Object)(this.dark ? 2 : 1));
        Map<Object, Object> map = this.removeThemeSpecificDefaults(uIDefaults);
        this.loadNamedColors(uIDefaults);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Object> entry2 : this.ui.entrySet()) {
            this.apply(entry2.getKey(), entry2.getValue(), uIDefaults, arrayList, hashSet);
        }
        this.applyColorPalette(uIDefaults);
        this.applyCheckBoxColors(uIDefaults);
        for (Map.Entry<String, Object> entry : uiKeyCopying.entrySet()) {
            object = uIDefaults.get(entry.getValue());
            if (object == null) continue;
            uIDefaults.put(entry.getKey(), object);
        }
        Object object2 = uIDefaults.get("Panel.background");
        uIDefaults.put("Button.disabledBackground", object2);
        uIDefaults.put("ToggleButton.disabledBackground", object2);
        this.copyIfNotSet(uIDefaults, "Button.focusedBorderColor", "Component.focusedBorderColor", hashSet);
        uIDefaults.put("Button.hoverBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        uIDefaults.put("HelpButton.hoverBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        Object object3 = uIDefaults.get("Button.startBackground");
        object = uIDefaults.get("Button.startBorderColor");
        if (object3 == null) {
            Object object4 = uIDefaults.get("Button.background");
        }
        if (object == null) {
            object = uIDefaults.get("Button.borderColor");
        }
        uIDefaults.put("HelpButton.background", (Object)var6_11);
        uIDefaults.put("HelpButton.borderColor", object);
        uIDefaults.put("HelpButton.disabledBackground", object2);
        uIDefaults.put("HelpButton.disabledBorderColor", uIDefaults.get("Button.disabledBorderColor"));
        uIDefaults.put("HelpButton.focusedBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        uIDefaults.put("HelpButton.focusedBackground", uIDefaults.get("Button.focusedBackground"));
        Object object5 = this.get(uIDefaults, map, "TextField.background");
        uIDefaults.put("ComboBox.editableBackground", object5);
        uIDefaults.put("Spinner.background", object5);
        uIDefaults.put("Spinner.buttonBackground", uIDefaults.get("ComboBox.buttonEditableBackground"));
        uIDefaults.put("Spinner.buttonArrowColor", uIDefaults.get("ComboBox.buttonArrowColor"));
        uIDefaults.put("Spinner.buttonDisabledArrowColor", uIDefaults.get("ComboBox.buttonDisabledArrowColor"));
        this.putAll(uIDefaults, object5, "EditorPane.background", "FormattedTextField.background", "PasswordField.background", "TextArea.background", "TextPane.background");
        this.putAll(uIDefaults, this.get(uIDefaults, map, "TextField.selectionBackground"), "EditorPane.selectionBackground", "FormattedTextField.selectionBackground", "PasswordField.selectionBackground", "TextArea.selectionBackground", "TextPane.selectionBackground");
        this.putAll(uIDefaults, this.get(uIDefaults, map, "TextField.selectionForeground"), "EditorPane.selectionForeground", "FormattedTextField.selectionForeground", "PasswordField.selectionForeground", "TextArea.selectionForeground", "TextPane.selectionForeground");
        this.putAll(uIDefaults, object2, "ComboBox.disabledBackground", "EditorPane.disabledBackground", "EditorPane.inactiveBackground", "FormattedTextField.disabledBackground", "FormattedTextField.inactiveBackground", "PasswordField.disabledBackground", "PasswordField.inactiveBackground", "Spinner.disabledBackground", "TextArea.disabledBackground", "TextArea.inactiveBackground", "TextField.disabledBackground", "TextField.inactiveBackground", "TextPane.disabledBackground", "TextPane.inactiveBackground");
        if (!hashSet.contains("ToggleButton.startBackground") && !hashSet.contains("*.startBackground")) {
            uIDefaults.put("ToggleButton.startBackground", uIDefaults.get("Button.startBackground"));
        }
        if (!hashSet.contains("ToggleButton.endBackground") && !hashSet.contains("*.endBackground")) {
            uIDefaults.put("ToggleButton.endBackground", uIDefaults.get("Button.endBackground"));
        }
        if (!hashSet.contains("ToggleButton.foreground") && hashSet.contains("Button.foreground")) {
            uIDefaults.put("ToggleButton.foreground", uIDefaults.get("Button.foreground"));
        }
        Color color = uIDefaults.getColor("Panel.background");
        Color color2 = ColorFunctions.applyFunctions(color, new ColorFunctions.HSLIncreaseDecrease(2, this.dark, 5.0f, false, true));
        uIDefaults.put("Desktop.background", new ColorUIResource(color2));
        if (this.isMaterialUILite) {
            uIDefaults.put("List.background", uIDefaults.get("Tree.background"));
            uIDefaults.put("Table.background", uIDefaults.get("Tree.background"));
        }
        if ((n = uIDefaults.getInt("Tree.rowHeight")) > 22) {
            uIDefaults.put("Tree.rowHeight", (Object)22);
        }
        HashMap hashMap = new HashMap();
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = iterator.next();
            String string = (String)objectArray.getKey();
            if (!string.startsWith("*.")) continue;
            hashMap.put(string.substring("*.".length()), objectArray.getValue());
            iterator.remove();
        }
        if (!hashMap.isEmpty()) {
            for (Object object6 : uIDefaults.keySet().toArray()) {
                String string;
                Object v;
                int n2;
                if (!(object6 instanceof String) || (n2 = ((String)object6).lastIndexOf(46)) < 0 || (v = hashMap.get(string = ((String)object6).substring(n2 + 1))) == null) continue;
                uIDefaults.put(object6, v);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Object object7;
            Object object6;
            Object k = entry.getKey();
            object6 = entry.getValue();
            if (k instanceof String && ((String)k).startsWith("[style]") && (object7 = uIDefaults.get(k)) != null) {
                object6 = object7 + "; " + object6;
            }
            uIDefaults.put(k, object6);
        }
        this.colors = null;
        this.ui = null;
        this.icons = null;
    }

    private Object get(UIDefaults uIDefaults, Map<Object, Object> map, String string) {
        return map.getOrDefault(string, uIDefaults.get(string));
    }

    private void putAll(UIDefaults uIDefaults, Object object, String ... stringArray) {
        for (String string : stringArray) {
            uIDefaults.put(string, object);
        }
    }

    private Map<Object, Object> removeThemeSpecificDefaults(UIDefaults uIDefaults) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : uIDefaults.keySet()) {
            if (!(object2 instanceof String) || !((String)object2).startsWith("[") || ((String)object2).startsWith("[style]")) continue;
            arrayList.add((String)object2);
        }
        HashMap hashMap = new HashMap();
        object2 = '[' + this.name.replace(' ', '_') + ']';
        String string = '[' + this.name.replace(' ', '_') + "---" + this.author.replace(' ', '_') + ']';
        String string2 = "[author-" + this.author.replace(' ', '_') + ']';
        String string3 = "[*]";
        String[] stringArray = new String[]{object2, string, string2, string3};
        block1: for (String string4 : arrayList) {
            Object v = uIDefaults.remove(string4);
            for (String string5 : stringArray) {
                if (!string4.startsWith(string5)) continue;
                hashMap.put(string4.substring(string5.length()), v);
                continue block1;
            }
        }
        return hashMap;
    }

    private void loadNamedColors(UIDefaults uIDefaults) {
        if (this.colors == null) {
            return;
        }
        this.namedColors = new HashMap<String, ColorUIResource>();
        for (Map.Entry<String, String> entry : this.colors.entrySet()) {
            String string = entry.getValue();
            ColorUIResource colorUIResource = this.parseColor(string);
            if (colorUIResource == null) continue;
            String string2 = entry.getKey();
            this.namedColors.put(string2, colorUIResource);
            uIDefaults.put("ColorPalette." + string2, colorUIResource);
        }
    }

    private void apply(String string, Object object, UIDefaults uIDefaults, ArrayList<Object> arrayList, Set<String> set) {
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.containsKey("os.default") || map.containsKey("os.windows") || map.containsKey("os.mac") || map.containsKey("os.linux")) {
                String string2;
                String string3 = SystemInfo.isWindows ? "os.windows" : (SystemInfo.isMacOS ? "os.mac" : (string2 = SystemInfo.isLinux ? "os.linux" : null));
                if (string2 != null && map.containsKey(string2)) {
                    this.apply(string, map.get(string2), uIDefaults, arrayList, set);
                } else if (map.containsKey("os.default")) {
                    this.apply(string, map.get("os.default"), uIDefaults, arrayList, set);
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    this.apply(string + '.' + (String)entry.getKey(), entry.getValue(), uIDefaults, arrayList, set);
                }
            }
        } else {
            Object object2;
            if ("".equals(object)) {
                return;
            }
            if (string.endsWith(".border") || string.endsWith(".rowHeight") || string.equals("ComboBox.padding") || string.equals("Spinner.padding") || string.equals("Tree.leftChildIndent") || string.equals("Tree.rightChildIndent")) {
                return;
            }
            if ((string = uiKeyMapping.getOrDefault(string, string)).isEmpty()) {
                return;
            }
            int n = string.indexOf(46);
            if (n > 0 && uiKeyExcludes.contains(string.substring(0, n + 1))) {
                return;
            }
            if (uiKeyDoNotOverride.contains(string) && set.contains(string)) {
                return;
            }
            set.add(string);
            String string4 = object.toString();
            Object object3 = this.namedColors.get(string4);
            if (object3 == null) {
                if (!string4.startsWith("#") && (string.endsWith("ground") || string.endsWith("Color"))) {
                    string4 = this.fixColorIfValid("#" + string4, string4);
                } else if (string4.startsWith("##")) {
                    string4 = this.fixColorIfValid(string4.substring(1), string4);
                } else if ((string.endsWith(".border") || string.endsWith("Border")) && (object2 = StringUtils.split(string4, ',')).size() == 5 && !((String)object2.get(4)).startsWith("#")) {
                    object2.set(4, "#" + (String)object2.get(4));
                    string4 = String.join((CharSequence)",", (Iterable<? extends CharSequence>)object2);
                }
                try {
                    object3 = UIDefaultsLoader.parseValue(string, string4, null);
                }
                catch (RuntimeException runtimeException) {
                    UIDefaultsLoader.logParseError(string, string4, runtimeException, false);
                    return;
                }
            }
            if (string.startsWith("*.")) {
                object2 = string.substring(1);
                if (arrayList.size() != uIDefaults.size()) {
                    arrayList.clear();
                    Enumeration enumeration = uIDefaults.keys();
                    while (enumeration.hasMoreElements()) {
                        arrayList.add(enumeration.nextElement());
                    }
                }
                for (Object e : arrayList) {
                    String string5;
                    if (e.equals("Desktop.background") || e.equals("DesktopIcon.background") || e.equals("TabbedPane.focusColor") || !(e instanceof String) || !(string5 = uiKeyInverseMapping.getOrDefault(e, (String)e)).endsWith((String)object2) || ((String)e).startsWith("CheckBox.icon.")) continue;
                    uIDefaults.put(e, object3);
                }
            } else {
                uIDefaults.put(string, object3);
            }
        }
    }

    private String fixColorIfValid(String string, String string2) {
        try {
            UIDefaultsLoader.parseColorRGBA(string);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string2;
        }
    }

    private void applyColorPalette(UIDefaults uIDefaults) {
        if (this.icons == null) {
            return;
        }
        Object object = this.icons.get("ColorPalette");
        if (!(object instanceof Map)) {
            return;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            ColorUIResource colorUIResource;
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string.startsWith("Checkbox.") || !(v instanceof String)) continue;
            if (this.dark) {
                string = StringUtils.removeTrailing(string, ".Dark");
            }
            if ((colorUIResource = this.toColor((String)v)) == null) continue;
            uIDefaults.put(string, colorUIResource);
        }
    }

    private ColorUIResource toColor(String string) {
        ColorUIResource colorUIResource = this.namedColors.get(string);
        return colorUIResource != null ? colorUIResource : this.parseColor(string);
    }

    private ColorUIResource parseColor(String string) {
        try {
            return UIDefaultsLoader.parseColor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void applyCheckBoxColors(UIDefaults uIDefaults) {
        Object object;
        if (this.icons == null) {
            return;
        }
        Object object2 = this.icons.get("ColorPalette");
        if (!(object2 instanceof Map)) {
            return;
        }
        boolean bl = false;
        Map map = (Map)object2;
        String[] stringArray = map.entrySet().iterator();
        while (stringArray.hasNext()) {
            ColorUIResource colorUIResource;
            String string;
            String[] stringArray2 = stringArray.next();
            String string2 = (String)stringArray2.getKey();
            Object v = stringArray2.getValue();
            if (!string2.startsWith("Checkbox.") || !(v instanceof String)) continue;
            if (this.dark) {
                string2 = StringUtils.removeTrailing(string2, ".Dark");
            }
            if ((string = checkboxKeyMapping.get(string2)) == null) continue;
            object = "CheckBox.icon.";
            if (!this.dark && string.startsWith((String)object)) {
                string = "CheckBox.icon[filled].".concat(string.substring(((String)object).length()));
            }
            if ((colorUIResource = this.toColor((String)v)) != null) {
                uIDefaults.put(string, colorUIResource);
                String string3 = checkboxDuplicateColors.get(string2 + ".Dark");
                if (string3 != null) {
                    String string4;
                    if (this.dark) {
                        string3 = StringUtils.removeTrailing(string3, ".Dark");
                    }
                    if ((string4 = checkboxKeyMapping.get(string3)) != null) {
                        uIDefaults.put(string4, colorUIResource);
                    }
                }
            }
            bl = true;
        }
        if (bl) {
            uIDefaults.remove("CheckBox.icon.focusWidth");
            uIDefaults.put("CheckBox.icon.hoverBorderColor", uIDefaults.get("CheckBox.icon.focusedBorderColor"));
            uIDefaults.remove("CheckBox.icon[filled].focusWidth");
            uIDefaults.put("CheckBox.icon[filled].hoverBorderColor", uIDefaults.get("CheckBox.icon[filled].focusedBorderColor"));
            uIDefaults.put("CheckBox.icon[filled].focusedSelectedBackground", uIDefaults.get("CheckBox.icon[filled].selectedBackground"));
            if (this.dark) {
                for (String string : stringArray = new String[]{"CheckBox.icon.focusedBorderColor", "CheckBox.icon.focusedSelectedBorderColor", "CheckBox.icon[filled].focusedBorderColor", "CheckBox.icon[filled].focusedSelectedBorderColor"}) {
                    object = uIDefaults.getColor(string);
                    if (object == null) continue;
                    uIDefaults.put(string, new ColorUIResource(new Color(((Color)object).getRGB() & 0xFFFFFF | 0xA6000000, true)));
                }
            }
        }
    }

    private void copyIfNotSet(UIDefaults uIDefaults, String string, String string2, Set<String> set) {
        if (!set.contains(string)) {
            uIDefaults.put(string, uIDefaults.get(string2));
        }
    }

    static {
        uiKeyMapping = new HashMap<String, String>();
        uiKeyCopying = new LinkedHashMap<String, String>();
        uiKeyInverseMapping = new HashMap<String, String>();
        checkboxKeyMapping = new HashMap<String, String>();
        checkboxDuplicateColors = new HashMap<String, String>();
        uiKeyExcludes = new HashSet<String>(Arrays.asList("ActionButton.", "ActionToolbar.", "ActionsList.", "AppInspector.", "AssignedMnemonic.", "Autocomplete.", "AvailableMnemonic.", "BigSpinner.", "Bookmark.", "BookmarkIcon.", "BookmarkMnemonicAssigned.", "BookmarkMnemonicAvailable.", "BookmarkMnemonicCurrent.", "BookmarkMnemonicIcon.", "Borders.", "Breakpoint.", "Canvas.", "CodeWithMe.", "ComboBoxButton.", "CompletionPopup.", "ComplexPopup.", "Content.", "CurrentMnemonic.", "Counter.", "Debugger.", "DebuggerPopup.", "DebuggerTabs.", "DefaultTabs.", "Dialog.", "DialogWrapper.", "DragAndDrop.", "Editor.", "EditorGroupsTabs.", "EditorTabs.", "FileColor.", "FlameGraph.", "Focus.", "Git.", "Github.", "GotItTooltip.", "Group.", "Gutter.", "GutterTooltip.", "HeaderColor.", "HelpTooltip.", "Hg.", "IconBadge.", "InformationHint.", "InplaceRefactoringPopup.", "Lesson.", "Link.", "LiveIndicator.", "MainMenu.", "MainToolbar.", "MemoryIndicator.", "MlModelBinding.", "MnemonicIcon.", "NavBar.", "NewClass.", "NewPSD.", "Notification.", "Notifications.", "NotificationsToolwindow.", "OnePixelDivider.", "OptionButton.", "Outline.", "ParameterInfo.", "Plugins.", "ProgressIcon.", "PsiViewer.", "ReviewList.", "RunWidget.", "ScreenView.", "SearchEverywhere.", "SearchFieldWithExtension.", "SearchMatch.", "SearchOption.", "SearchResults.", "SegmentedButton.", "Settings.", "SidePanel.", "Space.", "SpeedSearch.", "StateWidget.", "StatusBar.", "Tag.", "TipOfTheDay.", "ToolbarComboWidget.", "ToolWindow.", "UIDesigner.", "UnattendedHostStatus.", "ValidationTooltip.", "VersionControl.", "WelcomeScreen.", "darcula.", "dropArea.", "icons.", "intellijlaf.", "macOSWindow.", "material.", "tooltips.", "Checkbox.", "Toolbar.", "Tooltip.", "UiDesigner.", "link."));
        uiKeyDoNotOverride = new HashSet<String>(Arrays.asList("TabbedPane.selectedForeground"));
        uiKeyMapping.put("ComboBox.background", "");
        uiKeyMapping.put("ComboBox.buttonBackground", "");
        uiKeyMapping.put("ComboBox.nonEditableBackground", "ComboBox.background");
        uiKeyMapping.put("ComboBox.ArrowButton.background", "ComboBox.buttonEditableBackground");
        uiKeyMapping.put("ComboBox.ArrowButton.disabledIconColor", "ComboBox.buttonDisabledArrowColor");
        uiKeyMapping.put("ComboBox.ArrowButton.iconColor", "ComboBox.buttonArrowColor");
        uiKeyMapping.put("ComboBox.ArrowButton.nonEditableBackground", "ComboBox.buttonBackground");
        uiKeyCopying.put("ComboBox.buttonSeparatorColor", "Component.borderColor");
        uiKeyCopying.put("ComboBox.buttonDisabledSeparatorColor", "Component.disabledBorderColor");
        uiKeyMapping.put("Component.inactiveErrorFocusColor", "Component.error.borderColor");
        uiKeyMapping.put("Component.errorFocusColor", "Component.error.focusedBorderColor");
        uiKeyMapping.put("Component.inactiveWarningFocusColor", "Component.warning.borderColor");
        uiKeyMapping.put("Component.warningFocusColor", "Component.warning.focusedBorderColor");
        uiKeyMapping.put("Link.activeForeground", "Component.linkColor");
        uiKeyMapping.put("Menu.border", "Menu.margin");
        uiKeyMapping.put("MenuItem.border", "MenuItem.margin");
        uiKeyCopying.put("CheckBoxMenuItem.margin", "MenuItem.margin");
        uiKeyCopying.put("RadioButtonMenuItem.margin", "MenuItem.margin");
        uiKeyMapping.put("PopupMenu.border", "PopupMenu.borderInsets");
        uiKeyCopying.put("MenuItem.underlineSelectionColor", "TabbedPane.underlineColor");
        uiKeyCopying.put("Menu.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("MenuItem.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("CheckBoxMenuItem.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("RadioButtonMenuItem.selectionBackground", "List.selectionBackground");
        uiKeyMapping.put("ProgressBar.background", "");
        uiKeyMapping.put("ProgressBar.foreground", "");
        uiKeyMapping.put("ProgressBar.trackColor", "ProgressBar.background");
        uiKeyMapping.put("ProgressBar.progressColor", "ProgressBar.foreground");
        uiKeyCopying.put("ProgressBar.selectionForeground", "ProgressBar.background");
        uiKeyCopying.put("ProgressBar.selectionBackground", "ProgressBar.foreground");
        uiKeyMapping.put("ScrollBar.trackColor", "ScrollBar.track");
        uiKeyMapping.put("ScrollBar.thumbColor", "ScrollBar.thumb");
        uiKeyMapping.put("Separator.separatorColor", "Separator.foreground");
        uiKeyMapping.put("Slider.trackWidth", "");
        uiKeyCopying.put("Slider.trackValueColor", "ProgressBar.foreground");
        uiKeyCopying.put("Slider.thumbColor", "ProgressBar.foreground");
        uiKeyCopying.put("Slider.trackColor", "ProgressBar.background");
        uiKeyCopying.put("Spinner.buttonSeparatorColor", "Component.borderColor");
        uiKeyCopying.put("Spinner.buttonDisabledSeparatorColor", "Component.disabledBorderColor");
        uiKeyMapping.put("DefaultTabs.underlinedTabBackground", "TabbedPane.selectedBackground");
        uiKeyMapping.put("DefaultTabs.underlinedTabForeground", "TabbedPane.selectedForeground");
        uiKeyMapping.put("DefaultTabs.inactiveUnderlineColor", "TabbedPane.inactiveUnderlineColor");
        uiKeyCopying.put("TitlePane.inactiveBackground", "TitlePane.background");
        uiKeyMapping.put("TitlePane.infoForeground", "TitlePane.foreground");
        uiKeyMapping.put("TitlePane.inactiveInfoForeground", "TitlePane.inactiveForeground");
        Map.Entry[] entryArray = uiKeyMapping.entrySet().iterator();
        while (entryArray.hasNext()) {
            Map.Entry[] entryArray2 = entryArray.next();
            uiKeyInverseMapping.put(entryArray2.getValue(), entryArray2.getKey());
        }
        uiKeyCopying.put("ToggleButton.tab.underlineColor", "TabbedPane.underlineColor");
        uiKeyCopying.put("ToggleButton.tab.disabledUnderlineColor", "TabbedPane.disabledUnderlineColor");
        uiKeyCopying.put("ToggleButton.tab.selectedBackground", "TabbedPane.selectedBackground");
        uiKeyCopying.put("ToggleButton.tab.hoverBackground", "TabbedPane.hoverColor");
        uiKeyCopying.put("ToggleButton.tab.focusBackground", "TabbedPane.focusColor");
        checkboxKeyMapping.put("Checkbox.Background.Default", "CheckBox.icon.background");
        checkboxKeyMapping.put("Checkbox.Background.Disabled", "CheckBox.icon.disabledBackground");
        checkboxKeyMapping.put("Checkbox.Border.Default", "CheckBox.icon.borderColor");
        checkboxKeyMapping.put("Checkbox.Border.Disabled", "CheckBox.icon.disabledBorderColor");
        checkboxKeyMapping.put("Checkbox.Focus.Thin.Default", "CheckBox.icon.focusedBorderColor");
        checkboxKeyMapping.put("Checkbox.Focus.Wide", "CheckBox.icon.focusColor");
        checkboxKeyMapping.put("Checkbox.Foreground.Disabled", "CheckBox.icon.disabledCheckmarkColor");
        checkboxKeyMapping.put("Checkbox.Background.Selected", "CheckBox.icon.selectedBackground");
        checkboxKeyMapping.put("Checkbox.Border.Selected", "CheckBox.icon.selectedBorderColor");
        checkboxKeyMapping.put("Checkbox.Foreground.Selected", "CheckBox.icon.checkmarkColor");
        checkboxKeyMapping.put("Checkbox.Focus.Thin.Selected", "CheckBox.icon.focusedSelectedBorderColor");
        checkboxDuplicateColors.put("Checkbox.Background.Default.Dark", "Checkbox.Background.Selected.Dark");
        checkboxDuplicateColors.put("Checkbox.Border.Default.Dark", "Checkbox.Border.Selected.Dark");
        checkboxDuplicateColors.put("Checkbox.Focus.Thin.Default.Dark", "Checkbox.Focus.Thin.Selected.Dark");
        for (Map.Entry entry : entryArray = checkboxDuplicateColors.entrySet().toArray(new Map.Entry[checkboxDuplicateColors.size()])) {
            checkboxDuplicateColors.put((String)entry.getValue(), (String)entry.getKey());
        }
    }

    public static class ThemeLaf
    extends FlatLaf {
        private final IntelliJTheme theme;

        public ThemeLaf(IntelliJTheme intelliJTheme) {
            this.theme = intelliJTheme;
        }

        @Override
        public String getName() {
            return this.theme.name;
        }

        @Override
        public String getDescription() {
            return this.getName();
        }

        @Override
        public boolean isDark() {
            return this.theme.dark;
        }

        public IntelliJTheme getTheme() {
            return this.theme;
        }

        @Override
        void applyAdditionalDefaults(UIDefaults uIDefaults) {
            this.theme.applyProperties(uIDefaults);
        }

        protected ArrayList<Class<?>> getLafClassesForDefaultsLoading() {
            ArrayList arrayList = new ArrayList();
            arrayList.add(FlatLaf.class);
            arrayList.add(this.theme.dark ? FlatDarkLaf.class : FlatLightLaf.class);
            arrayList.add(this.theme.dark ? FlatDarculaLaf.class : FlatIntelliJLaf.class);
            arrayList.add(ThemeLaf.class);
            return arrayList;
        }
    }
}

