/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.text.StyleContext;

class LinuxFontPolicy {
    LinuxFontPolicy() {
    }

    static Font getFont() {
        return SystemInfo.isKDE ? LinuxFontPolicy.getKDEFont() : LinuxFontPolicy.getGnomeFont();
    }

    private static Font getGnomeFont() {
        int n;
        String string;
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName");
        if (!(object instanceof String)) {
            object = "sans 10";
        }
        String string2 = "";
        int n2 = 0;
        double d = 10.0;
        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.endsWith(",")) {
                string3 = string3.substring(0, string3.length() - 1).trim();
            }
            if ((string = string3.toLowerCase(Locale.ENGLISH)).equals("italic") || string.equals("oblique")) {
                n2 |= 2;
                continue;
            }
            if (string.equals("bold")) {
                n2 |= 1;
                continue;
            }
            if (Character.isDigit(string3.charAt(0))) {
                try {
                    d = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string.startsWith("semi-") || string.startsWith("demi-")) {
                string3 = string3.substring(0, 4) + string3.substring(5);
            } else if (string.startsWith("extra-") || string.startsWith("ultra-")) {
                string3 = string3.substring(0, 5) + string3.substring(6);
            }
            string2 = string2.isEmpty() ? string3 : string2 + ' ' + string3;
        }
        if (string2.startsWith("Ubuntu") && !SystemInfo.isJetBrainsJVM && !FlatSystemProperties.getBoolean("flatlaf.useUbuntuFont", false)) {
            string2 = "Liberation Sans";
        }
        if ((n = (int)((d *= LinuxFontPolicy.getGnomeFontScale()) + 0.5)) < 1) {
            n = 1;
        }
        if ((string = LinuxFontPolicy.mapFcName(string2.toLowerCase(Locale.ENGLISH))) != null) {
            string2 = string;
        }
        return LinuxFontPolicy.createFontEx(string2, n2, n, d);
    }

    private static Font createFontEx(String string, int n, int n2, double d) {
        while (true) {
            Font font = LinuxFontPolicy.createFont(string, n, n2, d);
            if ("Dialog".equals(string)) {
                return font;
            }
            if (!"Dialog".equals(font.getFamily())) {
                FontMetrics fontMetrics = StyleContext.getDefaultStyleContext().getFontMetrics(font);
                if (fontMetrics.getHeight() > n2 * 2 || fontMetrics.stringWidth("a") == 0) {
                    return LinuxFontPolicy.createFont("Dialog", n, n2, d);
                }
                return font;
            }
            int n3 = string.lastIndexOf(32);
            if (n3 < 0) {
                return LinuxFontPolicy.createFont("Dialog", n, n2, d);
            }
            String string2 = string.substring(n3 + 1).toLowerCase(Locale.ENGLISH);
            if (string2.contains("bold") || string2.contains("heavy") || string2.contains("black")) {
                n |= 1;
            }
            string = string.substring(0, n3);
        }
    }

    private static Font createFont(String string, int n, int n2, double d) {
        Font font = FlatLaf.createCompositeFont(string, n, n2);
        font = font.deriveFont(n, (float)d);
        return font;
    }

    private static double getGnomeFontScale() {
        if (LinuxFontPolicy.isSystemScaling()) {
            return 1.3333333333333333;
        }
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
        if (object instanceof Integer) {
            int n = (Integer)object / 1024;
            if (n == -1) {
                n = 96;
            }
            if (n < 50) {
                n = 50;
            }
            return (double)n / 72.0;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getNormalizingTransform().getScaleY();
    }

    private static String mapFcName(String string) {
        switch (string) {
            case "sans": {
                return "sansserif";
            }
            case "sans-serif": {
                return "sansserif";
            }
            case "serif": {
                return "serif";
            }
            case "monospace": {
                return "monospaced";
            }
        }
        return null;
    }

    private static Font getKDEFont() {
        double d;
        double d2;
        List<String> list = LinuxFontPolicy.readConfig("kdeglobals");
        List<String> list2 = LinuxFontPolicy.readConfig("kcmfonts");
        String string = LinuxFontPolicy.getConfigEntry(list, "General", "font");
        String string2 = LinuxFontPolicy.getConfigEntry(list2, "General", "forceFontDPI");
        String string3 = "sansserif";
        int n = 0;
        int n2 = 10;
        if (string != null) {
            List<String> list3 = StringUtils.split(string, ',');
            try {
                string3 = list3.get(0);
                n2 = Integer.parseInt(list3.get(1));
                if ("75".equals(list3.get(4))) {
                    n |= 1;
                }
                if ("1".equals(list3.get(5))) {
                    n |= 2;
                }
            }
            catch (RuntimeException runtimeException) {
                LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to parse 'font=" + string + "'.", runtimeException);
            }
        }
        int n3 = 96;
        if (string2 != null && !LinuxFontPolicy.isSystemScaling()) {
            try {
                n3 = Integer.parseInt(string2);
                if (n3 <= 0) {
                    n3 = 96;
                }
                if (n3 < 50) {
                    n3 = 50;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to parse 'forceFontDPI=" + string2 + "'.", numberFormatException);
            }
        }
        if ((n2 = (int)((d2 = (double)n2 * (d = (double)n3 / 72.0)) + 0.5)) < 1) {
            n2 = 1;
        }
        return LinuxFontPolicy.createFont(string3, n, n2, d2);
    }

    private static List<String> readConfig(String string) {
        String string2;
        File file = new File(System.getProperty("user.home"));
        String[] stringArray = new String[]{".config", ".kde4/share/config", ".kde/share/config"};
        File file2 = null;
        Object object = stringArray;
        int n = ((String[])object).length;
        for (int i = 0; i < n && !(file2 = new File(file, (string2 = object[i]) + "/" + string)).isFile(); ++i) {
        }
        if (!file2.isFile()) {
            return Collections.emptyList();
        }
        object = new ArrayList(200);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.US_ASCII));){
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                ((ArrayList)object).add(string3);
            }
        }
        catch (IOException iOException) {
            LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to read '" + string + "'.", iOException);
        }
        return object;
    }

    private static String getConfigEntry(List<String> list, String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        boolean bl = false;
        for (String string3 : list) {
            if (!bl) {
                if (string3.length() < n + 2 || string3.charAt(0) != '[' || string3.charAt(n + 1) != ']' || string3.indexOf(string) != 1) continue;
                bl = true;
                continue;
            }
            if (string3.startsWith("[")) {
                return null;
            }
            if (string3.length() < n2 + 2 || string3.charAt(n2) != '=' || !string3.startsWith(string2)) continue;
            return string3.substring(n2 + 1);
        }
        return null;
    }

    private static boolean isSystemScaling() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return UIScale.getSystemScaleFactor(graphicsConfiguration) > 1.0;
    }
}

