/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.ScaledImageIcon;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class FlatInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private JLabel titleLabel;
    private JPanel buttonPanel;

    public FlatInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this, "InternalFrameTitlePane.border");
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new FlatPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new BorderLayout(UIScale.scale(4), 0);
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
        Border border = BorderFactory.createEmptyBorder();
        this.iconButton.setBorder(border);
        this.maxButton.setBorder(border);
        this.closeButton.setBorder(border);
        this.updateButtonsVisibility();
    }

    @Override
    protected void addSubComponents() {
        this.titleLabel = new JLabel(this.frame.getTitle());
        this.titleLabel.setFont(FlatUIUtils.nonUIResource(this.getFont()));
        this.titleLabel.setMinimumSize(new Dimension(UIScale.scale(32), 1));
        this.updateFrameIcon();
        this.updateColors();
        this.buttonPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = dimension.height;
                if (!FlatInternalFrameTitlePane.this.iconButton.isVisible()) {
                    n = Math.max(n, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).iconButton.getPreferredSize().height);
                }
                if (!FlatInternalFrameTitlePane.this.maxButton.isVisible()) {
                    n = Math.max(n, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).maxButton.getPreferredSize().height);
                }
                if (!FlatInternalFrameTitlePane.this.closeButton.isVisible()) {
                    n = Math.max(n, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).closeButton.getPreferredSize().height);
                }
                return new Dimension(dimension.width, n);
            }
        };
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.add(this.iconButton);
        this.buttonPanel.add(this.maxButton);
        this.buttonPanel.add(this.closeButton);
        this.add((Component)this.titleLabel, "Center");
        this.add((Component)this.buttonPanel, "After");
    }

    protected void updateFrameIcon() {
        Icon icon = this.frame.getFrameIcon();
        if (icon != null && (icon.getIconWidth() == 0 || icon.getIconHeight() == 0)) {
            icon = null;
        } else if (icon instanceof ImageIcon) {
            icon = new ScaledImageIcon((ImageIcon)icon);
        }
        this.titleLabel.setIcon(icon);
    }

    protected void updateColors() {
        Color color = FlatUIUtils.nonUIResource(this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor);
        Color color2 = FlatUIUtils.nonUIResource(this.frame.isSelected() ? this.selectedTextColor : this.notSelectedTextColor);
        this.titleLabel.setForeground(color2);
        this.iconButton.setBackground(color);
        this.iconButton.setForeground(color2);
        this.maxButton.setBackground(color);
        this.maxButton.setForeground(color2);
        this.closeButton.setBackground(color);
        this.closeButton.setForeground(color2);
    }

    protected void updateButtonsVisibility() {
        this.iconButton.setVisible(this.frame.isIconifiable());
        this.maxButton.setVisible(this.frame.isMaximizable());
        this.closeButton.setVisible(this.frame.isClosable());
    }

    Rectangle getFrameIconBounds() {
        Icon icon = this.titleLabel.getIcon();
        if (icon == null) {
            return null;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        boolean bl = this.titleLabel.getComponentOrientation().isLeftToRight();
        int n3 = this.titleLabel.getX() + (bl ? 0 : this.titleLabel.getWidth() - n);
        int n4 = this.titleLabel.getY() + (this.titleLabel.getHeight() - n2) / 2;
        return new Rectangle(n3, n4, n, n2);
    }

    @Override
    protected void assembleSystemMenu() {
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
    }

    protected class FlatPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        protected FlatPropertyChangeHandler() {
            super(FlatInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "title": {
                    FlatInternalFrameTitlePane.this.titleLabel.setText(FlatInternalFrameTitlePane.this.frame.getTitle());
                    break;
                }
                case "frameIcon": {
                    FlatInternalFrameTitlePane.this.updateFrameIcon();
                    break;
                }
                case "selected": {
                    FlatInternalFrameTitlePane.this.updateColors();
                    break;
                }
                case "iconable": 
                case "maximizable": 
                case "closable": {
                    FlatInternalFrameTitlePane.this.updateButtonsVisibility();
                    FlatInternalFrameTitlePane.this.enableActions();
                    FlatInternalFrameTitlePane.this.revalidate();
                    FlatInternalFrameTitlePane.this.repaint();
                    return;
                }
                case "componentOrientation": {
                    FlatInternalFrameTitlePane.this.applyComponentOrientation(FlatInternalFrameTitlePane.this.frame.getComponentOrientation());
                    break;
                }
                case "opaque": {
                    return;
                }
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

