/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class FlatMenuBarUI
extends BasicMenuBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Insets itemMargins;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected Insets selectionEmbeddedInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc = -1;
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionBackground;
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionColor;
    @FlatStylingSupport.Styleable
    protected int underlineSelectionHeight = -1;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatMenuBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuBar, "opaque", false);
        LayoutManager layoutManager = this.menuBar.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.menuBar.setLayout(new FlatMenuBarLayout(this.menuBar));
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.menuBar, this::installStyle, null);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuBar);
        if (actionMap != null && !(actionMap.get("takeFocus") instanceof TakeFocusAction)) {
            actionMap.put("takeFocus", new TakeFocusAction("takeFocus"));
        }
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuBar, "MenuBar"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.menuBar, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.menuBar.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.menuBar.getBorder(), string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Color color = this.getBackground(jComponent);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    protected Color getBackground(JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (jComponent.isOpaque()) {
            return color;
        }
        if (!(color instanceof UIResource)) {
            return null;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
        if (jRootPane == null || !(jRootPane.getParent() instanceof Window) || jRootPane.getJMenuBar() != jComponent) {
            return color;
        }
        if (FlatMenuBarUI.useUnifiedBackground(jComponent)) {
            color = FlatUIUtils.getParentBackground(jComponent);
        }
        if (FlatUIUtils.isFullScreen(jRootPane)) {
            return color;
        }
        return FlatRootPaneUI.isMenuBarEmbedded(jRootPane) ? null : color;
    }

    static boolean useUnifiedBackground(Component component) {
        JRootPane jRootPane;
        return UIManager.getBoolean("TitlePane.unifiedBackground") && (jRootPane = SwingUtilities.getRootPane(component)) != null && jRootPane.getParent() instanceof Window && jRootPane.getJMenuBar() == component && jRootPane.getWindowDecorationStyle() != 0;
    }

    private static class TakeFocusAction
    extends FlatUIAction {
        TakeFocusAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray;
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                if (SystemInfo.isWindows) {
                    MenuElement[] menuElementArray2 = new MenuElement[2];
                    menuElementArray2[0] = jMenuBar;
                    menuElementArray = menuElementArray2;
                    menuElementArray2[1] = jMenu;
                } else {
                    MenuElement[] menuElementArray3 = new MenuElement[3];
                    menuElementArray3[0] = jMenuBar;
                    menuElementArray3[1] = jMenu;
                    menuElementArray = menuElementArray3;
                    menuElementArray3[2] = jMenu.getPopupMenu();
                }
                menuSelectionManager.setSelectedPath(menuElementArray);
                FlatLaf.showMnemonics(jMenuBar);
            }
        }
    }

    protected static class FlatMenuBarLayout
    extends DefaultMenuLayout {
        public FlatMenuBarLayout(Container container) {
            super(container, 2);
        }

        @Override
        public void layoutContainer(Container container) {
            block14: {
                int n;
                super.layoutContainer(container);
                JRootPane jRootPane = SwingUtilities.getRootPane(container);
                if (jRootPane == null || jRootPane.getJMenuBar() != container) {
                    return;
                }
                FlatTitlePane flatTitlePane = FlatRootPaneUI.getTitlePane(jRootPane);
                if (flatTitlePane == null || !flatTitlePane.isMenuBarEmbedded()) {
                    return;
                }
                Component component = flatTitlePane.findHorizontalGlue((JMenuBar)container);
                int n2 = UIScale.scale(flatTitlePane.titleMinimumWidth);
                if (component == null || component.getWidth() >= n2) break block14;
                int n3 = -1;
                Component[] componentArray = container.getComponents();
                for (n = componentArray.length - 1; n >= 0; --n) {
                    if (componentArray[n] != component) continue;
                    n3 = n;
                    break;
                }
                if (n3 < 0) {
                    return;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    Component component2;
                    int n4;
                    n = n2 - component.getWidth();
                    component.setSize(n2, component.getHeight());
                    int n5 = container.getWidth() - container.getInsets().right - n2;
                    if (n5 < component.getX()) {
                        n -= component.getX() - n5;
                        component.setLocation(n5, component.getY());
                        for (n4 = n3 - 1; n4 >= 0; --n4) {
                            component2 = componentArray[n4];
                            if (component2.getX() <= n5) {
                                component2.setSize(n5 - component2.getX(), component2.getHeight());
                                break;
                            }
                            component2.setBounds(n5, component2.getY(), 0, component2.getHeight());
                        }
                    }
                    for (n4 = n3 + 1; n4 < componentArray.length; ++n4) {
                        component2 = componentArray[n4];
                        component2.setLocation(component2.getX() + n, component2.getY());
                    }
                } else {
                    int n6;
                    n = n2 - component.getWidth();
                    component.setBounds(component.getX() - n, component.getY(), n2, component.getHeight());
                    int n7 = container.getInsets().left;
                    if (n7 > component.getX()) {
                        n -= component.getX() - n7;
                        component.setLocation(n7, component.getY());
                        n6 = component.getX() + component.getWidth();
                        for (int i = n3 - 1; i >= 0; --i) {
                            Component component3 = componentArray[i];
                            if (component3.getX() + component3.getWidth() >= n6) {
                                component3.setBounds(n6, component3.getY(), component3.getWidth() - (n6 - component3.getX()), component3.getHeight());
                                break;
                            }
                            component3.setBounds(n6, component3.getY(), 0, component3.getHeight());
                        }
                    }
                    for (n6 = n3 + 1; n6 < componentArray.length; ++n6) {
                        Component component4 = componentArray[n6];
                        component4.setLocation(component4.getX() - n, component4.getY());
                    }
                }
            }
        }
    }
}

