/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

@FlatStylingSupport.StyleableFields(value={@FlatStylingSupport.StyleableField(cls=BasicScrollBarUI.class, key="track", fieldName="trackColor"), @FlatStylingSupport.StyleableField(cls=BasicScrollBarUI.class, key="thumb", fieldName="thumbColor"), @FlatStylingSupport.StyleableField(cls=BasicScrollBarUI.class, key="width", fieldName="scrollBarWidth"), @FlatStylingSupport.StyleableField(cls=BasicScrollBarUI.class, key="minimumThumbSize"), @FlatStylingSupport.StyleableField(cls=BasicScrollBarUI.class, key="maximumThumbSize")})
public class FlatScrollBarUI
extends BasicScrollBarUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected boolean allowsAbsolutePositioning;
    @FlatStylingSupport.Styleable
    protected Dimension minimumButtonSize;
    @FlatStylingSupport.Styleable
    protected Insets trackInsets;
    @FlatStylingSupport.Styleable
    protected Insets thumbInsets;
    @FlatStylingSupport.Styleable
    protected int trackArc;
    @FlatStylingSupport.Styleable
    protected int thumbArc;
    @FlatStylingSupport.Styleable
    protected Color hoverTrackColor;
    @FlatStylingSupport.Styleable
    protected Color hoverThumbColor;
    @FlatStylingSupport.Styleable
    protected boolean hoverThumbWithTrack;
    @FlatStylingSupport.Styleable
    protected Color pressedTrackColor;
    @FlatStylingSupport.Styleable
    protected Color pressedThumbColor;
    @FlatStylingSupport.Styleable
    protected boolean pressedThumbWithTrack;
    @FlatStylingSupport.Styleable
    protected boolean showButtons;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color hoverButtonBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedButtonBackground;
    private MouseAdapter hoverListener;
    protected boolean hoverTrack;
    protected boolean hoverThumb;
    private Map<String, Object> oldStyleValues;
    private boolean isAWTPeer;
    private static boolean isPressed;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatScrollBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new ScrollBarHoverListener();
        this.scrollbar.addMouseListener(this.hoverListener);
        this.scrollbar.addMouseMotionListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this.hoverListener);
        this.scrollbar.removeMouseMotionListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.allowsAbsolutePositioning = super.getSupportsAbsolutePositioning();
        this.minimumButtonSize = UIManager.getDimension("ScrollBar.minimumButtonSize");
        this.trackInsets = UIManager.getInsets("ScrollBar.trackInsets");
        this.thumbInsets = UIManager.getInsets("ScrollBar.thumbInsets");
        this.trackArc = UIManager.getInt("ScrollBar.trackArc");
        this.thumbArc = UIManager.getInt("ScrollBar.thumbArc");
        this.hoverTrackColor = UIManager.getColor("ScrollBar.hoverTrackColor");
        this.hoverThumbColor = UIManager.getColor("ScrollBar.hoverThumbColor");
        this.hoverThumbWithTrack = UIManager.getBoolean("ScrollBar.hoverThumbWithTrack");
        this.pressedTrackColor = UIManager.getColor("ScrollBar.pressedTrackColor");
        this.pressedThumbColor = UIManager.getColor("ScrollBar.pressedThumbColor");
        this.pressedThumbWithTrack = UIManager.getBoolean("ScrollBar.pressedThumbWithTrack");
        this.showButtons = UIManager.getBoolean("ScrollBar.showButtons");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.buttonArrowColor = UIManager.getColor("ScrollBar.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ScrollBar.buttonDisabledArrowColor");
        this.hoverButtonBackground = UIManager.getColor("ScrollBar.hoverButtonBackground");
        this.pressedButtonBackground = UIManager.getColor("ScrollBar.pressedButtonBackground");
        if (this.trackInsets == null) {
            this.trackInsets = new Insets(0, 0, 0, 0);
        }
        if (this.thumbInsets == null) {
            this.thumbInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.minimumButtonSize = null;
        this.trackInsets = null;
        this.thumbInsets = null;
        this.hoverTrackColor = null;
        this.hoverThumbColor = null;
        this.pressedTrackColor = null;
        this.pressedThumbColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.hoverButtonBackground = null;
        this.pressedButtonBackground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            block7 : switch (propertyChangeEvent.getPropertyName()) {
                case "JScrollBar.showButtons": {
                    this.scrollbar.revalidate();
                    this.scrollbar.repaint();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.scrollbar.revalidate();
                    this.scrollbar.repaint();
                    break;
                }
                case "componentOrientation": {
                    InputMap inputMap;
                    InputMap inputMap2 = (InputMap)UIManager.get("ScrollBar.ancestorInputMap");
                    if (!this.scrollbar.getComponentOrientation().isLeftToRight() && (inputMap = (InputMap)UIManager.get("ScrollBar.ancestorInputMap.RightToLeft")) != null) {
                        inputMap.setParent(inputMap2);
                        inputMap2 = inputMap;
                    }
                    SwingUtilities.replaceUIInputMap(this.scrollbar, 1, inputMap2);
                    break;
                }
                case "ancestor": {
                    if (!SystemInfo.isMacOS) break;
                    Container container = this.scrollbar.getParent();
                    for (int i = 0; i < 2 && container != null; ++i, container = container.getParent()) {
                        if (!FlatUIUtils.isAWTPeer(container)) continue;
                        this.isAWTPeer = true;
                        if (!FlatLaf.isLafDark()) break block7;
                        FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> {
                            JScrollBar jScrollBar = this.scrollbar;
                            this.uninstallUI(jScrollBar);
                            this.installUI(jScrollBar);
                        });
                        break block7;
                    }
                    break;
                }
            }
        };
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.scrollbar, "ScrollBar"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.incrButton instanceof FlatScrollBarButton) {
            ((FlatScrollBarButton)this.incrButton).updateStyle();
        }
        if (this.decrButton instanceof FlatScrollBarButton) {
            ((FlatScrollBarButton)this.decrButton).updateStyle();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.scrollbar, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return UIScale.scale(super.getPreferredSize(jComponent));
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return new FlatScrollBarButton(n);
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return new FlatScrollBarButton(n);
    }

    protected boolean isShowButtons() {
        JScrollPane jScrollPane;
        Object object = this.scrollbar.getClientProperty("JScrollBar.showButtons");
        if (object == null && this.scrollbar.getParent() instanceof JScrollPane && (object = (jScrollPane = (JScrollPane)this.scrollbar.getParent()).getClientProperty("JScrollBar.showButtons")) == null && jScrollPane.getUI() instanceof FlatScrollPaneUI) {
            object = ((FlatScrollPaneUI)jScrollPane.getUI()).showButtons;
        }
        return object != null ? Objects.equals(object, true) : this.showButtons;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        super.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        graphics.setColor(this.getTrackColor(jComponent, this.hoverTrack, isPressed && this.hoverTrack && !this.hoverThumb));
        this.paintTrackOrThumb(graphics, jComponent, rectangle, this.trackInsets, this.trackArc);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        graphics.setColor(this.getThumbColor(jComponent, this.hoverThumb || this.hoverThumbWithTrack && this.hoverTrack, isPressed && (this.hoverThumb || this.pressedThumbWithTrack && this.hoverTrack)));
        this.paintTrackOrThumb(graphics, jComponent, rectangle, this.thumbInsets, this.thumbArc);
    }

    protected void paintTrackOrThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle, Insets insets, int n) {
        if (this.scrollbar.getOrientation() == 0) {
            insets = new Insets(insets.right, insets.top, insets.left, insets.bottom);
        }
        rectangle = FlatUIUtils.subtractInsets(rectangle, UIScale.scale(insets));
        if (n <= 0) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            n = Math.min(UIScale.scale(n), Math.min(rectangle.width, rectangle.height));
            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n);
        }
    }

    @Override
    protected void paintDecreaseHighlight(Graphics graphics) {
    }

    @Override
    protected void paintIncreaseHighlight(Graphics graphics) {
    }

    protected Color getTrackColor(JComponent jComponent, boolean bl, boolean bl2) {
        Color color = FlatUIUtils.deriveColor(this.trackColor, jComponent.getBackground());
        return bl2 && this.pressedTrackColor != null ? FlatUIUtils.deriveColor(this.pressedTrackColor, color) : (bl && this.hoverTrackColor != null && !this.isAWTPeer ? FlatUIUtils.deriveColor(this.hoverTrackColor, color) : color);
    }

    protected Color getThumbColor(JComponent jComponent, boolean bl, boolean bl2) {
        Color color = FlatUIUtils.deriveColor(this.trackColor, jComponent.getBackground());
        Color color2 = FlatUIUtils.deriveColor(this.thumbColor, color);
        return bl2 && this.pressedThumbColor != null ? FlatUIUtils.deriveColor(this.pressedThumbColor, color2) : (bl && this.hoverThumbColor != null && !this.isAWTPeer ? FlatUIUtils.deriveColor(this.hoverThumbColor, color2) : color2);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return UIScale.scale(FlatUIUtils.addInsets(super.getMinimumThumbSize(), this.thumbInsets));
    }

    @Override
    protected Dimension getMaximumThumbSize() {
        return UIScale.scale(FlatUIUtils.addInsets(super.getMaximumThumbSize(), this.thumbInsets));
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return this.allowsAbsolutePositioning;
    }

    protected class FlatScrollBarButton
    extends FlatArrowButton {
        protected FlatScrollBarButton(int n) {
            this(n, flatScrollBarUI.arrowType, flatScrollBarUI.buttonArrowColor, flatScrollBarUI.buttonDisabledArrowColor, null, flatScrollBarUI.hoverButtonBackground, null, flatScrollBarUI.pressedButtonBackground);
        }

        protected FlatScrollBarButton(int n, String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
            super(n, string, color, color2, color3, color4, color5, color6);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        protected void updateStyle() {
            this.updateStyle(FlatScrollBarUI.this.arrowType, FlatScrollBarUI.this.buttonArrowColor, FlatScrollBarUI.this.buttonDisabledArrowColor, null, FlatScrollBarUI.this.hoverButtonBackground, null, FlatScrollBarUI.this.pressedButtonBackground);
        }

        @Override
        public int getArrowWidth() {
            int n = Math.round(6.0f * ((float)FlatScrollBarUI.this.scrollBarWidth / 10.0f));
            n = FlatScrollBarUI.this.scrollBarWidth - (FlatScrollBarUI.this.scrollBarWidth - n) / 2 * 2;
            return n;
        }

        @Override
        protected Color deriveBackground(Color color) {
            return FlatUIUtils.deriveColor(color, FlatScrollBarUI.this.scrollbar.getBackground());
        }

        @Override
        public Dimension getPreferredSize() {
            if (FlatScrollBarUI.this.isShowButtons()) {
                int n = UIScale.scale(Math.max(FlatScrollBarUI.this.scrollBarWidth, FlatScrollBarUI.this.minimumButtonSize != null ? FlatScrollBarUI.this.minimumButtonSize.width : 0));
                int n2 = UIScale.scale(Math.max(FlatScrollBarUI.this.scrollBarWidth, FlatScrollBarUI.this.minimumButtonSize != null ? FlatScrollBarUI.this.minimumButtonSize.height : 0));
                return new Dimension(n, n2);
            }
            return new Dimension();
        }

        @Override
        public Dimension getMinimumSize() {
            return FlatScrollBarUI.this.isShowButtons() ? super.getMinimumSize() : new Dimension();
        }

        @Override
        public Dimension getMaximumSize() {
            return FlatScrollBarUI.this.isShowButtons() ? super.getMaximumSize() : new Dimension();
        }
    }

    private class ScrollBarHoverListener
    extends MouseAdapter {
        private ScrollBarHoverListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!isPressed) {
                FlatScrollBarUI.this.hoverThumb = false;
                FlatScrollBarUI.this.hoverTrack = false;
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!isPressed) {
                this.update(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) || this.isAbsolutePositioning(mouseEvent)) {
                isPressed = true;
                this.repaint();
                if (this.isAbsolutePositioning(mouseEvent)) {
                    this.update(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) || this.isAbsolutePositioning(mouseEvent)) {
                isPressed = false;
                this.repaint();
            }
            this.update(mouseEvent.getX(), mouseEvent.getY());
        }

        private boolean isAbsolutePositioning(MouseEvent mouseEvent) {
            return FlatScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent);
        }

        private void update(int n, int n2) {
            boolean bl = FlatScrollBarUI.this.getTrackBounds().contains(n, n2);
            boolean bl2 = FlatScrollBarUI.this.getThumbBounds().contains(n, n2);
            if (bl != FlatScrollBarUI.this.hoverTrack || bl2 != FlatScrollBarUI.this.hoverThumb) {
                FlatScrollBarUI.this.hoverTrack = bl;
                FlatScrollBarUI.this.hoverThumb = bl2;
                this.repaint();
            }
        }

        private void repaint() {
            if (FlatScrollBarUI.this.scrollbar.isEnabled()) {
                FlatScrollBarUI.this.scrollbar.repaint();
            }
        }
    }
}

