/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatScrollPaneBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FlatScrollPaneUI
extends BasicScrollPaneUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Boolean showButtons;
    private Handler handler;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatScrollPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        int n = UIManager.getInt("Component.focusWidth");
        int n2 = UIManager.getInt("ScrollPane.arc");
        LookAndFeel.installProperty(jComponent, "opaque", n == 0 && n2 == 0);
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager != null && layoutManager.getClass() == ScrollPaneLayout.UIResource.class) {
            jComponent.setLayout(this.createScrollPaneLayout());
        }
        this.installStyle();
        MigLayoutVisualPadding.install(this.scrollpane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        MigLayoutVisualPadding.uninstall(this.scrollpane);
        if (jComponent.getLayout() instanceof FlatScrollPaneLayout) {
            jComponent.setLayout(new ScrollPaneLayout.UIResource());
        }
        super.uninstallUI(jComponent);
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.addViewportListeners(this.scrollpane.getViewport());
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        this.removeViewportListeners(this.scrollpane.getViewport());
        this.handler = null;
    }

    protected FlatScrollPaneLayout createScrollPaneLayout() {
        return new FlatScrollPaneLayout();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        MouseWheelListener mouseWheelListener = super.createMouseWheelListener();
        return mouseWheelEvent -> {
            if (this.isSmoothScrollingEnabled() && this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollType() == 0 && mouseWheelEvent.getPreciseWheelRotation() != 0.0 && mouseWheelEvent.getPreciseWheelRotation() != (double)mouseWheelEvent.getWheelRotation()) {
                this.mouseWheelMovedSmooth(mouseWheelEvent);
            } else {
                mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            }
        };
    }

    protected boolean isSmoothScrollingEnabled() {
        Object object = this.scrollpane.getClientProperty("JScrollPane.smoothScrolling");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    private void mouseWheelMovedSmooth(MouseWheelEvent mouseWheelEvent) {
        int n;
        int n2;
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport == null) {
            return;
        }
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        if (!(jScrollBar != null && jScrollBar.isVisible() && !mouseWheelEvent.isShiftDown() || (jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
            return;
        }
        mouseWheelEvent.consume();
        double d = mouseWheelEvent.getPreciseWheelRotation();
        int n3 = jScrollBar.getOrientation();
        Component component = jViewport.getView();
        if (component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            Rectangle rectangle = new Rectangle(jViewport.getViewSize());
            n2 = scrollable.getScrollableUnitIncrement(rectangle, n3, 1);
            if (n2 > 0) {
                if (n3 == 1) {
                    rectangle.y += n2;
                    rectangle.height -= n2;
                } else {
                    rectangle.x += n2;
                    rectangle.width -= n2;
                }
                int n4 = scrollable.getScrollableUnitIncrement(rectangle, n3, 1);
                if (n4 > 0) {
                    n2 = Math.min(n2, n4);
                }
            }
        } else {
            int n5 = d < 0.0 ? -1 : 1;
            n2 = jScrollBar.getUnitIncrement(n5);
        }
        int n6 = n3 == 1 ? jViewport.getHeight() : jViewport.getWidth();
        int n7 = Math.min(n2 * mouseWheelEvent.getScrollAmount(), n6);
        double d2 = d * (double)n7;
        int n8 = (int)Math.round(d2);
        if (n8 == 0) {
            if (d > 0.0) {
                n8 = 1;
            } else if (d < 0.0) {
                n8 = -1;
            }
        }
        int n9 = jScrollBar.getValue();
        int n10 = jScrollBar.getMinimum();
        int n11 = Math.max(n10, Math.min(n9 + n8, n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent()));
        if (n11 != n9) {
            jScrollBar.setValue(n11);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            switch (propertyChangeEvent.getPropertyName()) {
                case "JScrollBar.showButtons": {
                    JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
                    JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar != null) {
                        jScrollBar.revalidate();
                        jScrollBar.repaint();
                    }
                    if (jScrollBar2 == null) break;
                    jScrollBar2.revalidate();
                    jScrollBar2.repaint();
                    break;
                }
                case "LOWER_LEFT_CORNER": 
                case "LOWER_RIGHT_CORNER": 
                case "UPPER_LEFT_CORNER": 
                case "UPPER_RIGHT_CORNER": {
                    Object object = propertyChangeEvent.getNewValue();
                    if (!(object instanceof JButton) || !(((JButton)object).getBorder() instanceof FlatButtonBorder) || !(FlatScrollPaneUI.getView(this.scrollpane) instanceof JTable)) break;
                    ((JButton)object).setBorder(BorderFactory.createEmptyBorder());
                    ((JButton)object).setFocusable(false);
                    break;
                }
                case "JComponent.outline": {
                    this.scrollpane.repaint();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.scrollpane.revalidate();
                    this.scrollpane.repaint();
                    break;
                }
                case "border": {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object == null || object != UIManager.getBorder("Table.scrollPaneBorder")) break;
                    this.borderShared = null;
                    this.installStyle();
                    this.scrollpane.revalidate();
                    this.scrollpane.repaint();
                }
            }
        };
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.scrollpane, "ScrollPane"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("focusWidth") || string.equals("arc")) {
            int n = object instanceof Integer ? (Integer)object : UIManager.getInt("Component.focusWidth");
            int n2 = object instanceof Integer ? (Integer)object : UIManager.getInt("ScrollPane.arc");
            LookAndFeel.installProperty(this.scrollpane, "opaque", n == 0 && n2 == 0);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.scrollpane, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.scrollpane.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.scrollpane.getBorder(), string);
    }

    @Override
    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        super.updateViewport(propertyChangeEvent);
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        this.removeViewportListeners(jViewport);
        this.addViewportListeners(jViewport2);
    }

    private void addViewportListeners(JViewport jViewport) {
        if (jViewport == null) {
            return;
        }
        jViewport.addContainerListener(this.getHandler());
        Component component = jViewport.getView();
        if (component != null) {
            component.addFocusListener(this.getHandler());
        }
    }

    private void removeViewportListeners(JViewport jViewport) {
        if (jViewport == null) {
            return;
        }
        jViewport.removeContainerListener(this.getHandler());
        Component component = jViewport.getView();
        if (component != null) {
            component.removeFocusListener(this.getHandler());
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f;
        Serializable serializable;
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
            serializable = jComponent.getInsets();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(((Insets)serializable).left, ((Insets)serializable).top, jComponent.getWidth() - ((Insets)serializable).left - ((Insets)serializable).right, jComponent.getHeight() - ((Insets)serializable).top - ((Insets)serializable).bottom);
        }
        if ((f = FlatScrollPaneUI.getBorderArc(this.scrollpane)) > 0.0f && (serializable = FlatScrollPaneUI.getView(this.scrollpane)) != null) {
            float f2 = FlatUIUtils.getBorderFocusWidth(jComponent);
            graphics.setColor(((Component)serializable).getBackground());
            Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), f2, f);
            FlatUIUtils.resetRenderingHints(graphics, objectArray);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            int n = FlatScrollPaneUI.getBorderLeftRightPadding(this.scrollpane);
            JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
            if (n > 0 && jScrollBar != null && jScrollBar.isVisible() && this.scrollpane.getLayout() instanceof FlatScrollPaneLayout && ((FlatScrollPaneLayout)this.scrollpane.getLayout()).canIncreaseViewportWidth(this.scrollpane)) {
                boolean bl = this.scrollpane.getComponentOrientation().isLeftToRight();
                int n2 = Math.min(n, jScrollBar.getWidth());
                border.paintBorder(this.scrollpane, graphics, rectangle.x - (bl ? 0 : n2), rectangle.y, rectangle.width + n2, rectangle.height);
            } else {
                border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public static boolean isPermanentFocusOwner(JScrollPane jScrollPane) {
        Component component;
        Component component2 = FlatScrollPaneUI.getView(jScrollPane);
        if (component2 == null) {
            return false;
        }
        if (FlatUIUtils.isPermanentFocusOwner(component2)) {
            return true;
        }
        if ((component2 instanceof JTable && ((JTable)component2).isEditing() || component2 instanceof JTree && ((JTree)component2).isEditing()) && (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null) {
            return SwingUtilities.isDescendingFrom(component, component2);
        }
        return false;
    }

    static Component getView(JScrollPane jScrollPane) {
        JViewport jViewport = jScrollPane.getViewport();
        return jViewport != null ? jViewport.getView() : null;
    }

    private static float getBorderArc(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        return border instanceof FlatScrollPaneBorder ? UIScale.scale((float)((FlatScrollPaneBorder)border).getArc(jScrollPane)) : 0.0f;
    }

    private static int getBorderLeftRightPadding(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        return border instanceof FlatScrollPaneBorder ? ((FlatScrollPaneBorder)border).getLeftRightPadding(jScrollPane) : 0;
    }

    protected static class FlatScrollPaneLayout
    extends ScrollPaneLayout.UIResource {
        protected FlatScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            JScrollPane jScrollPane = (JScrollPane)container;
            int n = FlatScrollPaneUI.getBorderLeftRightPadding(jScrollPane);
            if (n > 0 && this.vsb != null && this.vsb.isVisible()) {
                Insets insets = jScrollPane.getInsets();
                Rectangle rectangle = this.vsb.getBounds();
                int n2 = Math.max(rectangle.y, insets.top + n);
                int n3 = Math.min(rectangle.y + rectangle.height, jScrollPane.getHeight() - insets.bottom - n);
                boolean bl = jScrollPane.getComponentOrientation().isLeftToRight();
                this.vsb.setBounds(rectangle.x + (bl ? n : -n), n2, rectangle.width, n3 - n2);
                if (this.canIncreaseViewportWidth(jScrollPane)) {
                    int n4 = Math.min(n, this.vsb.getWidth());
                    FlatScrollPaneLayout.resizeViewport(this.viewport, n4, bl);
                    FlatScrollPaneLayout.resizeViewport(this.colHead, n4, bl);
                    FlatScrollPaneLayout.resizeViewport(this.hsb, n4, bl);
                }
            }
        }

        boolean canIncreaseViewportWidth(JScrollPane jScrollPane) {
            return jScrollPane.getComponentOrientation().isLeftToRight() ? !FlatScrollPaneLayout.isCornerVisible(this.upperRight) && !FlatScrollPaneLayout.isCornerVisible(this.lowerRight) : !FlatScrollPaneLayout.isCornerVisible(this.upperLeft) && !FlatScrollPaneLayout.isCornerVisible(this.lowerLeft);
        }

        private static boolean isCornerVisible(Component component) {
            return component != null && component.getWidth() > 0 && component.getHeight() > 0 && component.isVisible();
        }

        private static void resizeViewport(Component component, int n, boolean bl) {
            if (component == null) {
                return;
            }
            Rectangle rectangle = component.getBounds();
            component.setBounds(rectangle.x - (bl ? 0 : n), rectangle.y, rectangle.width + n, rectangle.height);
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener {
        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addFocusListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                FlatScrollPaneUI.this.scrollpane.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                FlatScrollPaneUI.this.scrollpane.repaint();
            }
        }
    }
}

