/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatTabbedPaneCloseIcon;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class FlatTabbedPaneUI
extends BasicTabbedPaneUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    protected static final int TAB_TYPE_UNDERLINED = 0;
    protected static final int TAB_TYPE_CARD = 1;
    protected static final int NEVER = 0;
    protected static final int AS_NEEDED = 2;
    protected static final int AS_NEEDED_SINGLE = 3;
    protected static final int BOTH = 100;
    protected static final int FILL = 100;
    protected static final int WIDTH_MODE_PREFERRED = 0;
    protected static final int WIDTH_MODE_EQUAL = 1;
    protected static final int WIDTH_MODE_COMPACT = 2;
    protected static final int NONE = -1;
    protected static final int AUTO = -2;
    private static Set<KeyStroke> focusForwardTraversalKeys;
    private static Set<KeyStroke> focusBackwardTraversalKeys;
    protected Color foreground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color underlineColor;
    @FlatStylingSupport.Styleable
    protected Color inactiveUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color disabledUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color hoverColor;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color focusColor;
    @FlatStylingSupport.Styleable
    protected Color focusForeground;
    @FlatStylingSupport.Styleable
    protected Color tabSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color contentAreaColor;
    private int textIconGapUnscaled;
    @FlatStylingSupport.Styleable
    protected int minimumTabWidth;
    @FlatStylingSupport.Styleable
    protected int maximumTabWidth;
    @FlatStylingSupport.Styleable
    protected int tabHeight;
    @FlatStylingSupport.Styleable
    protected int tabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int cardTabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int tabArc;
    @FlatStylingSupport.Styleable
    protected int tabSelectionArc;
    @FlatStylingSupport.Styleable
    protected int cardTabArc;
    @FlatStylingSupport.Styleable
    protected Insets selectedInsets;
    @FlatStylingSupport.Styleable
    protected Insets tabSelectionInsets;
    @FlatStylingSupport.Styleable
    protected int contentSeparatorHeight;
    @FlatStylingSupport.Styleable
    protected boolean showTabSeparators;
    @FlatStylingSupport.Styleable
    protected boolean tabSeparatorsFullHeight;
    @FlatStylingSupport.Styleable
    protected boolean hasFullBorder;
    @FlatStylingSupport.Styleable
    protected boolean tabsOpaque = true;
    @FlatStylingSupport.Styleable
    protected boolean rotateTabRuns = true;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabType;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabsPopupPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPlacement;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAreaAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabWidthMode;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabRotation;
    protected Icon closeIcon;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Insets buttonInsets;
    @FlatStylingSupport.Styleable
    protected int buttonArc;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedBackground;
    @FlatStylingSupport.Styleable
    protected String moreTabsButtonToolTipText;
    @FlatStylingSupport.Styleable
    protected String tabCloseToolTipText;
    @FlatStylingSupport.Styleable
    protected boolean showContentSeparator = true;
    @FlatStylingSupport.Styleable
    protected boolean hideTabAreaWithOneTab;
    @FlatStylingSupport.Styleable
    protected boolean tabClosable;
    @FlatStylingSupport.Styleable
    protected int tabIconPlacement = 10;
    protected JViewport tabViewport;
    protected FlatWheelTabScroller wheelTabScroller;
    private JButton tabCloseButton;
    private JButton moreTabsButton;
    private Container leadingComponent;
    private Container trailingComponent;
    private Dimension scrollBackwardButtonPrefSize;
    private Handler handler;
    private boolean blockRollover;
    private boolean rolloverTabClose;
    private boolean pressedTabClose;
    private boolean inBasicLayoutContainer;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;
    private boolean closeIconShared = true;
    private boolean repaintRolloverPending;
    private boolean inCalculateEqual;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        String string = UIManager.getString("TabbedPane.tabLayoutPolicy");
        if (string != null) {
            int n;
            switch (string) {
                default: {
                    n = 0;
                    break;
                }
                case "scroll": {
                    n = 1;
                }
            }
            ((JTabbedPane)jComponent).setTabLayoutPolicy(n);
        }
        this.arrowType = UIManager.getString("TabbedPane.arrowType");
        this.foreground = UIManager.getColor("TabbedPane.foreground");
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.buttonHoverBackground = UIManager.getColor("TabbedPane.buttonHoverBackground");
        this.buttonPressedBackground = UIManager.getColor("TabbedPane.buttonPressedBackground");
        super.installUI(jComponent);
        FlatSelectedTabRepainter.install();
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        Object object;
        if (UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
            object = UIManager.put("TabbedPane.tabsOverlapBorder", false);
            super.installDefaults();
            UIManager.put("TabbedPane.tabsOverlapBorder", object);
        } else {
            super.installDefaults();
        }
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.inactiveUnderlineColor = FlatUIUtils.getUIColor("TabbedPane.inactiveUnderlineColor", this.underlineColor);
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.hoverForeground = UIManager.getColor("TabbedPane.hoverForeground");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.focusForeground = UIManager.getColor("TabbedPane.focusForeground");
        this.tabSeparatorColor = UIManager.getColor("TabbedPane.tabSeparatorColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.textIconGapUnscaled = UIManager.getInt("TabbedPane.textIconGap");
        this.minimumTabWidth = UIManager.getInt("TabbedPane.minimumTabWidth");
        this.maximumTabWidth = UIManager.getInt("TabbedPane.maximumTabWidth");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.cardTabSelectionHeight = UIManager.getInt("TabbedPane.cardTabSelectionHeight");
        this.tabArc = UIManager.getInt("TabbedPane.tabArc");
        this.tabSelectionArc = UIManager.getInt("TabbedPane.tabSelectionArc");
        this.cardTabArc = UIManager.getInt("TabbedPane.cardTabArc");
        this.selectedInsets = UIManager.getInsets("TabbedPane.selectedInsets");
        this.tabSelectionInsets = UIManager.getInsets("TabbedPane.tabSelectionInsets");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.showTabSeparators = UIManager.getBoolean("TabbedPane.showTabSeparators");
        this.tabSeparatorsFullHeight = UIManager.getBoolean("TabbedPane.tabSeparatorsFullHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.rotateTabRuns = FlatUIUtils.getUIBoolean("TabbedPane.rotateTabRuns", true);
        this.tabType = FlatTabbedPaneUI.parseTabType(UIManager.getString("TabbedPane.tabType"));
        this.tabsPopupPolicy = FlatTabbedPaneUI.parseTabsPopupPolicy(UIManager.getString("TabbedPane.tabsPopupPolicy"));
        this.scrollButtonsPolicy = FlatTabbedPaneUI.parseScrollButtonsPolicy(UIManager.getString("TabbedPane.scrollButtonsPolicy"));
        this.scrollButtonsPlacement = FlatTabbedPaneUI.parseScrollButtonsPlacement(UIManager.getString("TabbedPane.scrollButtonsPlacement"));
        this.tabAreaAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAreaAlignment"), 10);
        this.tabAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAlignment"), 0);
        this.tabWidthMode = FlatTabbedPaneUI.parseTabWidthMode(UIManager.getString("TabbedPane.tabWidthMode"));
        this.tabRotation = FlatTabbedPaneUI.parseTabRotation(UIManager.getString("TabbedPane.tabRotation"));
        this.closeIcon = UIManager.getIcon("TabbedPane.closeIcon");
        this.closeIconShared = true;
        this.buttonInsets = UIManager.getInsets("TabbedPane.buttonInsets");
        this.buttonArc = UIManager.getInt("TabbedPane.buttonArc");
        object = this.tabPane.getLocale();
        this.moreTabsButtonToolTipText = UIManager.getString((Object)"TabbedPane.moreTabsButtonToolTipText", (Locale)object);
        this.tabCloseToolTipText = UIManager.getString((Object)"TabbedPane.tabCloseToolTipText", (Locale)object);
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (focusForwardTraversalKeys == null) {
            focusForwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 0));
            focusBackwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 64));
        }
        this.tabPane.setFocusTraversalKeys(0, focusForwardTraversalKeys);
        this.tabPane.setFocusTraversalKeys(1, focusBackwardTraversalKeys);
        MigLayoutVisualPadding.install(this.tabPane, null);
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
        this.foreground = null;
        this.disabledForeground = null;
        this.selectedBackground = null;
        this.selectedForeground = null;
        this.underlineColor = null;
        this.inactiveUnderlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.hoverForeground = null;
        this.focusColor = null;
        this.focusForeground = null;
        this.tabSeparatorColor = null;
        this.contentAreaColor = null;
        this.closeIcon = null;
        this.buttonHoverBackground = null;
        this.buttonPressedBackground = null;
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(this.tabPane);
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.tabViewport = null;
        if (this.isScrollTabLayout()) {
            for (Component component : this.tabPane.getComponents()) {
                if (!(component instanceof JViewport) || !component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$ScrollableTabViewport")) continue;
                this.tabViewport = (JViewport)component;
                break;
            }
        }
        this.installHiddenTabsNavigation();
        this.installLeadingComponent();
        this.installTrailingComponent();
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallHiddenTabsNavigation();
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        super.uninstallComponents();
        this.tabCloseButton = null;
        this.tabViewport = null;
    }

    protected void installHiddenTabsNavigation() {
        if (!this.isScrollTabLayout() || this.tabViewport == null) {
            return;
        }
        this.tabPane.setLayout(this.createScrollLayoutManager((BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout()));
        this.moreTabsButton = this.createMoreTabsButton();
        this.tabPane.add(this.moreTabsButton);
    }

    protected void uninstallHiddenTabsNavigation() {
        if (this.tabPane.getLayout() instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)this.tabPane.getLayout()).delegate);
        }
        if (this.moreTabsButton != null) {
            this.tabPane.remove(this.moreTabsButton);
            this.moreTabsButton = null;
        }
    }

    protected void installLeadingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.leadingComponent");
        if (object instanceof Component) {
            this.leadingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.leadingComponent);
        }
    }

    protected void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.tabPane.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    protected void installTrailingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.trailingComponent");
        if (object instanceof Component) {
            this.trailingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.trailingComponent);
        }
    }

    protected void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.tabPane.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getHandler().installListeners();
        if (this.tabViewport != null && (this.wheelTabScroller = this.createWheelTabScroller()) != null) {
            this.tabPane.addMouseWheelListener(this.wheelTabScroller);
            this.tabPane.addMouseMotionListener(this.wheelTabScroller);
            this.tabPane.addMouseListener(this.wheelTabScroller);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.handler != null) {
            this.handler.uninstallListeners();
            this.handler = null;
        }
        if (this.wheelTabScroller != null) {
            this.wheelTabScroller.uninstall();
            this.tabPane.removeMouseWheelListener(this.wheelTabScroller);
            this.tabPane.removeMouseMotionListener(this.wheelTabScroller);
            this.tabPane.removeMouseListener(this.wheelTabScroller);
            this.wheelTabScroller = null;
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
        if (actionMap != null) {
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsForwardAction");
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsBackwardAction");
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected FlatWheelTabScroller createWheelTabScroller() {
        return new FlatWheelTabScroller();
    }

    @Override
    protected MouseListener createMouseListener() {
        Handler handler = this.getHandler();
        handler.mouseDelegate = super.createMouseListener();
        return handler;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        Handler handler = this.getHandler();
        handler.propertyChangeDelegate = super.createPropertyChangeListener();
        return handler;
    }

    @Override
    protected ChangeListener createChangeListener() {
        Handler handler = this.getHandler();
        handler.changeDelegate = super.createChangeListener();
        return handler;
    }

    @Override
    protected FocusListener createFocusListener() {
        Handler handler = this.getHandler();
        handler.focusDelegate = super.createFocusListener();
        return handler;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new FlatTabbedPaneLayout();
        }
        return super.createLayoutManager();
    }

    protected LayoutManager createScrollLayoutManager(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
        return new FlatTabbedPaneScrollLayout(tabbedPaneLayout);
    }

    protected JButton createMoreTabsButton() {
        return new FlatMoreTabsButton();
    }

    @Override
    protected JButton createScrollButton(int n) {
        return new FlatScrollableTabButton(n);
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.tabPane, "TabbedPane"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        for (Component component : this.tabPane.getComponents()) {
            if (!(component instanceof FlatTabAreaButton)) continue;
            ((FlatTabAreaButton)component).updateStyle();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.startsWith("close")) {
            if (!(this.closeIcon instanceof FlatTabbedPaneCloseIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.closeIconShared) {
                this.closeIcon = FlatStylingSupport.cloneIcon(this.closeIcon);
                this.closeIconShared = false;
            }
            return ((FlatTabbedPaneCloseIcon)this.closeIcon).applyStyleProperty(string, object);
        }
        if (object instanceof String) {
            switch (string) {
                case "tabType": {
                    object = FlatTabbedPaneUI.parseTabType((String)object);
                    break;
                }
                case "tabsPopupPolicy": {
                    object = FlatTabbedPaneUI.parseTabsPopupPolicy((String)object);
                    break;
                }
                case "scrollButtonsPolicy": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object);
                    break;
                }
                case "scrollButtonsPlacement": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object);
                    break;
                }
                case "tabAreaAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 10);
                    break;
                }
                case "tabAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 0);
                    break;
                }
                case "tabWidthMode": {
                    object = FlatTabbedPaneUI.parseTabWidthMode((String)object);
                    break;
                }
                case "tabRotation": {
                    object = FlatTabbedPaneUI.parseTabRotation((String)object);
                    break;
                }
                case "tabIconPlacement": {
                    object = FlatTabbedPaneUI.parseTabIconPlacement((String)object);
                }
            }
        } else {
            switch (string) {
                case "tabInsets": {
                    Insets insets = this.tabInsets;
                    this.tabInsets = (Insets)object;
                    return insets;
                }
                case "tabAreaInsets": {
                    Insets insets = this.tabAreaInsets;
                    this.tabAreaInsets = (Insets)object;
                    return insets;
                }
                case "textIconGap": {
                    Integer n = this.textIconGapUnscaled;
                    this.textIconGapUnscaled = (Integer)object;
                    this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
                    return n;
                }
            }
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.tabPane, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatStylingSupport.StyleableInfosMap styleableInfosMap = new FlatStylingSupport.StyleableInfosMap();
        styleableInfosMap.put("tabInsets", Insets.class);
        styleableInfosMap.put("tabAreaInsets", Insets.class);
        styleableInfosMap.put("textIconGap", Integer.TYPE);
        FlatStylingSupport.collectAnnotatedStyleableInfos(this, styleableInfosMap);
        if (this.closeIcon instanceof FlatTabbedPaneCloseIcon) {
            styleableInfosMap.putAll(((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableInfos());
        }
        return styleableInfosMap;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.startsWith("close")) {
            return this.closeIcon instanceof FlatTabbedPaneCloseIcon ? ((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableValue(string) : null;
        }
        switch (string) {
            case "tabInsets": {
                return this.tabInsets;
            }
            case "tabAreaInsets": {
                return this.tabAreaInsets;
            }
            case "textIconGap": {
                return this.textIconGapUnscaled;
            }
            case "tabType": {
                switch (this.tabType) {
                    default: {
                        return "underlined";
                    }
                    case 1: 
                }
                return "card";
            }
            case "tabsPopupPolicy": {
                switch (this.tabsPopupPolicy) {
                    default: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPolicy": {
                switch (this.scrollButtonsPolicy) {
                    default: {
                        return "asNeededSingle";
                    }
                    case 2: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPlacement": {
                switch (this.scrollButtonsPlacement) {
                    default: {
                        return "both";
                    }
                    case 11: 
                }
                return "trailing";
            }
            case "tabAreaAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAreaAlignment, "leading");
            }
            case "tabAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAlignment, "center");
            }
            case "tabWidthMode": {
                switch (this.tabWidthMode) {
                    default: {
                        return "preferred";
                    }
                    case 1: {
                        return "equal";
                    }
                    case 2: 
                }
                return "compact";
            }
            case "tabRotation": {
                switch (this.tabRotation) {
                    default: {
                        return "none";
                    }
                    case -2: {
                        return "auto";
                    }
                    case 2: {
                        return "left";
                    }
                    case 4: 
                }
                return "right";
            }
            case "tabIconPlacement": {
                switch (this.tabIconPlacement) {
                    default: {
                        return "leading";
                    }
                    case 11: {
                        return "trailing";
                    }
                    case 1: {
                        return "top";
                    }
                    case 3: 
                }
                return "bottom";
            }
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected void setRolloverTab(int n, int n2) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, n, n2));
    }

    @Override
    protected void setRolloverTab(int n) {
        if (this.blockRollover) {
            return;
        }
        int n2 = this.getRolloverTab();
        super.setRolloverTab(n);
        if (n != n2) {
            this.repaintRolloverLaterOnce(n2);
        }
    }

    private void repaintRolloverLaterOnce(int n) {
        if (this.repaintRolloverPending) {
            return;
        }
        this.repaintRolloverPending = true;
        EventQueue.invokeLater(() -> {
            this.repaintRolloverPending = false;
            if (this.tabPane == null) {
                return;
            }
            int n2 = this.getRolloverTab();
            if (n2 != n) {
                this.repaintTab(n);
                this.repaintTab(n2);
            }
        });
    }

    protected boolean isRolloverTabClose() {
        return this.rolloverTabClose;
    }

    protected void setRolloverTabClose(boolean bl) {
        if (this.rolloverTabClose == bl) {
            return;
        }
        this.rolloverTabClose = bl;
        this.repaintTab(this.getRolloverTab());
    }

    protected boolean isPressedTabClose() {
        return this.pressedTabClose;
    }

    protected void setPressedTabClose(boolean bl) {
        if (this.pressedTabClose == bl) {
            return;
        }
        this.pressedTabClose = bl;
        this.repaintTab(this.getRolloverTab());
    }

    private void repaintTab(int n) {
        if (n < 0 || n >= this.tabPane.getTabCount()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(this.tabPane, n);
        if (rectangle == null) {
            return;
        }
        if (this.contentSeparatorHeight > 0 && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", true)) {
            int n2 = UIScale.scale(this.contentSeparatorHeight);
            switch (this.tabPane.getTabPlacement()) {
                default: {
                    rectangle.height += n2;
                    break;
                }
                case 3: {
                    rectangle.height += n2;
                    rectangle.y -= n2;
                    break;
                }
                case 2: {
                    rectangle.width += n2;
                    break;
                }
                case 4: {
                    rectangle.width += n2;
                    rectangle.x -= n2;
                }
            }
        }
        this.tabPane.repaint(rectangle);
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return this.getRealTabRotation(n) == -1 ? this.calculateTabWidthImpl(n, n2, fontMetrics, false) : this.calculateTabHeightImpl(n, n2, fontMetrics.getHeight(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateTabWidthImpl(int n, int n2, FontMetrics fontMetrics, boolean bl) {
        int n3;
        Icon icon;
        int n4 = this.getTabWidthMode();
        if (n4 == 1 && this.isHorizontalOrRotated(n) && !this.inCalculateEqual) {
            this.inCalculateEqual = true;
            try {
                int n5 = this.isHorizontalTabPlacement(n) ? this.calculateMaxTabWidth(n) : this.calculateMaxTabHeight(n);
                return n5;
            }
            finally {
                this.inCalculateEqual = false;
            }
        }
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (n4 == 2 && n2 != this.tabPane.getSelectedIndex() && this.isHorizontalOrRotated(n) && this.tabPane.getTabComponentAt(n2) == null && (icon = this.getIconForTab(n2)) != null) {
            Insets insets = this.getTabInsets(n, n2);
            n3 = icon.getIconWidth() + insets.left + insets.right;
        } else {
            Object object;
            int n6 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
            if ((n6 == 1 || n6 == 3) && this.tabPane.getTabComponentAt(n2) == null && (icon = this.getIconForTab(n2)) != null) {
                Object object2;
                n3 = icon.getIconWidth();
                object = this.getTextViewForTab(n2);
                if (object != null) {
                    n3 = Math.max(n3, (int)((View)object).getPreferredSpan(0));
                } else {
                    object2 = this.tabPane.getTitleAt(n2);
                    if (object2 != null) {
                        n3 = Math.max(n3, fontMetrics.stringWidth((String)object2));
                    }
                }
                object2 = this.getTabInsets(n, n2);
                n3 += ((Insets)object2).left + ((Insets)object2).right;
            } else {
                n3 = super.calculateTabWidth(n, n2, fontMetrics) - 3;
                if (bl && (object = this.tabPane.getTabComponentAt(n2)) != null) {
                    Dimension dimension = ((Component)object).getPreferredSize();
                    n3 = n3 - dimension.width + dimension.height;
                }
            }
        }
        if (this.isTabClosable(n2)) {
            n3 += this.closeIcon.getIconWidth();
        }
        int n7 = this.getTabClientPropertyInt(n2, "JTabbedPane.minimumTabWidth", this.minimumTabWidth);
        int n8 = this.getTabClientPropertyInt(n2, "JTabbedPane.maximumTabWidth", this.maximumTabWidth);
        if (n7 > 0) {
            n3 = Math.max(n3, UIScale.scale(n7));
        }
        if (n8 > 0 && this.tabPane.getTabComponentAt(n2) == null) {
            n3 = Math.min(n3, UIScale.scale(n8));
        }
        return n3;
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        return this.getRealTabRotation(n) == -1 ? this.calculateTabHeightImpl(n, n2, n3, false) : this.calculateTabWidthImpl(n, n2, this.getFontMetrics(), true);
    }

    private int calculateTabHeightImpl(int n, int n2, int n3, boolean bl) {
        int n4;
        Icon icon;
        int n5 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
        if ((n5 == 1 || n5 == 3) && this.tabPane.getTabComponentAt(n2) == null && (icon = this.getIconForTab(n2)) != null) {
            n4 = icon.getIconHeight();
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                n4 += (int)view.getPreferredSpan(1) + UIScale.scale(this.textIconGapUnscaled);
            } else if (this.tabPane.getTitleAt(n2) != null) {
                n4 += n3 + UIScale.scale(this.textIconGapUnscaled);
            }
            Insets insets = this.getTabInsets(n, n2);
            n4 += insets.top + insets.bottom;
        } else {
            Component component;
            n4 = super.calculateTabHeight(n, n2, n3) - 2;
            if (bl && (component = this.tabPane.getTabComponentAt(n2)) != null) {
                Dimension dimension = component.getPreferredSize();
                n4 = n4 - dimension.height + dimension.width;
            }
        }
        return Math.max(n4, UIScale.scale(FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabHeight", this.tabHeight)));
    }

    @Override
    protected int calculateMaxTabWidth(int n) {
        return this.hideTabArea() ? 0 : super.calculateMaxTabWidth(n);
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        return this.hideTabArea() ? 0 : super.calculateMaxTabHeight(n);
    }

    @Override
    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        return this.hideTabArea() ? 0 : super.calculateTabAreaWidth(n, n2, n3);
    }

    @Override
    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        return this.hideTabArea() ? 0 : super.calculateTabAreaHeight(n, n2, n3);
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        Object object = this.getTabClientProperty(n2, "JTabbedPane.tabInsets");
        return UIScale.scale(object instanceof Insets ? (Insets)object : super.getTabInsets(n, n2));
    }

    protected Insets getTabInsetsRotated(int n, int n2, int n3) {
        Insets insets = this.getTabInsets(n, n2);
        switch (n3) {
            case 2: {
                return new Insets(insets.right, insets.top, insets.left, insets.bottom);
            }
            case 4: {
                return new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
        }
        return insets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int n) {
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getRealTabAreaInsets(int n) {
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(0, 0, 0, 0);
        }
        Insets insets = super.getTabAreaInsets(n);
        Insets insets2 = (Insets)insets.clone();
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaInsets");
        if (object instanceof Insets) {
            FlatTabbedPaneUI.rotateInsets((Insets)object, insets2, n);
        }
        insets.left = -10000;
        insets.top = -10000;
        insets2 = UIScale.scale(insets2);
        return insets2;
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        Insets insets = this.getRealTabAreaInsets(n);
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            if (this.isHorizontalTabPlacement(n)) {
                insets.left += this.getLeadingPreferredWidth();
                insets.right += this.getTrailingPreferredWidth();
            } else {
                insets.top += this.getLeadingPreferredHeight();
                insets.bottom += this.getTrailingPreferredHeight();
            }
        }
        return insets;
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        if (this.hideTabArea() || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return new Insets(0, 0, 0, 0);
        }
        boolean bl = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n2 = UIScale.scale(this.contentSeparatorHeight);
        Insets insets = bl ? new Insets(n2, n2, n2, n2) : new Insets(n2, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(insets, insets2, n);
        return insets2;
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        if (this.isTabClosable(n2) && this.getRealTabRotation(n) == -1) {
            int n3 = this.closeIcon.getIconWidth() / 2;
            return this.isLeftToRight() ? -n3 : n3;
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        if (this.isTabClosable(n2) && this.getRealTabRotation(n) != -1) {
            int n3 = this.closeIcon.getIconHeight() / 2;
            return this.isLeftToRight() ? n3 : -n3;
        }
        return 0;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(graphics);
        super.update(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.hideTabArea()) {
            return;
        }
        this.ensureCurrentLayout();
        int n = this.tabPane.getTabPlacement();
        int n2 = this.tabPane.getSelectedIndex();
        this.paintContentBorder(graphics, n, n2);
        if (this.tabsOpaque && !this.tabPane.isOpaque() && this.tabPane.getTabCount() > 0) {
            Rectangle rectangle = null;
            if (this.isScrollTabLayout()) {
                rectangle = this.tabViewport.getBounds();
                for (Component component : this.tabPane.getComponents()) {
                    if (!(component instanceof FlatTabAreaButton) || !component.isVisible()) continue;
                    rectangle = rectangle.union(component.getBounds());
                }
            } else {
                for (Rectangle rectangle2 : this.rects) {
                    rectangle = rectangle != null ? rectangle.union(rectangle2) : rectangle2;
                }
            }
            if (rectangle != null) {
                graphics.setColor(this.tabPane.getBackground());
                if (this.getTabType() == 1 && this.cardTabArc > 0) {
                    ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (!this.isScrollTabLayout()) {
            this.paintTabArea(graphics, n, n2);
        }
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        super.paintTabArea(graphics, n, n2);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        boolean bl2;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = rectangle3.x;
        int n4 = rectangle3.y;
        int n5 = rectangle3.width;
        int n6 = rectangle3.height;
        boolean bl3 = bl2 = n2 == this.tabPane.getSelectedIndex();
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl2);
        }
        this.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl2);
        if (this.isTabClosable(n2)) {
            this.paintTabCloseButton(graphics, n2, n3, n4, n5, n6);
        }
        if (bl2) {
            this.paintTabSelection(graphics, n, n2, n3, n4, n5, n6);
        }
        if (this.tabPane.getTabComponentAt(n2) != null) {
            return;
        }
        String string = this.tabPane.getTitleAt(n2);
        Icon icon = this.getIconForTab(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(font);
        boolean bl4 = bl = icon != null && !bl2 && this.getTabWidthMode() == 2 && this.isHorizontalOrRotated(n);
        if (bl) {
            string = null;
        }
        String string2 = this.layoutAndClipLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl2);
        if (this.tabViewport != null && (n == 1 || n == 3)) {
            Rectangle rectangle4 = this.tabViewport.getViewRect();
            rectangle4.width -= 4;
            if (!rectangle4.contains(rectangle2)) {
                Rectangle rectangle5 = rectangle4.intersection(rectangle2);
                if (rectangle5.x > rectangle4.x) {
                    string2 = JavaCompatibility.getClippedString(null, fontMetrics, string, rectangle5.width);
                }
            }
        }
        if (!bl) {
            this.paintText(graphics, n, font, fontMetrics, n2, string2, rectangle2, bl2);
        }
        this.paintIcon(graphics, n, n2, icon, rectangle, bl2);
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        FlatUIUtils.runWithoutRenderingHints(graphics, this.oldRenderingHints, () -> {
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
                Rectangle rectangle2 = affineTransform != null ? new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width) : rectangle;
                view.paint(graphics, rectangle2);
                if (affineTransform != null) {
                    ((Graphics2D)graphics).setTransform(affineTransform);
                }
                return;
            }
            AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
            int n3 = FlatLaf.isShowMnemonics() ? this.tabPane.getDisplayedMnemonicIndexAt(n2) : -1;
            graphics.setColor(this.getTabForeground(n, n2, bl));
            FlatUIUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            if (affineTransform != null) {
                ((Graphics2D)graphics).setTransform(affineTransform);
            }
        });
    }

    @Override
    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon == null) {
            return;
        }
        Shape shape = graphics.getClip();
        ((Graphics2D)graphics).clip(rectangle);
        AffineTransform affineTransform = this.rotateGraphics(graphics, n, rectangle);
        icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        if (affineTransform != null) {
            ((Graphics2D)graphics).setTransform(affineTransform);
        }
        graphics.setClip(shape);
    }

    private AffineTransform rotateGraphics(Graphics graphics, int n, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        int n2 = this.getRealTabRotation(n);
        if (n2 == 2) {
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(0, rectangle.height);
            graphics2D.rotate(Math.toRadians(270.0), rectangle.x, rectangle.y);
        } else if (n2 == 4) {
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(rectangle.width, 0);
            graphics2D.rotate(Math.toRadians(90.0), rectangle.x, rectangle.y);
        }
        return affineTransform;
    }

    protected Color getTabForeground(int n, int n2, boolean bl) {
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2)) {
            return this.disabledForeground;
        }
        if (this.hoverForeground != null && this.getRolloverTab() == n2) {
            return this.hoverForeground;
        }
        Color color = this.tabPane.getForegroundAt(n2);
        if (color != this.tabPane.getForeground()) {
            return color;
        }
        if (this.focusForeground != null && bl && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusForeground;
        }
        if (this.selectedForeground != null && bl) {
            return this.selectedForeground;
        }
        return color;
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Serializable serializable;
        boolean bl2;
        boolean bl3 = bl2 = this.getTabType() == 1;
        if (!bl2 && this.selectedInsets != null) {
            serializable = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.selectedInsets, (Insets)serializable, this.tabPane.getTabPlacement());
            n3 += UIScale.scale(((Insets)serializable).left);
            n4 += UIScale.scale(((Insets)serializable).top);
            n5 -= UIScale.scale(((Insets)serializable).left + ((Insets)serializable).right);
            n6 -= UIScale.scale(((Insets)serializable).top + ((Insets)serializable).bottom);
        }
        if ((serializable = this.getTabBackground(n, n2, bl)) != this.tabPane.getBackground()) {
            graphics.setColor(FlatUIUtils.deriveColor(serializable, this.tabPane.getBackground()));
            if (!bl2 && this.tabArc > 0) {
                float f = UIScale.scale((float)this.tabArc) / 2.0f;
                FlatUIUtils.paintSelection((Graphics2D)graphics, n3, n4, n5, n6, null, f, f, f, f, 0);
            } else if (bl2 && this.cardTabArc > 0) {
                ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n, n3, n4, n5, n6));
            } else {
                graphics.fillRect(n3, n4, n5, n6);
            }
        }
    }

    protected Color getTabBackground(int n, int n2, boolean bl) {
        Color color = this.tabPane.getBackgroundAt(n2);
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2)) {
            return color;
        }
        if (this.hoverColor != null && this.getRolloverTab() == n2) {
            return this.hoverColor;
        }
        if (color != this.tabPane.getBackground()) {
            return color;
        }
        if (this.focusColor != null && bl && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusColor;
        }
        if (this.selectedBackground != null && bl) {
            return this.selectedBackground;
        }
        return color;
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showTabSeparators", this.showTabSeparators) && !this.isLastInRun(n2)) {
            if (this.getTabType() == 1) {
                int n7 = this.tabPane.getSelectedIndex();
                if (n2 != n7 - 1 && n2 != n7) {
                    this.paintTabSeparator(graphics, n, n3, n4, n5, n6);
                }
            } else {
                this.paintTabSeparator(graphics, n, n3, n4, n5, n6);
            }
        }
        if (bl && this.getTabType() == 1) {
            this.paintCardTabBorder(graphics, n, n2, n3, n4, n5, n6);
        }
    }

    protected void paintCardTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(this.createCardTabOuterPath(n, n3, n4, n5, n6), false);
        float_.append(this.createCardTabInnerPath(n, n3, n4, n5, n6), false);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        graphics2D.fill(float_);
    }

    protected Shape createCardTabOuterPath(int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale((float)this.cardTabArc) / 2.0f;
        switch (n) {
            default: {
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, f, f, 0.0f, 0.0f);
            }
            case 3: {
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, 0.0f, 0.0f, f, f);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, f, 0.0f, f, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, 0.0f, f, 0.0f, f);
    }

    protected Shape createCardTabInnerPath(int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale((float)this.contentSeparatorHeight);
        float f2 = UIScale.scale((float)this.cardTabArc) / 2.0f - f;
        switch (n) {
            default: {
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, (float)n3 + f, (float)n4 - f * 2.0f, (float)n5 - f, f2, f2, 0.0f, 0.0f);
            }
            case 3: {
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, n3, (float)n4 - f * 2.0f, (float)n5 - f, 0.0f, 0.0f, f2, f2);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath((float)n2 + f, (float)n3 + f, (float)n4 - f, (float)n5 - f * 2.0f, f2, 0.0f, f2, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n2, (float)n3 + f, (float)n4 - f, (float)n5 - f * 2.0f, 0.0f, f2, 0.0f, f2);
    }

    protected void paintTabCloseButton(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.tabCloseButton == null) {
            this.tabCloseButton = new TabCloseButton();
            this.tabCloseButton.setVisible(false);
        }
        boolean bl = n == this.getRolloverTab();
        ButtonModel buttonModel = this.tabCloseButton.getModel();
        buttonModel.setRollover(bl && this.isRolloverTabClose());
        buttonModel.setPressed(bl && this.isPressedTabClose());
        this.tabCloseButton.setBackground(this.tabPane.getBackground());
        this.tabCloseButton.setForeground(this.tabPane.getForeground());
        Rectangle rectangle = this.getTabCloseBounds(n, n2, n3, n4, n5, this.calcRect);
        this.closeIcon.paintIcon(this.tabCloseButton, graphics, rectangle.x, rectangle.y);
    }

    protected void paintTabSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        float f = UIScale.scale(1.0f);
        float f2 = this.tabSeparatorsFullHeight ? 0.0f : UIScale.scale(5.0f);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        if (n == 2 || n == 4) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)n2 + f2, (float)(n3 + n5) - f, (float)n4 - f2 * 2.0f, f));
        } else if (this.isLeftToRight()) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)(n2 + n4) - f, (float)n3 + f2, f, (float)n5 - f2 * 2.0f));
        } else {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(n2, (float)n3 + f2, f, (float)n5 - f2 * 2.0f));
        }
    }

    protected void paintTabSelection(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Cloneable cloneable;
        boolean bl;
        graphics.setColor(this.tabPane.isEnabled() ? (this.isTabbedPaneOrChildFocused() ? this.underlineColor : this.inactiveUnderlineColor) : this.disabledUnderlineColor);
        boolean bl2 = this.getTabType() == 1;
        boolean bl3 = bl = !bl2;
        Insets insets = bl ? (!this.rotateTabRuns && this.runCount > 1 && !this.isScrollTabLayout() && this.getRunForTab(this.tabPane.getTabCount(), n2) > 0 ? new Insets(0, 0, 0, 0) : this.getContentBorderInsets(n)) : null;
        int n7 = UIScale.scale(bl2 ? this.cardTabSelectionHeight : this.tabSelectionHeight);
        float f = UIScale.scale((float)(bl2 ? this.cardTabArc : this.tabSelectionArc)) / 2.0f;
        int n8 = n3;
        int n9 = n4;
        int n10 = n5;
        int n11 = n6;
        switch (n) {
            default: {
                n9 = bl ? n4 + n6 + insets.top - n7 : n4;
                n11 = n7;
                break;
            }
            case 3: {
                n9 = bl ? n4 - insets.bottom : n4 + n6 - n7;
                n11 = n7;
                break;
            }
            case 2: {
                n8 = bl ? n3 + n5 + insets.left - n7 : n3;
                n10 = n7;
                break;
            }
            case 4: {
                n8 = bl ? n3 - insets.right : n3 + n5 - n7;
                n10 = n7;
            }
        }
        if (!bl2 && this.tabSelectionInsets != null) {
            cloneable = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.tabSelectionInsets, (Insets)cloneable, this.tabPane.getTabPlacement());
            n8 += UIScale.scale(((Insets)cloneable).left);
            n9 += UIScale.scale(((Insets)cloneable).top);
            n10 -= UIScale.scale(((Insets)cloneable).left + ((Insets)cloneable).right);
            n11 -= UIScale.scale(((Insets)cloneable).top + ((Insets)cloneable).bottom);
        }
        if (f <= 0.0f) {
            graphics.fillRect(n8, n9, n10, n11);
        } else if (bl2) {
            cloneable = new Area(this.createCardTabOuterPath(n, n3, n4, n5, n6));
            ((Area)cloneable).intersect(new Area(new Rectangle2D.Float(n8, n9, n10, n11)));
            ((Graphics2D)graphics).fill((Shape)((Object)cloneable));
        } else {
            FlatUIUtils.paintSelection((Graphics2D)graphics, n8, n9, n10, n11, null, f, f, f, f, 0);
        }
    }

    protected boolean isTabbedPaneOrChildFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object = this.tabPane.getClientProperty("JComponent.focusOwner");
        if (object instanceof Predicate) {
            return ((Predicate)object).test(this.tabPane) && FlatUIUtils.isInActiveWindow(this.tabPane, keyboardFocusManager.getActiveWindow());
        }
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        return component != null && SwingUtilities.isDescendingFrom(component, this.tabPane) && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        Rectangle2D rectangle2D;
        Shape shape;
        if (this.tabPane.getTabCount() <= 0 || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return;
        }
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.tabPane.getWidth() - insets.right - insets.left;
        int n6 = this.tabPane.getHeight() - insets.top - insets.bottom;
        switch (n) {
            default: {
                n4 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n6 -= (n4 -= insets2.bottom) - insets.top;
                break;
            }
            case 3: {
                n6 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n6 += insets2.top;
                break;
            }
            case 2: {
                n3 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n5 -= (n3 -= insets2.right) - insets.left;
                break;
            }
            case 4: {
                n5 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n5 += insets2.left;
            }
        }
        boolean bl = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n7 = UIScale.scale(this.contentSeparatorHeight * 100);
        Insets insets3 = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(bl ? new Insets(n7, n7, n7, n7) : new Insets(n7, 0, 0, 0), insets3, n);
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(new Rectangle2D.Float(n3, n4, n5, n6), false);
        float_.append(new Rectangle2D.Float((float)n3 + (float)insets3.left / 100.0f, (float)n4 + (float)insets3.top / 100.0f, (float)n5 - (float)insets3.left / 100.0f - (float)insets3.right / 100.0f, (float)n6 - (float)insets3.top / 100.0f - (float)insets3.bottom / 100.0f), false);
        if (this.getTabType() == 1) {
            float f;
            float f2 = UIScale.scale((float)this.contentSeparatorHeight);
            shape = this.getTabBounds(this.tabPane, n2);
            rectangle2D = new Rectangle2D.Float((float)shape.x + f2, (float)shape.y + f2, (float)shape.width - f2 * 2.0f, (float)shape.height - f2 * 2.0f);
            if (this.tabViewport != null) {
                Rectangle2D.intersect(this.tabViewport.getBounds(), rectangle2D, rectangle2D);
            }
            Rectangle2D.Float float_2 = null;
            if (this.isHorizontalTabPlacement(n)) {
                if (((Rectangle2D.Float)rectangle2D).width > 0.0f) {
                    f = n == 1 ? (float)n4 : (float)(n4 + n6) - f2;
                    float_2 = new Rectangle2D.Float(((Rectangle2D.Float)rectangle2D).x, f, ((Rectangle2D.Float)rectangle2D).width, f2);
                }
            } else if (((Rectangle2D.Float)rectangle2D).height > 0.0f) {
                f = n == 2 ? (float)n3 : (float)(n3 + n5) - f2;
                float_2 = new Rectangle2D.Float(f, ((Rectangle2D.Float)rectangle2D).y, f2, ((Rectangle2D.Float)rectangle2D).height);
            }
            if (float_2 != null) {
                float_.append(float_2, false);
                Color color = this.getTabBackground(n, n2, true);
                graphics.setColor(FlatUIUtils.deriveColor(color, this.tabPane.getBackground()));
                ((Graphics2D)graphics).fill(float_2);
            }
        }
        graphics.setColor(this.contentAreaColor);
        ((Graphics2D)graphics).fill(float_);
        if (this.isScrollTabLayout() && n2 >= 0 && this.tabViewport != null) {
            Rectangle rectangle = this.getTabBounds(this.tabPane, n2);
            shape = graphics.getClip();
            rectangle2D = this.tabViewport.getBounds();
            if (this.isHorizontalTabPlacement(n)) {
                graphics.clipRect(rectangle2D.x, 0, rectangle2D.width, this.tabPane.getHeight());
            } else {
                graphics.clipRect(0, rectangle2D.y, this.tabPane.getWidth(), rectangle2D.height);
            }
            this.paintTabSelection(graphics, n, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setClip(shape);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected String layoutAndClipLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        int n3;
        int n4;
        int n5 = this.getRealTabRotation(n);
        boolean bl2 = this.isLeftToRight();
        rectangle = FlatUIUtils.subtractInsets(rectangle, this.getTabInsetsRotated(n, n2, n5));
        if (this.isTabClosable(n2)) {
            if (n5 == -1) {
                n4 = this.closeIcon.getIconWidth();
                rectangle.width -= n4;
                if (!bl2) {
                    rectangle.x += n4;
                }
            } else {
                n4 = this.closeIcon.getIconHeight();
                rectangle.height -= n4;
                if (n5 == 2 && bl2 || n5 == 4 && !bl2) {
                    rectangle.y += n4;
                }
            }
        }
        switch (FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement)) {
            default: {
                n4 = 0;
                n3 = 11;
                break;
            }
            case 11: {
                n4 = 0;
                n3 = 10;
                break;
            }
            case 1: {
                n4 = 3;
                n3 = 0;
                break;
            }
            case 3: {
                n4 = 1;
                n3 = 0;
            }
        }
        rectangle3.setBounds(0, 0, 0, 0);
        rectangle2.setBounds(0, 0, 0, 0);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        String string2 = n5 == -1 ? SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n2), n4, n3, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled)) : this.layoutVerticalCompoundLabel(n5, this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n2), n4, n3, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled));
        this.tabPane.putClientProperty("html", null);
        return string2;
    }

    private String layoutVerticalCompoundLabel(int n, JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        Rectangle rectangle4 = new Rectangle(rectangle.height, rectangle.width);
        String string2 = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, n2, n3, n4, n5, rectangle4, rectangle2, rectangle3, n6);
        if (n == 2) {
            this.rotateLeft(rectangle, rectangle2);
            this.rotateLeft(rectangle, rectangle3);
        } else {
            this.rotateRight(rectangle, rectangle2);
            this.rotateRight(rectangle, rectangle3);
        }
        return string2;
    }

    private void rotateLeft(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.x + rectangle2.y;
        int n2 = rectangle.y + (rectangle.height - (rectangle2.x + rectangle2.width));
        rectangle2.setBounds(n, n2, rectangle2.height, rectangle2.width);
    }

    private void rotateRight(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.x + (rectangle.width - (rectangle2.y + rectangle2.height));
        int n2 = rectangle.y + rectangle2.x;
        rectangle2.setBounds(n, n2, rectangle2.height, rectangle2.width);
    }

    protected int getRealTabRotation(int n) {
        int n2;
        int n3 = this.getTabRotation();
        int n4 = n3 == -2 ? (n == 2 ? 2 : (n == 4 ? 4 : -1)) : (n2 = n3 == 2 || n3 == 4 ? n3 : -1);
        assert (n2 == -1 || n2 == 2 || n2 == 4);
        return n2;
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (this.moreTabsButton != null) {
            Point point = this.tabViewport.getViewPosition();
            n = n - this.tabViewport.getX() + point.x;
            n2 = n2 - this.tabViewport.getY() + point.y;
            if (!this.tabViewport.getViewRect().contains(n, n2)) {
                return -1;
            }
        }
        return super.tabForCoordinate(jTabbedPane, n, n2);
    }

    @Override
    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        if (this.moreTabsButton != null) {
            rectangle.setBounds(this.rects[n]);
            Point point = this.tabViewport.getViewPosition();
            rectangle.x = rectangle.x + this.tabViewport.getX() - point.x;
            rectangle.y = rectangle.y + this.tabViewport.getY() - point.y;
            return rectangle;
        }
        return super.getTabBounds(n, rectangle);
    }

    protected Rectangle getTabCloseBounds(int n, int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6 = this.closeIcon.getIconWidth();
        int n7 = this.closeIcon.getIconHeight();
        int n8 = this.tabPane.getTabPlacement();
        int n9 = this.getRealTabRotation(n8);
        Insets insets = this.getTabInsetsRotated(n8, n, n9);
        boolean bl = this.isLeftToRight();
        if (n9 == -1) {
            rectangle.x = bl ? n2 + n4 - insets.right / 3 * 2 - n6 : n2 + insets.left / 3 * 2;
            rectangle.y = n3 + (n5 - n7) / 2;
        } else {
            rectangle.x = n2 + (n4 - n6) / 2;
            rectangle.y = n9 == 4 && bl || n9 == 2 && !bl ? n3 + n5 - insets.bottom / 3 * 2 - n7 : n3 + insets.top / 3 * 2;
        }
        rectangle.width = n6;
        rectangle.height = n7;
        return rectangle;
    }

    protected Rectangle getTabCloseHitArea(int n) {
        Rectangle rectangle = this.getTabBounds(this.tabPane, n);
        Rectangle rectangle2 = this.getTabCloseBounds(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.calcRect);
        return this.getRealTabRotation(this.tabPane.getTabPlacement()) == -1 ? new Rectangle(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height) : new Rectangle(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
    }

    protected boolean isTabClosable(int n) {
        if (n < 0) {
            return false;
        }
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabClosable");
        return object instanceof Boolean ? (Boolean)object : this.tabClosable;
    }

    protected void closeTab(int n) {
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabCloseCallback");
        if (object instanceof IntConsumer) {
            ((IntConsumer)object).accept(n);
        } else if (object instanceof BiConsumer) {
            ((BiConsumer)object).accept(this.tabPane, n);
        } else {
            throw new RuntimeException("Missing tab close callback. Set client property 'JTabbedPane.tabCloseCallback' to a 'java.util.function.IntConsumer' or 'java.util.function.BiConsumer<JTabbedPane, Integer>'");
        }
    }

    protected Object getTabClientProperty(int n, String string) {
        Object object;
        if (n < 0) {
            return null;
        }
        Component component = this.tabPane.getComponentAt(n);
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(string)) != null) {
            return object;
        }
        return this.tabPane.getClientProperty(string);
    }

    protected int getTabClientPropertyInt(int n, String string, int n2) {
        Object object = this.getTabClientProperty(n, string);
        return object instanceof Integer ? (Integer)object : n2;
    }

    protected void ensureCurrentLayout() {
        super.getTabRunCount(this.tabPane);
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return this.rotateTabRuns;
    }

    private boolean isLastInRun(int n) {
        int n2 = this.getRunForTab(this.tabPane.getTabCount(), n);
        return this.lastTabInRun(this.tabPane.getTabCount(), n2) == n;
    }

    private boolean isScrollTabLayout() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private boolean isLeftToRight() {
        return this.tabPane.getComponentOrientation().isLeftToRight();
    }

    protected boolean isHorizontalTabPlacement(int n) {
        return n == 1 || n == 3;
    }

    private boolean isHorizontalOrRotated(int n) {
        return this.isHorizontalTabPlacement(n) == (this.getRealTabRotation(n) == -1);
    }

    protected boolean isSmoothScrollingEnabled() {
        if (!Animator.useAnimation()) {
            return false;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    protected boolean hideTabArea() {
        return this.tabPane.getTabCount() == 1 && this.leadingComponent == null && this.trailingComponent == null && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hideTabAreaWithOneTab", this.hideTabAreaWithOneTab);
    }

    protected int getTabType() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabType");
        return object instanceof String ? FlatTabbedPaneUI.parseTabType((String)object) : this.tabType;
    }

    protected int getTabsPopupPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabsPopupPolicy");
        return object instanceof String ? FlatTabbedPaneUI.parseTabsPopupPolicy((String)object) : this.tabsPopupPolicy;
    }

    protected int getScrollButtonsPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPolicy");
        return object instanceof String ? FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object) : this.scrollButtonsPolicy;
    }

    protected int getScrollButtonsPlacement() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPlacement");
        return object instanceof String ? FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object) : this.scrollButtonsPlacement;
    }

    protected int getTabAreaAlignment() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseAlignment((String)object, 10) : this.tabAreaAlignment;
    }

    protected int getTabAlignment(int n) {
        Object object = this.getTabClientProperty(n, "JTabbedPane.tabAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseAlignment((String)object, 0) : this.tabAlignment;
    }

    protected int getTabWidthMode() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabWidthMode");
        return object instanceof String ? FlatTabbedPaneUI.parseTabWidthMode((String)object) : this.tabWidthMode;
    }

    protected int getTabRotation() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabRotation");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseTabRotation((String)object) : this.tabRotation;
    }

    protected static int parseTabType(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return 0;
            }
            case "card": 
        }
        return 1;
    }

    protected static int parseTabsPopupPolicy(String string) {
        if (string == null) {
            return 2;
        }
        switch (string) {
            default: {
                return 2;
            }
            case "never": 
        }
        return 0;
    }

    protected static int parseScrollButtonsPolicy(String string) {
        if (string == null) {
            return 3;
        }
        switch (string) {
            default: {
                return 3;
            }
            case "asNeeded": {
                return 2;
            }
            case "never": 
        }
        return 0;
    }

    protected static int parseScrollButtonsPlacement(String string) {
        if (string == null) {
            return 100;
        }
        switch (string) {
            default: {
                return 100;
            }
            case "trailing": 
        }
        return 11;
    }

    protected static int parseAlignment(String string, int n) {
        if (string == null) {
            return n;
        }
        switch (string) {
            case "leading": {
                return 10;
            }
            case "trailing": {
                return 11;
            }
            case "center": {
                return 0;
            }
            case "fill": {
                return 100;
            }
        }
        return n;
    }

    private static String alignmentToString(int n, String string) {
        switch (n) {
            case 10: {
                return "leading";
            }
            case 11: {
                return "trailing";
            }
            case 0: {
                return "center";
            }
            case 100: {
                return "fill";
            }
        }
        return string;
    }

    protected static int parseTabWidthMode(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return 0;
            }
            case "equal": {
                return 1;
            }
            case "compact": 
        }
        return 2;
    }

    protected static int parseTabRotation(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return -1;
            }
            case "auto": {
                return -2;
            }
            case "left": {
                return 2;
            }
            case "right": 
        }
        return 4;
    }

    protected static int parseTabIconPlacement(String string) {
        if (string == null) {
            return 10;
        }
        switch (string) {
            default: {
                return 10;
            }
            case "trailing": {
                return 11;
            }
            case "top": {
                return 1;
            }
            case "bottom": 
        }
        return 3;
    }

    private void runWithOriginalLayoutManager(Runnable runnable) {
        LayoutManager layoutManager = this.tabPane.getLayout();
        if (layoutManager instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)layoutManager).delegate);
            runnable.run();
            this.tabPane.setLayout(layoutManager);
        } else {
            runnable.run();
        }
    }

    protected void ensureSelectedTabIsVisibleLater() {
        if (!this.tabPane.isDisplayable() || !EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(() -> this.ensureSelectedTabIsVisible());
    }

    protected void ensureSelectedTabIsVisible() {
        if (this.tabPane == null || this.tabViewport == null || !this.tabPane.isDisplayable()) {
            return;
        }
        this.ensureCurrentLayout();
        int n = this.tabPane.getSelectedIndex();
        if (n < 0 || n >= this.rects.length) {
            return;
        }
        ((JComponent)this.tabViewport.getView()).scrollRectToVisible((Rectangle)this.rects[n].clone());
    }

    private int getLeadingPreferredWidth() {
        return this.leadingComponent != null ? this.leadingComponent.getPreferredSize().width : 0;
    }

    private int getLeadingPreferredHeight() {
        return this.leadingComponent != null ? this.leadingComponent.getPreferredSize().height : 0;
    }

    private int getTrailingPreferredWidth() {
        return this.trailingComponent != null ? this.trailingComponent.getPreferredSize().width : 0;
    }

    private int getTrailingPreferredHeight() {
        return this.trailingComponent != null ? this.trailingComponent.getPreferredSize().height : 0;
    }

    private void shiftTabs(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        for (int i = 0; i < this.rects.length; ++i) {
            this.rects[i].x += n;
            this.rects[i].y += n2;
        }
    }

    private void stretchTabsWidth(int n, boolean bl) {
        int n2;
        int n3 = n / this.rects.length;
        int n4 = this.rects[0].x - (bl ? 0 : n3);
        for (n2 = 0; n2 < this.rects.length; ++n2) {
            this.rects[n2].x = n4;
            this.rects[n2].width += n3;
            if (bl) {
                n4 += this.rects[n2].width;
                continue;
            }
            if (n2 + 1 >= this.rects.length) continue;
            n4 = this.rects[n2].x - this.rects[n2 + 1].width - n3;
        }
        n2 = n - n3 * this.rects.length;
        this.rects[this.rects.length - 1].width += n2;
        if (!bl) {
            this.rects[this.rects.length - 1].x -= n2;
        }
    }

    private void stretchTabsHeight(int n) {
        int n2 = n / this.rects.length;
        int n3 = this.rects[0].y;
        for (int i = 0; i < this.rects.length; ++i) {
            this.rects[i].y = n3;
            this.rects[i].height += n2;
            n3 += this.rects[i].height;
        }
        this.rects[this.rects.length - 1].height += n - n2 * this.rects.length;
    }

    private int rectsTotalWidth(boolean bl) {
        int n = this.rects.length - 1;
        return bl ? this.rects[n].x + this.rects[n].width - this.rects[0].x : this.rects[0].x + this.rects[0].width - this.rects[n].x;
    }

    private int rectsTotalHeight() {
        int n = this.rects.length - 1;
        return this.rects[n].y + this.rects[n].height - this.rects[0].y;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n, int n2) {
        if (this.tabForCoordinate(this.tabPane, n, n2) >= 0) {
            return false;
        }
        return null;
    }

    private static class FlatSelectedTabRepainter
    implements PropertyChangeListener {
        private static FlatSelectedTabRepainter instance;
        private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void install() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                instance = new FlatSelectedTabRepainter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        FlatSelectedTabRepainter() {
            this.keyboardFocusManager.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uninstall() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.keyboardFocusManager.removePropertyChangeListener(this);
                this.keyboardFocusManager = null;
                instance = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof FlatLaf)) {
                this.uninstall();
                return;
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "permanentFocusOwner": {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object instanceof Component) {
                        this.repaintSelectedTabs((Component)object);
                    }
                    if (!(object2 instanceof Component)) break;
                    this.repaintSelectedTabs((Component)object2);
                    break;
                }
                case "activeWindow": {
                    Component component = this.keyboardFocusManager.getPermanentFocusOwner();
                    if (component == null) break;
                    this.repaintSelectedTabs(component);
                }
            }
        }

        private void repaintSelectedTabs(Component component) {
            EventQueue.invokeLater(() -> {
                if (!component.isDisplayable()) {
                    return;
                }
                if (component instanceof JTabbedPane) {
                    this.repaintSelectedTab((JTabbedPane)component);
                }
                Component component2 = component;
                while ((component2 = SwingUtilities.getAncestorOfClass(JTabbedPane.class, component2)) != null) {
                    this.repaintSelectedTab((JTabbedPane)component2);
                }
            });
        }

        private void repaintSelectedTab(JTabbedPane jTabbedPane) {
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            if (tabbedPaneUI instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)tabbedPaneUI).repaintTab(jTabbedPane.getSelectedIndex());
            }
        }
    }

    private static class RunWithOriginalLayoutManagerDelegateAction
    extends FlatUIAction {
        static void install(ActionMap actionMap, String string) {
            Action action = actionMap.get(string);
            if (action == null || action instanceof RunWithOriginalLayoutManagerDelegateAction) {
                return;
            }
            actionMap.put(string, new RunWithOriginalLayoutManagerDelegateAction(action));
        }

        private RunWithOriginalLayoutManagerDelegateAction(Action action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            if (tabbedPaneUI instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)tabbedPaneUI).runWithOriginalLayoutManager(() -> this.delegate.actionPerformed(actionEvent));
            } else {
                this.delegate.actionPerformed(actionEvent);
            }
        }
    }

    protected class FlatTabbedPaneScrollLayout
    extends FlatTabbedPaneLayout
    implements LayoutManager {
        private final BasicTabbedPaneUI.TabbedPaneLayout delegate;

        protected FlatTabbedPaneScrollLayout(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
            this.delegate = tabbedPaneLayout;
        }

        @Override
        public void calculateLayoutInfo() {
            this.delegate.calculateLayoutInfo();
        }

        @Override
        protected Dimension calculateTabAreaSize() {
            Dimension dimension = super.calculateTabAreaSize();
            if (FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                dimension.width = Math.min(dimension.width, UIScale.scale(100));
            } else {
                dimension.height = Math.min(dimension.height, UIScale.scale(100));
            }
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.minimumLayoutSize(container);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.delegate.addLayoutComponent(string, component);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.delegate.removeLayoutComponent(component);
        }

        @Override
        protected void layoutContainerImpl() {
            int n;
            Dimension dimension;
            int n2;
            int n3;
            int n4;
            int n5;
            Rectangle rectangle;
            int n6;
            int n7;
            int n8;
            Cloneable cloneable;
            Serializable serializable;
            int n9;
            this.layoutChildComponents();
            int n10 = FlatTabbedPaneUI.this.getTabsPopupPolicy();
            int n11 = FlatTabbedPaneUI.this.getScrollButtonsPolicy();
            int n12 = FlatTabbedPaneUI.this.getScrollButtonsPlacement();
            boolean bl = n10 == 2;
            boolean bl2 = n11 == 2 || n11 == 3;
            boolean bl3 = n11 == 3 && n12 == 100;
            boolean bl4 = n12 == 11;
            boolean bl5 = FlatTabbedPaneUI.this.isLeftToRight();
            if (!bl5 && FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                bl = true;
                bl2 = false;
            }
            JButton jButton = null;
            JButton jButton2 = null;
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (!(component instanceof FlatScrollableTabButton)) continue;
                n9 = ((FlatScrollableTabButton)component).getDirection();
                if (n9 == 7 || n9) {
                    jButton = (JButton)component;
                    continue;
                }
                if (n9 != 3 && n9 != 5) continue;
                jButton2 = (JButton)component;
            }
            if (jButton == null || jButton2 == null) {
                return;
            }
            int n13 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n14 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n13);
            boolean bl6 = false;
            n9 = 0;
            boolean bl7 = false;
            if (insets.left != 0 || insets.top != 0) {
                FlatTabbedPaneUI.this.shiftTabs(-insets.left, -insets.top);
                serializable = FlatTabbedPaneUI.this.tabViewport.getView();
                cloneable = ((Component)serializable).getPreferredSize();
                n8 = n13 == 1 || n13 == 3 ? 1 : 0;
                ((Component)serializable).setPreferredSize(new Dimension(cloneable.width - (n8 != 0 ? insets.left : 0), cloneable.height - (n8 != 0 ? 0 : insets.top)));
            }
            serializable = this.getTabAreaLayoutBounds(n13, insets);
            if (n13 == 1 || n13 == 3) {
                if (bl2 && bl3) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).x <= jButton.getPreferredSize().width) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(0, ((Point)cloneable).y));
                    }
                }
                n7 = ((Rectangle)serializable).width - FlatTabbedPaneUI.this.getLeadingPreferredWidth() - FlatTabbedPaneUI.this.getTrailingPreferredWidth() - insets.left - insets.right;
                n8 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalWidth(bl5) : 0;
                n6 = n8 < n7 ? 1 : 0;
                rectangle = this.layoutLeftAndRightComponents((Rectangle)serializable, n14, insets, n6 != 0, false, bl5);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    n5 = rectangle.x + (bl5 ? insets.left : insets.right);
                    n4 = rectangle.width - insets.left - insets.right;
                    n3 = rectangle.y;
                    n2 = rectangle.height;
                    if (n4 < n8) {
                        if (bl) {
                            int n15 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().width;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(bl5 ? n5 + n4 - n15 : n5, n3, n15, n2);
                            n5 += bl5 ? 0 : n15;
                            n4 -= n15;
                            bl6 = true;
                        }
                        if (bl2) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (!bl3 || dimension.width - point.x > n4) {
                                n = jButton2.getPreferredSize().width;
                                jButton2.setBounds(n5 + n4 - n, n3, n, n2);
                                n4 -= n;
                                bl7 = true;
                            }
                            if (!bl3 || point.x > 0) {
                                n = jButton.getPreferredSize().width;
                                if (bl4) {
                                    jButton.setBounds(n5 + n4 - n, n3, n, n2);
                                } else {
                                    jButton.setBounds(n5, n3, n, n2);
                                    n5 += n;
                                }
                                n4 -= n;
                                n9 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n5, n3, n4, n2);
                    if (!bl5) {
                        FlatTabbedPaneUI.this.tabViewport.doLayout();
                        FlatTabbedPaneUI.this.shiftTabs(FlatTabbedPaneUI.this.tabViewport.getView().getWidth() - (((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].x + ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].width), 0);
                    }
                }
            } else {
                if (bl2 && bl3) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).y <= jButton.getPreferredSize().height) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(((Point)cloneable).x, 0));
                    }
                }
                n7 = ((Rectangle)serializable).height - FlatTabbedPaneUI.this.getLeadingPreferredHeight() - FlatTabbedPaneUI.this.getTrailingPreferredHeight() - insets.top - insets.bottom;
                n8 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalHeight() : 0;
                n6 = n8 < n7 ? 1 : 0;
                rectangle = this.layoutTopAndBottomComponents((Rectangle)serializable, n14, insets, n6 != 0, false);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    n5 = rectangle.y + insets.top;
                    n4 = rectangle.height - insets.top - insets.bottom;
                    n3 = rectangle.x;
                    n2 = rectangle.width;
                    if (n4 < n8) {
                        if (bl) {
                            int n16 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().height;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(n3, n5 + n4 - n16, n2, n16);
                            n4 -= n16;
                            bl6 = true;
                        }
                        if (bl2) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (!bl3 || dimension.height - point.y > n4) {
                                n = jButton2.getPreferredSize().height;
                                jButton2.setBounds(n3, n5 + n4 - n, n2, n);
                                n4 -= n;
                                bl7 = true;
                            }
                            if (!bl3 || point.y > 0) {
                                n = jButton.getPreferredSize().height;
                                if (bl4) {
                                    jButton.setBounds(n3, n5 + n4 - n, n2, n);
                                } else {
                                    jButton.setBounds(n3, n5, n2, n);
                                    n5 += n;
                                }
                                n4 -= n;
                                n9 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n3, n5, n2, n4);
                }
            }
            Component component = FlatTabbedPaneUI.this.tabViewport.getView();
            if (component instanceof Container && ((Container)component).getComponentCount() > 0) {
                for (Component component2 : ((Container)component).getComponents()) {
                    if (!this.isTabContainer(component2)) continue;
                    this.layoutTabComponents(component2);
                    break;
                }
            }
            FlatTabbedPaneUI.this.tabViewport.setVisible(FlatTabbedPaneUI.this.rects.length > 0);
            FlatTabbedPaneUI.this.moreTabsButton.setVisible(bl6);
            jButton.setVisible(n9 != 0);
            jButton2.setVisible(bl7);
            FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize = jButton.getPreferredSize();
        }

        @Override
        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.tabViewport || component instanceof FlatTabAreaButton || component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            component.setBounds(rectangle);
        }
    }

    protected class FlatTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected FlatTabbedPaneLayout() {
            super(FlatTabbedPaneUI.this);
        }

        @Override
        protected Dimension calculateSize(boolean bl) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return super.calculateSize(bl);
        }

        protected boolean isContentEmpty() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabCount();
            if (n == 0) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Component component = FlatTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width == 0 && dimension.height == 0) continue;
                return false;
            }
            return true;
        }

        protected Dimension calculateTabAreaSize() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n);
            FontMetrics fontMetrics = FlatTabbedPaneUI.this.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                if (bl) {
                    n3 += FlatTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                    n4 = Math.max(n4, FlatTabbedPaneUI.this.calculateTabHeight(n, i, n2));
                    continue;
                }
                n3 = Math.max(n3, FlatTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics));
                n4 += FlatTabbedPaneUI.this.calculateTabHeight(n, i, n2);
            }
            if (bl) {
                n4 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            } else {
                n3 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            }
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getTabAreaInsets(n);
            return new Dimension(n3 + insets.left + insets.right + insets2.left + insets2.right, n4 + insets.bottom + insets.top + insets2.top + insets2.bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            Object object;
            FlatTabbedPaneUI.this.setRolloverTab(-1);
            this.calculateLayoutInfo();
            boolean bl = false;
            int n = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (n >= 0) {
                object = FlatTabbedPaneUI.this.getVisibleComponent();
                Component component = FlatTabbedPaneUI.this.tabPane.getComponentAt(n);
                if (component != null && component != object) {
                    bl = SwingUtilities.findFocusOwner((Component)object) != null;
                    FlatTabbedPaneUI.this.setVisibleComponent(component);
                }
            } else {
                FlatTabbedPaneUI.this.setVisibleComponent(null);
            }
            this.layoutContainerImpl();
            if (bl && (object = FlatTabbedPaneUI.this.tabPane.getActionMap().get("requestFocusForVisibleComponent")) != null) {
                object.actionPerformed(new ActionEvent(FlatTabbedPaneUI.this.tabPane, 1001, null));
            }
        }

        protected void layoutContainerImpl() {
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n);
            boolean bl = FlatTabbedPaneUI.this.isLeftToRight();
            Rectangle rectangle = this.getTabAreaLayoutBounds(n, insets);
            if (n == 1 || n == 3) {
                if (!bl) {
                    FlatTabbedPaneUI.this.shiftTabs(((FlatTabbedPaneUI)FlatTabbedPaneUI.this).tabPane.getInsets().left + insets.right + FlatTabbedPaneUI.this.getTrailingPreferredWidth(), 0);
                }
                this.layoutLeftAndRightComponents(rectangle, n2, insets, FlatTabbedPaneUI.this.runCount == 1, true, bl);
            } else {
                this.layoutTopAndBottomComponents(rectangle, n2, insets, FlatTabbedPaneUI.this.runCount == 1, true);
            }
            this.layoutChildComponents();
        }

        protected void layoutChildComponents() {
            if (FlatTabbedPaneUI.this.tabPane.getComponentCount() == 0) {
                return;
            }
            Rectangle rectangle = this.getContentAreaLayoutBounds(FlatTabbedPaneUI.this.tabPane.getTabPlacement(), FlatTabbedPaneUI.this.tabAreaInsets);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                this.layoutChildComponent(component, rectangle);
            }
        }

        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            if (this.isTabContainer(component)) {
                this.layoutTabContainer(component);
            } else {
                component.setBounds(rectangle);
            }
        }

        boolean isTabContainer(Component component) {
            return component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$TabContainer");
        }

        private void layoutTabContainer(Component component) {
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rectangle = FlatTabbedPaneUI.this.tabPane.getBounds();
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getContentBorderInsets(n);
            boolean bl = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n);
            int n2 = !bl ? FlatTabbedPaneUI.this.calculateTabAreaWidth(n, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabWidth) : 0;
            int n3 = bl ? FlatTabbedPaneUI.this.calculateTabAreaHeight(n, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabHeight) : 0;
            int n4 = n2 != 0 ? n2 + insets.left + insets.right + insets2.left + insets2.right : rectangle.width;
            int n5 = n3 != 0 ? n3 + insets.top + insets.bottom + insets2.top + insets2.bottom : rectangle.height;
            int n6 = n == 4 ? rectangle.width - n4 : 0;
            int n7 = n == 3 ? rectangle.height - n5 : 0;
            component.setBounds(n6, n7, n4, n5);
            this.layoutTabComponents(component);
        }

        void layoutTabComponents(Component component) {
            if (component instanceof Container && ((Container)component).getComponentCount() == 0) {
                return;
            }
            int n = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle rectangle = new Rectangle();
            int n3 = -component.getX();
            int n4 = -component.getY();
            if (FlatTabbedPaneUI.this.isScrollTabLayout()) {
                Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                n3 = n3 - FlatTabbedPaneUI.this.tabViewport.getX() + point.x;
                n4 = n4 - FlatTabbedPaneUI.this.tabViewport.getY() + point.y;
            }
            int n5 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                Component component2 = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (component2 == null) continue;
                Rectangle rectangle2 = FlatTabbedPaneUI.this.getTabBounds(i, rectangle);
                Insets insets = FlatTabbedPaneUI.this.getTabInsets(n, i);
                int n6 = rectangle2.x + insets.left + n3;
                int n7 = rectangle2.y + insets.top + n4;
                int n8 = rectangle2.width - insets.left - insets.right;
                int n9 = rectangle2.height - insets.top - insets.bottom;
                Dimension dimension = component2.getPreferredSize();
                int n10 = n6 + (n8 - dimension.width) / 2;
                int n11 = n7 + (n9 - dimension.height) / 2;
                boolean bl = i == n2;
                component2.setBounds(n10 += FlatTabbedPaneUI.this.getTabLabelShiftX(n, i, bl), n11 += FlatTabbedPaneUI.this.getTabLabelShiftY(n, i, bl), dimension.width, dimension.height);
            }
        }

        Rectangle getContentAreaLayoutBounds(int n, Insets insets) {
            int n2 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n3 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets3 = FlatTabbedPaneUI.this.getContentBorderInsets(n);
            boolean bl = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n);
            int n4 = !bl ? FlatTabbedPaneUI.this.calculateTabAreaWidth(n, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabWidth) : 0;
            int n5 = bl ? FlatTabbedPaneUI.this.calculateTabAreaHeight(n, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabHeight) : 0;
            Rectangle rectangle = new Rectangle();
            rectangle.x = insets2.left + insets3.left;
            rectangle.y = insets2.top + insets3.top;
            rectangle.width = n2 - insets2.left - insets2.right - insets3.left - insets3.right - n4;
            rectangle.height = n3 - insets2.top - insets2.bottom - insets3.top - insets3.bottom - n5;
            if (n == 1) {
                rectangle.y += n5;
            } else if (n == 2) {
                rectangle.x += n4;
            }
            return rectangle;
        }

        Rectangle getTabAreaLayoutBounds(int n, Insets insets) {
            int n2 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n3 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Rectangle rectangle = new Rectangle();
            if (n == 1 || n == 3) {
                int n4 = FlatTabbedPaneUI.this.maxTabHeight > 0 ? FlatTabbedPaneUI.this.maxTabHeight : Math.max(Math.max(FlatTabbedPaneUI.this.getLeadingPreferredHeight(), FlatTabbedPaneUI.this.getTrailingPreferredHeight()), UIScale.scale(FlatClientProperties.clientPropertyInt(FlatTabbedPaneUI.this.tabPane, "JTabbedPane.tabHeight", FlatTabbedPaneUI.this.tabHeight)));
                rectangle.x = insets2.left;
                rectangle.y = n == 1 ? insets2.top + insets.top : n3 - insets2.bottom - insets.bottom - n4;
                rectangle.width = n2 - insets2.left - insets2.right;
                rectangle.height = n4;
            } else {
                int n5 = FlatTabbedPaneUI.this.maxTabWidth > 0 ? FlatTabbedPaneUI.this.maxTabWidth : Math.max(FlatTabbedPaneUI.this.getLeadingPreferredWidth(), FlatTabbedPaneUI.this.getTrailingPreferredWidth());
                rectangle.x = n == 2 ? insets2.left + insets.left : n2 - insets2.right - insets.right - n5;
                rectangle.y = insets2.top;
                rectangle.width = n5;
                rectangle.height = n3 - insets2.top - insets2.bottom;
            }
            return rectangle;
        }

        Rectangle layoutLeftAndRightComponents(Rectangle rectangle, int n, Insets insets, boolean bl, boolean bl2, boolean bl3) {
            int n2;
            int n3;
            int n4 = FlatTabbedPaneUI.this.getLeadingPreferredWidth();
            int n5 = FlatTabbedPaneUI.this.getTrailingPreferredWidth();
            if (bl && FlatTabbedPaneUI.this.rects.length > 0) {
                int n6 = rectangle.width - n4 - n5 - insets.left - insets.right;
                n3 = FlatTabbedPaneUI.this.rectsTotalWidth(bl3);
                int n7 = n6 - n3;
                switch (n) {
                    case 10: {
                        n5 += n7;
                        break;
                    }
                    case 11: {
                        if (bl2) {
                            FlatTabbedPaneUI.this.shiftTabs(bl3 ? n7 : -n7, 0);
                        }
                        n4 += n7;
                        break;
                    }
                    case 0: {
                        if (bl2) {
                            FlatTabbedPaneUI.this.shiftTabs((bl3 ? n7 : -n7) / 2, 0);
                        }
                        n4 += n7 / 2;
                        n5 += n7 - n7 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsWidth(n7, bl3);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n5 = rectangle.width - n4;
            }
            Container container = bl3 ? FlatTabbedPaneUI.this.leadingComponent : FlatTabbedPaneUI.this.trailingComponent;
            int n8 = n3 = bl3 ? n4 : n5;
            if (container != null) {
                container.setBounds(rectangle.x, rectangle.y, n3, rectangle.height);
            }
            Container container2 = bl3 ? FlatTabbedPaneUI.this.trailingComponent : FlatTabbedPaneUI.this.leadingComponent;
            int n9 = n2 = bl3 ? n5 : n4;
            if (container2 != null) {
                container2.setBounds(rectangle.x + rectangle.width - n2, rectangle.y, n2, rectangle.height);
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x += n3;
            rectangle2.width -= n3 + n2;
            return rectangle2;
        }

        Rectangle layoutTopAndBottomComponents(Rectangle rectangle, int n, Insets insets, boolean bl, boolean bl2) {
            int n2 = FlatTabbedPaneUI.this.getLeadingPreferredHeight();
            int n3 = FlatTabbedPaneUI.this.getTrailingPreferredHeight();
            if (bl && FlatTabbedPaneUI.this.rects.length > 0) {
                int n4 = rectangle.height - n2 - n3 - insets.top - insets.bottom;
                int n5 = FlatTabbedPaneUI.this.rectsTotalHeight();
                int n6 = n4 - n5;
                switch (n) {
                    case 10: {
                        n3 += n6;
                        break;
                    }
                    case 11: {
                        if (bl2) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n6);
                        }
                        n2 += n6;
                        break;
                    }
                    case 0: {
                        if (bl2) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n6 / 2);
                        }
                        n2 += n6 / 2;
                        n3 += n6 - n6 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsHeight(n6);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n3 = rectangle.height - n2;
            }
            if (FlatTabbedPaneUI.this.leadingComponent != null) {
                FlatTabbedPaneUI.this.leadingComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, n2);
            }
            if (FlatTabbedPaneUI.this.trailingComponent != null) {
                FlatTabbedPaneUI.this.trailingComponent.setBounds(rectangle.x, rectangle.y + rectangle.height - n3, rectangle.width, n3);
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.y += n2;
            rectangle2.height -= n2 + n3;
            return rectangle2;
        }
    }

    private class Handler
    implements ComponentListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        MouseListener mouseDelegate;
        PropertyChangeListener propertyChangeDelegate;
        ChangeListener changeDelegate;
        FocusListener focusDelegate;
        private final PropertyChangeListener contentListener = this::contentPropertyChange;
        private int pressedTabIndex = -1;
        private int lastTipTabIndex = -1;
        private String lastTip;

        private Handler() {
        }

        void installListeners() {
            FlatTabbedPaneUI.this.tabPane.addMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.addComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.addContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.addPropertyChangeListener(this.contentListener);
            }
        }

        void uninstallListeners() {
            FlatTabbedPaneUI.this.tabPane.removeMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.removeComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.removeContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.mouseDelegate.mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
            if (!FlatTabbedPaneUI.this.isPressedTabClose() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.mouseDelegate.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FlatTabbedPaneUI.this.isPressedTabClose()) {
                this.updateRollover(mouseEvent);
                if (this.pressedTabIndex >= 0 && this.pressedTabIndex == FlatTabbedPaneUI.this.getRolloverTab()) {
                    this.restoreTabToolTip();
                    FlatTabbedPaneUI.this.closeTab(this.pressedTabIndex);
                }
            } else {
                this.mouseDelegate.mouseReleased(mouseEvent);
            }
            this.pressedTabIndex = -1;
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        private void updateRollover(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, n, n2);
            FlatTabbedPaneUI.this.setRolloverTab(n3);
            boolean bl2 = bl = FlatTabbedPaneUI.this.isTabClosable(n3) && FlatTabbedPaneUI.this.getTabCloseHitArea(n3).contains(n, n2);
            if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.pressedTabIndex = bl ? n3 : -1;
            }
            FlatTabbedPaneUI.this.setRolloverTabClose(bl);
            FlatTabbedPaneUI.this.setPressedTabClose(bl && n3 == this.pressedTabIndex);
            if (n3 >= 0 && bl) {
                Object object = FlatTabbedPaneUI.this.getTabClientProperty(n3, "JTabbedPane.tabCloseToolTipText");
                if (object == null) {
                    object = FlatTabbedPaneUI.this.tabCloseToolTipText;
                }
                if (object instanceof String) {
                    this.setCloseToolTip(n3, (String)object);
                } else {
                    this.restoreTabToolTip();
                }
            } else {
                this.restoreTabToolTip();
            }
        }

        private void setCloseToolTip(int n, String string) {
            if (n == this.lastTipTabIndex) {
                return;
            }
            this.restoreTabToolTip();
            this.lastTipTabIndex = n;
            this.lastTip = FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(this.lastTipTabIndex);
            FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, string);
        }

        private void restoreTabToolTip() {
            if (this.lastTipTabIndex < 0) {
                return;
            }
            if (this.lastTipTabIndex < FlatTabbedPaneUI.this.tabPane.getTabCount()) {
                FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, this.lastTip);
            }
            this.lastTip = null;
            this.lastTipTabIndex = -1;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": 
                case "opaque": 
                case "background": 
                case "indexForTabComponent": {
                    FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> this.propertyChangeDelegate.propertyChange(propertyChangeEvent));
                    break;
                }
                default: {
                    this.propertyChangeDelegate.propertyChange(propertyChangeEvent);
                }
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": {
                    if (!(FlatTabbedPaneUI.this.moreTabsButton instanceof FlatMoreTabsButton)) break;
                    ((FlatMoreTabsButton)FlatTabbedPaneUI.this.moreTabsButton).updateDirection();
                    break;
                }
                case "componentOrientation": {
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "JTabbedPane.showTabSeparators": 
                case "JTabbedPane.tabType": {
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    break;
                }
                case "JTabbedPane.showContentSeparator": 
                case "JTabbedPane.hasFullBorder": 
                case "JTabbedPane.hideTabAreaWithOneTab": 
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabHeight": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAreaInsets": 
                case "JTabbedPane.tabsPopupPolicy": 
                case "JTabbedPane.scrollButtonsPolicy": 
                case "JTabbedPane.scrollButtonsPlacement": 
                case "JTabbedPane.tabAreaAlignment": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabWidthMode": 
                case "JTabbedPane.tabRotation": 
                case "JTabbedPane.tabIconPlacement": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    break;
                }
                case "JTabbedPane.leadingComponent": {
                    FlatTabbedPaneUI.this.uninstallLeadingComponent();
                    FlatTabbedPaneUI.this.installLeadingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "JTabbedPane.trailingComponent": {
                    FlatTabbedPaneUI.this.uninstallTrailingComponent();
                    FlatTabbedPaneUI.this.installTrailingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    FlatTabbedPaneUI.this.installStyle();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeDelegate.stateChanged(changeEvent);
            if (FlatTabbedPaneUI.this.moreTabsButton != null) {
                FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
            }
        }

        protected void contentPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (!(component instanceof UIResource)) {
                component.addPropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (!(component instanceof UIResource)) {
                component.removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusDelegate.focusGained(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusDelegate.focusLost(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    protected class FlatWheelTabScroller
    extends MouseAdapter {
        private int lastMouseX;
        private int lastMouseY;
        private boolean inViewport;
        private boolean scrolled;
        private Timer rolloverTimer;
        private Timer exitedTimer;
        private Animator animator;
        private Point startViewPosition;
        private Point targetViewPosition;

        protected FlatWheelTabScroller() {
        }

        protected void uninstall() {
            if (this.rolloverTimer != null) {
                this.rolloverTimer.stop();
            }
            if (this.exitedTimer != null) {
                this.exitedTimer.stop();
            }
            if (this.animator != null) {
                this.animator.cancel();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (FlatTabbedPaneUI.this.tabPane.getMouseWheelListeners().length > 1) {
                return;
            }
            if (!this.isInViewport(mouseWheelEvent.getX(), mouseWheelEvent.getY())) {
                return;
            }
            this.lastMouseX = mouseWheelEvent.getX();
            this.lastMouseY = mouseWheelEvent.getY();
            double d = mouseWheelEvent.getPreciseWheelRotation();
            boolean bl = d != 0.0 && d != (double)mouseWheelEvent.getWheelRotation();
            int n = (int)((double)FlatTabbedPaneUI.this.maxTabHeight * d);
            if (n == 0) {
                if (d > 0.0) {
                    n = 1;
                } else if (d < 0.0) {
                    n = -1;
                }
            }
            Point point = this.targetViewPosition != null ? this.targetViewPosition : FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            Dimension dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
            boolean bl2 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n2 = point.x;
            int n3 = point.y;
            if (bl2) {
                n2 += FlatTabbedPaneUI.this.isLeftToRight() ? n : -n;
            } else {
                n3 += n;
            }
            if (bl && FlatTabbedPaneUI.this.getScrollButtonsPlacement() == 100 && FlatTabbedPaneUI.this.getScrollButtonsPolicy() == 3 && (FlatTabbedPaneUI.this.isLeftToRight() || !bl2) && FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize != null) {
                if (bl2) {
                    if (point.x == 0 && n2 > 0) {
                        n2 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width;
                    } else if (n < 0 && n2 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width) {
                        n2 = 0;
                    }
                } else if (point.y == 0 && n3 > 0) {
                    n3 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height;
                } else if (n < 0 && n3 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height) {
                    n3 = 0;
                }
            }
            if (bl2) {
                n2 = Math.min(Math.max(n2, 0), dimension.width - FlatTabbedPaneUI.this.tabViewport.getWidth());
            } else {
                n3 = Math.min(Math.max(n3, 0), dimension.height - FlatTabbedPaneUI.this.tabViewport.getHeight());
            }
            Point point2 = new Point(n2, n3);
            if (point2.equals(point)) {
                return;
            }
            if (bl) {
                if (this.animator != null) {
                    this.animator.stop();
                }
                FlatTabbedPaneUI.this.tabViewport.setViewPosition(point2);
                this.updateRolloverDelayed();
            } else {
                this.setViewPositionAnimated(point2);
            }
            this.scrolled = true;
        }

        protected void setViewPositionAnimated(Point point) {
            if (point.equals(FlatTabbedPaneUI.this.tabViewport.getViewPosition())) {
                return;
            }
            if (!FlatTabbedPaneUI.this.isSmoothScrollingEnabled()) {
                FlatTabbedPaneUI.this.tabViewport.setViewPosition(point);
                this.updateRolloverDelayed();
                return;
            }
            this.startViewPosition = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            this.targetViewPosition = point;
            if (this.animator == null) {
                int n = 200;
                int n2 = 10;
                this.animator = new Animator(n, f -> {
                    if (FlatTabbedPaneUI.this.tabViewport == null || !FlatTabbedPaneUI.this.tabViewport.isShowing()) {
                        this.animator.stop();
                        return;
                    }
                    int n = this.startViewPosition.x + Math.round((float)(this.targetViewPosition.x - this.startViewPosition.x) * f);
                    int n2 = this.startViewPosition.y + Math.round((float)(this.targetViewPosition.y - this.startViewPosition.y) * f);
                    FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(n, n2));
                }, () -> {
                    this.targetViewPosition = null;
                    this.startViewPosition = null;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.animator.setResolution(n2);
                this.animator.setInterpolator(new CubicBezierEasing(0.5f, 0.5f, 0.5f, 1.0f));
            }
            this.animator.restart();
        }

        protected void updateRolloverDelayed() {
            int n;
            FlatTabbedPaneUI.this.blockRollover = true;
            int n2 = FlatTabbedPaneUI.this.getRolloverTab();
            if (n2 >= 0 && (n = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, this.lastMouseX, this.lastMouseY)) >= 0 && n != n2) {
                FlatTabbedPaneUI.this.blockRollover = false;
                FlatTabbedPaneUI.this.setRolloverTab(-1);
                FlatTabbedPaneUI.this.blockRollover = true;
            }
            if (this.rolloverTimer == null) {
                this.rolloverTimer = new Timer(150, actionEvent -> {
                    FlatTabbedPaneUI.this.blockRollover = false;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.rolloverTimer.setRepeats(false);
            }
            this.rolloverTimer.restart();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FlatTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        protected boolean isInViewport(int n, int n2) {
            return FlatTabbedPaneUI.this.tabViewport != null && FlatTabbedPaneUI.this.tabViewport.getBounds().contains(n, n2);
        }

        protected void checkViewportExited(int n, int n2) {
            this.lastMouseX = n;
            this.lastMouseY = n2;
            boolean bl = this.inViewport;
            this.inViewport = this.isInViewport(n, n2);
            if (this.inViewport != bl) {
                if (!this.inViewport) {
                    this.viewportExited();
                } else if (this.exitedTimer != null) {
                    this.exitedTimer.stop();
                }
            }
        }

        protected void viewportExited() {
            if (!this.scrolled) {
                return;
            }
            if (this.exitedTimer == null) {
                this.exitedTimer = new Timer(500, actionEvent -> this.ensureSelectedTabVisible());
                this.exitedTimer.setRepeats(false);
            }
            this.exitedTimer.start();
        }

        protected void ensureSelectedTabVisible() {
            if (FlatTabbedPaneUI.this.tabPane == null || FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            if (!this.scrolled) {
                return;
            }
            this.scrolled = false;
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }
    }

    protected class FlatScrollableTabButton
    extends FlatTabAreaButton
    implements MouseListener {
        private Timer autoRepeatTimer;

        protected FlatScrollableTabButton(int n) {
            super(n);
            this.addMouseListener(this);
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> super.fireActionPerformed(actionEvent));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.isEnabled()) {
                if (this.autoRepeatTimer == null) {
                    this.autoRepeatTimer = new Timer(60, actionEvent -> {
                        if (this.isEnabled()) {
                            this.doClick();
                        }
                    });
                    this.autoRepeatTimer.setInitialDelay(300);
                }
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null && this.isPressed()) {
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }
    }

    protected class FlatMoreTabsButton
    extends FlatTabAreaButton
    implements ActionListener,
    PopupMenuListener {
        private boolean popupVisible;

        public FlatMoreTabsButton() {
            super(5);
            this.updateDirection();
            this.setToolTipText(FlatTabbedPaneUI.this.moreTabsButtonToolTipText);
            this.addActionListener(this);
        }

        protected void updateDirection() {
            int n;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n = 5;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 7;
                }
            }
            this.setDirection(n);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            boolean bl = this.direction == 5 || this.direction == 1;
            int n = UIScale.scale(8);
            return new Dimension(dimension.width + (bl ? n : 0), dimension.height + (bl ? 0 : n));
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.direction == 3 || this.direction == 7) {
                int n = Math.max(UIScale.unscale((this.getWidth() - this.getHeight()) / 2) - 4, 0);
                this.setXOffset(this.direction == 3 ? (float)n : (float)(-n));
            } else {
                this.setXOffset(0.0f);
            }
            super.paint(graphics);
        }

        @Override
        protected boolean isHover() {
            return super.isHover() || this.popupVisible;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.addPopupMenuListener(this);
            Rectangle rectangle = FlatTabbedPaneUI.this.tabViewport.getViewRect();
            int n2 = -1;
            for (n = 0; n < FlatTabbedPaneUI.this.rects.length; ++n) {
                if (rectangle.contains(FlatTabbedPaneUI.this.rects[n])) continue;
                if (n2 >= 0 && n2 + 1 != n) {
                    jPopupMenu.addSeparator();
                }
                n2 = n;
                jPopupMenu.add(this.createTabMenuItem(n));
            }
            n = this.getWidth();
            int n3 = this.getHeight();
            Dimension dimension = jPopupMenu.getPreferredSize();
            int n4 = FlatTabbedPaneUI.this.isLeftToRight() ? n - dimension.width : 0;
            int n5 = n3 - dimension.height;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n5 = n3;
                    break;
                }
                case 3: {
                    n5 = -dimension.height;
                    break;
                }
                case 2: {
                    n4 = n;
                    break;
                }
                case 4: {
                    n4 = -dimension.width;
                }
            }
            jPopupMenu.show(this, n4, n5);
        }

        protected JMenuItem createTabMenuItem(int n) {
            Color color;
            Component component;
            String string = FlatTabbedPaneUI.this.tabPane.getTitleAt(n);
            if (StringUtils.isEmpty(string)) {
                component = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(n);
                if (component != null) {
                    string = this.findTabTitle(component);
                }
                if (StringUtils.isEmpty(string)) {
                    string = FlatTabbedPaneUI.this.tabPane.getAccessibleContext().getAccessibleChild(n).getAccessibleContext().getAccessibleName();
                }
                if (StringUtils.isEmpty(string) && component instanceof Accessible) {
                    string = this.findTabTitleInAccessible((Accessible)((Object)component));
                }
                if (StringUtils.isEmpty(string)) {
                    string = n + 1 + ". Tab";
                }
            }
            component = new JMenuItem(string, FlatTabbedPaneUI.this.tabPane.getIconAt(n));
            ((AbstractButton)component).setDisabledIcon(FlatTabbedPaneUI.this.tabPane.getDisabledIconAt(n));
            ((JComponent)component).setToolTipText(FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(n));
            Color color2 = FlatTabbedPaneUI.this.tabPane.getForegroundAt(n);
            if (color2 != FlatTabbedPaneUI.this.tabPane.getForeground()) {
                ((JComponent)component).setForeground(color2);
            }
            if ((color = FlatTabbedPaneUI.this.tabPane.getBackgroundAt(n)) != FlatTabbedPaneUI.this.tabPane.getBackground()) {
                ((JComponent)component).setBackground(color);
                ((JComponent)component).setOpaque(true);
            }
            if (!FlatTabbedPaneUI.this.tabPane.isEnabled() || !FlatTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                ((JMenuItem)component).setEnabled(false);
            }
            ((AbstractButton)component).addActionListener(actionEvent -> this.selectTab(n));
            return component;
        }

        private String findTabTitle(Component component) {
            String string = null;
            if (component instanceof JLabel) {
                string = ((JLabel)component).getText();
            } else if (component instanceof JTextComponent) {
                string = ((JTextComponent)component).getText();
            }
            if (!StringUtils.isEmpty(string)) {
                return string;
            }
            if (component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    string = this.findTabTitle(component2);
                    if (string == null) continue;
                    return string;
                }
            }
            return null;
        }

        private String findTabTitleInAccessible(Accessible accessible) {
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext == null) {
                return null;
            }
            String string = accessibleContext.getAccessibleName();
            if (!StringUtils.isEmpty(string)) {
                return string;
            }
            int n = accessibleContext.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                string = this.findTabTitleInAccessible(accessibleContext.getAccessibleChild(i));
                if (string == null) continue;
                return string;
            }
            return null;
        }

        protected void selectTab(int n) {
            FlatTabbedPaneUI.this.tabPane.setSelectedIndex(n);
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = true;
            this.repaint();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            this.repaint();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            this.repaint();
        }
    }

    protected class FlatTabAreaButton
    extends FlatArrowButton {
        public FlatTabAreaButton(int n) {
            super(n, FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
            this.setArrowWidth(11);
        }

        protected void updateStyle() {
            this.updateStyle(FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
        }

        @Override
        protected Color deriveBackground(Color color) {
            return FlatUIUtils.deriveColor(color, FlatTabbedPaneUI.this.tabPane.getBackground());
        }

        @Override
        protected void paintBackground(Graphics2D graphics2D) {
            Insets insets = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(FlatTabbedPaneUI.this.buttonInsets, insets, FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n = UIScale.scale2(insets.top);
            int n2 = UIScale.scale2(insets.left);
            int n3 = UIScale.scale2(insets.bottom);
            int n4 = UIScale.scale2(insets.right);
            FlatUIUtils.paintComponentBackground(graphics2D, n2, n, this.getWidth() - n2 - n4, this.getHeight() - n - n3, 0.0f, UIScale.scale((float)FlatTabbedPaneUI.this.buttonArc));
        }
    }

    private class ContainerUIResource
    extends JPanel
    implements UIResource {
        private ContainerUIResource(Component component) {
            super(new BorderLayout());
            this.add(component);
        }

        @Override
        public void reshape(int n, int n2, int n3, int n4) {
            if (FlatTabbedPaneUI.this.inBasicLayoutContainer) {
                return;
            }
            super.reshape(n, n2, n3, n4);
        }
    }

    private static class TabCloseButton
    extends JButton
    implements UIResource {
        private TabCloseButton() {
        }
    }
}

