/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class FlatWindowResizer
implements ComponentListener,
PropertyChangeListener {
    protected static final Integer WINDOW_RESIZER_LAYER = JLayeredPane.DRAG_LAYER + 1;
    protected final JComponent resizeComp;
    protected final int borderDragThickness = FlatUIUtils.getUIInt("RootPane.borderDragThickness", 5);
    protected final int cornerDragWidth = FlatUIUtils.getUIInt("RootPane.cornerDragWidth", 16);
    protected final boolean honorFrameMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorFrameMinimumSizeOnResize");
    protected final boolean honorDialogMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorDialogMinimumSizeOnResize");
    protected final DragBorderComponent topDragComp;
    protected final DragBorderComponent bottomDragComp;
    protected final DragBorderComponent leftDragComp;
    protected final DragBorderComponent rightDragComp;

    protected FlatWindowResizer(JComponent jComponent) {
        this.resizeComp = jComponent;
        this.topDragComp = this.createDragBorderComponent(6, 8, 7);
        this.bottomDragComp = this.createDragBorderComponent(4, 9, 5);
        this.leftDragComp = this.createDragBorderComponent(6, 10, 4);
        this.rightDragComp = this.createDragBorderComponent(7, 11, 5);
        JComponent jComponent2 = jComponent instanceof JRootPane ? ((JRootPane)jComponent).getLayeredPane() : jComponent;
        Integer n = jComponent2 instanceof JLayeredPane ? WINDOW_RESIZER_LAYER : null;
        jComponent2.add(this.topDragComp, n, 0);
        jComponent2.add(this.bottomDragComp, n, 1);
        jComponent2.add(this.leftDragComp, n, 2);
        jComponent2.add(this.rightDragComp, n, 3);
        jComponent.addComponentListener(this);
        jComponent.addPropertyChangeListener("ancestor", this);
        if (jComponent.isDisplayable()) {
            this.addNotify();
        }
    }

    protected DragBorderComponent createDragBorderComponent(int n, int n2, int n3) {
        return new DragBorderComponent(n, n2, n3);
    }

    public void uninstall() {
        this.removeNotify();
        this.resizeComp.removeComponentListener(this);
        this.resizeComp.removePropertyChangeListener("ancestor", this);
        Container container = this.topDragComp.getParent();
        container.remove(this.topDragComp);
        container.remove(this.bottomDragComp);
        container.remove(this.leftDragComp);
        container.remove(this.rightDragComp);
    }

    public void doLayout() {
        if (!this.topDragComp.isVisible()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.resizeComp.getWidth();
        int n4 = this.resizeComp.getHeight();
        if (n3 == 0 || n4 == 0) {
            return;
        }
        Insets insets = this.getResizeInsets();
        int n5 = UIScale.scale(this.borderDragThickness);
        int n6 = Math.max(insets.top, n5);
        int n7 = Math.max(insets.bottom, n5);
        int n8 = Math.max(insets.left, n5);
        int n9 = Math.max(insets.right, n5);
        int n10 = n2 + n6;
        int n11 = n4 - n6 - n7;
        this.topDragComp.setBounds(n, n2, n3, n6);
        this.bottomDragComp.setBounds(n, n2 + n4 - n7, n3, n7);
        this.leftDragComp.setBounds(n, n10, n8, n11);
        this.rightDragComp.setBounds(n + n3 - n9, n10, n9, n11);
        int n12 = UIScale.scale(this.cornerDragWidth - this.borderDragThickness);
        this.topDragComp.setCornerDragWidths(n8 + n12, n9 + n12);
        this.bottomDragComp.setCornerDragWidths(n8 + n12, n9 + n12);
        this.leftDragComp.setCornerDragWidths(n12, n12);
        this.rightDragComp.setCornerDragWidths(n12, n12);
    }

    protected Insets getResizeInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected void addNotify() {
        this.updateVisibility();
    }

    protected void removeNotify() {
        this.updateVisibility();
    }

    protected void updateVisibility() {
        boolean bl = this.isWindowResizable();
        if (bl == this.topDragComp.isVisible()) {
            return;
        }
        this.topDragComp.setVisible(bl);
        this.bottomDragComp.setVisible(bl);
        this.leftDragComp.setVisible(bl);
        this.rightDragComp.setEnabled(bl);
        if (bl) {
            this.rightDragComp.setVisible(true);
            this.doLayout();
        } else {
            this.rightDragComp.setBounds(0, 0, 1, 1);
        }
    }

    boolean isDialog() {
        return false;
    }

    protected abstract boolean isWindowResizable();

    protected abstract Rectangle getWindowBounds();

    protected abstract void setWindowBounds(Rectangle var1);

    protected abstract boolean limitToParentBounds();

    protected abstract Rectangle getParentBounds();

    protected abstract boolean honorMinimumSizeOnResize();

    protected abstract boolean honorMaximumSizeOnResize();

    protected abstract Dimension getWindowMinimumSize();

    protected abstract Dimension getWindowMaximumSize();

    protected void beginResizing(int n) {
    }

    protected void endResizing() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "ancestor": {
                if (propertyChangeEvent.getNewValue() != null) {
                    this.addNotify();
                    break;
                }
                this.removeNotify();
                break;
            }
            case "resizable": {
                this.updateVisibility();
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.doLayout();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    protected class DragBorderComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private final int leadingResizeDir;
        private final int centerResizeDir;
        private final int trailingResizeDir;
        private int resizeDir = -1;
        private int leadingCornerDragWidth;
        private int trailingCornerDragWidth;
        private int dragLeftOffset;
        private int dragRightOffset;
        private int dragTopOffset;
        private int dragBottomOffset;

        protected DragBorderComponent(int n, int n2, int n3) {
            this.leadingResizeDir = n;
            this.centerResizeDir = n2;
            this.trailingResizeDir = n3;
            this.setResizeDir(n2);
            this.setVisible(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        void setCornerDragWidths(int n, int n2) {
            this.leadingCornerDragWidth = n;
            this.trailingCornerDragWidth = n2;
        }

        protected void setResizeDir(int n) {
            if (this.resizeDir == n) {
                return;
            }
            this.resizeDir = n;
            this.setCursor(Cursor.getPredefinedCursor(n));
        }

        @Override
        public Dimension getPreferredSize() {
            int n = UIScale.scale(FlatWindowResizer.this.borderDragThickness);
            return new Dimension(n, n);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintChildren(graphics);
            FlatWindowResizer.this.updateVisibility();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int n = mouseEvent.getXOnScreen();
            int n2 = mouseEvent.getYOnScreen();
            Rectangle rectangle = FlatWindowResizer.this.getWindowBounds();
            this.dragLeftOffset = n - rectangle.x;
            this.dragTopOffset = n2 - rectangle.y;
            this.dragRightOffset = rectangle.x + rectangle.width - n;
            this.dragBottomOffset = rectangle.y + rectangle.height - n2;
            int n3 = 0;
            switch (this.resizeDir) {
                case 8: {
                    n3 = 1;
                    break;
                }
                case 9: {
                    n3 = 5;
                    break;
                }
                case 10: {
                    n3 = 7;
                    break;
                }
                case 11: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 8;
                    break;
                }
                case 7: {
                    n3 = 2;
                    break;
                }
                case 4: {
                    n3 = 6;
                    break;
                }
                case 5: {
                    n3 = 4;
                }
            }
            FlatWindowResizer.this.beginResizing(n3);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            this.dragBottomOffset = 0;
            this.dragTopOffset = 0;
            this.dragRightOffset = 0;
            this.dragLeftOffset = 0;
            FlatWindowResizer.this.endResizing();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            boolean bl = this.centerResizeDir == 8 || this.centerResizeDir == 9;
            int n2 = bl ? mouseEvent.getX() : mouseEvent.getY();
            int n3 = n = bl ? this.getWidth() : this.getHeight();
            this.setResizeDir(n2 <= this.leadingCornerDragWidth ? this.leadingResizeDir : (n2 >= n - this.trailingCornerDragWidth ? this.trailingResizeDir : this.centerResizeDir));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Cloneable cloneable;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int n2 = mouseEvent.getXOnScreen();
            int n3 = mouseEvent.getYOnScreen();
            Rectangle rectangle = FlatWindowResizer.this.getWindowBounds();
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (this.resizeDir == 8 || this.resizeDir == 6 || this.resizeDir == 7) {
                rectangle2.y = n3 - this.dragTopOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    rectangle2.y = Math.max(rectangle2.y, FlatWindowResizer.this.getParentBounds().y);
                }
                rectangle2.height += rectangle.y - rectangle2.y;
            }
            if (this.resizeDir == 9 || this.resizeDir == 4 || this.resizeDir == 5) {
                rectangle2.height = n3 + this.dragBottomOffset - rectangle2.y;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    cloneable = FlatWindowResizer.this.getParentBounds();
                    n = cloneable.y + cloneable.height;
                    if (rectangle2.y + rectangle2.height > n) {
                        rectangle2.height = n - rectangle2.y;
                    }
                }
            }
            if (this.resizeDir == 10 || this.resizeDir == 6 || this.resizeDir == 4) {
                rectangle2.x = n2 - this.dragLeftOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    rectangle2.x = Math.max(rectangle2.x, FlatWindowResizer.this.getParentBounds().x);
                }
                rectangle2.width += rectangle.x - rectangle2.x;
            }
            if (this.resizeDir == 11 || this.resizeDir == 7 || this.resizeDir == 5) {
                rectangle2.width = n2 + this.dragRightOffset - rectangle2.x;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    cloneable = FlatWindowResizer.this.getParentBounds();
                    n = cloneable.x + cloneable.width;
                    if (rectangle2.x + rectangle2.width > n) {
                        rectangle2.width = n - rectangle2.x;
                    }
                }
            }
            Cloneable cloneable2 = cloneable = FlatWindowResizer.this.honorMinimumSizeOnResize() ? FlatWindowResizer.this.getWindowMinimumSize() : null;
            if (cloneable == null) {
                cloneable = UIScale.scale(new Dimension(150, 50));
            }
            if (rectangle2.width < ((Dimension)cloneable).width) {
                this.changeWidth(rectangle, rectangle2, ((Dimension)cloneable).width);
            }
            if (rectangle2.height < ((Dimension)cloneable).height) {
                this.changeHeight(rectangle, rectangle2, ((Dimension)cloneable).height);
            }
            if (FlatWindowResizer.this.honorMaximumSizeOnResize()) {
                Dimension dimension = FlatWindowResizer.this.getWindowMaximumSize();
                if (rectangle2.width > dimension.width) {
                    this.changeWidth(rectangle, rectangle2, dimension.width);
                }
                if (rectangle2.height > dimension.height) {
                    this.changeHeight(rectangle, rectangle2, dimension.height);
                }
            }
            if (!rectangle2.equals(rectangle)) {
                FlatWindowResizer.this.setWindowBounds(rectangle2);
            }
        }

        private void changeWidth(Rectangle rectangle, Rectangle rectangle2, int n) {
            if (rectangle2.x != rectangle.x) {
                rectangle2.x -= n - rectangle2.width;
            }
            rectangle2.width = n;
        }

        private void changeHeight(Rectangle rectangle, Rectangle rectangle2, int n) {
            if (rectangle2.y != rectangle.y) {
                rectangle2.y -= n - rectangle2.height;
            }
            rectangle2.height = n;
        }
    }

    public static class InternalFrameResizer
    extends FlatWindowResizer {
        protected final Supplier<DesktopManager> desktopManager;

        public InternalFrameResizer(JInternalFrame jInternalFrame, Supplier<DesktopManager> supplier) {
            super(jInternalFrame);
            this.desktopManager = supplier;
            jInternalFrame.addPropertyChangeListener("resizable", this);
        }

        @Override
        public void uninstall() {
            this.getFrame().removePropertyChangeListener("resizable", this);
            super.uninstall();
        }

        private JInternalFrame getFrame() {
            return (JInternalFrame)this.resizeComp;
        }

        @Override
        protected Insets getResizeInsets() {
            return this.getFrame().getInsets();
        }

        @Override
        protected boolean isWindowResizable() {
            return this.getFrame().isResizable();
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.getFrame().getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle rectangle) {
            this.desktopManager.get().resizeFrame(this.getFrame(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        protected boolean limitToParentBounds() {
            return true;
        }

        @Override
        protected Rectangle getParentBounds() {
            return new Rectangle(this.getFrame().getParent().getSize());
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return true;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return true;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.getFrame().getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.getFrame().getMaximumSize();
        }

        @Override
        protected void beginResizing(int n) {
            this.desktopManager.get().beginResizingFrame(this.getFrame(), n);
        }

        @Override
        protected void endResizing() {
            this.desktopManager.get().endResizingFrame(this.getFrame());
        }
    }

    public static class WindowResizer
    extends FlatWindowResizer
    implements WindowStateListener {
        protected Window window;
        private final boolean limitResizeToScreenBounds = SystemInfo.isLinux;

        public WindowResizer(JRootPane jRootPane) {
            super(jRootPane);
        }

        @Override
        protected void addNotify() {
            Container container = this.resizeComp.getParent();
            Window window = this.window = container instanceof Window ? (Window)container : null;
            if (this.window instanceof Frame) {
                this.window.addPropertyChangeListener("resizable", this);
                this.window.addWindowStateListener(this);
            }
            super.addNotify();
        }

        @Override
        protected void removeNotify() {
            if (this.window instanceof Frame) {
                this.window.removePropertyChangeListener("resizable", this);
                this.window.removeWindowStateListener(this);
            }
            this.window = null;
            super.removeNotify();
        }

        @Override
        protected boolean isWindowResizable() {
            if (FlatUIUtils.isFullScreen(this.resizeComp)) {
                return false;
            }
            if (this.window instanceof Frame) {
                return ((Frame)this.window).isResizable() && (((Frame)this.window).getExtendedState() & 6) == 0;
            }
            if (this.window instanceof Dialog) {
                return ((Dialog)this.window).isResizable();
            }
            return false;
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.window.getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle rectangle) {
            this.window.setBounds(rectangle);
            this.doLayout();
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                this.window.validate();
                this.resizeComp.repaint();
            }
        }

        @Override
        protected boolean limitToParentBounds() {
            return this.limitResizeToScreenBounds && this.window != null;
        }

        @Override
        protected Rectangle getParentBounds() {
            if (this.limitResizeToScreenBounds && this.window != null) {
                GraphicsConfiguration graphicsConfiguration = this.window.getGraphicsConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                Insets insets = this.window.getToolkit().getScreenInsets(graphicsConfiguration);
                return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
            }
            return null;
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return this.honorFrameMinimumSizeOnResize && this.window instanceof Frame || this.honorDialogMinimumSizeOnResize && this.window instanceof Dialog;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return false;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.window.getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.window.getMaximumSize();
        }

        @Override
        boolean isDialog() {
            return this.window instanceof Dialog;
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            this.updateVisibility();
        }
    }
}

