/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class JavaCompatibility2 {
    private static boolean getUIMethodInitialized;
    private static MethodHandle getUIMethod;

    public static ComponentUI getUI(JComponent jComponent) {
        try {
            Object object;
            if (SystemInfo.isJava_9_orLater) {
                if (!getUIMethodInitialized) {
                    getUIMethodInitialized = true;
                    try {
                        object = MethodType.methodType(ComponentUI.class, new Class[0]);
                        getUIMethod = MethodHandles.publicLookup().findVirtual(JComponent.class, "getUI", (MethodType)object);
                    }
                    catch (Exception exception) {
                        LoggingFacade.INSTANCE.logSevere(null, exception);
                    }
                }
                if (getUIMethod != null) {
                    return getUIMethod.invoke(jComponent);
                }
            }
            if (jComponent instanceof JPanel) {
                return ((JPanel)jComponent).getUI();
            }
            if (jComponent instanceof JList) {
                return ((JList)jComponent).getUI();
            }
            if (jComponent instanceof JTable) {
                return ((JTable)jComponent).getUI();
            }
            if (jComponent instanceof JTree) {
                return ((JTree)jComponent).getUI();
            }
            if (jComponent instanceof JTextComponent) {
                return ((JTextComponent)jComponent).getUI();
            }
            object = jComponent.getClass().getMethod("getUI", new Class[0]);
            return (ComponentUI)((Method)object).invoke((Object)jComponent, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static File[] getChooserShortcutPanelFiles(FileSystemView fileSystemView) {
        try {
            if (SystemInfo.isJava_12_orLater) {
                Method method = fileSystemView.getClass().getMethod("getChooserShortcutPanelFiles", new Class[0]);
                File[] fileArray = (File[])method.invoke((Object)fileSystemView, new Object[0]);
                if (fileArray.length == 1 && fileArray[0].equals(new File(System.getProperty("user.home")))) {
                    fileArray = new File[]{};
                }
                return fileArray;
            }
            if (SystemInfo.isWindows) {
                Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
                Method method = clazz.getMethod("get", String.class);
                return (File[])method.invoke(null, "fileChooserShortcutPanelFolders");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
        }
        return new File[0];
    }

    public static File[] getChooserComboBoxFiles(FileSystemView fileSystemView) {
        try {
            if (SystemInfo.isJava_9_orLater) {
                Method method = fileSystemView.getClass().getMethod("getChooserComboBoxFiles", new Class[0]);
                return (File[])method.invoke((Object)fileSystemView, new Object[0]);
            }
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            Method method = clazz.getMethod("get", String.class);
            return (File[])method.invoke(null, "fileChooserComboBoxFolders");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
        }
        return new File[0];
    }
}

