/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.function.Function;
import javax.swing.JComponent;

public class MigLayoutVisualPadding {
    public static String VISUAL_PADDING_PROPERTY = "visualPadding";
    private static final FlatMigInsets ZERO = new FlatMigInsets(0, 0, 0, 0);
    private static final boolean migLayoutAvailable;

    public static void install(JComponent jComponent, Insets insets) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(jComponent, insets);
    }

    public static void install(JComponent jComponent2) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.install(jComponent2, jComponent -> {
            FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
            if (flatBorder != null) {
                int n = flatBorder.getFocusWidth((Component)jComponent);
                return new Insets(n, n, n, n);
            }
            return null;
        }, "border", "FlatLaf.style", "FlatLaf.styleClass");
    }

    public static void install(JComponent jComponent, Function<JComponent, Insets> function, String ... stringArray) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(jComponent, function.apply(jComponent));
        jComponent.addPropertyChangeListener(propertyChangeEvent -> {
            String string = propertyChangeEvent.getPropertyName();
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                MigLayoutVisualPadding.setVisualPadding(jComponent, (Insets)function.apply(jComponent));
                break;
            }
        });
    }

    private static void setVisualPadding(JComponent jComponent, Insets insets) {
        Object object = jComponent.getClientProperty(VISUAL_PADDING_PROPERTY);
        if (object == null || object instanceof FlatMigInsets) {
            FlatMigInsets flatMigInsets = insets != null ? new FlatMigInsets(UIScale.scale2(insets.top), UIScale.scale2(insets.left), UIScale.scale2(insets.bottom), UIScale.scale2(insets.right)) : ZERO;
            jComponent.putClientProperty(VISUAL_PADDING_PROPERTY, flatMigInsets);
        }
    }

    public static void uninstall(JComponent jComponent) {
        if (!migLayoutAvailable) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener : jComponent.getPropertyChangeListeners()) {
            if (!(propertyChangeListener instanceof FlatMigListener)) continue;
            jComponent.removePropertyChangeListener(propertyChangeListener);
            break;
        }
        if (jComponent.getClientProperty(VISUAL_PADDING_PROPERTY) instanceof FlatMigInsets) {
            jComponent.putClientProperty(VISUAL_PADDING_PROPERTY, null);
        }
    }

    static {
        boolean bl = false;
        try {
            Class.forName("net.miginfocom.swing.MigLayout");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        migLayoutAvailable = bl;
    }

    private static interface FlatMigListener
    extends PropertyChangeListener {
    }

    private static class FlatMigInsets
    extends Insets {
        FlatMigInsets(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }
    }
}

