/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScaledImageIcon
implements Icon {
    private final ImageIcon imageIcon;
    private final int iconWidth;
    private final int iconHeight;
    private double lastSystemScaleFactor;
    private float lastUserScaleFactor;
    private Image lastImage;

    public ScaledImageIcon(ImageIcon imageIcon) {
        this(imageIcon, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n, int n2) {
        this.imageIcon = imageIcon;
        this.iconWidth = n;
        this.iconHeight = n2;
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconWidth);
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconHeight);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        float f;
        double d = UIScale.getSystemScaleFactor((Graphics2D)graphics);
        double d2 = d * (double)(f = UIScale.getUserScaleFactor());
        if (d2 == 1.0 && this.imageIcon != null && this.iconWidth == this.imageIcon.getIconWidth() && this.iconHeight == this.imageIcon.getIconHeight()) {
            this.imageIcon.paintIcon(component, graphics, n, n2);
            return;
        }
        if (d == this.lastSystemScaleFactor && f == this.lastUserScaleFactor && this.lastImage != null) {
            this.paintLastImage(graphics, n, n2);
            return;
        }
        int n3 = (int)Math.round((double)this.iconWidth * d2);
        int n4 = (int)Math.round((double)this.iconHeight * d2);
        Image image = this.getResolutionVariant(n3, n4);
        int n5 = -1;
        int n6 = -1;
        if (image != null) {
            n5 = image.getWidth(null);
            n6 = image.getHeight(null);
        }
        if (n5 < 0 || n6 < 0) {
            graphics.setColor(Color.red);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            return;
        }
        if (n5 != n3 || n6 != n4) {
            Object object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            float f2 = (float)n3 / (float)n5;
            if ((float)((int)f2) == f2 && f2 > 1.0f && n5 <= 16 && n6 <= 16) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            BufferedImage bufferedImage = this.image2bufferedImage(image);
            image = this.scaleImage(bufferedImage, n3, n4, object);
        }
        this.lastSystemScaleFactor = d;
        this.lastUserScaleFactor = f;
        this.lastImage = image;
        this.paintLastImage(graphics, n, n2);
    }

    protected Image getResolutionVariant(int n, int n2) {
        return MultiResolutionImageSupport.getResolutionVariant(this.imageIcon.getImage(), n, n2);
    }

    private void paintLastImage(Graphics graphics, int n5, int n6) {
        if (this.lastSystemScaleFactor > 1.0) {
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n5, n6, 100, 100, (graphics2D, n, n2, n3, n4, d) -> graphics2D.drawImage(this.lastImage, n, n2, null));
        } else {
            graphics.drawImage(this.lastImage, n5, n6, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2, Object object) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage image2bufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

