/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;

public final class EpollDatagramChannelConfig
extends EpollChannelConfig
implements DatagramChannelConfig {
    private boolean activeOnOpen;
    private volatile int maxDatagramSize;
    private volatile boolean gro;

    EpollDatagramChannelConfig(EpollDatagramChannel epollDatagramChannel) {
        super((Channel)epollDatagramChannel, (RecvByteBufAllocator)new FixedRecvByteBufAllocator(2048));
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.SO_BROADCAST, ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.SO_REUSEADDR, ChannelOption.IP_MULTICAST_LOOP_DISABLED, ChannelOption.IP_MULTICAST_ADDR, ChannelOption.IP_MULTICAST_IF, ChannelOption.IP_MULTICAST_TTL, ChannelOption.IP_TOS, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, EpollChannelOption.SO_REUSEPORT, EpollChannelOption.IP_FREEBIND, EpollChannelOption.IP_TRANSPARENT, EpollChannelOption.IP_RECVORIGDSTADDR, EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE, EpollChannelOption.UDP_GRO});
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_BROADCAST) {
            return (T)Boolean.valueOf(this.isBroadcast());
        }
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
            return (T)Boolean.valueOf(this.isLoopbackModeDisabled());
        }
        if (channelOption == ChannelOption.IP_MULTICAST_ADDR) {
            return (T)this.getInterface();
        }
        if (channelOption == ChannelOption.IP_MULTICAST_IF) {
            return (T)this.getNetworkInterface();
        }
        if (channelOption == ChannelOption.IP_MULTICAST_TTL) {
            return (T)Integer.valueOf(this.getTimeToLive());
        }
        if (channelOption == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (channelOption == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            return (T)Boolean.valueOf(this.activeOnOpen);
        }
        if (channelOption == EpollChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (channelOption == EpollChannelOption.IP_FREEBIND) {
            return (T)Boolean.valueOf(this.isFreeBind());
        }
        if (channelOption == EpollChannelOption.IP_RECVORIGDSTADDR) {
            return (T)Boolean.valueOf(this.isIpRecvOrigDestAddr());
        }
        if (channelOption == EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE) {
            return (T)Integer.valueOf(this.getMaxDatagramPayloadSize());
        }
        if (channelOption == EpollChannelOption.UDP_GRO) {
            return (T)Boolean.valueOf(this.isUdpGro());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
        this.validate(channelOption, t);
        if (channelOption == ChannelOption.SO_BROADCAST) {
            this.setBroadcast((Boolean)t);
        } else if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t);
        } else if (channelOption == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t);
        } else if (channelOption == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
            this.setLoopbackModeDisabled((Boolean)t);
        } else if (channelOption == ChannelOption.IP_MULTICAST_ADDR) {
            this.setInterface((InetAddress)t);
        } else if (channelOption == ChannelOption.IP_MULTICAST_IF) {
            this.setNetworkInterface((NetworkInterface)t);
        } else if (channelOption == ChannelOption.IP_MULTICAST_TTL) {
            this.setTimeToLive((Integer)t);
        } else if (channelOption == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)t);
        } else if (channelOption == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            this.setActiveOnOpen((Boolean)t);
        } else if (channelOption == EpollChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)t);
        } else if (channelOption == EpollChannelOption.IP_FREEBIND) {
            this.setFreeBind((Boolean)t);
        } else if (channelOption == EpollChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)t);
        } else if (channelOption == EpollChannelOption.IP_RECVORIGDSTADDR) {
            this.setIpRecvOrigDestAddr((Boolean)t);
        } else if (channelOption == EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE) {
            this.setMaxDatagramPayloadSize((Integer)t);
        } else if (channelOption == EpollChannelOption.UDP_GRO) {
            this.setUdpGro((Boolean)t);
        } else {
            return super.setOption(channelOption, t);
        }
        return true;
    }

    private void setActiveOnOpen(boolean bl) {
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = bl;
    }

    boolean getActiveOnOpen() {
        return this.activeOnOpen;
    }

    @Override
    public EpollDatagramChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    @Deprecated
    public EpollDatagramChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    @Override
    @Deprecated
    public EpollDatagramChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public EpollDatagramChannelConfig setAutoClose(boolean bl) {
        super.setAutoClose(bl);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EpollDatagramChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Override
    @Deprecated
    public EpollDatagramChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    public int getSendBufferSize() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setSendBufferSize(int n) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setSendBufferSize(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setReceiveBufferSize(int n) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setReceiveBufferSize(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public int getTrafficClass() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getTrafficClass();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setTrafficClass(int n) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setTrafficClass(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isReuseAddress() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setReuseAddress(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setReuseAddress(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isBroadcast() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isBroadcast();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setBroadcast(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setBroadcast(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isLoopbackModeDisabled() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isLoopbackModeDisabled();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public DatagramChannelConfig setLoopbackModeDisabled(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setLoopbackModeDisabled(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public int getTimeToLive() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getTimeToLive();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setTimeToLive(int n) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setTimeToLive(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public InetAddress getInterface() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getInterface();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setInterface(InetAddress inetAddress) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setInterface(inetAddress);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public NetworkInterface getNetworkInterface() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.getNetworkInterface();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setNetworkInterface(NetworkInterface networkInterface) {
        try {
            EpollDatagramChannel epollDatagramChannel = (EpollDatagramChannel)this.channel;
            epollDatagramChannel.socket.setNetworkInterface(networkInterface);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    @Override
    public EpollDatagramChannelConfig setEpollMode(EpollMode epollMode) {
        super.setEpollMode(epollMode);
        return this;
    }

    public boolean isReusePort() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isReusePort();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setReusePort(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setReusePort(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setIpTransparent(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setIpTransparent(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isFreeBind() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isIpFreeBind();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setFreeBind(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setIpFreeBind(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isIpRecvOrigDestAddr() {
        try {
            return ((EpollDatagramChannel)this.channel).socket.isIpRecvOrigDestAddr();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setIpRecvOrigDestAddr(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setIpRecvOrigDestAddr(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public EpollDatagramChannelConfig setMaxDatagramPayloadSize(int n) {
        this.maxDatagramSize = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxDatagramSize");
        return this;
    }

    public int getMaxDatagramPayloadSize() {
        return this.maxDatagramSize;
    }

    public EpollDatagramChannelConfig setUdpGro(boolean bl) {
        try {
            ((EpollDatagramChannel)this.channel).socket.setUdpGro(bl);
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
        this.gro = bl;
        return this;
    }

    public boolean isUdpGro() {
        return this.gro;
    }

    public EpollDatagramChannelConfig setMaxMessagesPerWrite(int n) {
        super.setMaxMessagesPerWrite(n);
        return this;
    }
}

