/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollDomainDatagramChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainDatagramPacket;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class EpollDomainDatagramChannel
extends AbstractEpollChannel
implements DomainDatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final EpollDomainDatagramChannelConfig config = new EpollDomainDatagramChannelConfig(this);

    public EpollDomainDatagramChannel() {
        this(LinuxSocket.newSocketDomainDgram(), false);
    }

    public EpollDomainDatagramChannel(int n) {
        this(new LinuxSocket(n), true);
    }

    private EpollDomainDatagramChannel(LinuxSocket linuxSocket, boolean bl) {
        super(null, linuxSocket, bl);
    }

    @Override
    public EpollDomainDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        super.doBind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
        this.active = true;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.active = false;
        this.connected = false;
        this.local = null;
        this.remote = null;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            if (socketAddress2 != null) {
                this.local = (DomainSocketAddress)socketAddress2;
            }
            this.remote = (DomainSocketAddress)socketAddress;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        int n = this.maxMessagesPerWrite();
        while (n > 0 && (object = channelOutboundBuffer.current()) != null) {
            try {
                boolean bl = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    if (!this.doWriteMessage(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                channelOutboundBuffer.remove();
                --n;
            }
            catch (IOException iOException) {
                --n;
                channelOutboundBuffer.remove((Throwable)iOException);
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    private boolean doWriteMessage(Object object) {
        long l;
        DomainSocketAddress domainSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)addressedEnvelope.content();
            domainSocketAddress = (DomainSocketAddress)addressedEnvelope.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            domainSocketAddress = null;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return true;
        }
        if (byteBuf.hasMemoryAddress()) {
            long l2 = byteBuf.memoryAddress();
            l = domainSocketAddress == null ? (long)this.socket.sendAddress(l2, byteBuf.readerIndex(), byteBuf.writerIndex()) : (long)this.socket.sendToAddressDomainSocket(l2, byteBuf.readerIndex(), byteBuf.writerIndex(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else if (byteBuf.nioBufferCount() > 1) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
            iovArray.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
            int n2 = iovArray.count();
            assert (n2 != 0);
            l = domainSocketAddress == null ? this.socket.writevAddresses(iovArray.memoryAddress(0), n2) : (long)this.socket.sendToAddressesDomainSocket(iovArray.memoryAddress(0), n2, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes());
            l = domainSocketAddress == null ? (long)this.socket.send(byteBuffer, byteBuffer.position(), byteBuffer.limit()) : (long)this.socket.sendToDomainSocket(byteBuffer, byteBuffer.position(), byteBuffer.limit(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        }
        return l > 0L;
    }

    protected Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DomainDatagramPacket) {
            DomainDatagramPacket domainDatagramPacket = (DomainDatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)domainDatagramPacket.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DomainDatagramPacket(this.newDirectBuffer(domainDatagramPacket, byteBuf), (DomainSocketAddress)domainDatagramPacket.recipient()) : object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof DomainSocketAddress)) {
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DefaultAddressedEnvelope((Object)this.newDirectBuffer(addressedEnvelope, byteBuf), (SocketAddress)((DomainSocketAddress)addressedEnvelope.recipient())) : addressedEnvelope;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainDatagramChannelUnsafe();
    }

    public PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class EpollDomainDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollDomainDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (EpollDomainDatagramChannel.this.eventLoop().inEventLoop());
            EpollDomainDatagramChannelConfig epollDomainDatagramChannelConfig = EpollDomainDatagramChannel.this.config();
            if (EpollDomainDatagramChannel.this.shouldBreakEpollInReady((ChannelConfig)epollDomainDatagramChannelConfig)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(EpollDomainDatagramChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = EpollDomainDatagramChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = epollDomainDatagramChannelConfig.getAllocator();
            epollRecvByteAllocatorHandle.reset((ChannelConfig)epollDomainDatagramChannelConfig);
            this.epollInBefore();
            Throwable throwable = null;
            try {
                ByteBuf byteBuf = null;
                try {
                    boolean bl = EpollDomainDatagramChannel.this.isConnected();
                    do {
                        DomainDatagramPacket domainDatagramPacket;
                        byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                        epollRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                        if (bl) {
                            epollRecvByteAllocatorHandle.lastBytesRead(EpollDomainDatagramChannel.this.doReadBytes(byteBuf));
                            if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                                byteBuf.release();
                                break;
                            }
                            domainDatagramPacket = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                        } else {
                            ByteBuffer byteBuffer;
                            DomainDatagramSocketAddress domainDatagramSocketAddress;
                            if (byteBuf.hasMemoryAddress()) {
                                domainDatagramSocketAddress = EpollDomainDatagramChannel.this.socket.recvFromAddressDomainSocket(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                            } else {
                                byteBuffer = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                                domainDatagramSocketAddress = EpollDomainDatagramChannel.this.socket.recvFromDomainSocket(byteBuffer, byteBuffer.position(), byteBuffer.limit());
                            }
                            if (domainDatagramSocketAddress == null) {
                                epollRecvByteAllocatorHandle.lastBytesRead(-1);
                                byteBuf.release();
                                break;
                            }
                            byteBuffer = domainDatagramSocketAddress.localAddress();
                            if (byteBuffer == null) {
                                byteBuffer = (DomainSocketAddress)this.localAddress();
                            }
                            epollRecvByteAllocatorHandle.lastBytesRead(domainDatagramSocketAddress.receivedAmount());
                            byteBuf.writerIndex(byteBuf.writerIndex() + epollRecvByteAllocatorHandle.lastBytesRead());
                            domainDatagramPacket = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)byteBuffer, (DomainSocketAddress)domainDatagramSocketAddress);
                        }
                        epollRecvByteAllocatorHandle.incMessagesRead(1);
                        this.readPending = false;
                        channelPipeline.fireChannelRead((Object)domainDatagramPacket);
                        byteBuf = null;
                    } while (epollRecvByteAllocatorHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                }
                catch (Throwable throwable2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throwable = throwable2;
                }
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
            }
            finally {
                this.epollInFinally((ChannelConfig)epollDomainDatagramChannelConfig);
            }
        }
    }
}

