/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.openblas.presets;

import java.util.List;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.FunctionPointer;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(inherit={javacpp.class}, global="org.bytedeco.openblas.global.openblas_nolapack", value={@Platform(define={"__OPENBLAS 1", "LAPACK_COMPLEX_CPP"}, include={"openblas_config.h", "cblas.h"}, link={"openblas_nolapack@.0"}, resource={"include", "lib"}, preload={"gcc_s@.1.1", "gcc_s@.1", "quadmath@.0", "gfortran@.5", "gfortran@.4", "gfortran@.3", "openblas@.0#openblas_nolapack@.0"}, preloadpath={"/opt/intel/oneapi/mkl/latest/lib/", "/opt/intel/oneapi/compiler/latest/mac/compiler/lib/"}), @Platform(value={"android"}, link={"openblas"}, preload={""}), @Platform(value={"macosx"}, preloadpath={"/usr/local/lib/gcc/13/", "/usr/local/lib/gcc/12/", "/usr/local/lib/gcc/11/", "/usr/local/lib/gcc/10/", "/usr/local/lib/gcc/9/", "/usr/local/lib/gcc/8/", "/usr/local/lib/gcc/7/", "/usr/local/lib/gcc/6/", "/usr/local/lib/gcc/5/"}), @Platform(value={"windows"}, preload={"libopenblas#libopenblas_nolapack"}), @Platform(value={"windows-x86"}, preloadpath={"C:/Program Files (x86)/Intel/oneAPI/mkl/latest/redist/ia32/", "C:/Program Files (x86)/Intel/oneAPI/compiler/latest/windows/redist/ia32_win/compiler/"}), @Platform(value={"windows-x86_64"}, preloadpath={"C:/Program Files (x86)/Intel/oneAPI/mkl/latest/redist/intel64/", "C:/Program Files (x86)/Intel/oneAPI/compiler/latest/windows/redist/intel64_win/compiler/"}), @Platform(value={"linux"}, preloadpath={"/usr/lib/", "/usr/lib32/", "/usr/lib64/"}), @Platform(value={"linux-armhf"}, preloadpath={"/usr/arm-linux-gnueabihf/lib/", "/usr/lib/arm-linux-gnueabihf/"}), @Platform(value={"linux-arm64"}, preloadpath={"/usr/aarch64-linux-gnu/lib/", "/usr/lib/aarch64-linux-gnu/"}), @Platform(value={"linux-x86"}, preloadpath={"/lib32/", "/lib/", "/usr/lib32/", "/usr/lib/", "/opt/intel/oneapi/mkl/latest/lib/ia32/", "/opt/intel/oneapi/compiler/latest/linux/compiler/lib/ia32_lin/"}), @Platform(value={"linux-x86_64"}, preloadpath={"/lib64/", "/lib/", "/usr/lib64/", "/usr/lib/", "/opt/intel/oneapi/mkl/latest/lib/intel64/", "/opt/intel/oneapi/compiler/latest/linux/compiler/lib/intel64_lin/"}), @Platform(value={"linux-ppc64"}, preloadpath={"/usr/powerpc64-linux-gnu/lib/", "/usr/powerpc64le-linux-gnu/lib/", "/usr/lib/powerpc64-linux-gnu/", "/usr/lib/powerpc64le-linux-gnu/"}), @Platform(value={"ios"}, preload={"libopenblas"})})
@NoException
public class openblas_nolapack
implements LoadEnabled,
InfoMapper {
    static int maxThreads;
    static int vendor;

    public void init(ClassProperties classProperties) {
        String string = classProperties.getProperty("platform");
        List list = classProperties.get("platform.preload");
        List list2 = classProperties.get("platform.preloadresource");
        String string2 = this.getClass().getSimpleName();
        if (!Loader.isLoadLibraries() || this.getClass() != classProperties.getEffectiveClasses().get(0)) {
            return;
        }
        String string3 = System.getProperty("org.bytedeco." + string2 + ".load", "").toLowerCase();
        if (string3.length() == 0) {
            string3 = System.getProperty("org.bytedeco.openblas.load", "").toLowerCase();
        }
        int n = 0;
        if (string.startsWith("linux-x86") || string.startsWith("macosx-x86") || string.startsWith("windows-x86")) {
            if (string3.equals("mklml") || string3.equals("mklml_intel")) {
                String[] stringArray = new String[]{"iomp5", "libiomp5md", "msvcr120", "mklml_intel", "mklml"};
                for (n = 0; n < stringArray.length; ++n) {
                    list.add(n, stringArray[n] + "#" + stringArray[n]);
                }
                string3 = string.startsWith("linux") ? "mklml_intel" : "mklml";
                list2.add("/org/bytedeco/mkldnn/");
            } else if (string3.equals("mkl") || string3.equals("mkl_rt")) {
                String[] stringArray = new String[]{"iomp5", "libiomp5md", "mkl_core@.2", "mkl_avx@.2", "mkl_avx2@.2", "mkl_avx512@.2", "mkl_avx512_mic@.2", "mkl_def@.2", "mkl_mc@.2", "mkl_mc3@.2", "mkl_intel_lp64@.2", "mkl_intel_thread@.2", "mkl_gnu_thread@.2", "mkl_rt@.2"};
                for (n = 0; n < stringArray.length; ++n) {
                    list.add(n, stringArray[n] + "#" + stringArray[n]);
                }
                string3 = "mkl_rt@.2";
                list2.add("/org/bytedeco/mkl/");
            }
        }
        if (string3.length() > 0) {
            if (string.startsWith("linux")) {
                list.add(n, string3 + "#" + string2 + "@.0");
            } else if (string.startsWith("macosx")) {
                list.add(n, string3 + "#" + string2 + ".0");
            } else if (string.startsWith("windows")) {
                list.add(n, string3 + "#lib" + string2);
            }
        }
    }

    public void map(InfoMap infoMap) {
        String[] stringArray;
        infoMap.put(new Info(new String[]{"lapack.h", "lapacke.h"}).linePatterns(new String[]{".*LAPACK_GLOBAL.*"}).skip()).put(new Info(new String[]{"OPENBLAS_PTHREAD_CREATE_FUNC", "OPENBLAS_BUNDERSCORE", "OPENBLAS_FUNDERSCORE", "DOUBLE_DEFINED", "xdouble", "FLOATRET", "OPENBLAS_CONST", "CBLAS_INDEX", "LAPACK_IFMT", "FORTRAN_STRLEN", "lapack_int", "lapack_logical"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"OPENBLAS_QUAD_PRECISION", "defined OPENBLAS_EXPRECISION", "OPENBLAS_USE64BITINT", "defined(LAPACK_COMPLEX_STRUCTURE)", "defined(LAPACK_COMPLEX_C99)", "OPENBLAS_OS_LINUX"}).define(false).translate(true)).put(new Info(new String[]{"((defined(__STDC_IEC_559_COMPLEX__) || __STDC_VERSION__ >= 199901L ||      (__GNUC__ >= 3 && !defined(__cplusplus))) && !(defined(FORCE_OPENBLAS_COMPLEX_STRUCT))) && !defined(_MSC_VER)", "defined(LAPACK_COMPLEX_CPP)", "LAPACK_COMPLEX_CUSTOM", "LAPACK_FORTRAN_STRLEN_END"}).define()).put(new Info(new String[]{"openblas_complex_float", "lapack_complex_float"}).cast().pointerTypes(new String[]{"FloatPointer", "FloatBuffer", "float[]"})).put(new Info(new String[]{"openblas_complex_double", "lapack_complex_double"}).cast().pointerTypes(new String[]{"DoublePointer", "DoubleBuffer", "double[]"}));
        for (String string : stringArray = new String[]{"cblas_caxpby", "cblas_daxpby", "cblas_saxpby", "cblas_zaxpby", "cblas_caxpyc", "cblas_zaxpyc", "cblas_sgemmt", "cblas_dgemmt", "cblas_cgemmt", "cblas_zgemmt", "cblas_cgemm_batch", "cblas_dgemm_batch", "cblas_sgemm_batch", "cblas_zgemm_batch", "cblas_samax", "cblas_damax", "cblas_scamax", "cblas_dzamax", "cblas_samin", "cblas_damin", "cblas_scamin", "cblas_dzamin", "cblas_cgemm3m", "cblas_zgemm3m", "cblas_xerbla", "cblas_icamin", "cblas_idamin", "cblas_isamin", "cblas_izamin", "cblas_ssum", "cblas_dsum", "cblas_scsum", "cblas_dzsum", "cblas_ismax", "cblas_idmax", "cblas_icmax", "cblas_izmax", "cblas_ismin", "cblas_idmin", "cblas_icmin", "cblas_izmin", "cblas_csrot", "cblas_zdrot", "cblas_crotg", "cblas_zrotg", "openblas_set_num_threads", "goto_set_num_threads", "openblas_set_num_threads_local", "openblas_get_num_threads", "openblas_get_num_procs", "openblas_get_config", "openblas_get_corename", "openblas_get_parallel", "openblas_set_threads_callback_function", "cblas_cdotc", "cblas_cdotu", "cblas_cimatcopy", "cblas_comatcopy", "cblas_dimatcopy", "cblas_domatcopy", "cblas_cgeadd", "cblas_dgeadd", "cblas_sgeadd", "cblas_simatcopy", "cblas_somatcopy", "cblas_zdotc", "cblas_zdotu", "cblas_zgeadd", "cblas_zimatcopy", "cblas_zomatcopy", "clacrm", "dlacrm", "slacrm", "zlacrm", "clarcm", "dlarcm", "slarcm", "zlarcm", "classq", "dlassq", "slassq", "zlassq", "cgesvdq", "dgesvdq", "sgesvdq", "zgesvdq", "lapack_make_complex_double", "lapack_make_complex_float", "cgetsqrhrt", "dgetsqrhrt", "sgetsqrhrt", "zgetsqrhrt", "dorgtsqr_row", "sorgtsqr_row", "cungtsqr_row", "zungtsqr_row", "clangb", "dlangb", "slangb", "zlangb", "ctrsyl3", "dtrsyl3", "strsyl3", "ztrsyl3", "ctz_trans", "dtz_trans", "stz_trans", "ztz_trans", "ctz_nancheck", "dtz_nancheck", "stz_nancheck", "ztz_nancheck", "sgedmd", "dgedmd", "cgedmd", "zgedmd", "sgedmdq", "dgedmdq", "cgedmdq", "zgedmdq", "sorhr_col", "dorhr_col", "cunhr_col", "zunhr_col", "cgegs", "cggsvd", "ctzrqf", "dgeqpf", "dlatzm", "sgelsx", "slahrd", "zgegv", "zggsvp", "cgegv", "cggsvp", "dgegs", "dggsvd", "dtzrqf", "sgeqpf", "slatzm", "zgelsx", "zlahrd", "cgelsx", "clahrd", "dgegv", "dggsvp", "sgegs", "sggsvd", "stzrqf", "zgeqpf", "zlatzm", "cgeqpf", "clatzm", "dgelsx", "dlahrd", "sgegv", "sggsvp", "zgegs", "zggsvd", "ztzrqf", "cblas_sbstobf16", "cblas_sbdtobf16", "cblas_sbf16tos", "cblas_dbf16tod", "cblas_sbdot", "cblas_sbgemv", "cblas_sbgemm", "cblas_sbgemm_batch", "cgbrfsx", "cporfsx", "dgerfsx", "sgbrfsx", "ssyrfsx", "zherfsx", "cgerfsx", "csyrfsx", "dporfsx", "sgerfsx", "zgbrfsx", "zporfsx", "cherfsx", "dgbrfsx", "dsyrfsx", "sporfsx", "zgerfsx", "zsyrfsx", "cgbsvxx", "cposvxx", "dgesvxx", "sgbsvxx", "ssysvxx", "zhesvxx", "cgesvxx", "csysvxx", "dposvxx", "sgesvxx", "zgbsvxx", "zposvxx", "chesvxx", "dgbsvxx", "dsysvxx", "sposvxx", "zgesvxx", "zsysvxx"}) {
            infoMap.put(new Info(new String[]{string, "LAPACK_" + string, "LAPACK_" + string + "_base", "LAPACKE_" + string, "LAPACKE_" + string + "_work"}).skip());
        }
    }

    public static void blas_set_num_threads(int n) {
        Loader.load(openblas_nolapack.class);
        Pointer pointer = Loader.addressof((String)"MKL_Set_Num_Threads");
        Pointer pointer2 = Loader.addressof((String)"MKL_Set_Num_Threads_Local");
        Pointer pointer3 = Loader.addressof((String)"MKL_Domain_Set_Num_Threads");
        Pointer pointer4 = Loader.addressof((String)"openblas_set_num_threads");
        vendor = 0;
        if (pointer != null) {
            new SetNumThreads().put(pointer).call(n);
            vendor = 3;
        }
        if (pointer2 != null) {
            new MklSetNumThreadsLocal().put(pointer2).call(n);
            vendor = 3;
        }
        if (pointer3 != null) {
            MklDomainSetNumThreads mklDomainSetNumThreads = new MklDomainSetNumThreads().put(pointer3);
            mklDomainSetNumThreads.call(n, 0);
            mklDomainSetNumThreads.call(n, 1);
            vendor = 3;
        }
        if (pointer4 != null) {
            new SetNumThreads().put(pointer4).call(n);
            vendor = 2;
        }
        if (vendor != 0) {
            maxThreads = n;
        } else {
            System.out.println("Unable to tune runtime. Please set OMP_NUM_THREADS manually.");
        }
    }

    public static int blas_get_num_threads() {
        return maxThreads;
    }

    public static int blas_get_vendor() {
        return vendor;
    }

    static {
        Loader.checkVersion((String)"org.bytedeco", (String)"openblas");
        maxThreads = -1;
        vendor = 0;
    }

    public static class MklDomainSetNumThreads
    extends FunctionPointer {
        public MklDomainSetNumThreads(Pointer pointer) {
            super(pointer);
        }

        protected MklDomainSetNumThreads() {
            this.allocate();
        }

        private native void allocate();

        public native int call(int var1, int var2);

        public native Pointer get();

        public native MklDomainSetNumThreads put(Pointer var1);

        static {
            Loader.load();
        }
    }

    public static class MklSetNumThreadsLocal
    extends FunctionPointer {
        public MklSetNumThreadsLocal(Pointer pointer) {
            super(pointer);
        }

        protected MklSetNumThreadsLocal() {
            this.allocate();
        }

        private native void allocate();

        public native int call(int var1);

        public native Pointer get();

        public native MklSetNumThreadsLocal put(Pointer var1);

        static {
            Loader.load();
        }
    }

    public static class SetNumThreads
    extends FunctionPointer {
        public SetNumThreads(Pointer pointer) {
            super(pointer);
        }

        protected SetNumThreads() {
            this.allocate();
        }

        private native void allocate();

        public native void call(int var1);

        public native Pointer get();

        public native SetNumThreads put(Pointer var1);

        static {
            Loader.load();
        }
    }
}

