/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.saveable;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.SaveableStateRegistry;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003BG\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJK\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u001f\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/compose/runtime/saveable/SaveableHolder;", "T", "Landroidx/compose/runtime/saveable/SaverScope;", "Landroidx/compose/runtime/RememberObserver;", "saver", "Landroidx/compose/runtime/saveable/Saver;", "", "registry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry;", "key", "", "value", "inputs", "", "<init>", "(Landroidx/compose/runtime/saveable/Saver;Landroidx/compose/runtime/saveable/SaveableStateRegistry;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V", "Ljava/lang/Object;", "[Ljava/lang/Object;", "entry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry$Entry;", "valueProvider", "Lkotlin/Function0;", "update", "", "register", "canBeSaved", "", "onRemembered", "onForgotten", "onAbandoned", "getValueIfInputsDidntChange", "([Ljava/lang/Object;)Ljava/lang/Object;", "runtime-saveable"})
final class SaveableHolder<T>
implements RememberObserver,
SaverScope {
    private Saver<T, Object> saver;
    private SaveableStateRegistry registry;
    private String key;
    private T value;
    private Object[] inputs;
    private SaveableStateRegistry.Entry entry;
    private final Function0<Object> valueProvider;

    public SaveableHolder(Saver<T, Object> saver, SaveableStateRegistry saveableStateRegistry, String string, T t, Object[] objectArray) {
        Intrinsics.checkNotNullParameter(saver, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        this.saver = saver;
        this.registry = saveableStateRegistry;
        this.key = string;
        this.value = t;
        this.inputs = objectArray;
        this.valueProvider = () -> SaveableHolder.valueProvider$lambda$2(this);
    }

    public final void update(Saver<T, Object> saver, SaveableStateRegistry saveableStateRegistry, String string, T t, Object[] objectArray) {
        Intrinsics.checkNotNullParameter(saver, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        boolean bl = false;
        if (this.registry != saveableStateRegistry) {
            this.registry = saveableStateRegistry;
            bl = true;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)string)) {
            this.key = string;
            bl = true;
        }
        this.saver = saver;
        this.value = t;
        this.inputs = objectArray;
        if (this.entry != null && bl) {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry != null) {
                entry.unregister();
            }
            this.entry = null;
            this.register();
        }
    }

    private final void register() {
        SaveableStateRegistry saveableStateRegistry = this.registry;
        if (!(this.entry == null)) {
            boolean bl = false;
            String string = "entry(" + this.entry + ") is not null";
            throw new IllegalArgumentException(string.toString());
        }
        if (saveableStateRegistry != null) {
            RememberSaveableKt.access$requireCanBeSaved(saveableStateRegistry, this.valueProvider.invoke());
            this.entry = saveableStateRegistry.registerProvider(this.key, this.valueProvider);
        }
    }

    @Override
    public boolean canBeSaved(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        SaveableStateRegistry saveableStateRegistry = this.registry;
        return saveableStateRegistry == null || saveableStateRegistry.canBeSaved(object);
    }

    public void onRemembered() {
        this.register();
    }

    public void onForgotten() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    public void onAbandoned() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    public final T getValueIfInputsDidntChange(Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        return Arrays.equals(objectArray, this.inputs) ? (T)this.value : null;
    }

    private static final Object valueProvider$lambda$2(SaveableHolder saveableHolder) {
        Saver saver = saveableHolder.saver;
        boolean bl = false;
        Saver saver2 = saver;
        SaverScope saverScope = saveableHolder;
        Object t = saveableHolder.value;
        if (t == null) {
            SaverScope saverScope2 = saverScope;
            Saver saver3 = saver2;
            boolean bl2 = false;
            String string = "Value should be initialized";
            Saver saver4 = saver3;
            SaverScope saverScope3 = saverScope2;
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        return saver2.save(saverScope, t);
    }
}

