/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ExpandingArray;
import dorkbox.collections.ObjectMap;
import dorkbox.collections.StateException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b.\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u0081\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004:\n\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB3\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000fB#\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u0010B\u001b\b\u0016\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010?\u001a\u00020@H\u0016J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0007J\u0017\u0010B\u001a\u00020\n2\b\u0010C\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010DJ\u0015\u0010E\u001a\u00020\n2\u0006\u0010C\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u0006\u0010F\u001a\u00020\nJ\u0017\u0010G\u001a\u00020\n2\b\u0010H\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010DJ\u001d\u0010G\u001a\u00020\n2\b\u0010H\u001a\u0004\u0018\u00018\u00012\u0006\u0010I\u001a\u00020\n\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\u00020@2\u0006\u0010L\u001a\u00020\u0007J\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001fJ\u0013\u0010M\u001a\u00020\n2\b\u0010N\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u000e\u0010O\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u0002J\r\u0010P\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010QJ\r\u0010R\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010QJ\u0018\u0010S\u001a\u0004\u0018\u00018\u00012\u0006\u0010C\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010TJ\"\u0010S\u001a\u0004\u0018\u00018\u00012\b\u0010C\u001a\u0004\u0018\u00018\u00002\u0006\u0010U\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010VJ\u001f\u0010W\u001a\u0004\u0018\u00018\u00002\b\u0010H\u001a\u0004\u0018\u00018\u00012\u0006\u0010I\u001a\u00020\n\u00a2\u0006\u0002\u0010XJ\u0015\u0010Y\u001a\u0004\u0018\u00018\u00002\u0006\u0010Z\u001a\u00020\u0007\u00a2\u0006\u0002\u0010[J\u0015\u0010\\\u001a\u0004\u0018\u00018\u00012\u0006\u0010Z\u001a\u00020\u0007\u00a2\u0006\u0002\u0010[J\b\u0010]\u001a\u00020\u0007H\u0016J\u0015\u0010^\u001a\u00020\u00072\b\u0010C\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010_J\u001d\u0010`\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00018\u00012\u0006\u0010I\u001a\u00020\n\u00a2\u0006\u0002\u0010aJ#\u0010b\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u00072\u0006\u0010C\u001a\u00028\u00002\u0006\u0010H\u001a\u00028\u0001\u00a2\u0006\u0002\u0010cJ\b\u0010d\u001a\u00020\nH\u0016J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000+J\u0006\u0010e\u001a\u00020\nJ\r\u0010f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010QJ\r\u0010g\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010QJ#\u0010h\u001a\u00020\u00072\u0006\u0010C\u001a\u00028\u00002\u0006\u0010H\u001a\u00028\u00012\u0006\u0010Z\u001a\u00020\u0007\u00a2\u0006\u0002\u0010iJ!\u0010h\u001a\u0004\u0018\u00018\u00012\u0006\u0010C\u001a\u00028\u00002\b\u0010H\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010VJ2\u0010j\u001a\u00020@2\u0016\u0010k\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u00002\b\b\u0002\u0010l\u001a\u00020\u00072\b\b\u0002\u0010m\u001a\u00020\u0007J \u0010j\u001a\u00020@2\u0016\u0010n\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010oH\u0016J\u001d\u0010p\u001a\u00020\u00072\u0006\u0010C\u001a\u00028\u00002\b\u0010H\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010qJ\u0017\u0010r\u001a\u0004\u0018\u00018\u00012\u0006\u0010C\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010TJ\u000e\u0010s\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u0007J\u0017\u0010t\u001a\u0004\u0018\u00018\u00012\b\u0010C\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010TJ\u001d\u0010u\u001a\u00020\n2\b\u0010H\u001a\u0004\u0018\u00018\u00012\u0006\u0010I\u001a\u00020\n\u00a2\u0006\u0002\u0010JJ\u0010\u0010v\u001a\u00020@2\u0006\u0010w\u001a\u00020\u0007H\u0004J\u0006\u0010x\u001a\u00020@J\u001b\u0010y\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u00072\u0006\u0010C\u001a\u00028\u0000\u00a2\u0006\u0002\u0010zJ\u001b\u0010{\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u00072\u0006\u0010H\u001a\u00028\u0001\u00a2\u0006\u0002\u0010zJ\u0006\u0010|\u001a\u00020@J\u0006\u0010}\u001a\u00020@J\b\u0010~\u001a\u00020\u007fH\u0016J\u000f\u0010\u0080\u0001\u001a\u00020@2\u0006\u0010w\u001a\u00020\u0007J\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010=R\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R.\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001a0\u00198VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0005\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0015\"\u0004\b.\u0010\u0017R\u0014\u0010/\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00101\"\u0004\b4\u0010\bR$\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b6\u0010$\"\u0004\b7\u0010&R\u001c\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u0001098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0016\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Ldorkbox/collections/ArrayMap;", "K", "", "V", "", "()V", "capacity", "", "(I)V", "ordered", "", "(ZI)V", "keyArrayType", "Ljava/lang/Class;", "valueArrayType", "(ZILjava/lang/Class;Ljava/lang/Class;)V", "(Ljava/lang/Class;Ljava/lang/Class;)V", "array", "(Ldorkbox/collections/ArrayMap;)V", "allocateIterators", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ArrayMap$Entries;", "entries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ArrayMap$Keys;", "keys2", "getOrdered", "setOrdered", "size", "getSize", "()I", "size_", "getSize_", "setSize_", "valueTable", "getValueTable", "setValueTable", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ArrayMap$Values;", "values2", "clear", "", "maximumCapacity", "containsAnyKey", "key", "(Ljava/lang/Object;)Z", "containsKey", "containsNullKey", "containsValue", "value", "identity", "(Ljava/lang/Object;Z)Z", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "firstKey", "()Ljava/lang/Object;", "firstValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "getKeyAt", "index", "(I)Ljava/lang/Object;", "getValueAt", "hashCode", "indexOfKey", "(Ljava/lang/Object;)I", "indexOfValue", "(Ljava/lang/Object;Z)I", "insert", "(ILjava/lang/Object;Ljava/lang/Object;)V", "isEmpty", "notEmpty", "peekKey", "peekValue", "put", "(Ljava/lang/Object;Ljava/lang/Object;I)I", "putAll", "map", "offset", "length", "from", "", "putIndex", "(Ljava/lang/Object;Ljava/lang/Object;)I", "remove", "removeIndex", "removeKey", "removeValue", "resize", "newSize", "reverse", "setKey", "(ILjava/lang/Object;)V", "setValue", "shrink", "shuffle", "toString", "", "truncate", "Companion", "Entries", "Entry", "Keys", "Values", "Collections"})
public final class ArrayMap<K, V>
implements Map<K, V>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private K[] keyTable;
    private V[] valueTable;
    private int size_;
    private boolean ordered;
    private transient Entries<K, V> entries1;
    private transient Entries<K, V> entries2;
    private transient Values<V> values1;
    private transient Values<V> values2;
    private transient Keys<K> keys1;
    private transient Keys<K> keys2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"");
        this.keyTable = KArray;
    }

    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"");
        this.valueTable = VArray;
    }

    public final int getSize_() {
        return this.size_;
    }

    public final void setSize_(int n) {
        this.size_ = n;
    }

    public final boolean getOrdered() {
        return this.ordered;
    }

    public final void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int n) {
        this(true, n);
    }

    public ArrayMap(boolean bl, int n) {
        this.ordered = bl;
        this.keyTable = new Object[n];
        this.valueTable = new Object[n];
    }

    public /* synthetic */ ArrayMap(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            n = 16;
        }
        this(bl, n);
    }

    public ArrayMap(boolean bl, int n, Class<K> clazz, Class<V> clazz2) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter(clazz2, (String)"");
        this.ordered = bl;
        Object object = Array.newInstance(clazz, n);
        Intrinsics.checkNotNull((Object)object);
        this.keyTable = (Object[])object;
        Object object2 = Array.newInstance(clazz2, n);
        Intrinsics.checkNotNull((Object)object2);
        this.valueTable = (Object[])object2;
    }

    public ArrayMap(Class<K> clazz, Class<V> clazz2) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter(clazz2, (String)"");
        this(false, 16, clazz, clazz2);
    }

    public ArrayMap(ArrayMap<K, V> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"");
        boolean bl = arrayMap.ordered;
        int n = arrayMap.size_;
        Class<?> clazz = arrayMap.keyTable.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz);
        Class<?> clazz2 = arrayMap.valueTable.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz2);
        this(bl, n, clazz, clazz2);
        this.size_ = arrayMap.size_;
        System.arraycopy(arrayMap.keyTable, 0, this.keyTable, 0, this.size_);
        System.arraycopy(arrayMap.valueTable, 0, this.valueTable, 0, this.size_);
    }

    @Override
    public V put(K k, V v) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        V v2 = this.get(k);
        this.putIndex(k, v);
        return v2;
    }

    public final int putIndex(K k, V v) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.indexOfKey(k);
        if (n == -1) {
            if (this.size_ == this.keyTable.length) {
                this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
            }
            int n2 = this.size_;
            this.size_ = n2 + 1;
            n = n2;
        }
        this.keyTable[n] = k;
        this.valueTable[n] = v;
        return n;
    }

    public final int put(K k, V v, int n) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n2 = this.indexOfKey(k);
        if (n2 != -1) {
            this.removeIndex(n2);
        } else if (this.size_ == this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
        }
        System.arraycopy(this.keyTable, n, this.keyTable, n + 1, this.size_ - n);
        System.arraycopy(this.valueTable, n, this.valueTable, n + 1, this.size_ - n);
        this.keyTable[n] = k;
        this.valueTable[n] = v;
        int n3 = this.size_;
        this.size_ = n3 + 1;
        return n;
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        return this.removeKey(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        Map<K, V> map2 = map;
        boolean bl = false;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry;
            Map.Entry<K, V> entry2 = entry = iterator.next();
            boolean bl2 = false;
            K k = entry2.getKey();
            V v = entry2.getValue();
            this.put(k, v);
        }
    }

    public final void putAll(ArrayMap<? extends K, ? extends V> arrayMap, int n, int n2) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"");
        if (n + n2 > arrayMap.size_) {
            throw new StateException("offset + length must be <= size: " + n + " + " + n2 + " <= " + arrayMap.size_);
        }
        int n3 = this.size_ + n2 - n;
        if (n3 >= this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)n3 * 1.75f))));
        }
        System.arraycopy(arrayMap.keyTable, n, this.keyTable, this.size_, n2);
        System.arraycopy(arrayMap.valueTable, n, this.valueTable, this.size_, n2);
        this.size_ += n2;
    }

    public static /* synthetic */ void putAll$default(ArrayMap arrayMap, ArrayMap arrayMap2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = arrayMap2.size_;
        }
        arrayMap.putAll(arrayMap2, n, n2);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        K[] KArray = this.keyTable;
        for (int i = this.size_ - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual((Object)object, KArray[i])) continue;
            V v = this.valueTable[i];
            Intrinsics.checkNotNull(v);
            return v;
        }
        return null;
    }

    public final V get(K k, V v) {
        int n;
        K[] KArray = this.keyTable;
        if (k == null) {
            for (n = this.size_ - 1; n >= 0; --n) {
                if (KArray[n] != k) continue;
                return this.valueTable[n];
            }
        } else {
            while (n >= 0) {
                if (Intrinsics.areEqual(k, KArray[n])) {
                    return this.valueTable[n];
                }
                --n;
            }
        }
        return v;
    }

    public final K getKey(V v, boolean bl) {
        int n;
        V[] VArray = this.valueTable;
        if (bl || v == null) {
            for (n = this.size_ - 1; n >= 0; --n) {
                if (VArray[n] != v) continue;
                return this.keyTable[n];
            }
        } else {
            while (n >= 0) {
                if (Intrinsics.areEqual(v, VArray[n])) {
                    return this.keyTable[n];
                }
                --n;
            }
        }
        return null;
    }

    public final K getKeyAt(int n) {
        if (n >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.keyTable[n];
    }

    public final V getValueAt(int n) {
        if (n >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.valueTable[n];
    }

    public final K firstKey() {
        if (!(this.size_ != 0)) {
            boolean bl = false;
            String string = "Map is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.keyTable[0];
    }

    public final V firstValue() {
        if (!(this.size_ != 0)) {
            boolean bl = false;
            String string = "Map is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.valueTable[0];
    }

    public final void setKey(int n, K k) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        if (n >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.keyTable[n] = k;
    }

    public final void setValue(int n, V v) {
        if (n >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.valueTable[n] = v;
    }

    public final void insert(int n, K k, V v) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        if (n > this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (this.size_ == this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
        }
        if (this.ordered) {
            System.arraycopy(this.keyTable, n, this.keyTable, n + 1, this.size_ - n);
            System.arraycopy(this.valueTable, n, this.valueTable, n + 1, this.size_ - n);
        } else {
            this.keyTable[this.size_] = this.keyTable[n];
            this.valueTable[this.size_] = this.valueTable[n];
        }
        int n2 = this.size_;
        this.size_ = n2 + 1;
        this.keyTable[n] = k;
        this.valueTable[n] = v;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        return this.containsAnyKey(object);
    }

    public final boolean containsNullKey() {
        return this.containsAnyKey(null);
    }

    private final boolean containsAnyKey(K k) {
        K[] KArray = this.keyTable;
        int n = this.size_ - 1;
        if (k == null) {
            while (n >= 0) {
                if (k != KArray[n--]) continue;
                return true;
            }
        } else {
            while (n >= 0) {
                if (!Intrinsics.areEqual(k, KArray[n--])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue(object, false);
    }

    public final boolean containsValue(V v, boolean bl) {
        V[] VArray = this.valueTable;
        int n = this.size_ - 1;
        if (bl || v == null) {
            while (n >= 0) {
                if (VArray[n--] != v) continue;
                return true;
            }
        } else {
            while (n >= 0) {
                if (!Intrinsics.areEqual(v, VArray[n--])) continue;
                return true;
            }
        }
        return false;
    }

    public final int indexOfKey(K k) {
        K[] KArray = this.keyTable;
        if (k == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (KArray[i] != k) continue;
                return i;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(k, KArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int indexOfValue(V v, boolean bl) {
        V[] VArray = this.valueTable;
        if (bl || v == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (VArray[i] != v) continue;
                return i;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(v, VArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final V removeKey(K k) {
        K[] KArray = this.keyTable;
        if (k == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (KArray[i] != k) continue;
                V v = this.valueTable[i];
                this.removeIndex(i);
                return v;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(k, KArray[i])) continue;
                V v = this.valueTable[i];
                this.removeIndex(i);
                return v;
            }
        }
        return null;
    }

    public final boolean removeValue(V v, boolean bl) {
        V[] VArray = this.valueTable;
        if (bl || v == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (VArray[i] != v) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(v, VArray[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public final void removeIndex(int n) {
        if (n >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        K[] KArray = this.keyTable;
        int n2 = this.size_;
        this.size_ = n2 + -1;
        if (this.ordered) {
            System.arraycopy(KArray, n + 1, KArray, n, this.size_ - n);
            System.arraycopy(this.valueTable, n + 1, this.valueTable, n, this.size_ - n);
        } else {
            KArray[n] = KArray[this.size_];
            this.valueTable[n] = this.valueTable[this.size_];
        }
        KArray[this.size_] = null;
        this.valueTable[this.size_] = null;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public final K peekKey() {
        return this.keyTable[this.size_ - 1];
    }

    public final V peekValue() {
        return this.valueTable[this.size_ - 1];
    }

    public final void clear(int n) {
        if (this.keyTable.length <= n) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.resize(n);
    }

    public int getSize() {
        return this.size_;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keyTable, 0, this.size_, null);
        Arrays.fill(this.valueTable, 0, this.size_, null);
        this.size_ = 0;
    }

    public final void shrink() {
        if (this.keyTable.length == this.size_) {
            return;
        }
        this.resize(this.size_);
    }

    public final void ensureCapacity(int n) {
        if (n < 0) {
            throw new StateException("additionalCapacity must be >= 0: " + n);
        }
        int n2 = this.size_ + n;
        if (n2 > this.keyTable.length) {
            this.resize((int)Math.max(Math.max(8.0, (double)n2), (double)((int)((float)this.size_ * 1.75f))));
        }
    }

    protected final void resize(int n) {
        Object object = Array.newInstance(this.keyTable.getClass().getComponentType(), n);
        Intrinsics.checkNotNull((Object)object);
        Object[] objectArray = (Object[])object;
        System.arraycopy(this.keyTable, 0, objectArray, 0, (int)Math.min((double)this.size_, (double)objectArray.length));
        this.keyTable = objectArray;
        Object object2 = Array.newInstance(this.valueTable.getClass().getComponentType(), n);
        Intrinsics.checkNotNull((Object)object2);
        Object[] objectArray2 = (Object[])object2;
        System.arraycopy(this.valueTable, 0, objectArray2, 0, (int)Math.min((double)this.size_, (double)objectArray2.length));
        this.valueTable = objectArray2;
    }

    public final void reverse() {
        int n = this.size_ - 1;
        int n2 = this.size_ / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            K k = this.keyTable[i];
            this.keyTable[i] = this.keyTable[n3];
            this.keyTable[n3] = k;
            V v = this.valueTable[i];
            this.valueTable[i] = this.valueTable[n3];
            this.valueTable[n3] = v;
        }
    }

    public final void shuffle() {
        for (int i = this.size_ - 1; -1 < i; --i) {
            int n = Collections.INSTANCE.random(i);
            K k = this.keyTable[i];
            this.keyTable[i] = this.keyTable[n];
            this.keyTable[n] = k;
            V v = this.valueTable[i];
            this.valueTable[i] = this.valueTable[n];
            this.valueTable[n] = v;
        }
    }

    public final void truncate(int n) {
        if (this.size_ <= n) {
            return;
        }
        int n2 = this.size_;
        for (int i = n; i < n2; ++i) {
            this.keyTable[i] = null;
            this.valueTable[i] = null;
        }
        this.size_ = n;
    }

    @Override
    public int hashCode() {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = 0;
        int n2 = this.size_;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            V v = VArray[i];
            if (k != null) {
                n += k.hashCode() * 31;
            }
            if (v == null) continue;
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayMap)) {
            return false;
        }
        ArrayMap cfr_ignored_0 = (ArrayMap)object;
        if (((ArrayMap)object).size_ != this.size_) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            K k;
            Intrinsics.checkNotNull(KArray[i]);
            V v = VArray[i];
            if (!(v == null ? ((ArrayMap)object).get(k, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(v, ((ArrayMap)object).get(k)))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayMap)) {
            return false;
        }
        ArrayMap cfr_ignored_0 = (ArrayMap)object;
        if (((ArrayMap)object).size_ != this.size_) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            if (VArray[i] == ((ArrayMap)object).get(KArray[i], ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size_ == 0) {
            return "{}";
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(KArray[0]);
        stringBuilder.append('=');
        stringBuilder.append(VArray[0]);
        int n = this.size_;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(KArray[i]);
            stringBuilder.append('=');
            stringBuilder.append(VArray[i]);
        }
        stringBuilder.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public Set<Map.Entry<K, V>> getEntries() {
        Entries<K, V> entries = this.entries();
        Intrinsics.checkNotNull(entries);
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    public Set<K> getKeys() {
        return this.keys();
    }

    public Collection<V> getValues() {
        return this.values();
    }

    public final Entries<K, V> entries() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K, V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid$Collections()) {
            Entries<K, V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.setIndex$Collections(0);
            Entries<K, V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid$Collections(true);
            Entries<K, V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid$Collections(false);
            Entries<K, V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        Entries<K, V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.setIndex$Collections(0);
        Entries<K, V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid$Collections(true);
        Entries<K, V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid$Collections(false);
        Entries<K, V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    @Override
    public final Values<V> values() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.setIndex(0);
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5);
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.setIndex(0);
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9);
        return values9;
    }

    public final Keys<K> keys() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Keys(this);
        }
        if (this.keys1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.setIndex(0);
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.setIndex(0);
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<K> keySet() {
        return this.getKeys();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/ArrayMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u00042\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u0006B\u001b\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0019\u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\u001b\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001f\u0010 \u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J$\u0010!\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\t\u0010\"\u001a\u00020\u0014H\u0096\u0002J\b\u0010#\u001a\u00020\u0014H\u0016J\u001d\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0006H\u0096\u0002J\u0017\u0010%\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J\b\u0010&\u001a\u00020\u001fH\u0016J\u001e\u0010&\u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010'\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\u0006\u0010(\u001a\u00020\u001fJ$\u0010)\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Ldorkbox/collections/ArrayMap$Entries;", "K", "", "V", "", "Ldorkbox/collections/ArrayMap$Entry;", "", "map", "Ldorkbox/collections/ArrayMap;", "(Ldorkbox/collections/ArrayMap;)V", "entry", "index", "", "getIndex$Collections", "()I", "setIndex$Collections", "(I)V", "size", "getSize", "valid", "", "getValid$Collections", "()Z", "setValid$Collections", "(Z)V", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "reset", "retainAll", "Collections"})
    public static final class Entries<K, V>
    implements Iterator<Entry<K, V>>,
    Set<Entry<K, V>>,
    KMutableIterator,
    KMutableSet {
        private final ArrayMap<K, V> map;
        private Entry<K, V> entry;
        private int index;
        private boolean valid;

        public Entries(ArrayMap<K, V> arrayMap) {
            Intrinsics.checkNotNullParameter(arrayMap, (String)"");
            this.map = arrayMap;
            this.valid = true;
        }

        public final int getIndex$Collections() {
            return this.index;
        }

        public final void setIndex$Collections(int n) {
            this.index = n;
        }

        public final boolean getValid$Collections() {
            return this.valid;
        }

        public final void setValid$Collections(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        @Override
        public boolean add(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.map.put(entry.getKey(), entry.getValue());
            this.reset();
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Entry<K, V>> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                this.map.put(k, v);
                bl = true;
            }
            this.reset();
            return bl;
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl2 = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.map.get(k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            return Intrinsics.areEqual(this.map.get(entry.getKey()), entry.getValue());
        }

        @Override
        public Iterator<Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            K[] KArray = this.map.getKeyTable();
            boolean bl2 = false;
            int n = KArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl3;
                Object v0;
                K k;
                block2: {
                    K k2;
                    k = k2 = KArray[i];
                    boolean bl4 = false;
                    if (k == null) continue;
                    Iterable iterable = collection;
                    boolean bl5 = false;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual(entry.getKey(), k)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                boolean bl7 = bl3 = v0 != null;
                if (bl3) continue;
                bl = this.map.remove(k) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (!Intrinsics.areEqual(this.map.get(k), v)) continue;
                this.map.removeKey(k);
                bl = true;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            if (Intrinsics.areEqual(this.map.get(entry.getKey()), entry.getValue())) {
                this.map.removeKey(entry.getKey());
                return true;
            }
            this.reset();
            return false;
        }

        @Override
        public Entry<K, V> next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.entry == null) {
                K k = this.map.getKeyTable()[this.index];
                Intrinsics.checkNotNull(k);
                int n = this.index;
                this.index = n + 1;
                this.entry = new Entry<K, V>(k, this.map.getValueTable()[n], this.map);
            } else {
                Entry<K, V> entry = this.entry;
                Intrinsics.checkNotNull(entry);
                K k = this.map.getKeyTable()[this.index];
                Intrinsics.checkNotNull(k);
                entry.setKey(k);
                Entry<K, V> entry2 = this.entry;
                Intrinsics.checkNotNull(entry2);
                int n = this.index;
                this.index = n + 1;
                entry2.setValue(this.map.getValueTable()[n]);
            }
            Entry<K, V> entry = this.entry;
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004B)\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u0012\u001a\u0004\u0018\u00018\u00032\b\u0010\u0013\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0005\u001a\u00028\u0002X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0003X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/ArrayMap$Entry;", "K", "", "V", "", "key", "value", "map", "Ldorkbox/collections/ArrayMap;", "(Ljava/lang/Object;Ljava/lang/Object;Ldorkbox/collections/ArrayMap;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ArrayMap;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        private final ArrayMap<K, V> map;
        private K key;
        private V value;

        public Entry(K k, V v, ArrayMap<K, V> arrayMap) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            Intrinsics.checkNotNullParameter(arrayMap, (String)"");
            this.map = arrayMap;
            this.key = k;
            this.value = v;
        }

        public final ArrayMap<K, V> getMap() {
            return this.map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            this.key = k;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(V v) {
            this.value = v;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.getValue();
            ((Map)this.map).put(this.getKey(), v);
            this.setValue(v);
            return v2;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\t\u0010 \u001a\u00020\u0011H\u0096\u0002J\b\u0010!\u001a\u00020\u0011H\u0016J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004H\u0096\u0002J\u000e\u0010#\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001dH\u0016J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u0006\u0010'\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020*J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020*R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Ldorkbox/collections/ArrayMap$Keys;", "K", "", "", "", "map", "Ldorkbox/collections/ArrayMap;", "(Ldorkbox/collections/ArrayMap;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "size", "getSize", "valid", "", "getValid", "()Z", "setValid", "(Z)V", "add", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "reset", "retainAll", "toArray", "Ldorkbox/collections/ExpandingArray;", "array", "Collections"})
    public static final class Keys<K>
    implements Iterator<K>,
    Set<K>,
    KMutableIterator,
    KMutableSet {
        private final ArrayMap<K, Object> map;
        private int index;
        private boolean valid;

        public Keys(ArrayMap<K, Object> arrayMap) {
            Intrinsics.checkNotNullParameter(arrayMap, (String)"");
            this.valid = true;
            this.map = arrayMap;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        @Override
        public boolean add(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.map.getSize_() == 0;
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl2 = false;
                if (this.map.containsKey(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            return this.map.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            K[] KArray = this.map.getKeyTable();
            boolean bl2 = false;
            int n = KArray.length;
            for (int i = 0; i < n; ++i) {
                K k;
                K k2 = k = KArray[i];
                boolean bl3 = false;
                if (k2 == null || collection.contains(k2)) continue;
                this.map.remove(k2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl3 = false;
                if (this.map.remove(t2) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            boolean bl = this.map.remove(object) == null;
            this.reset();
            return bl;
        }

        @Override
        public K next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            K k = this.map.getKeyTable()[n];
            Intrinsics.checkNotNull(k);
            return k;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        public final ExpandingArray<K> toArray() {
            return new ExpandingArray<K>(true, this.map.getKeyTable(), this.index, this.map.getSize_() - this.index);
        }

        public final ExpandingArray<K> toArray(ExpandingArray<K> expandingArray) {
            Intrinsics.checkNotNullParameter(expandingArray, (String)"");
            expandingArray.addAll(this.map.getKeyTable(), this.index, this.map.getSize_() - this.index);
            return expandingArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\t\u0010 \u001a\u00020\u0011H\u0096\u0002J\b\u0010!\u001a\u00020\u0011H\u0016J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003H\u0096\u0002J\u000e\u0010#\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001dH\u0016J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u0006\u0010'\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020*R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Ldorkbox/collections/ArrayMap$Values;", "V", "", "", "map", "Ldorkbox/collections/ArrayMap;", "", "(Ldorkbox/collections/ArrayMap;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "size", "getSize", "valid", "", "getValid", "()Z", "setValid", "(Z)V", "add", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "reset", "retainAll", "toArray", "Ldorkbox/collections/ExpandingArray;", "array", "Collections"})
    public static final class Values<V>
    implements Collection<V>,
    Iterator<V>,
    KMutableCollection,
    KMutableIterator {
        private final ArrayMap<Object, V> map;
        private int index;
        private boolean valid;

        public Values(ArrayMap<Object, V> arrayMap) {
            Intrinsics.checkNotNullParameter(arrayMap, (String)"");
            this.valid = true;
            this.map = arrayMap;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V v) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.map.getSize_() == 0;
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl2 = false;
                if (this.map.containsValue(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Object[] objectArray = this.map.getKeyTable();
            boolean bl2 = false;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                V v;
                Object object;
                Object object2 = object = objectArray[i];
                boolean bl3 = false;
                if (object2 == null || CollectionsKt.contains((Iterable)collection, v = this.map.get(object2))) continue;
                this.map.remove(object2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl3 = false;
                Object object = this.map.getKey(t2, false);
                if (object == null) continue;
                bl = this.map.remove(object) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            Object object2 = this.map.getKey(object, false);
            if (object2 != null) {
                bl = this.map.remove(object2) != null;
            }
            this.reset();
            return bl;
        }

        @Override
        public V next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            V v = this.map.getValueTable()[n];
            Intrinsics.checkNotNull(v);
            return v;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        public final ExpandingArray<V> toArray() {
            return new ExpandingArray<V>(true, this.map.getValueTable(), this.index, this.map.getSize_() - this.index);
        }

        public final ExpandingArray<V> toArray(ExpandingArray<V> expandingArray) {
            Intrinsics.checkNotNullParameter(expandingArray, (String)"");
            expandingArray.addAll(this.map.getValueTable(), this.index, this.map.getSize_() - this.index);
            return expandingArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

