/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.IntMap;
import dorkbox.collections.LockFreeObjectIntBiMap;
import dorkbox.collections.ObjectIntMap;
import dorkbox.collections.StateException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 ;*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00052\u00020\u0006:\u0001;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB9\b\u0010\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0015\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010,J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\b\u0010-\u001a\u00020$H\u0016J\u001f\u0010.\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\"2\u0014\u00101\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u000002H\u0016J\u001a\u00103\u001a\u00020\"2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u000002J\u001d\u00105\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0017\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010*J\u001c\u00107\u001a\u00020\"2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u000102J\u001c\u00108\u001a\u00020\"2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u000102J\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\rR\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006<"}, d2={"Ldorkbox/collections/LockFreeIntBiMap;", "V", "", "", "", "", "Ljava/io/Serializable;", "()V", "defaultReturnValue", "(I)V", "forwardHashMap", "Ldorkbox/collections/IntMap;", "reverseHashMap", "Ldorkbox/collections/ObjectIntMap;", "inverse", "Ldorkbox/collections/LockFreeObjectIntBiMap;", "(Ldorkbox/collections/IntMap;Ldorkbox/collections/ObjectIntMap;Ldorkbox/collections/LockFreeObjectIntBiMap;I)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "reverseValues", "", "getReverseValues", "()Ljava/util/Collection;", "size", "getSize", "()I", "values", "getValues", "clear", "", "containsKey", "", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "get", "(I)Ljava/lang/Object;", "getReverse", "(Ljava/lang/Object;)Ljava/lang/Integer;", "isEmpty", "put", "(ILjava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "putAllForce", "hashMap", "putForce", "remove", "replaceAll", "replaceAllForce", "toMap", "toReverseMap", "Companion", "Collections"})
public final class LockFreeIntBiMap<V>
implements Serializable,
Cloneable,
Map<Integer, V>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private final int defaultReturnValue;
    private volatile IntMap<V> forwardHashMap;
    private volatile ObjectIntMap<V> reverseHashMap;
    private final LockFreeObjectIntBiMap<V> inverse;
    public static final String version = "2.8";
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap<?>, IntMap<?>> forwardREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, IntMap.class, "forwardHashMap");
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap<?>, ObjectIntMap<?>> reverseREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, ObjectIntMap.class, "reverseHashMap");

    public LockFreeIntBiMap() {
        this(Integer.MIN_VALUE);
    }

    public LockFreeIntBiMap(int n) {
        this.forwardHashMap = new IntMap();
        this.reverseHashMap = new ObjectIntMap();
        this.inverse = new LockFreeObjectIntBiMap<V>(this.reverseHashMap, this.forwardHashMap, this, n);
        this.defaultReturnValue = n;
    }

    public LockFreeIntBiMap(IntMap<V> intMap, ObjectIntMap<V> objectIntMap, LockFreeObjectIntBiMap<V> lockFreeObjectIntBiMap, int n) {
        Intrinsics.checkNotNullParameter(intMap, (String)"");
        Intrinsics.checkNotNullParameter(objectIntMap, (String)"");
        Intrinsics.checkNotNullParameter(lockFreeObjectIntBiMap, (String)"");
        this.forwardHashMap = intMap;
        this.reverseHashMap = objectIntMap;
        this.inverse = lockFreeObjectIntBiMap;
        this.defaultReturnValue = n;
    }

    public int getSize() {
        return this.forwardHashMap.size();
    }

    @Override
    public synchronized void clear() {
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        IntMap<?> intMap = forwardREF.get(this);
        Intrinsics.checkNotNullExpressionValue(intMap, (String)"");
        return ((Map)intMap).containsValue(object);
    }

    public boolean containsKey(int n) {
        return forwardREF.get(this).containsKey((Object)n);
    }

    public final LockFreeObjectIntBiMap<V> inverse() {
        return this.inverse;
    }

    public final synchronized void replaceAll(Map<Integer, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("hashMap");
        }
        LockFreeIntBiMap<? extends V> lockFreeIntBiMap = new LockFreeIntBiMap<V>();
        lockFreeIntBiMap.putAll(map);
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.forwardHashMap.putAll(lockFreeIntBiMap.forwardHashMap);
        this.reverseHashMap.putAll(lockFreeIntBiMap.reverseHashMap);
    }

    public final synchronized void replaceAllForce(Map<Integer, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("hashMap");
        }
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.putAllForce(map);
    }

    @Override
    public synchronized V put(int n, V v) {
        Intrinsics.checkNotNullParameter(v, (String)"");
        V v2 = this.forwardHashMap.put(n, v);
        if (v2 != null) {
            this.reverseHashMap.remove((Object)v2);
        }
        int n2 = this.reverseHashMap.get(v, this.defaultReturnValue);
        this.reverseHashMap.put(v, n);
        if (n2 != this.defaultReturnValue) {
            if (v2 != null) {
                this.forwardHashMap.put(n, v2);
            } else {
                this.forwardHashMap.remove((Object)n);
            }
            this.reverseHashMap.put(v, n2);
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        return v2;
    }

    public final synchronized V putForce(int n, V v) {
        Intrinsics.checkNotNullParameter(v, (String)"");
        V v2 = this.forwardHashMap.put(n, v);
        if (v2 != null) {
            this.reverseHashMap.remove(v2, this.defaultReturnValue);
        }
        int n2 = this.reverseHashMap.get(v, this.defaultReturnValue);
        this.reverseHashMap.put(v, n);
        if (n2 != this.defaultReturnValue) {
            this.forwardHashMap.remove((Object)n2);
        }
        return v2;
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        LockFreeIntBiMap<V> lockFreeIntBiMap = new LockFreeIntBiMap<V>();
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            int n = ((Number)entry.getKey()).intValue();
            V v = entry.getValue();
            lockFreeIntBiMap.put(n, v);
            if (this.forwardHashMap.containsKey((Object)n)) {
                throw new StateException("Key already exists. Keys and values must both be unique!");
            }
            if (!this.reverseHashMap.containsKey(v)) continue;
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        this.forwardHashMap.putAll(lockFreeIntBiMap.forwardHashMap);
        this.reverseHashMap.putAll(lockFreeIntBiMap.reverseHashMap);
    }

    public final synchronized void putAllForce(Map<Integer, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            int n = ((Number)entry.getKey()).intValue();
            V v = entry.getValue();
            this.putForce(n, v);
        }
    }

    public synchronized V remove(int n) {
        V v = this.forwardHashMap.remove((Object)n);
        if (v != null) {
            this.reverseHashMap.remove((Object)v);
        }
        return v;
    }

    public V get(int n) {
        return (V)forwardREF.get(this).get((Object)n);
    }

    public final Integer getReverse(V v) {
        Intrinsics.checkNotNullParameter(v, (String)"");
        ObjectIntMap<?> objectIntMap = reverseREF.get(this);
        Intrinsics.checkNotNullExpressionValue(objectIntMap, (String)"");
        return (Integer)((Map)objectIntMap).get(v);
    }

    public Set<Map.Entry<Integer, V>> getEntries() {
        Set<Map.Entry<Integer, ?>> set = forwardREF.get(this).entrySet();
        Intrinsics.checkNotNull(set);
        return TypeIntrinsics.asMutableSet(set);
    }

    public Set<Integer> getKeys() {
        return forwardREF.get(this).keySet();
    }

    public Collection<V> getValues() {
        Collection<?> collection = forwardREF.get(this).values();
        Intrinsics.checkNotNull(collection);
        return TypeIntrinsics.asMutableCollection(collection);
    }

    @Override
    public boolean isEmpty() {
        return forwardREF.get(this).isEmpty();
    }

    public final Collection<Integer> getReverseValues() {
        return reverseREF.get(this).values();
    }

    public final IntMap<V> toMap() {
        IntMap<?> intMap = forwardREF.get(this);
        Intrinsics.checkNotNull(intMap);
        return new IntMap(intMap);
    }

    public final ObjectIntMap<V> toReverseMap() {
        ObjectIntMap<?> objectIntMap = reverseREF.get(this);
        Intrinsics.checkNotNull(objectIntMap);
        return new ObjectIntMap(objectIntMap);
    }

    public Object clone() {
        return super.clone();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.containsKey(((Number)object).intValue());
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        return this.put(((Number)object).intValue(), object2);
    }

    @Override
    public final V remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final V get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final Set<Map.Entry<Integer, V>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<Integer> keySet() {
        return this.getKeys();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rn\u0010\u0003\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\b\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/collections/LockFreeIntBiMap$Companion;", "", "()V", "forwardREF", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Ldorkbox/collections/LockFreeIntBiMap;", "kotlin.jvm.PlatformType", "Ldorkbox/collections/IntMap;", "reverseREF", "Ldorkbox/collections/ObjectIntMap;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

