/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 O2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002OPB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\nJ\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0018J\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J\u0016\u0010+\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u0002H\u0002J\b\u00104\u001a\u00020,H\u0016J\u000e\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\u0005J\u0011\u00106\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0002H\u0096\u0002J\u0016\u00107\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0016J\u000e\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020\u0005J\u0013\u0010:\u001a\u00020\f2\b\u0010;\u001a\u0004\u0018\u00010<H\u0096\u0002J\u0006\u0010=\u001a\u00020\u0002J\u0018\u0010>\u001a\u0004\u0018\u00010\u00022\u0006\u00103\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u0005H\u0016J\b\u0010A\u001a\u00020\fH\u0016J\t\u0010B\u001a\u00020\u0015H\u0096\u0002J\u0010\u0010C\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0002H\u0002J\u0006\u0010D\u001a\u00020\fJ\u0010\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0002H\u0004J\u0010\u0010G\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0016\u0010H\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0016J\u0010\u0010I\u001a\u00020,2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0016\u0010K\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0016J\u000e\u0010L\u001a\u00020,2\u0006\u00105\u001a\u00020\u0005J\b\u0010M\u001a\u00020NH\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u0014\u0010%\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001fR\u000e\u0010'\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Ldorkbox/collections/LongSet;", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/LongSet;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "iterator1", "Ldorkbox/collections/LongSet$LongSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[J", "setKeyTable", "([J)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "add", "element", "addAll", "", "array", "offset", "length", "elements", "", "addResize", "key", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "", "first", "get", "(J)Ljava/lang/Long;", "hashCode", "isEmpty", "iterator", "locateKey", "notEmpty", "place", "item", "remove", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "Companion", "LongSetIterator", "Collections"})
public final class LongSet
implements Set<Long>,
KMutableSet {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private long[] keyTable;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient LongSetIterator iterator1;
    private transient LongSetIterator iterator2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final long[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
        this.keyTable = lArray;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public LongSet() {
        this(51, 0.8f);
    }

    public LongSet(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[n2];
    }

    public /* synthetic */ LongSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public LongSet(LongSet longSet) {
        Intrinsics.checkNotNullParameter((Object)longSet, (String)"");
        this((int)((float)longSet.keyTable.length * longSet.loadFactor), longSet.loadFactor);
        System.arraycopy(longSet.keyTable, 0, this.keyTable, 0, longSet.keyTable.length);
        this.size_ = longSet.size_;
        this.hasZeroValue = longSet.hasZeroValue;
    }

    public int getSize() {
        return this.size_;
    }

    protected final int place(long l) {
        return (int)(l * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(long l) {
        long[] lArray = this.keyTable;
        int n = this.place(l);
        long l2;
        while ((l2 = lArray[n]) != 0L) {
            if (l2 == l) {
                return n;
            }
            n = n + 1 & this.mask;
        }
        return -(n + 1);
    }

    public final Long get(long l) {
        int n = this.locateKey(l);
        return n < 0 ? null : Long.valueOf(this.keyTable[n]);
    }

    @Override
    public boolean add(long l) {
        if (l == 0L) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            int n = this.size_;
            this.size_ = n + 1;
            return true;
        }
        int n = this.locateKey(l);
        if (n >= 0) {
            return false;
        }
        n = -(n + 1);
        this.keyTable[n] = l;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        for (Object t : iterable) {
            long l = ((Number)t).longValue();
            boolean bl3 = false;
            bl = this.add(l) || bl;
        }
        return bl;
    }

    public final void addAll(long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
        this.addAll(lArray, 0, lArray.length);
    }

    public final void addAll(long[] lArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
        if (n + n2 > lArray.length) {
            throw new StateException("offset + length must be <= size: " + n + " + " + n2 + " <= " + lArray.length);
        }
        this.ensureCapacity(n2);
        int n4 = n3 + n2;
        for (n3 = n; n3 < n4; ++n3) {
            this.add(lArray[n3]);
        }
    }

    public final void addAll(LongSet longSet) {
        Intrinsics.checkNotNullParameter((Object)longSet, (String)"");
        this.ensureCapacity(longSet.size_);
        if (longSet.hasZeroValue) {
            this.add(0L);
        }
        for (long l : longSet.keyTable) {
            if (l == 0L) continue;
            this.add(l);
        }
    }

    private final void addResize(long l) {
        long[] lArray = this.keyTable;
        int n = this.place(l);
        while (true) {
            if (lArray[n] == 0L) {
                lArray[n] = l;
                return;
            }
            n = n + 1 & this.mask;
        }
    }

    public boolean remove(long l) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            int n = this.size_;
            this.size_ = n + -1;
            return true;
        }
        int n = this.locateKey(l);
        if (n < 0) {
            return false;
        }
        long[] lArray = this.keyTable;
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        long l2 = 0L;
        while (true) {
            long l3;
            long l4 = l3 = lArray[n3];
            boolean bl = false;
            l2 = l4;
            if (l3 == 0L) break;
            int n4 = this.place(l2);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                lArray[n] = l2;
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        lArray[n] = 0L;
        int n5 = this.size_;
        this.size_ = n5 + -1;
        return true;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public final void clear(int n) {
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.resize(n2);
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0L);
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Iterable iterable = collection;
        boolean bl = false;
        for (Object t : iterable) {
            long l = ((Number)t).longValue();
            boolean bl2 = false;
            if (this.contains((Object)l)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(long l) {
        return l == 0L ? this.hasZeroValue : this.locateKey(l) >= 0;
    }

    public final long first() {
        if (this.hasZeroValue) {
            return 0L;
        }
        long[] lArray = this.keyTable;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == 0L) continue;
            return lArray[i];
        }
        throw new IllegalStateException("LongSet is empty.");
    }

    public final void ensureCapacity(int n) {
        int n2 = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] lArray = this.keyTable;
        this.keyTable = new long[n];
        if (this.size_ > 0) {
            for (int i = 0; i < n2; ++i) {
                long l = lArray[i];
                if (l == 0L) continue;
                this.addResize(l);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size_;
        for (long l : this.keyTable) {
            if (l == 0L) continue;
            n += (int)l;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LongSet)) {
            return false;
        }
        if (((LongSet)object).size_ != this.size_) {
            return false;
        }
        if (((LongSet)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        long[] lArray = this.keyTable;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == 0L || ((LongSet)object).contains((Object)lArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long l;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.keyTable;
        int n = lArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0");
        } else {
            while (n-- > 0) {
                l = lArray[n];
                if (l == 0L) continue;
                stringBuilder.append(l);
                break;
            }
        }
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public LongSetIterator iterator() {
        if (this.allocateIterators) {
            return new LongSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new LongSetIterator(this);
            this.iterator2 = new LongSetIterator(this);
        }
        LongSetIterator longSetIterator = this.iterator1;
        Intrinsics.checkNotNull((Object)longSetIterator);
        if (!longSetIterator.getValid()) {
            LongSetIterator longSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator2);
            longSetIterator2.reset();
            LongSetIterator longSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator3);
            longSetIterator3.setValid(true);
            LongSetIterator longSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull((Object)longSetIterator4);
            longSetIterator4.setValid(false);
            LongSetIterator longSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator5);
            return longSetIterator5;
        }
        LongSetIterator longSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator6);
        longSetIterator6.reset();
        LongSetIterator longSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator7);
        longSetIterator7.setValid(true);
        LongSetIterator longSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull((Object)longSetIterator8);
        longSetIterator8.setValid(false);
        LongSetIterator longSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator9);
        return longSetIterator9;
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        long[] lArray = this.keyTable;
        boolean bl2 = false;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long l;
            long l2 = l = lArray[i];
            boolean bl3 = false;
            if (collection.contains(l2)) continue;
            this.remove((Object)l2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        for (Object t : iterable) {
            long l = ((Number)t).longValue();
            boolean bl3 = false;
            bl = this.remove((Object)l) || bl;
        }
        return bl;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        return this.add(((Number)object).longValue());
    }

    @Override
    public final boolean remove(Object object) {
        if (!(object instanceof Long)) {
            return false;
        }
        return this.remove(((Number)object).longValue());
    }

    @Override
    public final boolean contains(Object object) {
        if (!(object instanceof Long)) {
            return false;
        }
        return this.contains(((Number)object).longValue());
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/collections/LongSet$Companion;", "", "()V", "version", "", "with", "Ldorkbox/collections/LongSet;", "array", "", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final LongSet with(long ... lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
            LongSet longSet = new LongSet();
            longSet.addAll(lArray);
            return longSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011\u00a8\u0006$"}, d2={"Ldorkbox/collections/LongSet$LongSetIterator;", "", "", "set", "Ldorkbox/collections/LongSet;", "(Ldorkbox/collections/LongSet;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/LongSet;", "valid", "getValid", "setValid", "findNextIndex", "", "next", "()Ljava/lang/Long;", "remove", "reset", "toArray", "", "array", "Companion", "Collections"})
    public static final class LongSetIterator
    implements Iterator<Long>,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final LongSet set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;

        public LongSetIterator(LongSet longSet) {
            Intrinsics.checkNotNullParameter((Object)longSet, (String)"");
            this.set = longSet;
            this.valid = true;
            this.reset();
        }

        public final LongSet getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                long[] lArray = this.set.getKeyTable();
                int n = lArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (lArray[this.nextIndex] == 0L);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n == -1 && this.set.getHasZeroValue()) {
                this.set.setHasZeroValue(false);
            } else {
                if (n < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] lArray = this.set.getKeyTable();
                int n2 = this.set.getMask();
                int n3 = n + 1 & n2;
                long l = 0L;
                while (true) {
                    long l2;
                    long l3 = l2 = lArray[n3];
                    boolean bl = false;
                    l = l3;
                    if (l2 == 0L) break;
                    int n4 = this.set.place(l);
                    if ((n3 - n4 & n2) > (n - n4 & n2)) {
                        lArray[n] = l;
                        n = n3;
                    }
                    n3 = n3 + 1 & n2;
                }
                lArray[n] = 0L;
                if (n != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                LongSet longSet = this.set;
                int n5 = longSet.size_;
                longSet.size_ = n5 + -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Long next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long l = this.nextIndex == -1 ? 0L : this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return l;
        }

        public final long[] toArray() {
            long[] lArray = new long[this.set.size()];
            int n = 0;
            while (this.hasNext()) {
                lArray[n++] = this.next();
            }
            return lArray;
        }

        public final long[] toArray(long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
            int n = 0;
            while (this.hasNext) {
                lArray[n++] = this.next();
            }
            return lArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/LongSet$LongSetIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

