/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 \u007f*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004:\u000b\u007f\u0080\u0001\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010W\u001a\u00020XH\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0007H\u0016J\u0015\u0010Z\u001a\u00020\u000e2\u0006\u0010[\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\\J\u0017\u0010]\u001a\u00020\u000e2\b\u0010^\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\\J\u001a\u0010]\u001a\u00020\u000e2\b\u0010^\u001a\u0004\u0018\u00010\u00022\u0006\u0010_\u001a\u00020\u000eH\u0016J\u000e\u0010`\u001a\u00020X2\u0006\u0010a\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0019H\u0016J\u0013\u0010b\u001a\u00020\u000e2\b\u0010c\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0012\u0010d\u001a\u00020\u000e2\b\u0010c\u001a\u0004\u0018\u00010\u0002H\u0016J\u001f\u0010e\u001a\u0004\u0018\u00018\u00002\b\u0010^\u001a\u0004\u0018\u00010\u00022\u0006\u0010_\u001a\u00020\u000e\u00a2\u0006\u0002\u0010fJ\u0018\u0010g\u001a\u0004\u0018\u00018\u00012\u0006\u0010[\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010hJ \u0010g\u001a\u0004\u0018\u00018\u00012\u0006\u0010[\u001a\u00028\u00002\u0006\u0010i\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010jJ\b\u0010k\u001a\u00020\u0007H\u0016J\b\u0010l\u001a\u00020\u000eH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0016J\u0010\u0010m\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0002H\u0016J\u0006\u0010n\u001a\u00020\u000eJ\u0010\u0010o\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\u0002H\u0014J!\u0010q\u001a\u0004\u0018\u00018\u00012\u0006\u0010[\u001a\u00028\u00002\b\u0010^\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010jJ\"\u0010r\u001a\u00020X2\u0018\u0010s\u001a\u0014\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00010\u0000H\u0016J \u0010r\u001a\u00020X2\u0016\u0010s\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010tH\u0016J\u001f\u0010u\u001a\u00020X2\u0006\u0010[\u001a\u00028\u00002\b\u0010^\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010vJ\u0017\u0010w\u001a\u0004\u0018\u00018\u00012\u0006\u0010[\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010hJ\u000e\u0010x\u001a\u00020X2\u0006\u0010y\u001a\u00020\u0007J\u0010\u0010z\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0007H\u0016J\b\u0010{\u001a\u00020|H\u0016J\u000e\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020|J\u0018\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020|2\u0006\u0010~\u001a\u00020\u000eH\u0014J\u0010\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010OH\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0017R\"\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00109\"\u0004\b>\u0010;R\u001a\u0010?\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00109\"\u0004\bA\u0010;R\u0014\u0010B\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u00109R\u001a\u0010D\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00109\"\u0004\bF\u0010;R$\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\bH\u0010$\"\u0004\bI\u0010&R\u001c\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010K8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR$\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR$\u0010T\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010Q\"\u0004\bV\u0010S\u00a8\u0006\u0085\u0001"}, d2={"Ldorkbox/collections/ObjectMap;", "K", "", "V", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/ObjectMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ObjectMap$Entries;", "getEntries1", "()Ldorkbox/collections/ObjectMap$Entries;", "setEntries1", "(Ldorkbox/collections/ObjectMap$Entries;)V", "entries2", "getEntries2", "setEntries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ObjectMap$Keys;", "getKeys1", "()Ldorkbox/collections/ObjectMap$Keys;", "setKeys1", "(Ldorkbox/collections/ObjectMap$Keys;)V", "keys2", "getKeys2", "setKeys2", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mapSize", "getMapSize", "()I", "setMapSize", "(I)V", "mask", "getMask", "setMask", "shift", "getShift", "setShift", "size", "getSize", "threshold", "getThreshold", "setThreshold", "valueTable", "getValueTable", "setValueTable", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ObjectMap$Values;", "getValues1", "()Ldorkbox/collections/ObjectMap$Values;", "setValues1", "(Ldorkbox/collections/ObjectMap$Values;)V", "values2", "getValues2", "setValues2", "clear", "", "maximumCapacity", "containsKey", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "separator", "braces", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public class ObjectMap<K, V>
implements Map<K, V>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int mapSize;
    private K[] keyTable;
    private V[] valueTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries<K, V> entries1;
    private transient Entries<K, V> entries2;
    private transient Values<V> values1;
    private transient Values<V> values2;
    private transient Keys<K> keys1;
    private transient Keys<K> keys2;
    public static final String version = "2.8";
    private static final Object dummy = new Object();

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    protected final int getMapSize() {
        return this.mapSize;
    }

    protected final void setMapSize(int n) {
        this.mapSize = n;
    }

    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"");
        this.keyTable = KArray;
    }

    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"");
        this.valueTable = VArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public final Entries<K, V> getEntries1() {
        return this.entries1;
    }

    public final void setEntries1(Entries<K, V> entries) {
        this.entries1 = entries;
    }

    public final Entries<K, V> getEntries2() {
        return this.entries2;
    }

    public final void setEntries2(Entries<K, V> entries) {
        this.entries2 = entries;
    }

    public final Values<V> getValues1() {
        return this.values1;
    }

    public final void setValues1(Values<V> values) {
        this.values1 = values;
    }

    public final Values<V> getValues2() {
        return this.values2;
    }

    public final void setValues2(Values<V> values) {
        this.values2 = values;
    }

    public final Keys<K> getKeys1() {
        return this.keys1;
    }

    public final void setKeys1(Keys<K> keys) {
        this.keys1 = keys;
    }

    public final Keys<K> getKeys2() {
        return this.keys2;
    }

    public final void setKeys2(Keys<K> keys) {
        this.keys2 = keys;
    }

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
    }

    public /* synthetic */ ObjectMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectMap(ObjectMap<? extends K, ? extends V> objectMap) {
        Intrinsics.checkNotNullParameter(objectMap, (String)"");
        this((int)((float)objectMap.keyTable.length * objectMap.loadFactor), objectMap.loadFactor);
        System.arraycopy(objectMap.keyTable, 0, this.keyTable, 0, objectMap.keyTable.length);
        System.arraycopy(objectMap.valueTable, 0, this.valueTable, 0, objectMap.valueTable.length);
        this.mapSize = objectMap.mapSize;
    }

    public int getSize() {
        return this.mapSize;
    }

    protected int place(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        return (int)((long)object.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public int locateKey(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        K[] KArray = this.keyTable;
        int n = this.place(object);
        while (KArray[n] != null) {
            K k;
            if (Intrinsics.areEqual(k, (Object)object)) {
                return n;
            }
            n = n + 1 & this.mask;
        }
        return -(n + 1);
    }

    @Override
    public V put(K k, V v) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n >= 0) {
            V v2 = this.valueTable[n];
            this.valueTable[n] = v;
            return v2;
        }
        n = -(n + 1);
        this.keyTable[n] = k;
        this.valueTable[n] = v;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public void putAll(ObjectMap<? extends K, ? extends V> objectMap) {
        Intrinsics.checkNotNullParameter(objectMap, (String)"");
        this.ensureCapacity(objectMap.mapSize);
        K[] KArray = objectMap.keyTable;
        V[] VArray = objectMap.valueTable;
        K k = null;
        int n = KArray.length;
        for (int i = 0; i < n; ++i) {
            k = KArray[i];
            if (k == null) continue;
            this.put(k, VArray[i]);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.ensureCapacity(map.size());
        Map<K, V> map2 = map;
        boolean bl = false;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry;
            Map.Entry<K, V> entry2 = entry = iterator.next();
            boolean bl2 = false;
            K k = entry2.getKey();
            V v = entry2.getValue();
            this.put(k, v);
        }
    }

    private final void putResize(K k, V v) {
        K[] KArray = this.keyTable;
        int n = this.place(k);
        while (true) {
            if (KArray[n] == null) {
                KArray[n] = k;
                this.valueTable[n] = v;
                return;
            }
            n = n + 1 & this.mask;
        }
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.locateKey(object);
        return n < 0 ? null : (V)this.valueTable[n];
    }

    public final V get(K k, V v) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        return n < 0 ? v : this.valueTable[n];
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.locateKey(object);
        if (n < 0) {
            return null;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v = VArray[n];
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        Object var8_8 = null;
        while (true) {
            K k;
            K k2 = k = KArray[n3];
            boolean bl = false;
            var8_8 = k2;
            if (k == null) break;
            Object v0 = var8_8;
            Intrinsics.checkNotNull(v0);
            int n4 = this.place(v0);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                KArray[n] = var8_8;
                VArray[n] = VArray[n3];
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        KArray[n] = null;
        VArray[n] = null;
        int n5 = this.mapSize;
        this.mapSize = n5 + -1;
        return v;
    }

    public final boolean notEmpty() {
        return this.mapSize > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.mapSize == 0;
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public void clear(int n) {
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.mapSize = 0;
        this.resize(n2);
    }

    @Override
    public void clear() {
        if (this.mapSize == 0) {
            return;
        }
        this.mapSize = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue(object, false);
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n2;
                    if (KArray[n2 = n--] == null || VArray[n2] != null) continue;
                    return true;
                } while (0 <= n);
            }
        } else if (bl) {
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n3;
                    if (VArray[n3 = n--] != object) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n4;
                    if (!Intrinsics.areEqual((Object)object, VArray[n4 = n--])) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        return this.locateKey(object) >= 0;
    }

    public final K findKey(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n2;
                    if (KArray[n2 = n--] == null || VArray[n2] != null) continue;
                    return KArray[n2];
                } while (0 <= n);
            }
        } else if (bl) {
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n3;
                    if (VArray[n3 = n--] != object) continue;
                    return this.keyTable[n3];
                } while (0 <= n);
            }
        } else {
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n4;
                    if (!Intrinsics.areEqual((Object)object, VArray[n4 = n--])) continue;
                    return this.keyTable[n4];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final void ensureCapacity(int n) {
        int n2 = ObjectSet.Companion.tableSize(this.mapSize + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    public final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n];
        this.valueTable = new Object[n];
        if (this.mapSize > 0) {
            for (int i = 0; i < n2; ++i) {
                K k = KArray[i];
                if (k == null) continue;
                this.putResize(k, VArray[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.mapSize;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            n += k.hashCode();
            V v = VArray[i];
            if (v == null) continue;
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        ObjectMap cfr_ignored_0 = (ObjectMap)object;
        if (((ObjectMap)object).size() != this.mapSize) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = KArray.length;
        for (int i = 0; i < n; ++i) {
            V v;
            K k = KArray[i];
            if (k == null || !((v = VArray[i]) == null ? ((ObjectMap)object).get(k, dummy) != null : !Intrinsics.areEqual(v, ((ObjectMap)object).get(k)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        ObjectMap cfr_ignored_0 = (ObjectMap)object;
        if (((ObjectMap)object).size() != this.mapSize) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = KArray.length;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            if (k == null || VArray[i] == ((ObjectMap)object).get(k, dummy)) continue;
            return false;
        }
        return true;
    }

    public final String toString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String string, boolean bl) {
        V v;
        K k;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (this.mapSize == 0) {
            return bl ? "{}" : "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            K k2 = KArray[n];
            if (k2 == null) continue;
            k = k2;
            stringBuilder.append((Object)(k == this ? "(this)" : k));
            stringBuilder.append('=');
            v = VArray[n];
            stringBuilder.append((Object)(v == this ? "(this)" : v));
            break;
        }
        while (n-- > 0) {
            if (KArray[n] == null) continue;
            stringBuilder.append(string);
            stringBuilder.append((Object)(k == this ? "(this)" : k));
            stringBuilder.append('=');
            v = VArray[n];
            stringBuilder.append((Object)(v == this ? "(this)" : v));
        }
        if (bl) {
            stringBuilder.append('}');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public Set<Map.Entry<K, V>> getEntries() {
        Entries<K, V> entries = this.entries();
        Intrinsics.checkNotNull(entries);
        return TypeIntrinsics.asMutableSet(entries);
    }

    public Entries<K, V> entries() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K, V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<K, V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<K, V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<K, V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<K, V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        Entries<K, V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<K, V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<K, V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<K, V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    public Values<V> values() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5);
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9);
        return values9;
    }

    public Set<K> getKeys() {
        return this.keys();
    }

    public Keys<K> keys() {
        if (this.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.reset();
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.reset();
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Override
    public final Set<K> keySet() {
        return this.getKeys();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/collections/ObjectMap$Companion;", "", "()V", "dummy", "getDummy$Collections", "()Ljava/lang/Object;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final Object getDummy$Collections() {
            return dummy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u00042$\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u0003\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u0006B\u001b\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\u0016\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001f\u0010\u001b\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J$\u0010\u001c\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J\t\u0010\u001d\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0017\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0000H\u0096\u0002J\u0017\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J\u001e\u0010!\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\"\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J$\u0010#\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016R*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u0003\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Ldorkbox/collections/ObjectMap$Entries;", "K", "", "V", "", "Ldorkbox/collections/ObjectMap$Entry;", "Ldorkbox/collections/ObjectMap$MapIterator;", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "entry", "getEntry$Collections", "()Ldorkbox/collections/ObjectMap$Entry;", "setEntry$Collections", "(Ldorkbox/collections/ObjectMap$Entry;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>>
    implements Set<Entry<K, V>>,
    KMutableSet {
        private Entry<K, V> entry;

        public Entries(ObjectMap<K, V> objectMap) {
            Intrinsics.checkNotNullParameter(objectMap, (String)"");
            super(objectMap);
        }

        public final Entry<K, V> getEntry$Collections() {
            return this.entry;
        }

        public final void setEntry$Collections(Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public Entry<K, V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.getMap().getKeyTable();
            if (this.entry == null) {
                Object k = KArray[this.getNextIndex()];
                Intrinsics.checkNotNull(k);
                this.entry = new Entry(k, this.getMap().getValueTable()[this.getNextIndex()], this.getMap());
            } else {
                Entry entry = this.entry;
                Intrinsics.checkNotNull(entry);
                Object k = KArray[this.getNextIndex()];
                Intrinsics.checkNotNull(k);
                entry.setKey(k);
                Entry entry2 = this.entry;
                Intrinsics.checkNotNull(entry2);
                entry2.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Entry<K, V> entry = this.entry;
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Entry<K, V>> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                this.getMap().put(entry.getKey(), entry.getValue());
                bl = true;
            }
            return bl;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl2 = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.getMap().get(k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            return Intrinsics.areEqual(this.getMap().get(entry.getKey()), entry.getValue());
        }

        public Entries<K, V> iterator() {
            Intrinsics.checkNotNull((Object)this);
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            K[] KArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = KArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl3;
                Object v0;
                Object k;
                block2: {
                    Object k2;
                    k = k2 = KArray[i];
                    boolean bl4 = false;
                    if (k == null) continue;
                    Iterable iterable = collection;
                    boolean bl5 = false;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual(entry.getKey(), k)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                boolean bl7 = bl3 = v0 != null;
                if (bl3) continue;
                bl = this.getMap().remove(k) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                Object k = ((Map.Entry)entry).getKey();
                bl = this.getMap().remove(k) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            ObjectMap objectMap = this.getMap();
            Entry<K, V> entry2 = this.entry;
            Intrinsics.checkNotNull(entry2);
            boolean bl = objectMap.remove(entry2.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004B+\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u0012\u001a\u0004\u0018\u00018\u00032\b\u0010\u0013\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0005\u001a\u00028\u0002X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0003X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/ObjectMap$Entry;", "K", "", "V", "", "key", "value", "map", "Ldorkbox/collections/ObjectMap;", "(Ljava/lang/Object;Ljava/lang/Object;Ldorkbox/collections/ObjectMap;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ObjectMap;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        private final ObjectMap<K, V> map;
        private K key;
        private V value;

        public Entry(K k, V v, ObjectMap<K, V> objectMap) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            Intrinsics.checkNotNullParameter(objectMap, (String)"");
            this.map = objectMap;
            this.key = k;
            this.value = v;
        }

        public final ObjectMap<K, V> getMap() {
            return this.map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            this.key = k;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(V v) {
            this.value = v;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.getValue();
            ((Map)this.map).put(this.getKey(), v);
            this.setValue(v);
            return v2;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00020 H\u0016\u00a2\u0006\u0002\u0010!J)\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \"\b\b\u0003\u0010\"*\u00028\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectMap$Keys;", "K", "", "", "Ldorkbox/collections/ObjectMap$MapIterator;", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    public static class Keys<K>
    extends MapIterator<K, Object, K>
    implements Set<K>,
    KMutableSet {
        public Keys(ObjectMap<K, ?> objectMap) {
            Intrinsics.checkNotNullParameter(objectMap, (String)"");
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public K next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Object k2 = k;
            Intrinsics.checkNotNull(k2);
            return k2;
        }

        @Override
        public boolean add(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl2 = false;
                if (this.getMap().containsKey(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            return this.getMap().containsKey(object);
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            K[] KArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = KArray.length;
            for (int i = 0; i < n; ++i) {
                Object k;
                Object k2 = k = KArray[i];
                boolean bl3 = false;
                if (k2 == null || collection.contains(k2)) continue;
                this.getMap().remove(k2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl3 = false;
                if (this.getMap().remove(t2) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            boolean bl = this.getMap().remove(object) == null;
            this.reset();
            return bl;
        }

        @Override
        public K[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public final <T extends K> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                int n2 = n++;
                K k = this.next();
                Intrinsics.checkNotNull(k);
                TArray[n2] = k;
            }
            return TArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u0003*\u0004\b\u0004\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00040\u0005B\u001b\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000eR\u001a\u0010\u001a\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006!"}, d2={"Ldorkbox/collections/ObjectMap$MapIterator;", "K", "", "V", "I", "", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/ObjectMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Collections"})
    public static abstract class MapIterator<K, V, I>
    implements Iterator<I>,
    KMutableIterator {
        private final ObjectMap<K, V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public MapIterator(ObjectMap<K, V> objectMap) {
            Intrinsics.checkNotNullParameter(objectMap, (String)"");
            this.map = objectMap;
            this.valid = true;
            this.reset();
        }

        public final ObjectMap<K, V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                K[] KArray = this.map.getKeyTable();
                int n = KArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int n = this.currentIndex;
            if (!(n >= 0)) {
                boolean bl = false;
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            K[] KArray = this.map.getKeyTable();
            V[] VArray = this.map.getValueTable();
            int n2 = this.map.getMask();
            int n3 = n + 1 & n2;
            Object var6_8 = null;
            while (true) {
                object = KArray[n3];
                K k = object;
                boolean bl = false;
                var6_8 = k;
                if (object == null) break;
                Object v0 = var6_8;
                Intrinsics.checkNotNull(v0);
                int n4 = this.map.place(v0);
                if ((n3 - n4 & n2) > (n - n4 & n2)) {
                    KArray[n] = var6_8;
                    VArray[n] = VArray[n3];
                    n = n3;
                }
                n3 = n3 + 1 & n2;
            }
            KArray[n] = null;
            VArray[n] = null;
            object = this.map;
            int n5 = ((ObjectMap)object).getMapSize();
            ((ObjectMap)object).setMapSize(n5 + -1);
            if (n != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0015\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020 H\u0016\u00a2\u0006\u0002\u0010!J-\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\"0 \"\b\b\u0003\u0010\"*\u00028\u00022\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectMap$Values;", "V", "", "Ldorkbox/collections/ObjectMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    public static class Values<V>
    extends MapIterator<Object, V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(ObjectMap<?, V> objectMap) {
            Intrinsics.checkNotNullParameter(objectMap, (String)"");
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Object v2 = v;
            Intrinsics.checkNotNull(v2);
            return v2;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V v) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl2 = false;
                if (this.getMap().containsValue(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return this.getMap().containsValue(object);
        }

        @Override
        public Values<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            K[] KArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = KArray.length;
            for (int i = 0; i < n; ++i) {
                Object v;
                Object k;
                Object k2 = k = KArray[i];
                boolean bl3 = false;
                if (k2 == null || CollectionsKt.contains((Iterable)collection, v = this.getMap().get(k2))) continue;
                this.getMap().remove(k2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl3 = false;
                Object k = this.getMap().findKey(t2, false);
                if (k == null) continue;
                bl = this.getMap().remove(k) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            Object k = this.getMap().findKey(object, false);
            if (k != null) {
                bl = this.getMap().remove(k) != null;
            }
            this.reset();
            return bl;
        }

        @Override
        public V[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public final <T extends V> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                TArray[n++] = this.next();
            }
            return TArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }
    }
}

