/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob.element;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.ContentId;

public class BoBDataExtension
implements ExtensionElement {
    public static final String ELEMENT = "data";
    public static final String NAMESPACE = "urn:xmpp:bob";
    private final ContentId cid;
    private final BoBData bobData;

    public BoBDataExtension(ContentId contentId, BoBData boBData) {
        this.cid = (ContentId)Objects.requireNonNull((Object)contentId);
        this.bobData = (BoBData)Objects.requireNonNull((Object)boBData);
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public final ContentId getContentId() {
        return this.cid;
    }

    public final BoBData getBobData() {
        return this.bobData;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((ExtensionElement)this);
        xmlStringBuilder.attribute("cid", this.cid.getCid());
        xmlStringBuilder.attribute("type", this.bobData.getType());
        xmlStringBuilder.optAttribute("max-age", (Number)this.bobData.getMaxAge());
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.append((CharSequence)this.bobData.getContentBase64Encoded());
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public static BoBDataExtension from(StanzaView stanzaView) {
        return (BoBDataExtension)stanzaView.getExtension(BoBDataExtension.class);
    }
}

