/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;

class CloseListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected CloseListener(InBandBytestreamManager inBandBytestreamManager) {
        super("close", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = inBandBytestreamManager;
    }

    public IQ handleIQRequest(IQ iQ) {
        Close close = (Close)iQ;
        InBandBytestreamSession inBandBytestreamSession = this.manager.getSessions().get(close.getSessionID());
        if (inBandBytestreamSession == null) {
            try {
                this.manager.replyItemNotFoundPacket(close);
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                return null;
            }
        }
        try {
            inBandBytestreamSession.closeByPeer(close);
        }
        catch (InterruptedException | SmackException.NotConnectedException throwable) {
            return null;
        }
        this.manager.getSessions().remove(close.getSessionID());
        return null;
    }
}

