/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.e;
import org.e.a.i;
import org.e.c.a.a;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.internal.AbstractStats;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.ExtendedAppendable;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class ServiceDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServiceDiscoveryManager.class.getName());
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static final List<DiscoInfoLookupShortcutMechanism> discoInfoLookupShortcutMechanisms = new ArrayList<DiscoInfoLookupShortcutMechanism>(2);
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private final Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private final Set<EntityCapabilitiesChangedListener> entityCapabilitiesChangedListeners = new CopyOnWriteArraySet<EntityCapabilitiesChangedListener>();
    private static final Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private List<DataForm> extendedInfos = new ArrayList<DataForm>(2);
    private final Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private volatile Presence presenceSend;
    private final a<String, List<DiscoverInfo>> services = new org.e.c.a.b(25, 86400000L);
    private static final int RENEW_ENTITY_CAPS_DELAY_MILLIS = 25;
    private ScheduledAction renewEntityCapsScheduledAction;
    private final AtomicInteger renewEntityCapsPerformed = new AtomicInteger();
    private int renewEntityCapsRequested = 0;
    private int scheduledRenewEntityCapsAvoided = 0;

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                DiscoverItems discoverItems = (DiscoverItems)iQ;
                DiscoverItems discoverItems2 = new DiscoverItems();
                discoverItems2.setType(IQ.Type.result);
                discoverItems2.setTo(discoverItems.getFrom());
                discoverItems2.setStanzaId(discoverItems.getStanzaId());
                discoverItems2.setNode(discoverItems.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                if (nodeInformationProvider != null) {
                    discoverItems2.addItems(nodeInformationProvider.getNodeItems());
                    discoverItems2.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (discoverItems.getNode() != null) {
                    discoverItems2.setType(IQ.Type.error);
                    discoverItems2.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found).build());
                }
                return discoverItems2;
            }
        });
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                Object object;
                DiscoverInfo discoverInfo = (DiscoverInfo)iQ;
                DiscoverInfoBuilder discoverInfoBuilder = DiscoverInfoBuilder.buildResponseFor(discoverInfo, IQ.ResponseType.result);
                if (discoverInfo.getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(discoverInfoBuilder);
                } else {
                    object = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                    if (object != null) {
                        discoverInfoBuilder.addFeatures(object.getNodeFeatures());
                        discoverInfoBuilder.addIdentities(object.getNodeIdentities());
                        discoverInfoBuilder.addOptExtensions(object.getNodePacketExtensions());
                    } else {
                        discoverInfoBuilder.ofType(IQ.Type.error);
                        discoverInfoBuilder.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found).build());
                    }
                }
                object = discoverInfoBuilder.build();
                return object;
            }
        });
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!bl) {
                    ServiceDiscoveryManager.this.presenceSend = null;
                }
            }
        });
        xMPPConnection.addStanzaSendingListener(stanza -> {
            this.presenceSend = (Presence)stanza;
        }, PresenceTypeFilter.OUTGOING_PRESENCE_BROADCAST);
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public synchronized void setIdentity(DiscoverInfo.Identity identity) {
        this.identity = (DiscoverInfo.Identity)Objects.requireNonNull((Object)identity, (String)"Identity can not be null");
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public synchronized void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> hashSet = new HashSet<DiscoverInfo.Identity>(this.identities);
        hashSet.add(this.identity);
        return Collections.unmodifiableSet(hashSet);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = instances.get(xMPPConnection);
        if (serviceDiscoveryManager == null) {
            serviceDiscoveryManager = new ServiceDiscoveryManager(xMPPConnection);
            instances.put(xMPPConnection, serviceDiscoveryManager);
        }
        return serviceDiscoveryManager;
    }

    public synchronized void addDiscoverInfoTo(DiscoverInfoBuilder discoverInfoBuilder) {
        discoverInfoBuilder.addIdentities(this.getIdentities());
        for (String string : this.getFeatures()) {
            discoverInfoBuilder.addFeature(string);
        }
        discoverInfoBuilder.addExtensions(this.extendedInfos);
    }

    private NodeInformationProvider getNodeInformationProvider(String string) {
        if (string == null) {
            return null;
        }
        return this.nodeInformationProviders.get(string);
    }

    public void setNodeInformationProvider(String string, NodeInformationProvider nodeInformationProvider) {
        this.nodeInformationProviders.put(string, nodeInformationProvider);
    }

    public void removeNodeInformationProvider(String string) {
        this.nodeInformationProviders.remove(string);
    }

    public synchronized List<String> getFeatures() {
        return new ArrayList<String>(this.features);
    }

    public synchronized void addFeature(String string) {
        this.features.add(string);
        this.renewEntityCapsVersion();
    }

    public synchronized void removeFeature(String string) {
        this.features.remove(string);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean includesFeature(String string) {
        return this.features.contains(string);
    }

    @Deprecated
    public synchronized void setExtendedInfo(DataForm dataForm) {
        this.addExtendedInfo(dataForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataForm addExtendedInfo(DataForm dataForm) {
        DataForm dataForm2;
        String string = dataForm.getFormType();
        StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"The data form must have a form type set");
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            dataForm2 = DataForm.remove(this.extendedInfos, string);
            this.extendedInfos.add(dataForm);
            this.renewEntityCapsVersion();
        }
        return dataForm2;
    }

    public synchronized void removeExtendedInfo(String string) {
        DataForm dataForm = DataForm.remove(this.extendedInfos, string);
        if (dataForm != null) {
            this.renewEntityCapsVersion();
        }
    }

    public synchronized List<DataForm> getExtendedInfo() {
        return CollectionUtil.newListWith(this.extendedInfos);
    }

    @Deprecated
    public List<DataForm> getExtendedInfoAsList() {
        return this.getExtendedInfo();
    }

    public synchronized void removeExtendedInfo() {
        int n = this.extendedInfos.size();
        this.extendedInfos.clear();
        if (n > 0) {
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo discoverInfo(i i2) {
        if (i2 == null) {
            return this.discoverInfo(null, null);
        }
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            for (DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism : discoInfoLookupShortcutMechanisms) {
                DiscoverInfo discoverInfo = discoInfoLookupShortcutMechanism.getDiscoverInfoByUser(this, i2);
                if (discoverInfo == null) continue;
                return discoverInfo;
            }
        }
        return this.discoverInfo(i2, null);
    }

    public DiscoverInfo discoverInfo(i i2, String string) {
        XMPPConnection xMPPConnection = this.connection();
        DiscoverInfo discoverInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder(xMPPConnection).to(i2)).setNode(string).build();
        Stanza stanza = xMPPConnection.createStanzaCollectorAndSend((IQ)discoverInfo).nextResultOrThrow();
        return (DiscoverInfo)stanza;
    }

    public DiscoverItems discoverItems(i i2) {
        return this.discoverItems(i2, null);
    }

    public DiscoverItems discoverItems(i i2, String string) {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setType(IQ.Type.get);
        discoverItems.setTo(i2);
        discoverItems.setNode(string);
        Stanza stanza = this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
        return (DiscoverItems)stanza;
    }

    public boolean serverSupportsFeature(CharSequence charSequence) {
        return this.serverSupportsFeatures(charSequence);
    }

    public boolean serverSupportsFeatures(CharSequence ... charSequenceArray) {
        return this.serverSupportsFeatures(Arrays.asList(charSequenceArray));
    }

    public boolean serverSupportsFeatures(Collection<? extends CharSequence> collection) {
        return this.supportsFeatures((i)this.connection().getXMPPServiceDomain(), collection);
    }

    public boolean accountSupportsFeatures(CharSequence ... charSequenceArray) {
        return this.accountSupportsFeatures(Arrays.asList(charSequenceArray));
    }

    public boolean accountSupportsFeatures(Collection<? extends CharSequence> collection) {
        e e2 = this.connection().getUser().b();
        return this.supportsFeatures((i)e2, collection);
    }

    public boolean supportsFeature(i i2, CharSequence charSequence) {
        return this.supportsFeatures(i2, charSequence);
    }

    public boolean supportsFeatures(i i2, CharSequence ... charSequenceArray) {
        return this.supportsFeatures(i2, Arrays.asList(charSequenceArray));
    }

    public boolean supportsFeatures(i i2, Collection<? extends CharSequence> collection) {
        DiscoverInfo discoverInfo = this.discoverInfo(i2);
        for (CharSequence charSequence : collection) {
            if (discoverInfo.containsFeature(charSequence)) continue;
            return false;
        }
        return true;
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String string, boolean bl, boolean bl2) {
        return this.findServicesDiscoverInfo(string, bl, bl2, null);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String string, boolean bl, boolean bl2, Map<? super i, Exception> map) {
        b b2 = this.connection().getXMPPServiceDomain();
        return this.findServicesDiscoverInfo(b2, string, bl, bl2, map);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(b b2, String string, boolean bl, boolean bl2, Map<? super i, Exception> map) {
        DiscoverItems discoverItems;
        DiscoverInfo discoverInfo;
        LinkedList<DiscoverInfo> linkedList;
        if (bl2 && (linkedList = (List)this.services.a((Object)string)) != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        try {
            discoverInfo = this.discoverInfo((i)b2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (map != null) {
                map.put((i)b2, (Exception)((Object)xMPPErrorException));
            }
            return linkedList;
        }
        if (discoverInfo.containsFeature(string)) {
            linkedList.add(discoverInfo);
            if (bl) {
                if (bl2) {
                    this.services.put((Object)string, linkedList);
                }
                return linkedList;
            }
        }
        try {
            discoverItems = this.discoverItems((i)b2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (map != null) {
                map.put((i)b2, (Exception)((Object)xMPPErrorException));
            }
            return linkedList;
        }
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            i i2 = item.getEntityID();
            try {
                discoverInfo = this.discoverInfo(i2);
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
                if (map == null) continue;
                map.put((i)i2, (Exception)throwable);
                continue;
            }
            if (!discoverInfo.containsFeature(string)) continue;
            linkedList.add(discoverInfo);
            if (!bl) continue;
            break;
        }
        if (bl2) {
            this.services.put((Object)string, linkedList);
        }
        return linkedList;
    }

    public List<b> findServices(String string, boolean bl, boolean bl2) {
        List<DiscoverInfo> list = this.findServicesDiscoverInfo(string, bl, bl2);
        ArrayList<b> arrayList = new ArrayList<b>(list.size());
        for (DiscoverInfo discoverInfo : list) {
            arrayList.add(discoverInfo.getFrom().v());
        }
        return arrayList;
    }

    public b findService(String string, boolean bl, String string2, String string3) {
        boolean bl2 = StringUtils.isNullOrEmpty((CharSequence)string2);
        boolean bl3 = StringUtils.isNullOrEmpty((CharSequence)string3);
        if (bl3 != bl2) {
            throw new IllegalArgumentException("Must specify either both, category and type, or none");
        }
        List<DiscoverInfo> list = this.findServicesDiscoverInfo(string, false, bl);
        if (list.isEmpty()) {
            return null;
        }
        if (!bl2 && !bl3) {
            for (DiscoverInfo discoverInfo : list) {
                if (!discoverInfo.hasIdentity(string2, string3)) continue;
                return discoverInfo.getFrom().v();
            }
        }
        return list.get(0).getFrom().v();
    }

    public b findService(String string, boolean bl) {
        return this.findService(string, bl, null, null);
    }

    public boolean addEntityCapabilitiesChangedListener(EntityCapabilitiesChangedListener entityCapabilitiesChangedListener) {
        return this.entityCapabilitiesChangedListeners.add(entityCapabilitiesChangedListener);
    }

    private synchronized void renewEntityCapsVersion() {
        boolean bl;
        if (this.entityCapabilitiesChangedListeners.isEmpty()) {
            return;
        }
        ++this.renewEntityCapsRequested;
        if (this.renewEntityCapsScheduledAction != null && (bl = this.renewEntityCapsScheduledAction.cancel())) {
            ++this.scheduledRenewEntityCapsAvoided;
        }
        this.renewEntityCapsScheduledAction = ServiceDiscoveryManager.scheduleBlocking(() -> {
            XMPPConnection xMPPConnection = this.connection();
            if (xMPPConnection == null) {
                return;
            }
            this.renewEntityCapsPerformed.incrementAndGet();
            DiscoverInfoBuilder discoverInfoBuilder = (DiscoverInfoBuilder)DiscoverInfo.builder("synthetized-disco-info-response").ofType(IQ.Type.result);
            this.addDiscoverInfoTo(discoverInfoBuilder);
            DiscoverInfo discoverInfo = discoverInfoBuilder.build();
            for (EntityCapabilitiesChangedListener entityCapabilitiesChangedListener : this.entityCapabilitiesChangedListeners) {
                entityCapabilitiesChangedListener.onEntityCapabilitiesChanged(discoverInfo);
            }
            Presence presence = this.presenceSend;
            if (xMPPConnection.isAuthenticated() && presence != null) {
                EntityCapabilitiesChangedListener entityCapabilitiesChangedListener;
                entityCapabilitiesChangedListener = presence.asBuilder(xMPPConnection).build();
                try {
                    xMPPConnection.sendStanza((Stanza)entityCapabilitiesChangedListener);
                }
                catch (InterruptedException | SmackException.NotConnectedException throwable) {
                    LOGGER.log(Level.WARNING, "Could could not update presence with caps info", throwable);
                }
            }
        }, (long)25L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.add(discoInfoLookupShortcutMechanism);
            Collections.sort(discoInfoLookupShortcutMechanisms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.remove(discoInfoLookupShortcutMechanism);
        }
    }

    public synchronized Stats getStats() {
        return new Stats(this);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
            }
        });
    }

    public static final class Stats
    extends AbstractStats {
        public final int renewEntityCapsRequested;
        public final int renewEntityCapsPerformed;
        public final int scheduledRenewEntityCapsAvoided;

        private Stats(ServiceDiscoveryManager serviceDiscoveryManager) {
            this.renewEntityCapsRequested = serviceDiscoveryManager.renewEntityCapsRequested;
            this.renewEntityCapsPerformed = serviceDiscoveryManager.renewEntityCapsPerformed.get();
            this.scheduledRenewEntityCapsAvoided = serviceDiscoveryManager.scheduledRenewEntityCapsAvoided;
        }

        public void appendStatsTo(ExtendedAppendable extendedAppendable) {
            StringUtils.appendHeading((Appendable)extendedAppendable, (String)"ServiceDiscoveryManager stats", (char)'#').append('\n');
            extendedAppendable.append((CharSequence)"renew-entitycaps-requested: ").append(this.renewEntityCapsRequested).append('\n');
            extendedAppendable.append((CharSequence)"renew-entitycaps-performed: ").append(this.renewEntityCapsPerformed).append('\n');
            extendedAppendable.append((CharSequence)"scheduled-renew-entitycaps-avoided: ").append(this.scheduledRenewEntityCapsAvoided).append('\n');
        }
    }
}

