/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferException;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class FileTransferNegotiator
extends Manager {
    public static final String SI_NAMESPACE = "http://jabber.org/protocol/si";
    public static final String SI_PROFILE_FILE_TRANSFER_NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer"};
    private static final Map<XMPPConnection, FileTransferNegotiator> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator;
    public static boolean IBB_ONLY;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static synchronized FileTransferNegotiator getInstanceFor(XMPPConnection xMPPConnection) {
        FileTransferNegotiator fileTransferNegotiator = INSTANCES.get(xMPPConnection);
        if (fileTransferNegotiator == null) {
            fileTransferNegotiator = new FileTransferNegotiator(xMPPConnection);
            INSTANCES.put(xMPPConnection, fileTransferNegotiator);
        }
        return fileTransferNegotiator;
    }

    private static void setServiceEnabled(XMPPConnection xMPPConnection, boolean bl) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(NAMESPACE));
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        for (String string : arrayList) {
            if (bl) {
                serviceDiscoveryManager.addFeature(string);
                continue;
            }
            serviceDiscoveryManager.removeFeature(string);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(NAMESPACE));
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        for (String string : arrayList) {
            if (serviceDiscoveryManager.includesFeature(string)) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(arrayList);
    }

    private FileTransferNegotiator(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.byteStreamTransferManager = new Socks5TransferNegotiator(xMPPConnection);
        this.inbandTransferManager = new IBBTransferNegotiator(xMPPConnection);
        FileTransferNegotiator.setServiceEnabled(xMPPConnection, true);
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest fileTransferRequest) {
        StreamNegotiator streamNegotiator;
        StreamInitiation streamInitiation = fileTransferRequest.getStreamInitiation();
        ListSingleFormField listSingleFormField = FileTransferNegotiator.getStreamMethodField(streamInitiation.getFeatureNegotiationForm());
        if (listSingleFormField == null) {
            String string = "No stream methods contained in stanza.";
            StanzaError stanzaError = StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)string).build();
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)streamInitiation, (StanzaError)stanzaError);
            this.connection().sendStanza((Stanza)errorIQ);
            throw new FileTransferException.NoStreamMethodsOfferedException();
        }
        try {
            streamNegotiator = this.getNegotiator(listSingleFormField);
        }
        catch (FileTransferException.NoAcceptableTransferMechanisms noAcceptableTransferMechanisms) {
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)streamInitiation, (StanzaError)StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"No acceptable transfer mechanism").build());
            this.connection().sendStanza((Stanza)errorIQ);
            throw noAcceptableTransferMechanisms;
        }
        return streamNegotiator;
    }

    private static ListSingleFormField getStreamMethodField(DataForm dataForm) {
        return (ListSingleFormField)dataForm.getField(STREAM_DATA_FIELD_NAME);
    }

    private StreamNegotiator getNegotiator(ListSingleFormField listSingleFormField) {
        boolean bl = false;
        boolean bl2 = false;
        for (FormField.Option option : listSingleFormField.getOptions()) {
            String string = option.getValueString();
            if (string.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public static String getNextStreamID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STREAM_INIT_PREFIX);
        stringBuilder.append(randomGenerator.nextInt(Integer.MAX_VALUE) + randomGenerator.nextInt(Integer.MAX_VALUE));
        return stringBuilder.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(i i2, String string, String string2, long l, String string3, int n) {
        StreamInitiation streamInitiation = new StreamInitiation();
        streamInitiation.setSessionID(string);
        streamInitiation.setMimeType(URLConnection.guessContentTypeFromName(string2));
        StreamInitiation.File file = new StreamInitiation.File(string2, l);
        file.setDesc(string3);
        streamInitiation.setFile(file);
        streamInitiation.setFeatureNegotiationForm(FileTransferNegotiator.createDefaultInitiationForm());
        streamInitiation.setFrom((i)this.connection().getUser());
        streamInitiation.setTo(i2);
        streamInitiation.setType(IQ.Type.set);
        Stanza stanza = this.connection().createStanzaCollectorAndSend((IQ)streamInitiation).nextResultOrThrow((long)n);
        if (stanza instanceof IQ) {
            IQ iQ = (IQ)stanza;
            if (iQ.getType().equals((Object)IQ.Type.result)) {
                StreamInitiation streamInitiation2 = (StreamInitiation)stanza;
                return this.getOutgoingNegotiator(FileTransferNegotiator.getStreamMethodField(streamInitiation2.getFeatureNegotiationForm()));
            }
            throw new XMPPException.XMPPErrorException((Stanza)iQ, iQ.getError());
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField formField) {
        boolean bl = false;
        boolean bl2 = false;
        for (CharSequence charSequence : formField.getValues()) {
            String string = charSequence.toString();
            if (string.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private static DataForm createDefaultInitiationForm() {
        DataForm.Builder builder = DataForm.builder(DataForm.Type.form);
        ListSingleFormField.Builder builder2 = FormField.listSingleBuilder(STREAM_DATA_FIELD_NAME);
        if (!IBB_ONLY) {
            builder2.addOption("http://jabber.org/protocol/bytestreams");
        }
        builder2.addOption("http://jabber.org/protocol/ibb");
        builder.addField(builder2.build());
        return builder.build();
    }

    static {
        FormFieldRegistry.addLookasideFieldRegistryEntry(STREAM_DATA_FIELD_NAME, FormField.Type.list_single);
        randomGenerator = new Random();
        IBB_ONLY = System.getProperty("ibb") != null;
    }
}

