/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc;

import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.geoloc.provider.GeoLocationProvider;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;

public final class GeoLocationManager
extends Manager {
    public static final String GEOLOCATION_NODE = "http://jabber.org/protocol/geoloc";
    private static final Map<XMPPConnection, GeoLocationManager> INSTANCES = new WeakHashMap<XMPPConnection, GeoLocationManager>();
    private final PepManager pepManager;

    public static synchronized GeoLocationManager getInstanceFor(XMPPConnection xMPPConnection) {
        GeoLocationManager geoLocationManager = INSTANCES.get(xMPPConnection);
        if (geoLocationManager == null) {
            geoLocationManager = new GeoLocationManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, geoLocationManager);
        }
        return geoLocationManager;
    }

    private GeoLocationManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.pepManager = PepManager.getInstanceFor(xMPPConnection);
    }

    public void sendGeoLocationToJid(GeoLocation geoLocation, i i2) {
        XMPPConnection xMPPConnection = this.connection();
        Message message = ((MessageBuilder)((MessageBuilder)xMPPConnection.getStanzaFactory().buildMessageStanza().to(i2)).addExtension((ExtensionElement)geoLocation)).build();
        xMPPConnection.sendStanza((Stanza)message);
    }

    public static boolean isGeoLocationMessage(Message message) {
        return GeoLocation.from(message) != null;
    }

    public void publishGeoLocation(GeoLocation geoLocation) {
        this.pepManager.publish(GEOLOCATION_NODE, new PayloadItem<GeoLocation>(geoLocation));
    }

    public void stopPublishingGeolocation() {
        this.pepManager.publish(GEOLOCATION_NODE, new PayloadItem<GeoLocation>(GeoLocation.EMPTY_GEO_LOCATION));
    }

    public boolean addGeoLocationListener(PepEventListener<GeoLocation> pepEventListener) {
        return this.pepManager.addPepEventListener(GEOLOCATION_NODE, GeoLocation.class, pepEventListener);
    }

    public boolean removeGeoLocationListener(PepEventListener<GeoLocation> pepEventListener) {
        return this.pepManager.removePepEventListener(pepEventListener);
    }

    static {
        FormFieldChildElementProviderManager.addFormFieldChildElementProvider(GeoLocationProvider.GeoLocationFormFieldChildElementProvider.INSTANCE);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                GeoLocationManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

