/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.provider;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;

public class GeoLocationProvider
extends ExtensionElementProvider<GeoLocation> {
    public static final GeoLocationProvider INSTANCE = new GeoLocationProvider();

    /*
     * Enabled aggressive block sorting
     */
    public GeoLocation parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        GeoLocation.Builder builder = GeoLocation.builder();
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "accuracy": {
                            builder.setAccuracy(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "alt": {
                            builder.setAlt(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "altaccuracy": {
                            builder.setAltAccuracy(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "area": {
                            builder.setArea(xmlPullParser.nextText());
                            break block0;
                        }
                        case "bearing": {
                            builder.setBearing(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "building": {
                            builder.setBuilding(xmlPullParser.nextText());
                            break block0;
                        }
                        case "country": {
                            builder.setCountry(xmlPullParser.nextText());
                            break block0;
                        }
                        case "countrycode": {
                            builder.setCountryCode(xmlPullParser.nextText());
                            break block0;
                        }
                        case "datum": {
                            builder.setDatum(xmlPullParser.nextText());
                            break block0;
                        }
                        case "description": {
                            builder.setDescription(xmlPullParser.nextText());
                            break block0;
                        }
                        case "error": {
                            GeoLocationProvider.parseError(builder, xmlPullParser);
                            break block0;
                        }
                        case "floor": {
                            builder.setFloor(xmlPullParser.nextText());
                            break block0;
                        }
                        case "lat": {
                            builder.setLat(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "locality": {
                            builder.setLocality(xmlPullParser.nextText());
                            break block0;
                        }
                        case "lon": {
                            builder.setLon(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "postalcode": {
                            builder.setPostalcode(xmlPullParser.nextText());
                            break block0;
                        }
                        case "region": {
                            builder.setRegion(xmlPullParser.nextText());
                            break block0;
                        }
                        case "room": {
                            builder.setRoom(xmlPullParser.nextText());
                            break block0;
                        }
                        case "speed": {
                            builder.setSpeed(ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "street": {
                            builder.setStreet(xmlPullParser.nextText());
                            break block0;
                        }
                        case "text": {
                            builder.setText(xmlPullParser.nextText());
                            break block0;
                        }
                        case "timestamp": {
                            builder.setTimestamp(ParserUtils.getDateFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                        case "tzo": {
                            builder.setTzo(xmlPullParser.nextText());
                            break block0;
                        }
                        case "uri": {
                            builder.setUri(ParserUtils.getUriFromNextText((XmlPullParser)xmlPullParser));
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return builder.build();
                }
            }
        }
    }

    private static void parseError(GeoLocation.Builder builder, XmlPullParser xmlPullParser) {
        double d2 = ParserUtils.getDoubleFromNextText((XmlPullParser)xmlPullParser);
        builder.setError(d2);
    }

    public static class GeoLocationFormFieldChildElementProvider
    extends FormFieldChildElementProvider<GeoLocation> {
        public static final GeoLocationFormFieldChildElementProvider INSTANCE = new GeoLocationFormFieldChildElementProvider();

        @Override
        public QName getQName() {
            return GeoLocation.QNAME;
        }

        public GeoLocation parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
            return INSTANCE.parse(xmlPullParser, n, xmlEnvironment);
        }
    }
}

