/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateDataIQ;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;

public final class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static final Map<QName, PrivateDataProvider> privateDataProviders = new HashMap<QName, PrivateDataProvider>();
    private static final PrivateData DUMMY_PRIVATE_DATA = new PrivateData(){

        @Override
        public String getElementName() {
            return "smackDummyPrivateData";
        }

        @Override
        public String getNamespace() {
            return "https://igniterealtime.org/projects/smack";
        }

        @Override
        public CharSequence toXML() {
            return '<' + this.getElementName() + " xmlns='" + this.getNamespace() + "'/>";
        }
    };

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection xMPPConnection) {
        PrivateDataManager privateDataManager = instances.get(xMPPConnection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(xMPPConnection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String string, String string2) {
        QName qName = new QName(string2, string);
        return privateDataProviders.get(qName);
    }

    public static void addPrivateDataProvider(String string, String string2, PrivateDataProvider privateDataProvider) {
        QName qName = new QName(string2, string);
        privateDataProviders.put(qName, privateDataProvider);
    }

    public static void removePrivateDataProvider(String string, String string2) {
        QName qName = new QName(string2, string);
        privateDataProviders.remove(qName);
    }

    private PrivateDataManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        instances.put(xMPPConnection, this);
    }

    public PrivateData getPrivateData(String string, String string2) {
        PrivateDataIQ privateDataIQ = new PrivateDataIQ(string, string2);
        PrivateDataIQ privateDataIQ2 = (PrivateDataIQ)this.connection().createStanzaCollectorAndSend((IQ)privateDataIQ).nextResultOrThrow();
        return privateDataIQ2.getPrivateData();
    }

    public void setPrivateData(PrivateData privateData) {
        PrivateDataIQ privateDataIQ = new PrivateDataIQ(privateData);
        this.connection().createStanzaCollectorAndSend((IQ)privateDataIQ).nextResultOrThrow();
    }

    public boolean isSupported() {
        try {
            this.setPrivateData(DUMMY_PRIVATE_DATA);
            return true;
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return false;
            }
            throw xMPPErrorException;
        }
    }

    public static class PrivateDataIQProvider
    extends IQProvider<PrivateDataIQ> {
        public PrivateDataIQ parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
            PrivateData privateData = null;
            boolean bl = false;
            while (!bl) {
                XmlPullParser.Event event = xmlPullParser.next();
                if (event == XmlPullParser.Event.START_ELEMENT) {
                    String string;
                    String string2 = xmlPullParser.getName();
                    PrivateDataProvider privateDataProvider = PrivateDataManager.getPrivateDataProvider(string2, string = xmlPullParser.getNamespace());
                    if (privateDataProvider != null) {
                        privateData = privateDataProvider.parsePrivateData(xmlPullParser);
                        continue;
                    }
                    DefaultPrivateData defaultPrivateData = new DefaultPrivateData(string2, string);
                    boolean bl2 = false;
                    while (!bl2) {
                        XmlPullParser.Event event2 = xmlPullParser.next();
                        if (event2 == XmlPullParser.Event.START_ELEMENT) {
                            String string3 = xmlPullParser.getName();
                            event2 = xmlPullParser.next();
                            if (event2 == XmlPullParser.Event.TEXT_CHARACTERS) {
                                String string4 = xmlPullParser.getText();
                                defaultPrivateData.setValue(string3, string4);
                                continue;
                            }
                            if (event2 != XmlPullParser.Event.END_ELEMENT) continue;
                            defaultPrivateData.setValue(string3, "");
                            continue;
                        }
                        if (event2 != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals(string2)) continue;
                        bl2 = true;
                    }
                    privateData = defaultPrivateData;
                    continue;
                }
                if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            return new PrivateDataIQ(privateData);
        }
    }
}

