/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqregister;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.e.a.b.b;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqregister.packet.Registration;

public final class AccountManager
extends Manager {
    private static final Map<XMPPConnection, AccountManager> INSTANCES = new WeakHashMap<XMPPConnection, AccountManager>();
    private static boolean allowSensitiveOperationOverInsecureConnectionDefault = false;
    private boolean allowSensitiveOperationOverInsecureConnection = allowSensitiveOperationOverInsecureConnectionDefault;
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public static synchronized AccountManager getInstance(XMPPConnection xMPPConnection) {
        AccountManager accountManager = INSTANCES.get(xMPPConnection);
        if (accountManager == null) {
            accountManager = new AccountManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, accountManager);
        }
        return accountManager;
    }

    public static void sensitiveOperationOverInsecureConnectionDefault(boolean bl) {
        allowSensitiveOperationOverInsecureConnectionDefault = bl;
    }

    public void sensitiveOperationOverInsecureConnection(boolean bl) {
        this.allowSensitiveOperationOverInsecureConnection = bl;
    }

    private AccountManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
    }

    void setSupportsAccountCreation(boolean bl) {
        this.accountCreationSupported = bl;
    }

    public boolean supportsAccountCreation() {
        if (this.accountCreationSupported) {
            return true;
        }
        if (this.info == null) {
            this.getRegistrationInfo();
            this.accountCreationSupported = this.info.getType() != IQ.Type.error;
        }
        return this.accountCreationSupported;
    }

    public Set<String> getAccountAttributes() {
        Map<String, String> map;
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        if ((map = this.info.getAttributes()) != null) {
            return Collections.unmodifiableSet(map.keySet());
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String string) {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getAttributes().get(string);
    }

    public String getAccountInstructions() {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getInstructions();
    }

    public void createAccount(b b2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.getAccountAttributes()) {
            hashMap.put(string2, "");
        }
        this.createAccount(b2, string, hashMap);
    }

    public void createAccount(b b2, String string, Map<String, String> map) {
        if (!this.connection().isSecureConnection() && !this.allowSensitiveOperationOverInsecureConnection) {
            throw new IllegalStateException("Creating account over insecure connection");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("Username must not be null");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Password must not be null");
        }
        map.put("username", b2.toString());
        map.put("password", string);
        Registration registration = new Registration(map);
        registration.setType(IQ.Type.set);
        registration.setTo((i)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(registration).nextResultOrThrow();
    }

    public void changePassword(String string) {
        if (!this.connection().isSecureConnection() && !this.allowSensitiveOperationOverInsecureConnection) {
            throw new IllegalStateException("Changing password over insecure connection.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", this.connection().getUser().a().toString());
        hashMap.put("password", string);
        Registration registration = new Registration(hashMap);
        registration.setType(IQ.Type.set);
        registration.setTo((i)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(registration).nextResultOrThrow();
    }

    public void deleteAccount() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remove", "");
        Registration registration = new Registration(hashMap);
        registration.setType(IQ.Type.set);
        registration.setTo((i)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(registration).nextResultOrThrow();
    }

    public boolean isSupported() {
        XMPPConnection xMPPConnection = this.connection();
        ExtensionElement extensionElement = (ExtensionElement)xMPPConnection.getFeature(Registration.Feature.class);
        if (extensionElement != null) {
            return true;
        }
        if (xMPPConnection.isAuthenticated()) {
            return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).serverSupportsFeature("jabber:iq:register");
        }
        return false;
    }

    private synchronized void getRegistrationInfo() {
        Registration registration = new Registration();
        registration.setTo((i)this.connection().getXMPPServiceDomain());
        this.info = (Registration)this.createStanzaCollectorAndSend(registration).nextResultOrThrow();
    }

    private StanzaCollector createStanzaCollectorAndSend(IQ iQ) {
        return this.connection().createStanzaCollectorAndSend((StanzaFilter)new StanzaIdFilter(iQ.getStanzaId()), (Stanza)iQ);
    }
}

