/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;

public final class JingleContent
implements FullyQualifiedElement {
    public static final String ELEMENT = "content";
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String CREATOR_ATTRIBUTE_NAME = "creator";
    private final Creator creator;
    public static final String DISPOSITION_ATTRIBUTE_NAME = "disposition";
    private final String disposition;
    public static final String NAME_ATTRIBUTE_NAME = "name";
    private final String name;
    public static final String SENDERS_ATTRIBUTE_NAME = "senders";
    private final Senders senders;
    private final JingleContentDescription description;
    private final JingleContentTransport transport;

    private JingleContent(Creator creator, String string, String string2, Senders senders, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        this.creator = (Creator)((Object)Objects.requireNonNull((Object)((Object)creator), (String)"Jingle content creator must not be null"));
        this.disposition = string;
        this.name = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string2, (String)"Jingle content name must not be null nor empty");
        this.senders = senders;
        this.description = jingleContentDescription;
        this.transport = jingleContentTransport;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getName() {
        return this.name;
    }

    public Senders getSenders() {
        return this.senders;
    }

    public JingleContentDescription getDescription() {
        return this.description;
    }

    @Deprecated
    public JingleContentTransport getJingleTransport() {
        return this.getTransport();
    }

    public JingleContentTransport getTransport() {
        return this.transport;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlStringBuilder.attribute(CREATOR_ATTRIBUTE_NAME, (Enum)this.creator);
        xmlStringBuilder.optAttribute(DISPOSITION_ATTRIBUTE_NAME, this.disposition);
        xmlStringBuilder.attribute(NAME_ATTRIBUTE_NAME, this.name);
        xmlStringBuilder.optAttribute(SENDERS_ATTRIBUTE_NAME, (Enum)this.senders);
        if (this.description == null && this.transport == null) {
            return xmlStringBuilder.closeEmptyElement();
        }
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.optAppend((Element)this.description);
        xmlStringBuilder.optElement((Element)this.transport);
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Creator creator;
        private String disposition;
        private String name;
        private Senders senders;
        private JingleContentDescription description;
        private JingleContentTransport transport;

        private Builder() {
        }

        public Builder setCreator(Creator creator) {
            this.creator = creator;
            return this;
        }

        public Builder setDisposition(String string) {
            this.disposition = string;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setSenders(Senders senders) {
            this.senders = senders;
            return this;
        }

        public Builder setDescription(JingleContentDescription jingleContentDescription) {
            if (this.description != null) {
                throw new IllegalStateException("Jingle content description already set");
            }
            this.description = jingleContentDescription;
            return this;
        }

        public Builder setTransport(JingleContentTransport jingleContentTransport) {
            this.transport = jingleContentTransport;
            return this;
        }

        public JingleContent build() {
            return new JingleContent(this.creator, this.disposition, this.name, this.senders, this.description, this.transport);
        }
    }

    public static enum Senders {
        both,
        initiator,
        none,
        responder;

    }

    public static enum Creator {
        initiator,
        responder;

    }
}

