/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_ibb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.transports.JingleTransportInitiationCallback;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.JingleIBBTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.element.JingleIBBTransport;

public class JingleIBBTransportSession
extends JingleTransportSession<JingleIBBTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleIBBTransportSession.class.getName());
    private final JingleIBBTransportManager transportManager;

    public JingleIBBTransportSession(JingleSession jingleSession) {
        super(jingleSession);
        this.transportManager = JingleIBBTransportManager.getInstanceFor(jingleSession.getConnection());
    }

    @Override
    public JingleIBBTransport createTransport() {
        if (this.theirProposal == null) {
            return new JingleIBBTransport();
        }
        return new JingleIBBTransport(((JingleIBBTransport)this.theirProposal).getBlockSize(), ((JingleIBBTransport)this.theirProposal).getSessionId());
    }

    @Override
    public void setTheirProposal(JingleContentTransport jingleContentTransport) {
        this.theirProposal = (JingleIBBTransport)jingleContentTransport;
    }

    @Override
    public void initiateOutgoingSession(JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        LOGGER.log(Level.INFO, "Initiate Jingle InBandBytestream session.");
        try {
            InBandBytestreamSession inBandBytestreamSession = InBandBytestreamManager.getByteStreamManager(this.jingleSession.getConnection()).establishSession((i)this.jingleSession.getRemote(), ((JingleIBBTransport)this.theirProposal).getSessionId());
            jingleTransportInitiationCallback.onSessionInitiated(inBandBytestreamSession);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
            jingleTransportInitiationCallback.onException((Exception)throwable);
        }
    }

    @Override
    public void initiateIncomingSession(final JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        LOGGER.log(Level.INFO, "Await Jingle InBandBytestream session.");
        InBandBytestreamManager.getByteStreamManager(this.jingleSession.getConnection()).addIncomingBytestreamListener(new BytestreamListener(){

            @Override
            public void incomingBytestreamRequest(BytestreamRequest bytestreamRequest) {
                if (bytestreamRequest.getFrom().t().a((CharSequence)JingleIBBTransportSession.this.jingleSession.getRemote()) && bytestreamRequest.getSessionID().equals(((JingleIBBTransport)JingleIBBTransportSession.this.theirProposal).getSessionId())) {
                    BytestreamSession bytestreamSession;
                    try {
                        bytestreamSession = bytestreamRequest.accept();
                    }
                    catch (InterruptedException | SmackException | XMPPException.XMPPErrorException throwable) {
                        jingleTransportInitiationCallback.onException((Exception)throwable);
                        return;
                    }
                    jingleTransportInitiationCallback.onSessionInitiated(bytestreamSession);
                }
            }
        });
    }

    @Override
    public String getNamespace() {
        return this.transportManager.getNamespace();
    }

    @Override
    public IQ handleTransportInfo(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    @Override
    public JingleTransportManager<JingleIBBTransport> transportManager() {
        return JingleIBBTransportManager.getInstanceFor(this.jingleSession.getConnection());
    }
}

