/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider;

import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.provider.JingleContentTransportProvider;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransportProvider
extends JingleContentTransportProvider<JingleS5BTransport> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JingleS5BTransport parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        JingleS5BTransport.Builder builder = JingleS5BTransport.getBuilder();
        String string = xmlPullParser.getAttributeValue(null, "sid");
        builder.setStreamId(string);
        String string2 = xmlPullParser.getAttributeValue(null, "dstaddr");
        builder.setDestinationAddress(string2);
        String string3 = xmlPullParser.getAttributeValue(null, "mode");
        if (string3 != null) {
            builder.setMode(string3.equals(Bytestream.Mode.udp.toString()) ? Bytestream.Mode.udp : Bytestream.Mode.tcp);
        }
        while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            block0 : switch (tagEvent) {
                case START_ELEMENT: {
                    String string4;
                    switch (string4 = xmlPullParser.getName()) {
                        case "candidate": {
                            String string5;
                            JingleS5BTransportCandidate.Builder builder2 = JingleS5BTransportCandidate.getBuilder();
                            builder2.setCandidateId(xmlPullParser.getAttributeValue(null, "cid"));
                            builder2.setHost(ParserUtils.getInternetAddressIngoringZoneIdAttribute((XmlPullParser)xmlPullParser, (String)"host"));
                            builder2.setJid(xmlPullParser.getAttributeValue(null, "jid"));
                            builder2.setPriority(Integer.parseInt(xmlPullParser.getAttributeValue(null, "priority")));
                            String string6 = xmlPullParser.getAttributeValue(null, "port");
                            if (string6 != null) {
                                builder2.setPort(Integer.parseInt(string6));
                            }
                            if ((string5 = xmlPullParser.getAttributeValue(null, "type")) != null) {
                                builder2.setType(JingleS5BTransportCandidate.Type.fromString(string5));
                            }
                            builder.addTransportCandidate(builder2.build());
                            break block0;
                        }
                        case "activated": {
                            builder.setTransportInfo(new JingleS5BTransportInfo.CandidateActivated(xmlPullParser.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-used": {
                            builder.setTransportInfo(new JingleS5BTransportInfo.CandidateUsed(xmlPullParser.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-error": {
                            builder.setTransportInfo(JingleS5BTransportInfo.CandidateError.INSTANCE);
                            break block0;
                        }
                        case "proxy-error": {
                            builder.setTransportInfo(JingleS5BTransportInfo.ProxyError.INSTANCE);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return builder.build();
                }
            }
        }
    }
}

