/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.e.a.c.a;
import org.e.a.i;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;

public class MucConfigFormManager {
    private static final String HASH_ROOMCONFIG = "#roomconfig";
    public static final String FORM_TYPE = "http://jabber.org/protocol/muc#roomconfig";
    public static final String MUC_ROOMCONFIG_ROOMOWNERS = "muc#roomconfig_roomowners";
    public static final String MUC_ROOMCONFIG_MEMBERSONLY = "muc#roomconfig_membersonly";
    public static final String MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM = "muc#roomconfig_passwordprotectedroom";
    public static final String MUC_ROOMCONFIG_ROOMSECRET = "muc#roomconfig_roomsecret";
    private final MultiUserChat multiUserChat;
    private final FillableForm answerForm;
    private final List<i> owners;

    MucConfigFormManager(MultiUserChat multiUserChat) {
        this.multiUserChat = multiUserChat;
        Form form = multiUserChat.getConfigurationForm();
        this.answerForm = form.getFillableForm();
        FormField formField = this.answerForm.getDataForm().getField(MUC_ROOMCONFIG_ROOMOWNERS);
        if (formField != null) {
            List<? extends CharSequence> list = formField.getValues();
            this.owners = new ArrayList<i>(list.size());
            a.a(list, this.owners, null);
        } else {
            this.owners = null;
        }
    }

    public boolean supportsRoomOwners() {
        return this.owners != null;
    }

    public MucConfigFormManager setRoomOwners(Collection<? extends i> collection) {
        if (!this.supportsRoomOwners()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMOWNERS);
        }
        this.owners.clear();
        this.owners.addAll(collection);
        return this;
    }

    public boolean supportsMembersOnly() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_MEMBERSONLY);
    }

    public MucConfigFormManager makeMembersOnly() {
        return this.setMembersOnly(true);
    }

    public MucConfigFormManager setMembersOnly(boolean bl) {
        if (!this.supportsMembersOnly()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MEMBERSONLY);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_MEMBERSONLY, bl);
        return this;
    }

    public boolean supportsPasswordProtected() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
    }

    public MucConfigFormManager setAndEnablePassword(String string) {
        return this.setIsPasswordProtected(true).setRoomSecret(string);
    }

    public MucConfigFormManager makePasswordProtected() {
        return this.setIsPasswordProtected(true);
    }

    public MucConfigFormManager setIsPasswordProtected(boolean bl) {
        if (!this.supportsMembersOnly()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM, bl);
        return this;
    }

    public MucConfigFormManager setRoomSecret(String string) {
        if (!this.answerForm.hasField(MUC_ROOMCONFIG_ROOMSECRET)) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMSECRET);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMSECRET, string);
        return this;
    }

    public void submitConfigurationForm() {
        if (this.owners != null) {
            this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMOWNERS, a.c(this.owners));
        }
        this.multiUserChat.sendConfigurationForm(this.answerForm);
    }
}

