/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQResultReplyFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.privacy.PrivacyList;
import org.jivesoftware.smackx.privacy.PrivacyListListener;
import org.jivesoftware.smackx.privacy.filter.SetActiveListFilter;
import org.jivesoftware.smackx.privacy.filter.SetDefaultListFilter;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public final class PrivacyListManager
extends Manager {
    public static final String NAMESPACE = "jabber:iq:privacy";
    public static final StanzaFilter PRIVACY_FILTER = new StanzaTypeFilter(Privacy.class);
    private static final StanzaFilter PRIVACY_RESULT = new AndFilter(new StanzaFilter[]{IQTypeFilter.RESULT, PRIVACY_FILTER});
    private static final Map<XMPPConnection, PrivacyListManager> INSTANCES = new WeakHashMap<XMPPConnection, PrivacyListManager>();
    private final Set<PrivacyListListener> listeners = new CopyOnWriteArraySet<PrivacyListListener>();
    private volatile String cachedActiveListName;
    private volatile String cachedDefaultListName;

    private PrivacyListManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iQ) {
                Privacy privacy = (Privacy)iQ;
                for (PrivacyListListener privacyListListener : PrivacyListManager.this.listeners) {
                    for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                        String string = entry.getKey();
                        List<PrivacyItem> list = entry.getValue();
                        if (list.isEmpty()) {
                            privacyListListener.updatedPrivacyList(string);
                            continue;
                        }
                        privacyListListener.setPrivacyList(string, list);
                    }
                }
                return IQ.createResultIQ((IQ)privacy);
            }
        });
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                XMPPConnection xMPPConnection = PrivacyListManager.this.connection();
                Privacy privacy = (Privacy)stanza;
                IQResultReplyFilter iQResultReplyFilter = new IQResultReplyFilter((IQ)privacy, xMPPConnection);
                final String string = privacy.getActiveName();
                final boolean bl = privacy.isDeclineActiveList();
                xMPPConnection.addOneTimeSyncCallback(new StanzaListener(){

                    public void processStanza(Stanza stanza) {
                        if (bl) {
                            PrivacyListManager.this.cachedActiveListName = null;
                        } else {
                            PrivacyListManager.this.cachedActiveListName = string;
                        }
                    }
                }, (StanzaFilter)iQResultReplyFilter);
            }
        }, (StanzaFilter)SetActiveListFilter.INSTANCE);
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                XMPPConnection xMPPConnection = PrivacyListManager.this.connection();
                Privacy privacy = (Privacy)stanza;
                IQResultReplyFilter iQResultReplyFilter = new IQResultReplyFilter((IQ)privacy, xMPPConnection);
                final String string = privacy.getDefaultName();
                final boolean bl = privacy.isDeclineDefaultList();
                xMPPConnection.addOneTimeSyncCallback(new StanzaListener(){

                    public void processStanza(Stanza stanza) {
                        if (bl) {
                            PrivacyListManager.this.cachedDefaultListName = null;
                        } else {
                            PrivacyListManager.this.cachedDefaultListName = string;
                        }
                    }
                }, (StanzaFilter)iQResultReplyFilter);
            }
        }, (StanzaFilter)SetDefaultListFilter.INSTANCE);
        xMPPConnection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                String string;
                Privacy privacy = (Privacy)stanza;
                String string2 = privacy.getActiveName();
                if (string2 != null) {
                    PrivacyListManager.this.cachedActiveListName = string2;
                }
                if ((string = privacy.getDefaultName()) != null) {
                    PrivacyListManager.this.cachedDefaultListName = string;
                }
            }
        }, PRIVACY_RESULT);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (bl) {
                    return;
                }
                PrivacyListManager.this.cachedActiveListName = (PrivacyListManager.this.cachedDefaultListName = null);
            }
        });
        ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature(NAMESPACE);
    }

    public static synchronized PrivacyListManager getInstanceFor(XMPPConnection xMPPConnection) {
        PrivacyListManager privacyListManager = INSTANCES.get(xMPPConnection);
        if (privacyListManager == null) {
            privacyListManager = new PrivacyListManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, privacyListManager);
        }
        return privacyListManager;
    }

    private Privacy getRequest(Privacy privacy) {
        privacy.setType(IQ.Type.get);
        return (Privacy)this.connection().createStanzaCollectorAndSend((IQ)privacy).nextResultOrThrow();
    }

    private Stanza setRequest(Privacy privacy) {
        privacy.setType(IQ.Type.set);
        return this.connection().createStanzaCollectorAndSend((IQ)privacy).nextResultOrThrow();
    }

    private Privacy getPrivacyWithListNames() {
        Privacy privacy = new Privacy();
        return this.getRequest(privacy);
    }

    public PrivacyList getActiveList() {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getActiveName();
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            return null;
        }
        boolean bl = string != null && string.equals(privacy.getDefaultName());
        return new PrivacyList(true, bl, string, this.getPrivacyListItems(string));
    }

    public String getActiveListName() {
        if (this.cachedActiveListName != null) {
            return this.cachedActiveListName;
        }
        return this.getPrivacyWithListNames().getActiveName();
    }

    public PrivacyList getDefaultList() {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getDefaultName();
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            return null;
        }
        boolean bl = string.equals(privacy.getActiveName());
        return new PrivacyList(bl, true, string, this.getPrivacyListItems(string));
    }

    public String getDefaultListName() {
        if (this.cachedDefaultListName != null) {
            return this.cachedDefaultListName;
        }
        return this.getPrivacyWithListNames().getDefaultName();
    }

    public String getEffectiveListName() {
        String string = this.getActiveListName();
        if (string != null) {
            return string;
        }
        return this.getDefaultListName();
    }

    private List<PrivacyItem> getPrivacyListItems(String string) {
        assert (StringUtils.isNotEmpty((CharSequence)string));
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        Privacy privacy2 = this.getRequest(privacy);
        return privacy2.getPrivacyList(string);
    }

    public PrivacyList getPrivacyList(String string) {
        string = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"List name must not be null");
        return new PrivacyList(false, false, string, this.getPrivacyListItems(string));
    }

    public List<PrivacyList> getPrivacyLists() {
        Privacy privacy = this.getPrivacyWithListNames();
        Set<String> set = privacy.getPrivacyListNames();
        ArrayList<PrivacyList> arrayList = new ArrayList<PrivacyList>(set.size());
        for (String string : set) {
            boolean bl = string.equals(privacy.getActiveName());
            boolean bl2 = string.equals(privacy.getDefaultName());
            arrayList.add(new PrivacyList(bl, bl2, string, this.getPrivacyListItems(string)));
        }
        return arrayList;
    }

    public void setActiveListName(String string) {
        Privacy privacy = new Privacy();
        privacy.setActiveName(string);
        this.setRequest(privacy);
    }

    public void declineActiveList() {
        Privacy privacy = new Privacy();
        privacy.setDeclineActiveList(true);
        this.setRequest(privacy);
    }

    public void setDefaultListName(String string) {
        Privacy privacy = new Privacy();
        privacy.setDefaultName(string);
        this.setRequest(privacy);
    }

    public void declineDefaultList() {
        Privacy privacy = new Privacy();
        privacy.setDeclineDefaultList(true);
        this.setRequest(privacy);
    }

    public void createPrivacyList(String string, List<PrivacyItem> list) {
        this.updatePrivacyList(string, list);
    }

    public void updatePrivacyList(String string, List<PrivacyItem> list) {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, list);
        this.setRequest(privacy);
    }

    public void deletePrivacyList(String string) {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        this.setRequest(privacy);
    }

    public boolean addListener(PrivacyListListener privacyListListener) {
        return this.listeners.add(privacyListListener);
    }

    public boolean removeListener(PrivacyListListener privacyListListener) {
        return this.listeners.remove(privacyListListener);
    }

    public boolean isSupported() {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                PrivacyListManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

