/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    protected Boolean notify;
    protected List<? extends NamedElement> items;

    public ItemsExtension(ItemsElementType itemsElementType, String string, List<? extends NamedElement> list) {
        super(itemsElementType.getNodeElement(), string);
        this.type = itemsElementType;
        this.items = list;
    }

    public ItemsExtension(String string, List<? extends ExtensionElement> list, boolean bl) {
        super(ItemsElementType.retract.getNodeElement(), string);
        this.type = ItemsElementType.retract;
        this.items = list;
        this.notify = bl;
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    @Override
    public List<ExtensionElement> getExtensions() {
        return this.getItems();
    }

    public List<? extends NamedElement> getItems() {
        return this.items;
    }

    public boolean getNotify() {
        return this.notify;
    }

    @Override
    protected void addXml(XmlStringBuilder xmlStringBuilder) {
        if (this.items == null || this.items.size() == 0) {
            xmlStringBuilder.closeEmptyElement();
            return;
        }
        if (this.notify != null) {
            xmlStringBuilder.attribute(this.type.getElementAttribute(), this.notify.booleanValue());
            xmlStringBuilder.rightAngleBracket();
        } else {
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.append(this.items);
        }
        xmlStringBuilder.closeElement((NamedElement)this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "Content [" + this.toXML() + "]";
    }

    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private final PubSubElementType elem;
        private final String att;

        private ItemsElementType(PubSubElementType pubSubElementType, String string2) {
            this.elem = pubSubElementType;
            this.att = string2;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

