/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time;

import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.time.packet.Time;

public final class EntityTimeManager
extends Manager {
    private static final Map<XMPPConnection, EntityTimeManager> INSTANCES = new WeakHashMap<XMPPConnection, EntityTimeManager>();
    private static boolean autoEnable = true;
    private boolean enabled = false;

    public static void setAutoEnable(boolean bl) {
        autoEnable = bl;
    }

    public static synchronized EntityTimeManager getInstanceFor(XMPPConnection xMPPConnection) {
        EntityTimeManager entityTimeManager = INSTANCES.get(xMPPConnection);
        if (entityTimeManager == null) {
            entityTimeManager = new EntityTimeManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, entityTimeManager);
        }
        return entityTimeManager;
    }

    private EntityTimeManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        if (autoEnable) {
            this.enable();
        }
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("time", "urn:xmpp:time", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                if (EntityTimeManager.this.enabled) {
                    return Time.createResponse(iQ);
                }
                return IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.not_acceptable);
            }
        });
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.addFeature("urn:xmpp:time");
        this.enabled = true;
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.removeFeature("urn:xmpp:time");
        this.enabled = false;
    }

    public boolean isTimeSupported(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "urn:xmpp:time");
    }

    public Time getTime(i i2) {
        if (!this.isTimeSupported(i2)) {
            return null;
        }
        Time time = new Time();
        time.setTo(i2);
        return (Time)this.connection().createStanzaCollectorAndSend((IQ)time).nextResultOrThrow();
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                EntityTimeManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

