/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.SingleValueFormField;

public class BooleanFormField
extends SingleValueFormField {
    private final Boolean value;

    protected BooleanFormField(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public boolean getValueAsBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value;
    }

    public Boolean getValueAsBooleanOrNull() {
        return this.value;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends SingleValueFormField.Builder<BooleanFormField, Builder> {
        private Boolean value;

        private Builder(BooleanFormField booleanFormField) {
            super(booleanFormField);
            this.value = booleanFormField.value;
        }

        Builder(String string) {
            super(string, FormField.Type.bool);
        }

        @Override
        protected void resetInternal() {
            super.resetInternal();
            this.value = null;
        }

        @Deprecated
        public Builder addValue(CharSequence charSequence) {
            return this.setValue(new FormField.Value(charSequence));
        }

        public Builder setValue(CharSequence charSequence) {
            return this.setValue(new FormField.Value(charSequence));
        }

        public Builder setValue(FormField.Value value) {
            this.value = ParserUtils.parseXmlBoolean((String)value.getValue().toString());
            this.rawValue = value;
            return this.getThis();
        }

        public Builder setValue(boolean bl) {
            this.rawValue = new FormField.Value(Boolean.toString(bl));
            this.value = bl;
            return this;
        }

        @Override
        public BooleanFormField build() {
            return new BooleanFormField(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

