/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.e.a.a.d;
import org.e.a.c.a;
import org.e.a.i;
import org.e.b.c;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.SingleValueFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FilledForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FillableForm
extends FilledForm {
    private final Set<String> requiredFields;
    private final Set<String> filledRequiredFields = new HashSet<String>();
    private final Set<String> missingRequiredFields = new HashSet<String>();
    private final Map<String, FormField> filledFields = new HashMap<String, FormField>();

    public FillableForm(DataForm dataForm) {
        super(dataForm);
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<FormField> arrayList = new ArrayList<FormField>();
        for (FormField formField : dataForm.getFields()) {
            if (!formField.isRequired()) continue;
            String string = formField.getFieldName();
            hashSet.add(string);
            if (formField.hasValueSet()) {
                arrayList.add(formField);
                continue;
            }
            this.missingRequiredFields.add(string);
        }
        this.requiredFields = Collections.unmodifiableSet(hashSet);
        for (FormField formField : arrayList) {
            this.write(formField);
        }
    }

    protected void writeListMulti(String string, List<? extends CharSequence> list) {
        ListMultiFormField listMultiFormField = ((ListMultiFormField.Builder)FormField.listMultiBuilder(string).addValues(list)).build();
        this.write(listMultiFormField);
    }

    protected void writeTextSingle(String string, CharSequence charSequence) {
        TextSingleFormField textSingleFormField = ((TextSingleFormField.Builder)FormField.textSingleBuilder(string).setValue(charSequence)).build();
        this.write(textSingleFormField);
    }

    protected void writeBoolean(String string, boolean bl) {
        BooleanFormField booleanFormField = FormField.booleanBuilder(string).setValue(bl).build();
        this.write(booleanFormField);
    }

    protected void write(String string, int n) {
        this.writeTextSingle(string, Integer.toString(n));
    }

    protected void write(String string, Date date) {
        this.writeTextSingle(string, org.e.c.c.a((Date)date));
    }

    public void setAnswer(String string, Collection<? extends CharSequence> collection) {
        Object object;
        FormField formField = this.getFieldOrThrow(string);
        FormField.Type type = formField.getType();
        switch (type) {
            case list_multi: 
            case text_multi: {
                object = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder(string, type).addValues(collection)).build();
                break;
            }
            case jid_multi: {
                ArrayList arrayList = new ArrayList(collection.size());
                ArrayList arrayList2 = new ArrayList();
                a.a(collection, arrayList, arrayList2);
                if (!arrayList2.isEmpty()) {
                    throw new IllegalArgumentException((Throwable)arrayList2.get(0));
                }
                object = FormField.jidMultiBuilder(string).addValues(arrayList).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.write((FormField)object);
    }

    private static AbstractMultiFormField.Builder<?, ?> createMultiKindFieldbuilder(String string, FormField.Type type) {
        switch (type) {
            case list_multi: {
                return FormField.listMultiBuilder(string);
            }
            case text_multi: {
                return FormField.textMultiBuilder(string);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setAnswer(String string, int n) {
        this.setAnswer(string, Integer.toString(n));
    }

    public void setAnswer(String string, CharSequence charSequence) {
        SingleValueFormField singleValueFormField;
        FormField formField = this.getFieldOrThrow(string);
        FormField.Type type = formField.getType();
        switch (type) {
            case list_multi: 
            case jid_multi: {
                throw new IllegalArgumentException("Can not answer fields of type '" + (Object)((Object)type) + "' with a CharSequence");
            }
            case fixed: {
                throw new IllegalArgumentException("Fields of type 'fixed' are not answerable");
            }
            case list_single: 
            case text_private: 
            case text_single: 
            case hidden: {
                singleValueFormField = ((FormField.Builder)FillableForm.createSingleKindFieldBuilder(string, type).setValue(charSequence)).build();
                break;
            }
            case bool: {
                singleValueFormField = FormField.booleanBuilder(string).setValue(charSequence).build();
                break;
            }
            case jid_single: {
                i i2;
                try {
                    i2 = d.a((CharSequence)charSequence);
                }
                catch (c c2) {
                    throw new IllegalArgumentException(c2);
                }
                singleValueFormField = FormField.jidSingleBuilder(string).setValue(i2).build();
                break;
            }
            case text_multi: {
                singleValueFormField = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder(string, type).addValue(charSequence)).build();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.write(singleValueFormField);
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> createSingleKindFieldBuilder(String string, FormField.Type type) {
        switch (type) {
            case text_private: {
                return FormField.textPrivateBuilder(string);
            }
            case text_single: {
                return FormField.textSingleBuilder(string);
            }
            case hidden: {
                return FormField.hiddenBuilder(string);
            }
            case list_single: {
                return FormField.listSingleBuilder(string);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public void setAnswer(String string, boolean bl) {
        FormField formField = this.getFieldOrThrow(string);
        if (formField.getType() != FormField.Type.bool) {
            throw new IllegalArgumentException();
        }
        BooleanFormField booleanFormField = FormField.booleanBuilder(string).setValue(bl).build();
        this.write(booleanFormField);
    }

    public final void write(FormField formField) {
        if (formField.getType() == FormField.Type.fixed) {
            throw new IllegalArgumentException();
        }
        if (!formField.hasValueSet()) {
            throw new IllegalArgumentException();
        }
        String string = formField.getFieldName();
        if (!this.getDataForm().hasField(string)) {
            throw new IllegalArgumentException();
        }
        FormField formField2 = this.getDataForm().getField(string);
        for (FormFieldChildElement formFieldChildElement : formField2.getFormFieldChildElements()) {
            formFieldChildElement.validate(formField);
        }
        this.filledFields.put(string, formField);
        if (this.requiredFields.contains(string)) {
            this.filledRequiredFields.add(string);
            this.missingRequiredFields.remove(string);
        }
    }

    @Override
    public FormField getField(String string) {
        FormField formField = this.filledFields.get(string);
        if (formField != null) {
            return formField;
        }
        return super.getField(string);
    }

    public DataForm getDataFormToSubmit() {
        if (!this.missingRequiredFields.isEmpty()) {
            throw new IllegalStateException("Not all required fields filled. Missing: " + this.missingRequiredFields);
        }
        DataForm.Builder builder = DataForm.builder();
        if (this.formTypeFormField != null) {
            builder.addField(this.formTypeFormField);
        }
        builder.addFields(this.filledFields.values());
        return builder.build();
    }
}

