/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class XHTMLExtension
implements ExtensionElement {
    public static final String ELEMENT = "html";
    public static final String NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    public static final QName QNAME = new QName("http://jabber.org/protocol/xhtml-im", "html");
    private final List<CharSequence> bodies = new ArrayList<CharSequence>();

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((ExtensionElement)this);
        xmlStringBuilder.rightAngleBracket();
        for (CharSequence charSequence : this.getBodies()) {
            xmlStringBuilder.append(charSequence);
        }
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CharSequence> getBodies() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.bodies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBody(CharSequence charSequence) {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            this.bodies.add(charSequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBodiesCount() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return this.bodies.size();
        }
    }

    public static XHTMLExtension from(MessageView messageView) {
        return (XHTMLExtension)messageView.getExtension(XHTMLExtension.class);
    }
}

