/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CIOCipherSuites;
import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSConfig;
import io.ktor.network.tls.TLSConfigBuilderKt;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R.\u0010\u0016\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010!R$\u0010#\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lio/ktor/network/tls/TLSConfigBuilder;", "", "<init>", "()V", "Lio/ktor/network/tls/TLSConfig;", "build", "()Lio/ktor/network/tls/TLSConfig;", "", "Lio/ktor/network/tls/CertificateAndKey;", "certificates", "Ljava/util/List;", "getCertificates", "()Ljava/util/List;", "Ljava/security/SecureRandom;", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "setRandom", "(Ljava/security/SecureRandom;)V", "Ljavax/net/ssl/TrustManager;", "value", "trustManager", "Ljavax/net/ssl/TrustManager;", "getTrustManager", "()Ljavax/net/ssl/TrustManager;", "setTrustManager", "(Ljavax/net/ssl/TrustManager;)V", "", "Lio/ktor/network/tls/CipherSuite;", "cipherSuites", "getCipherSuites", "setCipherSuites", "(Ljava/util/List;)V", "", "serverName", "Ljava/lang/String;", "getServerName", "()Ljava/lang/String;", "setServerName", "(Ljava/lang/String;)V", "ktor-network-tls"})
public final class TLSConfigBuilder {
    private final List<CertificateAndKey> certificates = new ArrayList();
    private SecureRandom random;
    private TrustManager trustManager;
    private List<CipherSuite> cipherSuites = CIOCipherSuites.INSTANCE.getSupportedSuites();
    private String serverName;

    public final List<CertificateAndKey> getCertificates() {
        return this.certificates;
    }

    public final SecureRandom getRandom() {
        return this.random;
    }

    public final void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public final TrustManager getTrustManager() {
        return this.trustManager;
    }

    public final void setTrustManager(TrustManager trustManager) {
        TrustManager trustManager2 = trustManager;
        if (trustManager2 != null) {
            TrustManager trustManager3 = trustManager2;
            boolean bl = false;
            if (!(trustManager3 instanceof X509TrustManager)) {
                boolean bl2 = false;
                String string = "Failed to set [trustManager]: " + trustManager + ". Only [X509TrustManager] supported.";
                throw new IllegalStateException(string.toString());
            }
        }
        this.trustManager = trustManager;
    }

    public final List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public final void setCipherSuites(List<CipherSuite> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.cipherSuites = list;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final TLSConfig build() {
        TrustManager trustManager;
        X509TrustManager x509TrustManager;
        SecureRandom secureRandom = this.random;
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        if ((x509TrustManager = (trustManager = this.trustManager) instanceof X509TrustManager ? (X509TrustManager)trustManager : null) == null) {
            x509TrustManager = TLSConfigBuilderKt.access$findTrustManager();
        }
        return new TLSConfig(secureRandom, this.certificates, x509TrustManager, this.cipherSuites, this.serverName);
    }
}

