/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml.stax;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class StaxXmlPullParser
implements XmlPullParser {
    private final XMLStreamReader xmlStreamReader;
    private int depth;
    private boolean delayedDepthDecrement;

    StaxXmlPullParser(XMLStreamReader xMLStreamReader) {
        this.xmlStreamReader = xMLStreamReader;
    }

    public Object getProperty(String string) {
        return this.xmlStreamReader.getProperty(string);
    }

    public String getInputEncoding() {
        return this.xmlStreamReader.getEncoding();
    }

    public int getNamespaceCount() {
        return this.xmlStreamReader.getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        return this.xmlStreamReader.getNamespacePrefix(n);
    }

    public String getNamespaceUri(int n) {
        return this.xmlStreamReader.getNamespaceURI(n);
    }

    public String getNamespace(String string) {
        if (string == null) {
            string = "";
        }
        NamespaceContext namespaceContext = this.xmlStreamReader.getNamespaceContext();
        return namespaceContext.getNamespaceURI(string);
    }

    public String getNamespace() {
        String string = this.getPrefix();
        return this.getNamespace(string);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        Location location = this.xmlStreamReader.getLocation();
        return location.toString();
    }

    public int getLineNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getLineNumber();
    }

    public int getColumnNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getColumnNumber();
    }

    public boolean isWhiteSpace() {
        return this.xmlStreamReader.isWhiteSpace();
    }

    public String getText() {
        return this.xmlStreamReader.getText();
    }

    public String getName() {
        QName qName = this.getQName();
        return qName.getLocalPart();
    }

    public QName getQName() {
        return this.xmlStreamReader.getName();
    }

    public String getPrefix() {
        return this.xmlStreamReader.getPrefix();
    }

    public int getAttributeCount() {
        return this.xmlStreamReader.getAttributeCount();
    }

    public String getAttributeNamespace(int n) {
        return this.xmlStreamReader.getAttributeNamespace(n);
    }

    public String getAttributeName(int n) {
        QName qName = this.getAttributeQName(n);
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public QName getAttributeQName(int n) {
        return this.xmlStreamReader.getAttributeName(n);
    }

    public String getAttributePrefix(int n) {
        return this.xmlStreamReader.getAttributePrefix(n);
    }

    public String getAttributeType(int n) {
        return this.xmlStreamReader.getAttributeType(n);
    }

    public String getAttributeValue(int n) {
        return this.xmlStreamReader.getAttributeValue(n);
    }

    public String getAttributeValue(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        return this.xmlStreamReader.getAttributeValue(string3, string4);
    }

    public XmlPullParser.Event getEventType() {
        int n = this.xmlStreamReader.getEventType();
        return StaxXmlPullParser.staxEventIntegerToEvent(n);
    }

    public XmlPullParser.Event next() {
        int n;
        this.preNextEvent();
        try {
            n = this.xmlStreamReader.next();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        XmlPullParser.Event event = StaxXmlPullParser.staxEventIntegerToEvent(n);
        switch (event) {
            case START_ELEMENT: {
                ++this.depth;
                break;
            }
            case END_ELEMENT: {
                this.delayedDepthDecrement = true;
                break;
            }
        }
        return event;
    }

    public String nextText() {
        String string;
        try {
            string = this.xmlStreamReader.getElementText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        this.delayedDepthDecrement = true;
        return string;
    }

    public XmlPullParser.TagEvent nextTag() {
        int n;
        this.preNextEvent();
        try {
            n = this.xmlStreamReader.nextTag();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        switch (n) {
            case 1: {
                ++this.depth;
                return XmlPullParser.TagEvent.START_ELEMENT;
            }
            case 2: {
                this.delayedDepthDecrement = true;
                return XmlPullParser.TagEvent.END_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void preNextEvent() {
        if (this.delayedDepthDecrement) {
            --this.depth;
            this.delayedDepthDecrement = false;
            assert (this.depth >= 0);
        }
    }

    private static XmlPullParser.Event staxEventIntegerToEvent(int n) {
        switch (n) {
            case 1: {
                return XmlPullParser.Event.START_ELEMENT;
            }
            case 2: {
                return XmlPullParser.Event.END_ELEMENT;
            }
            case 3: {
                return XmlPullParser.Event.PROCESSING_INSTRUCTION;
            }
            case 4: {
                return XmlPullParser.Event.TEXT_CHARACTERS;
            }
            case 5: {
                return XmlPullParser.Event.COMMENT;
            }
            case 6: {
                return XmlPullParser.Event.IGNORABLE_WHITESPACE;
            }
            case 7: {
                return XmlPullParser.Event.START_DOCUMENT;
            }
            case 8: {
                return XmlPullParser.Event.END_DOCUMENT;
            }
            case 9: {
                return XmlPullParser.Event.ENTITY_REFERENCE;
            }
            case 10: {
                return XmlPullParser.Event.OTHER;
            }
            case 11: {
                return XmlPullParser.Event.OTHER;
            }
            case 12: {
                return XmlPullParser.Event.OTHER;
            }
            case 13: {
                return XmlPullParser.Event.OTHER;
            }
            case 14: {
                return XmlPullParser.Event.OTHER;
            }
            case 15: {
                return XmlPullParser.Event.OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown Stax event integer: " + n);
    }

    public boolean supportsRoundtrip() {
        return false;
    }
}

