/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyApplicationEngineKt;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.server.netty.NettyDispatcher;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.util.pipeline.PipelineContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.al;
import kotlinx.coroutines.an;
import kotlinx.coroutines.y;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001NB5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010%R\u001b\u0010+\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001b\u0010.\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010(\u001a\u0004\b-\u0010*R\u001b\u00102\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010(\u001a\u0004\b0\u00101R\u001b\u00105\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010(\u001a\u0004\b4\u0010*R\u001b\u0010:\u001a\u0002068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010(\u001a\u0004\b8\u00109R\u001b\u0010?\u001a\u00020;8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010(\u001a\u0004\b=\u0010>R\u0018\u0010A\u001a\u0004\u0018\u00010@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u001e\u0010E\u001a\n\u0012\u0004\u0012\u00020D\u0018\u00010C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR!\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00110C8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010(\u001a\u0004\bH\u0010IR\u0014\u0010L\u001a\u00020K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010M\u00a8\u0006O"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/events/Events;", "monitor", "", "developmentMode", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "configuration", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lio/ktor/events/Events;ZLio/ktor/server/netty/NettyApplicationEngine$Configuration;Lkotlin/jvm/functions/Function0;)V", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "Lio/netty/bootstrap/ServerBootstrap;", "createBootstrap", "(Lio/ktor/server/engine/EngineConnectorConfig;)Lio/netty/bootstrap/ServerBootstrap;", "wait", "start", "(Z)Lio/ktor/server/netty/NettyApplicationEngine;", "", "terminate", "()V", "", "gracePeriodMillis", "timeoutMillis", "stop", "(JJ)V", "", "toString", "()Ljava/lang/String;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "getConfiguration", "()Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lkotlin/jvm/functions/Function0;", "Lio/netty/channel/EventLoopGroup;", "connectionEventGroup$delegate", "Lkotlin/Lazy;", "getConnectionEventGroup", "()Lio/netty/channel/EventLoopGroup;", "connectionEventGroup", "workerEventGroup$delegate", "getWorkerEventGroup", "workerEventGroup", "customBootstrap$delegate", "getCustomBootstrap", "()Lio/netty/bootstrap/ServerBootstrap;", "customBootstrap", "callEventGroup$delegate", "getCallEventGroup", "callEventGroup", "Lkotlinx/coroutines/CoroutineDispatcher;", "nettyDispatcher$delegate", "getNettyDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "nettyDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "workerDispatcher$delegate", "getWorkerDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "workerDispatcher", "Lkotlinx/coroutines/CompletableJob;", "cancellationJob", "Lkotlinx/coroutines/CompletableJob;", "", "Lio/netty/channel/Channel;", "channels", "Ljava/util/List;", "bootstraps$delegate", "getBootstraps$ktor_server_netty", "()Ljava/util/List;", "bootstraps", "Lkotlin/coroutines/CoroutineContext;", "userContext", "Lkotlin/coroutines/CoroutineContext;", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    private final Configuration configuration;
    private final Function0<Application> applicationProvider;
    private final Lazy connectionEventGroup$delegate;
    private final Lazy workerEventGroup$delegate;
    private final Lazy customBootstrap$delegate;
    private final Lazy callEventGroup$delegate;
    private final Lazy nettyDispatcher$delegate;
    private final Lazy workerDispatcher$delegate;
    private y cancellationJob;
    private List<? extends Channel> channels;
    private final Lazy bootstraps$delegate;
    private final CoroutineContext userContext;

    public NettyApplicationEngine(ApplicationEnvironment applicationEnvironment, Events events, boolean bl, Configuration configuration, Function0<Application> function0) {
        Intrinsics.checkNotNullParameter((Object)applicationEnvironment, (String)"");
        Intrinsics.checkNotNullParameter((Object)events, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        super(applicationEnvironment, events, bl, null, 8, null);
        this.configuration = configuration;
        this.applicationProvider = function0;
        this.connectionEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.connectionEventGroup_delegate$lambda$0(this));
        this.workerEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.workerEventGroup_delegate$lambda$2(this));
        this.customBootstrap$delegate = LazyKt.lazy(() -> NettyApplicationEngine.customBootstrap_delegate$lambda$3(this));
        this.callEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.callEventGroup_delegate$lambda$4(this));
        this.nettyDispatcher$delegate = LazyKt.lazy(NettyApplicationEngine::nettyDispatcher_delegate$lambda$5);
        this.workerDispatcher$delegate = LazyKt.lazy(() -> NettyApplicationEngine.workerDispatcher_delegate$lambda$6(this));
        this.bootstraps$delegate = LazyKt.lazy(() -> NettyApplicationEngine.bootstraps_delegate$lambda$7(this));
        this.userContext = ((Application)this.applicationProvider.invoke()).getParentCoroutineContext().plus((CoroutineContext)this.getNettyDispatcher()).plus((CoroutineContext)NettyApplicationCallHandler.Companion.getCallHandlerCoroutineName$ktor_server_netty()).plus((CoroutineContext)new DefaultUncaughtExceptionHandler(applicationEnvironment.getLog()));
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), NettyApplicationEngineKt.access$getAFTER_CALL_PHASE$p());
        this.getPipeline().intercept(NettyApplicationEngineKt.access$getAFTER_CALL_PHASE$p(), (Function3)new Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PipelineContext pipelineContext;
                        ResultKt.throwOnFailure((Object)object);
                        PipelineContext pipelineContext2 = pipelineContext = (PipelineContext)this.L$0;
                        boolean bl = false;
                        PipelineCall pipelineCall = (PipelineCall)pipelineContext2.getContext();
                        NettyApplicationCall nettyApplicationCall = pipelineCall instanceof NettyApplicationCall ? (NettyApplicationCall)pipelineCall : null;
                        if (nettyApplicationCall == null) break;
                        this.label = 1;
                        Object object3 = nettyApplicationCall.finish$ktor_server_netty((Continuation<? super Unit>)((Continuation)this));
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(PipelineContext<Unit, PipelineCall> pipelineContext, Unit unit, Continuation<? super Unit> continuation) {
                Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = pipelineContext;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    private final EventLoopGroup getConnectionEventGroup() {
        Lazy lazy = this.connectionEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final EventLoopGroup getWorkerEventGroup() {
        Lazy lazy = this.workerEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ServerBootstrap getCustomBootstrap() {
        Lazy lazy = this.customBootstrap$delegate;
        return (ServerBootstrap)lazy.getValue();
    }

    private final EventLoopGroup getCallEventGroup() {
        Lazy lazy = this.callEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final CoroutineDispatcher getNettyDispatcher() {
        Lazy lazy = this.nettyDispatcher$delegate;
        return (CoroutineDispatcher)lazy.getValue();
    }

    private final al getWorkerDispatcher() {
        Lazy lazy = this.workerDispatcher$delegate;
        return (al)lazy.getValue();
    }

    public final List<ServerBootstrap> getBootstraps$ktor_server_netty() {
        Lazy lazy = this.bootstraps$delegate;
        return (List)lazy.getValue();
    }

    private final ServerBootstrap createBootstrap(EngineConnectorConfig engineConnectorConfig) {
        ServerBootstrap serverBootstrap;
        ServerBootstrap serverBootstrap2 = serverBootstrap = this.getCustomBootstrap().clone();
        boolean bl = false;
        if (serverBootstrap2.config().group() == null && serverBootstrap2.config().childGroup() == null) {
            serverBootstrap2.group(this.getConnectionEventGroup(), this.getWorkerEventGroup());
        }
        if (serverBootstrap2.config().channelFactory() == null) {
            serverBootstrap2.channel(JvmClassMappingKt.getJavaClass(NettyApplicationEngineKt.getChannelClass()));
        }
        serverBootstrap2.childHandler((ChannelHandler)new NettyChannelInitializer(this.applicationProvider, this.getPipeline(), this.getEnvironment(), (EventExecutorGroup)this.getCallEventGroup(), (CoroutineContext)this.getWorkerDispatcher(), this.userContext, engineConnectorConfig, this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec(), this.configuration.getChannelPipelineConfig(), this.configuration.getEnableHttp2()));
        if (this.configuration.getTcpKeepAlive()) {
            serverBootstrap2.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        ServerBootstrap serverBootstrap3 = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue((Object)serverBootstrap3, (String)"");
        return serverBootstrap3;
    }

    public NettyApplicationEngine start(boolean bl) {
        Object object;
        Object object22;
        Object object3;
        try {
            boolean bl2;
            Collection collection;
            Iterable iterable = CollectionsKt.zip((Iterable)this.getBootstraps$ktor_server_netty(), (Iterable)this.configuration.getConnectors());
            object3 = this;
            boolean bl3 = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl4 = false;
            for (Object object4 : iterable2) {
                object22 = (Pair)object4;
                collection = iterable3;
                bl2 = false;
                collection.add(((ServerBootstrap)object22.getFirst()).bind(((EngineConnectorConfig)object22.getSecond()).getHost(), ((EngineConnectorConfig)object22.getSecond()).getPort()));
            }
            iterable = (List)iterable3;
            bl3 = false;
            iterable2 = iterable;
            iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            bl4 = false;
            for (Object object4 : iterable2) {
                object22 = (ChannelFuture)object4;
                collection = iterable3;
                bl2 = false;
                collection.add(object22.sync().channel());
            }
            ((NettyApplicationEngine)((Object)object3)).channels = (List)iterable3;
            List<? extends Channel> list = this.channels;
            Intrinsics.checkNotNull(list);
            Iterable iterable4 = CollectionsKt.zip((Iterable)list, (Iterable)this.configuration.getConnectors());
            boolean bl5 = false;
            iterable3 = iterable4;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
            boolean bl6 = false;
            for (Object object22 : iterable3) {
                Object object5 = object22;
                object3 = object;
                boolean bl7 = false;
                EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)object5.getSecond();
                SocketAddress socketAddress = ((Channel)object5.getFirst()).localAddress();
                Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"");
                object3.add(EngineConnectorConfigJvmKt.withPort((EngineConnectorConfig)engineConnectorConfig, (int)NetworkAddressJvmKt.getPort((SocketAddress)socketAddress)));
            }
            iterable = (List)object;
            this.getResolvedConnectorsDeferred().complete((Object)iterable);
        }
        catch (BindException bindException) {
            this.terminate();
            throw bindException;
        }
        EventsKt.raiseCatching((Events)this.getMonitor(), (EventDefinition)DefaultApplicationEventsKt.getServerReady(), (Object)this.getEnvironment(), (Logger)this.getEnvironment().getLog());
        this.cancellationJob = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this), (Application)((Application)this.applicationProvider.invoke()), (long)this.configuration.getShutdownGracePeriod(), (long)this.configuration.getShutdownTimeout());
        if (bl) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                Iterable iterable = list;
                boolean bl8 = false;
                object = iterable;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl9 = false;
                object22 = object.iterator();
                while (object22.hasNext()) {
                    Object e = object22.next();
                    Channel channel = (Channel)e;
                    object3 = collection2;
                    boolean bl10 = false;
                    object3.add(channel.closeFuture());
                }
                iterable = (List)collection2;
                bl8 = false;
                for (Collection collection2 : iterable) {
                    ChannelFuture channelFuture = (ChannelFuture)collection2;
                    boolean bl11 = false;
                    channelFuture.sync();
                }
            }
            this.stop(this.configuration.getShutdownGracePeriod(), this.configuration.getShutdownTimeout());
        }
        return this;
    }

    private final void terminate() {
        this.getConnectionEventGroup().shutdownGracefully().sync();
        this.getWorkerEventGroup().shutdownGracefully().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long l, long l2) {
        List list;
        List list2;
        Iterable iterable;
        y y2 = this.cancellationJob;
        if (y2 != null) {
            y2.a();
        }
        this.getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        List<? extends Channel> list3 = this.channels;
        if (list3 != null) {
            iterable = list3;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Object object = new ArrayList();
            boolean bl2 = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            Iterator iterator = iterable3.iterator();
            while (iterator.hasNext()) {
                ChannelFuture channelFuture;
                Object t;
                Object t2 = t = iterator.next();
                boolean bl4 = false;
                Channel channel = (Channel)t2;
                boolean bl5 = false;
                if ((channel.isOpen() ? channel.close() : null) == null) continue;
                channelFuture = channelFuture;
                boolean bl6 = false;
                object.add(channelFuture);
            }
            list2 = (List)object;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List list4 = list;
        try {
            Future future;
            Future future2 = this.getConnectionEventGroup().shutdownGracefully(l, l2, TimeUnit.MILLISECONDS);
            future2.await();
            iterable = this.getWorkerEventGroup().shutdownGracefully(l, l2, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                future = iterable.await();
            } else {
                Future future3 = this.getCallEventGroup().shutdownGracefully(l, l2, TimeUnit.MILLISECONDS);
                iterable.await();
                future = future3.await();
            }
        }
        finally {
            iterable = list4;
            boolean bl = false;
            for (Object object : iterable) {
                ChannelFuture channelFuture = (ChannelFuture)object;
                boolean bl7 = false;
                channelFuture.sync();
            }
        }
    }

    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    private static final EventLoopGroup connectionEventGroup_delegate$lambda$0(NettyApplicationEngine nettyApplicationEngine) {
        EventLoopGroup eventLoopGroup = nettyApplicationEngine.getCustomBootstrap().config().group();
        if (eventLoopGroup == null) {
            eventLoopGroup = EventLoopGroupProxy.Companion.create(nettyApplicationEngine.configuration.getConnectionGroupSize());
        }
        return eventLoopGroup;
    }

    private static final EventLoopGroup workerEventGroup_delegate$lambda$2(NettyApplicationEngine nettyApplicationEngine) {
        EventLoopGroup eventLoopGroup = nettyApplicationEngine.getCustomBootstrap().config().childGroup();
        if (eventLoopGroup != null) {
            EventLoopGroup eventLoopGroup2 = eventLoopGroup;
            boolean bl = false;
            return eventLoopGroup2;
        }
        return nettyApplicationEngine.configuration.getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(nettyApplicationEngine.configuration.getWorkerGroupSize() + nettyApplicationEngine.configuration.getCallGroupSize()) : EventLoopGroupProxy.Companion.create(nettyApplicationEngine.configuration.getWorkerGroupSize());
    }

    private static final ServerBootstrap customBootstrap_delegate$lambda$3(NettyApplicationEngine nettyApplicationEngine) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        nettyApplicationEngine.configuration.getConfigureBootstrap().invoke((Object)serverBootstrap);
        return serverBootstrap;
    }

    private static final EventLoopGroup callEventGroup_delegate$lambda$4(NettyApplicationEngine nettyApplicationEngine) {
        return nettyApplicationEngine.configuration.getShareWorkGroup() ? nettyApplicationEngine.getWorkerEventGroup() : (EventLoopGroup)EventLoopGroupProxy.Companion.create(nettyApplicationEngine.configuration.getCallGroupSize());
    }

    private static final NettyDispatcher nettyDispatcher_delegate$lambda$5() {
        return NettyDispatcher.INSTANCE;
    }

    private static final al workerDispatcher_delegate$lambda$6(NettyApplicationEngine nettyApplicationEngine) {
        return an.a((ExecutorService)((ExecutorService)nettyApplicationEngine.getWorkerEventGroup()));
    }

    private static final List bootstraps_delegate$lambda$7(NettyApplicationEngine nettyApplicationEngine) {
        Iterable iterable = nettyApplicationEngine.configuration.getConnectors();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(nettyApplicationEngine.createBootstrap(engineConnectorConfig));
        }
        return (List)collection;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R3\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\t\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\"\u0010\"\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\t\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR\"\u0010%\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0010\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R\"\u0010(\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\t\u001a\u0004\b)\u0010\u000b\"\u0004\b*\u0010\rR\"\u0010+\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\t\u001a\u0004\b,\u0010\u000b\"\u0004\b-\u0010\rR\"\u0010.\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\t\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010\rR\"\u00101\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010\u0010\u001a\u0004\b2\u0010\u0012\"\u0004\b3\u0010\u0014R(\u00105\u001a\b\u0012\u0004\u0012\u00020\u0004048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R3\u0010<\u001a\u0013\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010\u001a\u001a\u0004\b=\u0010\u001c\"\u0004\b>\u0010\u001e\u00a8\u0006?"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "<init>", "()V", "Lio/netty/handler/codec/http/HttpServerCodec;", "defaultHttpServerCodec", "()Lio/netty/handler/codec/http/HttpServerCodec;", "", "runningLimit", "I", "getRunningLimit", "()I", "setRunningLimit", "(I)V", "", "shareWorkGroup", "Z", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "configureBootstrap", "Lkotlin/jvm/functions/Function1;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "tcpKeepAlive", "getTcpKeepAlive", "setTcpKeepAlive", "maxInitialLineLength", "getMaxInitialLineLength", "setMaxInitialLineLength", "maxHeaderSize", "getMaxHeaderSize", "setMaxHeaderSize", "maxChunkSize", "getMaxChunkSize", "setMaxChunkSize", "enableHttp2", "getEnableHttp2", "setEnableHttp2", "Lkotlin/Function0;", "httpServerCodec", "Lkotlin/jvm/functions/Function0;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "Lio/netty/channel/ChannelPipeline;", "channelPipelineConfig", "getChannelPipelineConfig", "setChannelPipelineConfig", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int runningLimit = 32;
        private boolean shareWorkGroup;
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = Configuration::configureBootstrap$lambda$0;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        private boolean tcpKeepAlive;
        private int maxInitialLineLength = 4096;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;
        private boolean enableHttp2 = true;
        private Function0<HttpServerCodec> httpServerCodec = (Function0)new Function0<HttpServerCodec>((Object)this){

            public final HttpServerCodec invoke() {
                return Configuration.access$defaultHttpServerCodec((Configuration)((Object)this.receiver));
            }
        };
        private Function1<? super ChannelPipeline, Unit> channelPipelineConfig = Configuration::channelPipelineConfig$lambda$1;

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n2) {
            this.runningLimit = n2;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n2) {
            this.responseWriteTimeoutSeconds = n2;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n2) {
            this.requestReadTimeoutSeconds = n2;
        }

        public final boolean getTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public final void setTcpKeepAlive(boolean bl) {
            this.tcpKeepAlive = bl;
        }

        public final int getMaxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        public final void setMaxInitialLineLength(int n2) {
            this.maxInitialLineLength = n2;
        }

        public final int getMaxHeaderSize() {
            return this.maxHeaderSize;
        }

        public final void setMaxHeaderSize(int n2) {
            this.maxHeaderSize = n2;
        }

        public final int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        public final void setMaxChunkSize(int n2) {
            this.maxChunkSize = n2;
        }

        public final boolean getEnableHttp2() {
            return this.enableHttp2;
        }

        public final void setEnableHttp2(boolean bl) {
            this.enableHttp2 = bl;
        }

        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(Function0<HttpServerCodec> function0) {
            Intrinsics.checkNotNullParameter(function0, (String)"");
            this.httpServerCodec = function0;
        }

        public final Function1<ChannelPipeline, Unit> getChannelPipelineConfig() {
            return this.channelPipelineConfig;
        }

        public final void setChannelPipelineConfig(Function1<? super ChannelPipeline, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.channelPipelineConfig = function1;
        }

        private final HttpServerCodec defaultHttpServerCodec() {
            return new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize);
        }

        private static final Unit configureBootstrap$lambda$0(ServerBootstrap serverBootstrap) {
            Intrinsics.checkNotNullParameter((Object)serverBootstrap, (String)"");
            return Unit.INSTANCE;
        }

        private static final Unit channelPipelineConfig$lambda$1(ChannelPipeline channelPipeline) {
            Intrinsics.checkNotNullParameter((Object)channelPipeline, (String)"");
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ HttpServerCodec access$defaultHttpServerCodec(Configuration configuration) {
            return configuration.defaultHttpServerCodec();
        }
    }
}

