/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativePointerArray;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 D2\u00020\u0001:\u0001DB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\u0010\n\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fB\u001d\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0006\u00100\u001a\u00020\u0003J\u001e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\rJ\u0013\u00104\u001a\u00020%2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00106\u001a\u00020\u0003H\u0016J\u000e\u00107\u001a\u00020%2\u0006\u0010/\u001a\u00020\rJ\b\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0003J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0019\u00a8\u0006E"}, d2={"Lorg/jetbrains/skia/ImageInfo;", "", "width", "", "height", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;)V", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(IIIIJ)V", "colorInfo", "Lorg/jetbrains/skia/ColorInfo;", "(Lorg/jetbrains/skia/ColorInfo;II)V", "bounds", "Lorg/jetbrains/skia/IRect;", "getBounds", "()Lorg/jetbrains/skia/IRect;", "bytesPerPixel", "getBytesPerPixel", "()I", "colorAlphaType", "getColorAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "getColorInfo", "()Lorg/jetbrains/skia/ColorInfo;", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "getHeight", "isEmpty", "", "()Z", "isGammaCloseToSRGB", "isOpaque", "minRowBytes", "getMinRowBytes", "shiftPerPixel", "getShiftPerPixel", "getWidth", "computeByteSize", "rowBytes", "computeMinByteSize", "computeOffset", "x", "y", "equals", "other", "hashCode", "isRowBytesValid", "toString", "", "withColorAlphaType", "withColorInfo", "_colorInfo", "withColorSpace", "withColorType", "withHeight", "_height", "withWidth", "_width", "withWidthHeight", "Companion", "skiko"})
public final class ImageInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorInfo colorInfo;
    private final int width;
    private final int height;
    private static final ImageInfo DEFAULT = new ImageInfo(ColorInfo.Companion.getDEFAULT(), 0, 0);

    public ImageInfo(ColorInfo colorInfo, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"");
        this.colorInfo = colorInfo;
        this.width = n;
        this.height = n2;
    }

    public final ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public ImageInfo(int n, int n2, ColorType colorType, ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this(new ColorInfo(colorType, colorAlphaType, null), n, n2);
    }

    public ImageInfo(int n, int n2, ColorType colorType, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this(new ColorInfo(colorType, colorAlphaType, colorSpace), n, n2);
    }

    public ImageInfo(int n, int n2, int n3, int n4, long l) {
        this(n, n2, ColorType.values()[n3], ColorAlphaType.values()[n4], l == Native.Companion.getNullPointer() ? null : new ColorSpace(l));
    }

    public final int getMinRowBytes() {
        return this.width * this.getBytesPerPixel();
    }

    public final ColorType getColorType() {
        return this.colorInfo.getColorType();
    }

    public final ImageInfo withColorType(ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        return this.withColorInfo(this.colorInfo.withColorType(colorType));
    }

    public final ColorAlphaType getColorAlphaType() {
        return this.colorInfo.getAlphaType();
    }

    public final ImageInfo withColorAlphaType(ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        return this.withColorInfo(this.colorInfo.withAlphaType(colorAlphaType));
    }

    public final ColorSpace getColorSpace() {
        return this.colorInfo.getColorSpace();
    }

    public final ImageInfo withColorSpace(ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"");
        return this.withColorInfo(this.colorInfo.withColorSpace(colorSpace));
    }

    public final boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public final boolean isOpaque() {
        return this.colorInfo.isOpaque();
    }

    public final IRect getBounds() {
        return IRect.Companion.makeXYWH(0, 0, this.width, this.height);
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorInfo.isGammaCloseToSRGB();
    }

    public final ImageInfo withWidthHeight(int n, int n2) {
        return new ImageInfo(this.colorInfo, n, n2);
    }

    public final int getBytesPerPixel() {
        return this.colorInfo.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorInfo.getShiftPerPixel();
    }

    public final boolean isRowBytesValid(long l) {
        if (l < (long)this.getMinRowBytes()) {
            return false;
        }
        int n = this.getShiftPerPixel();
        return l >> n << n == l;
    }

    public final long computeOffset(int n, int n2, long l) {
        return this.colorInfo.getColorType().computeOffset(n, n2, l);
    }

    public final int computeByteSize(int n) {
        return this.height == 0 ? 0 : (this.height - 1) * n + this.width * this.getBytesPerPixel();
    }

    public final int computeMinByteSize() {
        return this.computeByteSize(this.getMinRowBytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImageInfo)) {
            return false;
        }
        if (this.width != ((ImageInfo)object).width) {
            return false;
        }
        if (this.height != ((ImageInfo)object).height) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorInfo, (Object)((ImageInfo)object).colorInfo);
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + this.width;
        n2 = n2 * n + this.height;
        n2 = n2 * n + this.colorInfo.hashCode();
        return n2;
    }

    public String toString() {
        return "ImageInfo(_colorInfo=" + this.colorInfo + ", _width=" + this.width + ", _height=" + this.height + ')';
    }

    public final ImageInfo withColorInfo(ColorInfo colorInfo) {
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"");
        return this.colorInfo == colorInfo ? this : new ImageInfo(colorInfo, this.width, this.height);
    }

    public final ImageInfo withWidth(int n) {
        return this.width == n ? this : new ImageInfo(this.colorInfo, n, this.height);
    }

    public final ImageInfo withHeight(int n) {
        return this.height == n ? this : new ImageInfo(this.colorInfo, this.width, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jo\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2[\u0010\u000b\u001aW\u0012\u0017\u0012\u00150\tj\u0002`\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/ImageInfo$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/skia/ImageInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ImageInfo;", "createUsing", "_ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "_nGetImageInfo", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/skia/impl/InteropPointer;", "intArrayPointer", "nativePointerArrayPtr", "", "makeA8", "width", "", "height", "makeN32", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "makeN32Premul", "makeS32", "makeUnknown", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final ImageInfo getDEFAULT() {
            return DEFAULT;
        }

        public final ImageInfo makeN32(int n, int n2, ColorAlphaType colorAlphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, null), n, n2);
        }

        public final ImageInfo makeN32(int n, int n2, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, colorSpace), n, n2);
        }

        public final ImageInfo makeS32(int n, int n2, ColorAlphaType colorAlphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, ColorSpace.Companion.getSRGB()), n, n2);
        }

        public final ImageInfo makeN32Premul(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, null), n, n2);
        }

        public final ImageInfo makeN32Premul(int n, int n2, ColorSpace colorSpace) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, colorSpace), n, n2);
        }

        public final ImageInfo makeA8(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.ALPHA_8, ColorAlphaType.PREMUL, null), n, n2);
        }

        public final ImageInfo makeUnknown(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null), n, n2);
        }

        public final ImageInfo createUsing(long l, Function3<? super Long, Object, Object, Unit> function3) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter(function3, (String)"");
            Stats.INSTANCE.onNativeCall();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            int[] nArray = new int[4];
            boolean bl = false;
            boolean bl2 = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl3 = false;
            Object object3 = object2 = interopScope.toInteropForResult(nArray);
            InteropScope interopScope2 = interopScope;
            boolean bl4 = false;
            NativePointerArray nativePointerArray = new NativePointerArray(1);
            boolean bl5 = false;
            boolean bl6 = false;
            InteropScope interopScope3 = theScope.INSTANCE;
            boolean bl7 = false;
            Object object4 = object = interopScope3.toInteropForResult(nativePointerArray);
            InteropScope interopScope4 = interopScope3;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl8 = false;
            function3.invoke((Object)l, object3, object4);
            interopScope3.fromInterop(object, nativePointerArray);
            objectRef2.element = nativePointerArray.get(0);
            interopScope.fromInterop(object2, nArray);
            int[] nArray2 = nArray;
            bl2 = false;
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = nArray2[2];
            int n4 = nArray2[3];
            Object object5 = objectRef.element;
            Intrinsics.checkNotNull((Object)object5);
            return new ImageInfo(n, n2, n3, n4, ((Number)object5).longValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

