/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/skia/Point;", "", "x", "", "y", "(FF)V", "isEmpty", "", "()Z", "getX", "()F", "getY", "equals", "other", "hashCode", "", "offset", "dx", "dy", "vec", "scale", "sx", "sy", "toString", "", "Companion", "skiko"})
public final class Point {
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private static final Point ZERO = new Point(0.0f, 0.0f);

    public Point(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final Point offset(float f, float f2) {
        return new Point(this.x + f, this.y + f2);
    }

    public final Point offset(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        return this.offset(point.x, point.y);
    }

    public final Point scale(float f) {
        return this.scale(f, f);
    }

    public final Point scale(float f, float f2) {
        return new Point(this.x * f, this.y * f2);
    }

    public final boolean isEmpty() {
        return this.x <= 0.0f || this.y <= 0.0f;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        if (Float.compare(this.x, ((Point)object).x) != 0) {
            return false;
        }
        return Float.compare(this.y, ((Point)object).y) == 0;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + Float.floatToIntBits(this.x);
        n2 = n2 * n + Float.floatToIntBits(this.y);
        return n2;
    }

    public String toString() {
        return "Point(_x=" + this.x + ", _y=" + this.y + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ2\u0010\u000e\u001a\u00020\u00042#\u0010\u000f\u001a\u001f\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\b\u0014H\u0000\u00a2\u0006\u0002\b\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/Point$Companion;", "", "()V", "ZERO", "Lorg/jetbrains/skia/Point;", "getZERO", "()Lorg/jetbrains/skia/Point;", "flattenArray", "", "pts", "", "([Lorg/jetbrains/skia/Point;)[F", "fromArray", "([F)[Lorg/jetbrains/skia/Point;", "fromInteropPointer", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final Point getZERO() {
            return ZERO;
        }

        public final float[] flattenArray(Point[] pointArray) {
            if (pointArray == null) {
                return null;
            }
            float[] fArray = new float[pointArray.length * 2];
            int n = pointArray.length;
            for (int i = 0; i < n; ++i) {
                fArray[i * 2] = pointArray[i].getX();
                fArray[i * 2 + 1] = pointArray[i].getY();
            }
            return fArray;
        }

        public final Point[] fromArray(float[] fArray) {
            if (fArray == null) {
                return null;
            }
            if (!(fArray.length % 2 == 0)) {
                boolean bl = false;
                String string = "Expected " + fArray.length + " % 2 == 0";
                throw new IllegalArgumentException(string.toString());
            }
            Point[] pointArray = new Point[fArray.length / 2];
            int n = fArray.length / 2;
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(fArray[i * 2], fArray[i * 2 + 1]);
            }
            return pointArray;
        }

        public final Point fromInteropPointer$skiko(Function2<? super InteropScope, Object, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"");
            float[] fArray = new float[2];
            boolean bl = false;
            boolean bl2 = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl3 = false;
            Object object = interopScope.toInteropForResult(fArray);
            function2.invoke((Object)interopScope, object);
            interopScope.fromInterop(object, fArray);
            float[] fArray2 = fArray;
            return new Point(fArray2[0], fArray2[1]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

