/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/skiko/Library;", "", "()V", "copyDir", "Ljava/io/File;", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "findAndLoad", "", "load", "loadLibraryOrCopy", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "skiko"})
public final class Library {
    public static final Library INSTANCE = new Library();
    private static File copyDir;
    private static AtomicBoolean loaded;

    private Library() {
    }

    private final void loadLibraryOrCopy(File file) {
        try {
            System.load(file.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = unsatisfiedLinkError.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                File file2 = copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)file2);
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                File file3 = FilesKt.resolve((File)file2, (String)string2);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(file.toPath(), file3.toPath(), copyOptionArray);
                file3.deleteOnExit();
                System.load(file3.getAbsolutePath());
            }
            throw unsatisfiedLinkError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File file, String string, boolean bl) {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            File file3 = File.createTempFile("skiko", "", file);
            if (bl) {
                file2.deleteOnExit();
            }
            CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + string);
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)copyOptionArray;
                boolean bl2 = false;
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(inputStream, file3.toPath(), copyOptionArray2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
            }
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(file3.toPath(), file2.toPath(), copyOptionArray);
        }
        return file2;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoad() {
        Object object;
        Object object2;
        String string;
        String string2 = "skiko-" + OsArch_jvmKt.getHostId();
        String string3 = System.mapLibraryName(string2);
        String string4 = string = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String string5 = SkikoProperties.INSTANCE.getLibraryPath();
        if (string5 != null) {
            File file = new File(new File(string5), string3);
            this.loadLibraryOrCopy(file);
            if (string != null && copyDir != null) {
                File file2 = copyDir;
                Intrinsics.checkNotNull((Object)file2);
                this.unpackIfNeeded(file2, string, true);
            }
            return;
        }
        File file = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)string3);
        File file3 = FilesKt.resolve((File)file, (String)string3);
        if (file3.exists()) {
            boolean bl;
            String string6 = string;
            if (string6 != null) {
                object2 = string6;
                boolean bl2 = false;
                bl = !FilesKt.resolve((File)file, (String)object2).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(file3);
                return;
            }
        }
        if ((object2 = Library.class.getResourceAsStream('/' + string3 + ".sha256")) == null) {
            throw new LibraryLoadException("Cannot find " + string3 + ".sha256, proper native dependency missing.");
        }
        Object object3 = object2;
        Object object4 = (Closeable)object3;
        Serializable serializable = null;
        try {
            object = (InputStream)object4;
            boolean bl = false;
            InputStream inputStream = object;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            object = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object4, (Throwable)serializable);
        }
        object2 = object;
        object4 = new File(new File(SkikoProperties.INSTANCE.getDataPath()), (String)object2);
        ((File)object4).mkdirs();
        serializable = this.unpackIfNeeded((File)object4, string3, false);
        this.loadLibraryOrCopy((File)serializable);
        if (string != null) {
            if (copyDir != null) {
                File file4 = copyDir;
                Intrinsics.checkNotNull((Object)file4);
                this.unpackIfNeeded(file4, string, true);
            } else {
                this.unpackIfNeeded((File)object4, string, false);
            }
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

